 
/*
 *  Nuprl FFI Socket IO: Server & Client.
 * 
 *  The following functions are called from lisp in order to communicate via sockets.
 *
 *  SOCK_STREAM sockets are used.
 */

/*LAL TODO:  get rid of unnecessary includes*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <fcntl.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <sys/file.h>
#include <curses.h> 
#include <ctype.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <syslog.h>
#include <sys/param.h>
#include <arpa/inet.h>

#include <string.h>
#include <setjmp.h>

#define DEBUG 0


int establish_connection_server(port)
      int port;
{
  int sock, new_sock;
  char hostname_buffer[MAXHOSTNAMELEN];
  int fromlen, i;
  struct sockaddr_in server;
  struct sockaddr_in from;
  struct hostent *hp, *gethostbyname();

  /* Create socket */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror(" server opening stream socket\n");
    return(-1);
  }

  if (gethostname(hostname_buffer, MAXHOSTNAMELEN) < 0) {
    perror("Server failed getting hostname.\n");
    close(sock);
    return(-2);
  }
  /* Connect socket using hostname */
  server.sin_family = AF_INET;
  hp = gethostbyname(hostname_buffer);
  if (hp == 0) {
    fprintf(stderr, "%s: unknown host\n", hp);
    close(sock);
     return(-3);
  }
 
  server.sin_addr.s_addr = htonl(INADDR_ANY);
  server.sin_port = htons(port);

  if (bind(sock,  (struct sockaddr *)&server, sizeof server) < 0) {
    perror("binding stream socket\n");
    close(sock);
    return(-4);
  }

  if (listen(sock, 5) < 0) {
    perror("Sever failed listen.\n");
    close(sock);
    return(-5);
 }
  /*below is an attempt to handle interrupt, not needed*/
/* for (i = getdtablesize()-1; i >= 0; --i)
   close(i);
 open("/dev/null", O_RDONLY);
 dup2(0, 1);
 dup2(0, 2);

i = open("/dev/null", O_RDWR); 
 if (i >= 0) {
   ioctl(i, TIOCNOTTY, 0);
    close(i); 
 }*/

return(sock);
}

int make_nonblocking_socket(port, queue_size)
      int port, queue_size;
{
  int sock, new_sock;
  char hostname_buffer[MAXHOSTNAMELEN];
  int fromlen, i;
  struct sockaddr_in server;
  struct sockaddr_in from;
  struct hostent *hp, *gethostbyname();

  /* Create socket */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror(" server opening stream socket\n");
    return(-1);
  }

/* mark as nonblocking*/
  if (fcntl(sock, F_SETFL, FNDELAY) < 0) {
    perror(" server nonblocking socket\n");
    close(sock);
    return(-1);
  }
    

  if (gethostname(hostname_buffer, MAXHOSTNAMELEN) < 0) {
    perror("Server failed getting hostname.\n");
    close(sock);
    return(-2);
  }
  /* Connect socket using hostname */
  server.sin_family = AF_INET;
  hp = gethostbyname(hostname_buffer);
  if (hp == 0) {
    fprintf(stderr, "%s: unknown host\n", hp);
    close(sock);
     return(-3);
  }

  server.sin_addr.s_addr = htonl(INADDR_ANY);
  server.sin_port = htons(port);

  if (bind(sock,  (struct sockaddr *)&server, sizeof server) < 0) {
    perror("binding stream socket\n");
    close(sock);
    return(-4);
  }

  if (listen(sock, queue_size) < 0) {
    perror("Sever failed listen.\n");
    close(sock);
    return(-5);
 }
  /*below is an attempt to handle interrupt, not needed*/
/* for (i = getdtablesize()-1; i >= 0; --i)
   close(i);
 open("/dev/null", O_RDONLY);
 dup2(0, 1);
 dup2(0, 2);

i = open("/dev/null", O_RDWR); 
 if (i >= 0) {
   ioctl(i, TIOCNOTTY, 0);
    close(i); 
 }*/

return(sock);
}

/*below is another attempt to handle interrupt, not needed*/
/*  jmp_buf catch;
   int (*old_handler)();
 int wrapper(sock)
     int sock;
{
  auto int return_value;
  extern int new_handler(), server_accept();
  
  if ((return_value = setjmp(catch)) != 0)
    {
      perror("return value:\n");
    return return_value;
}

  old_handler = signal(SIGINT, new_handler);
#ifdef DEBUG
	fprintf(stderr, " before accept.\n");
#endif
  return_value = server_accept(sock);
  signal(SIGINT, old_handler);
  return return_value;
}

int new_handler()
{ 
   signal(SIGINT, old_handler);
  longjmp(catch, -1);
}
*/


int server_accept(sock)
     int sock;
{
  int new_sock;

  new_sock = accept(sock, (struct sockaddr *)0, (int *)0); 
  if (new_sock < 0) {
    /*perror(" first  server accept:\n");
    fprintf(stderr, "%d: first error number:\n",  errno);*/
    if (errno != EWOULDBLOCK) { /* close new_sock and try again*/
      close(new_sock);
      new_sock = accept(sock, (struct sockaddr *)0, (int *)0);   
      
      if (new_sock < 0) {
	/*perror("second server accept:\n");
       fprintf(stderr, "%d:  second error number:\n",  errno);*/
	close(new_sock);
	close(sock);
	return(-3);
      }
      else return(new_sock);
   }
    else return(-10000);
  }
else if ((fcntl(new_sock, F_SETFL, (fcntl(new_sock,F_GETFL,0)&~O_NDELAY))) < 0) 
     {
        perror(" server nonblocking socket\n"); close(new_sock);
	close(sock);
	return(-4);
     }
     else return(new_sock);
}

int establish_connection(port, host)
      int port;
      char *host;
{
  int sock, connected;
  int fromlen, i;
  struct sockaddr_in server;
  struct sockaddr_in from;
  struct hostent *hp, *gethostbyname();

  /* Create socket */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Client failed opening stream socket.\n");
    return(-1);
  }
  /* Connect socket using hostname */
  server.sin_family = AF_INET;
  hp = gethostbyname(host);
  if (hp == 0) {
    fprintf(stderr, "%s: unknown host\n", hp);
    close(sock);
    return(-3);
 } 
  server.sin_port = htons(port);
  bcopy((char *)hp->h_addr, (char *)&server.sin_addr, hp->h_length);

  connected = 0;
	for (i=0; i<1024; i++) {
	  if (connect(sock, (struct sockaddr *)&server, sizeof server) >= 0) {
	    connected = 1;
	    break;
	  };
	  if (errno == ETIMEDOUT) {
	    perror("Client connect timed out.\n");
	    close(sock);
	    return(-5);
	  }
	  sleep(1);
	}
	
	if (connected == 0) {
	  perror("Client failed to connect.\n");
	  close(sock);
	  return(-6);
	 }
	/*else if ((fcntl(sock, F_SETFL, (fcntl(sock,F_GETFL,0)&~O_NDELAY))) < 0) 
     {
        perror(" server nonblocking socket\n"); close(sock);
	close(sock);
	return(-4);
     }
     else */

return(sock);
}

void close_connection(fd1)
  int fd1;
{ 
  close(fd1);
 
}









