
;; this is probably dangerous:

#+lucid
(unless (find-package "CL-USER")
  ;; be nice if LCL is not needed? but for now need it to get clos functions.
  (make-package "CL-USER" :use '("LISP" "LCL" "USER")) 
  )


(in-package "CL-USER")

;;;;	
;;;;	This is where it all begins.
;;;;	
;;;;	Should not have load if restart of disksave.
;;;;	
;;;;	Must be config file as anchor for system to load.
;;;;	
;;;;	 
;;;;    Find and load config files.
;;;;	  - <kind>.config
;;;;	 
;;;;	
;;;;	Do general purpose : 
;;;;	  - load portable utilities defsystem.
;;;;	


;;;;	
;;;;	
;;;;	<system> : system root as specified by environment variable or guessed
;;;;		   from default list (see generate-root-candidate-list).
;;;;		  or defaults to <home>/<kind>
;;;;	
;;;;	<kind>-init.l : <system>/bin/<kind>-init.l
;;;;	  - site : loaded at lisp startup for any variety. but not restart.
;;;;	      * allegro - load in ~/.clinit.cl
;;;;	      * cmu - command line option in startup script.
;;;;	  - load : loaded by site <kind>-init from via system-path-prefix.
;;;;	      * see site <kind>-init to see how path prefix determined.
;;;;	  - restart : <system>/bin/<kind>.config read to set <system-path-prefix>.
;;;;	      * <system-path-prefix>/restart<i> : patches restart
;;;;	  - user : loaded at disksave startup from <userhome>/<kind>-init.l
;;;;	    if want to multiplex over flavors of <kind> then do so by examining
;;;;	    features and/or globals.
;;;;	
;;;;	<kind>.config
;;;;	  - system root : redirect paths for restart.
;;;;	  - system source instance : version and origin path.
;;;;	
;;;;	
;;;;	Lisp startup : lisp probably also loads <home>/lisp-init
;;;;	  - system site startup script will load site <kind>-init.l
;;;;	  - <system>-init.l 
;;;;	      * set *system-root*
;;;;	      * read relative source <system>.config
;;;;		  - sets system-path-prefix
;;;;	      * load <system>-init.l from <system-path-prefix>/sys
;;;;	
;;;;	Disksave restart : 
;;;;	  - load <system-root>/bin/<kind>.config
;;;;	      * <system-path-prefix> will be computed from <system-root>
;;;;		and redirects of <kind>.config
;;;;	  - loads <system-path-prefix>/bin/<kind>-init.l
;;;;

;;;;	
;;;;	<system>/bin/<kind>.config : This file should be in the bin directory 
;;;;	of the system root directory.
;;;;	
;;;;	At disksave time, the path-prefix was set by a <kind>.config file local to the 
;;;;	source instance. To make disksaves more portable the system-path-prefix can be
;;;;	redirected. 
;;;;	
;;;;	Path prefix woud have been specified similar to : 
;;;;	 (path-prefix "development" "<kind>")
;;;;	
;;;;	To redirect :  (redirect <old> <new>)
;;;;	 (redirect (path-prefix "development" "<kind>")
;;;;		   (path-prefix "remote-production" "<kind>"))
;;;;	
;;;;	This changes what the path-prefix will be at restart time. You may rebind
;;;;	the path prefix in the restart file. Users may also rebind path prefix in
;;;;	their <kind>-init.l file.
;;;;	



(defun search-symbols (&optional package (predicate #'fboundp))
  (let ((acc nil))
    (if package
	(do-symbols (s (find-package (string-upcase (string package))))
	  (when (funcall predicate s)
	    (push s acc)))
	(do-all-symbols (s )
	  (when (funcall predicate s)
	    (push s acc))))
    acc))

(defun filter-symbols (list &optional (predicate #'fboundp))
  (let ((acc nil))
    (dolist (s list)
      (when (funcall predicate s)
	(push s acc)))
    acc))

  (defun sub-fun-name (s)
    #'(lambda (sym)
	(and (fboundp sym)
	     (search s (string-upcase (string sym))))))

  ;; find-function
  (defun ff (s)
    (search-symbols nil
		    (sub-fun-name (string-upcase (string s)))))

  ;; filter function
  (defun ft (s l)
    (filter-symbols l 
		    (sub-fun-name (string-upcase (string s)))))


  ;;
  ;;	Shell commands.
  ;;	
  ;;	getenv
  ;;	cd
  ;;	pwd
  ;;	
  ;;	


  (defun getenv (str)
    nil
    #+(or lcl3.0 lcl4.0) (lcl:environment-variable str)
    #+allegro (system:getenv str)
    #+cmu (xlib::getenv str)
    #+clisp (system::getenv str)
    )


  (defun pwd ()
    #+cmu(default-directory)
    #+allegro(current-directory)
    #+clisp(lisp:cd)
    )

  (defun cd (str)
    #+allegro(top-level::cd-command str)
    #+cmu(setf (default-directory) str)
    #+clisp(lisp:cd str)
    )

  #+(or cmu allegro)
  (defun prompt-and-read (&key string)
		      (format t "~a ? " string)
		      (read-line t))
  #+(or cmu allegro) (export '(prompt-and-read))

  #+cmu(import '(extensions::gc))
  #+allegro(import '(excl:gc))

  (defun pfeatures (&optional (stream t))
    (mapc #'(lambda (f) (format stream "~a ~%" f)) *features*))

  #+allegro(defun quit () (top-level::exit-command))



;; rudimentary filename hacking:

(defparameter *path-separator*
  #+unix #\/
  #+windows #\\)

(defparameter *path-separator-string* (make-string 1 :initial-element *path-separator*))

(defun path-separator-terminated-p (s)
  (when (> (length s) 0)
    (char= (char s (1- (length s))) *path-separator*)))

(defun path-separator-terminate (s)
  (unless (path-separator-terminated-p s)
    (format nil "~a~a" s *path-separator*)))
      
(defun extend-pathname (path &optional dirs fname ftype)
  (make-pathname :host (pathname-host path)
		 :device (pathname-device path)
		 :directory (append (pathname-directory path) dirs)
		 :name fname
		 :type ftype))

(defun butlast-pathname (path)
  (make-pathname :host (pathname-host path)
		 :device (pathname-device path)
		 :directory (butlast (pathname-directory path))))

(defun probe-dir (fname)
  #+clisp(let ((pn (directory (pathname fname))))
	   (when pn fname))
  #-clisp(let ((pn (probe-file (pathname fname))))
	   (when pn (namestring pn))))


;;	
;;	Make
;;	

(defun host-platform () 
  #+(and x86 winnt)			"winnt86"
  #+(or linux86 (and x86 linux))	"linux86"
  #+(and allegro solaris2)		"solaris"
  #+(and sun sparc-v8 (not (or sunos4 sun-os)))	"solaris"
  #+(and sun sparc-v9 (not (or sunos4 sun-os)))	"solaris9"
  #+(and cmu solaris sparc-v8)  "solaris"
  #+(and cmu solaris sparc-v9)  "solaris9"
  #+(and (or sunos4 sun-os) (not (or linux linux86)))	"sunos";; for some strange reason the linux executable has the sunos4 feature.
  )

(defun lisp-version ()
  #+lucid				"lucid"
  #+allegro-v6.2			"allegro62"
  #+allegro-v6.1			"allegro61"
  #+allegro-v6.0			"allegro6"
  #+allegro-v5.0			"allegro5"
  #+allegro-v5.0.1			"allegro501"
  #+allegro-v4.3			"allegro43"
  #+(and allegro (not (or allegro-v6.2  allegro-v6.1 allegro-v6.0 allegro-v5.0 allegro-v5.0.1 allegro-v4.3)))	"allegro"
  #+cmu18d				"cmucl18d"
  #+cmu18e				"cmucl18e"
  #+(and cmu (not cmu18))		"cmucl"
  #+mcl		                "mcl"
  )

(defun standard-binary-directories ()
  (list
   (host-platform)
   (lisp-version)))


(defun append-standard-binary-directories (s)
  (let ((separator-terminated (path-separator-terminated-p s)))
    
    (format nil "~a~a~a~a~a~a"
	    s
	    (if separator-terminated "" *path-separator*)
	    (host-platform)
	    *path-separator*
	    (lisp-version)
	    (if separator-terminated *path-separator* ""))))

#+(and linux86 (not linux))(push :linux *features*)



(defvar *system-major-version* 0)
(defvar *system-minor-version* 0)

(defun set-version (version)

  (unless (and (= (length version) 2)
	       (integerp (car version))
	       (integerp (cadr version)))
    (error (format nil ";;; ~a~%;;; ~a[~a]"
		   "Expected version expression of config to be list of two integers"
		   "representing the major and minor version"
		   version)))

  (setf *system-major-version* (car version)
	*system-minor-version* (cadr version)))

;; used to build  .<kind>.config filename.
(defvar *system-kind* nil)

(defvar *system-root* "")
(defvar *system-path-prefix-list* nil)
(defvar *system-path-prefix* "./")
(defvar *system-site-prefix* nil)

;; remember candidates since on restart maybe reset to diff root.
(defvar *system-root-candidates* nil)
  
(defun set-system-root-aux ()
  (let ((kind *system-kind*)
	(candidates *system-root-candidates*))

    (setf *system-root*
	  (or (let ((ne (getenv kind)))
		(when ne
		  (let ((l (length ne)))
		    (unless (eql (char ne (1- l)) *path-separator*)
		      (setf ne (concatenate 'string ne (string *path-separator*)))))
		  
		  (let ((pn (probe-dir (pathname ne))))
		    (when pn (namestring pn)))))

	      (find-if #'(lambda (ne) (probe-dir (pathname ne)))
		       candidates)

	      (let ((ne (extend-pathname (user-homedir-pathname) (list kind))))
		(probe-dir (pathname ne)))

	      (let ((ne (extend-pathname (user-homedir-pathname)
					 (list (string-downcase kind)))))
		(probe-dir (pathname ne)))

	      (error (format nil "Could not determine system-root path. Set ~a environment variable."
			     kind))))

    (format t ";;;	System root set : ~a~%;;;~%" *system-root*) ))

(defun set-system-kind (kind)
  (setf *system-kind* (string kind)))

(defun set-system-root (candidates)
  (setf *system-root-candidates* candidates)
  (set-system-root-aux))

(defun set-path-prefix (path-prefix)
  (unless (and (listp path-prefix)
	       (every #'stringp path-prefix))
    (error ";;; Expected path prefix expression of config to be string list ~% \
              ;;; ~a.~%"
	   path-prefix))

  ;; don't reset, since original helps identify disksave origin.
  (unless  *system-path-prefix-list* 
    (setf *system-path-prefix-list* path-prefix))
	 
  (setf *system-path-prefix*
	(namestring (extend-pathname (pathname *system-root*)
				     (cons "sys" path-prefix)))))


(defvar *system-config* nil)

(defun read-config (fname)
  (let ((kind *system-kind*))
    (with-standard-io-syntax
      (let ((data nil))
	(if (not (probe-file fname))
	    (warn (format nil "~a config file ~a could not be located." kind fname))
	    (with-open-file (s fname)
	      (when (null s)
		(error (format nil "~a config file ~a located but could not be opened."
			       kind fname)))

	      (do ((sexpr (read s nil nil) (read s nil nil)))
		  ((null sexpr))
		(push sexpr *system-config*)
		(push sexpr data)
		)
	      (nreverse data)))))))


(defparameter *restart-config-filter* '(iam eddhost))

(defun filter-config-at-restart ()
  (setf *system-config*
	(mapcan #'(lambda (x)
		    (unless (member (car x) *restart-config-filter*)
		      (list x)))
		*system-config*)))

(defun load-user-config (&optional restartp)

    (when restartp
      (set-system-root-aux)
      (set-path-prefix *system-path-prefix-list*))

    (let ((kind *system-kind*))

      (let ((filen (let ((fn (extend-pathname (or (getenv (format nil "~aUSERHOME" (string-upcase kind)))
						(user-homedir-pathname))
					    nil
					    (format nil ".~a" kind)
					    "config")))
		   (if (probe-file fn)
		       (progn
			 (format t ";;; Loading user .~a.config : ~%;;;   ~a~%;;;~%"
				 kind fn)
			 fn)
		       (progn
			 (format t ";;;	No user .~a.config file found at : ~%;;;		~a~%;;;~%"
				 kind fn)
			 nil
			 )))))

      (when restartp
	(filter-config-at-restart))

      (when filen
	(read-config filen))

      (values))))

(defun load-config (&optional sitep)

  (let ((kind *system-kind*))
    (if sitep
	(format t "~%;;;~%;;;	Loading site config file.~%;;;~%")
	(format t "~%;;;~%;;;	Loading config file.~%;;;~%"))

    ;; requires *system-root* and *system-path-prefix* to have been set. 
    (let ((filen (or
		  (let ((envconfig (getenv (format nil "~aCONFIG" (string-upcase kind)))))
		    (if envconfig
			(let ((fn (format nil
					  "~a~a~a~a~a~a"
					  envconfig
					  (if (path-separator-terminated-p envconfig)
					      ""
					      *path-separator-string*)
					  "bin"
					  (*path-separator-string*)
					  kind
					  ".config")))

			  (if (probe-file fn)
			      (progn
				(format t ";;; Using ~a.config file found by env variable ~aCONFIG [~a].~%;;;~%"
					kind (string-upcase kind) envconfig)
				fn)
			      (progn
				(format t ";;; No ~a.config file at env variable ~aCONFIG [~a].~%"
					kind (string-upcase kind) envconfig)
				nil )))
			(progn
			  (format t ";;; No ~aCONFIG environment variable.~%" (string-upcase kind))
			  nil )))

		  (let ((fn (extend-pathname (pathname *system-path-prefix*)
					     (list "bin")
					     kind
					     "config")))
		    (if (probe-file fn)
			(progn
			  (format t ";;; Using ~a.config file found in directory : ~%;;;   ~a~%;;;~%"
				  kind fn)
			  fn)
			(progn
			  (format t ";;; ~a.config file not found at : ~%;;;   ~a~%;;;~%"
				  kind fn)
			  nil
			  )))
		    
		  (error (format nil "~a.config file could not be located. ~% Set path-prefix in ~~.~a.config or set ~aCONFIG environment variable and try again."
				 kind kind (string-upcase kind))))))

      ;;(setf -filen  filen) (break "filen")
      (dolist (sexpr (read-config filen))
	(case (car sexpr)
	  (version (set-version (cdr sexpr)))
	  (path-prefix (set-path-prefix (cdr sexpr)))
	  (redirect (when (equal (cdr (cadr sexpr)) *system-path-prefix-list*)
		      (set-path-prefix (cdaddr sexpr))))

	  ))

      (format t ";;;	SYSTEM VERSION is ~a.~a~%;;;	SYSTEM-PATH-PREFIX is ~a.~%;;;~%"
	      *system-major-version*
	      *system-minor-version*
	      *system-path-prefix*))
    ))

(defvar *system-registry* nil)

(defvar *system-interrogate-p* t)

(export'(host-platform lisp-version
	 standard-binary-directories append-standard-binary-directories
	 *system-interrogate-p* *system-config* read-config))

(defun load-make ()

  (let ((sroot (pathname *system-path-prefix*)))

    (let ((sreg (extend-pathname sroot (list "registry"))))
      
      (setf *system-registry* (namestring sreg)))
    

    #-lucid(unless (find-package "MAKE") 
	     (make-package "MAKE" :nicknames '("MK") :use '("COMMON-LISP")));;  #+lucid'("LISP")

    (let* ((source (extend-pathname sroot
				    (list "utils" "portable-utilities")
				    "defsystem"
				    "lsp"))
	   (binary (extend-pathname sroot
				    (append (list "utils" "portable-utilities" "bin") (standard-binary-directories))
				    "defsystem"
				    #+Lucid "sbin" #-Lucid "fasl"
				    )))

      (format t ";;;  ~%;;;  Portable utilities source : ~a" source)
      (format t ";;;  ~%;;;  Portable utilities binary : ~a~%;;; " binary)

      (if (null (probe-file source))
	  (format t ";;; ~%;;;	Not loading portable-utilites defsystem package. ~%;;;	~%")
	  (progn
	    (unless (and (probe-file binary)
			 (> (file-write-date binary) (file-write-date source)))
	      #+(or allegro cmu)(compile-file source :verbose nil :output-file binary)
	      #+lucid(compile-file source :output-file binary)
	      )
    
	    (load binary :verbose nil)

	    (setf (symbol-value (intern "*CENTRAL-REGISTRY*" 'make))
		  *system-registry*)


	    (funcall (intern "LOAD-SYSTEM" (find-package "MAKE")) 'basic-support)))))

  ;; following compatability flag is set so ilisp doesn't choke on allegro.
  ;;  it is turned off somehow by my emacs or Ilisp init files.
  ;;
  ;;#+excl
  ;;(setf excl:*cltl1-in-package-compatibility-p* nil)

  #+cmu(setf *compile-print* nil)
  nil)

(defun generate-root-candidate-list (k)
  (let ((kind (string-downcase k)))

    (list (format nil "/home/~a/" kind)
	  (format nil "~~/~a/" kind)
	  (format nil "/usr/local/~a/" kind)
	  (format nil "/usr/public/~a/" kind)
	  (format nil "/usr/local/public/~a/" kind))))
  
(defun go-go-go-aux (kind ;;relative-source-path
		     &optional candidates)

  (terpri)
  (setf *init-root* (path-separator-terminate *init-root*))

  (set-system-kind kind)
  (set-system-root (append (mapcar #'path-separator-terminate candidates)
			   (generate-root-candidate-list kind)))

  (load-user-config)
  (set-path-prefix (assoc 'path-prefix *system-config*))
  (load-config)


  (when (let ((e (assoc 'interrogate *system-config*)))
	  (and e (null (cadr e))))
    (setf *system-interrogate-p* nil))

  (load-make)

  ;; load source instance <kind>-init.l
  (let ((lpath (extend-pathname (pathname *system-path-prefix*)
			 (list "bin")
			 (format nil "~a-load" kind)
			 "l")))
    (format t "~%;;; ~%;;;  Loading ~a ~%;;;" lpath)
    (load lpath))
  )

(defun lisp-executable ()
  (extend-pathname *system-root* (list "bin") (lisp-version) "x")
  )

(defun config-data () *system-config*)

(export '(*system-kind* *system-root* *system-path-prefix* *system-site-prefix*
	  *system-major-version* *system-minor-version*
	  *path-separator-string*
	  cd pwd getenv pfeatures quit gc
	  extend-pathname butlast-pathname load-config set-system-root set-path-prefix lisp-executable
	  load-user-config config-data
	  ))
