package FDL.term;

import java.util.*;
import FDL.workingmap.*;

/* 
 *	FDL Terms
 *	
 *	
 *	Parameter	: String # String
 *	Term		: Parameter List # Term List
 *	
 *	No bindings \x.y  
 *	eg \x.y == {lambda:s}({bound_id:s, x:variable}({variable:s, y:variable}()))
 */

public class Term {

    // might want to buffer input then dump into arrays later so keep 
    //  access to parms and subterms abstract.
    private ArrayList parms;
    private ArrayList subterms;

    private static final ArrayList noterms = new ArrayList();

    public Term(ArrayList ps, ArrayList ts) {
	parms = ps;
	subterms = ts;
    }

    public Term(Parameter p) {
	parms = new ArrayList ();
	subterms = new ArrayList ();
	
	parms.add(p);
    }

    public Term(Parameter p, Term s) {
	parms = new ArrayList ();
	subterms = new ArrayList ();
	
	parms.add(p);
	subterms.add(s);
    }

    public Term(Parameter[] p, Term[] s) {
	parms = new ArrayList ();
	subterms = new ArrayList ();
	
	parms.addAll(Arrays.asList(p));
	subterms.addAll(Arrays.asList(s));
    }

    static StringBuffer sbuf = new StringBuffer(80);
    private void toString_aux(int depth) {
	
	//indent
	for ( int i=0; i<depth; i++) {
	    sbuf.append(' ');
	}
	
	Iterator itp = parms.iterator();
	Parameter p;

	sbuf.append('{');
	while (itp.hasNext()) {
	    p = (Parameter)(itp.next());
	    sbuf.append(p.toString());
	    sbuf.append(',');
	}
	sbuf.replace(sbuf.length() -1,sbuf.length(), "}");
	
	if (subterms.size() == 0) {
	    sbuf.append("()\n");
	}
	else {
	    sbuf.append('\n');
	    
	    Iterator itt = subterms.iterator();
	    Term t;
	    while (itt.hasNext()) {
		t = (Term)itt.next();
		t.toString_aux(depth+1);
	    }
	}
    }
    
    public String toString() {
	sbuf.delete(0,sbuf.length());
	toString_aux(0);
	return sbuf.toString();
    }

    public boolean equals(Term t) {
	
	Iterator ita = parms.iterator();
	Iterator itb = t.parms.iterator();
	Parameter p,q;
	
	while (ita.hasNext()) {
	    if (!(itb.hasNext())) { 
		//System.out.println(parms.size() + " Parms lengths " + t.parms.size());
		return false; 
	    }
	    
	    p = (Parameter)(ita.next());
	    q = (Parameter)(itb.next());
	    if (p instanceof SParameter && q instanceof SParameter) {
		if (!((SParameter)p).equals((SParameter)q)) { 
		    return false; 
		}
	    } else if (p instanceof OParameter && q instanceof OParameter) {
		if (!((OParameter)p).equals((OParameter)q)) { 
		    return false; 
		}
	    } else { return false; }
	}

	Term sa,sb;
	ita = subterms.iterator();
	itb = t.subterms.iterator();
	
	while (ita.hasNext()) {
	    if (!(itb.hasNext())) { 
		//System.out.println(subterms.size() + " subterms lengths " + t.subterms.size());
		return false; 
	    }
	    
	    sa = (Term)(ita.next());
	    sb = (Term)(itb.next());
	    if (!(sa.equals(sb))) { 
		//System.out.println(sa.toString() + " Terms " + sb.toString());
		return false;
	    }
	}

	return true;
    }

    private static boolean obidstring_p (String s) {
	try {
	    System.out.println("obidstring_p " + s + " " + s.substring(0,5));

	    if (s.substring(0,5).equals("%%NOr")) { return true;}
	    else { return false; }
	} catch (Exception e) { return false; }
    }
    private static Parameter readParameter (TermReader r) throws TermInputException {
	String v = r.read();

	r.mustbe(TermSyntax.colon);

	String type = r.read();

	if (type.equals("ObjectId")) { 
	    return (Parameter) new OParameter(v); 
	} else if (type.equals("s") && obidstring_p(v)) {
	    return (Parameter)new OParameter(v.substring(5));
	} else { return (Parameter)new SParameter(type, v); }

    }
    private static Term readTerm_aux(TermReader s) throws TermInputException {

	// read parameters 
        ArrayList ps = new ArrayList ();
	s.mustbe(TermSyntax.lcurly);
	while (s.maybe(TermSyntax.comma)  || !(s.maybe(TermSyntax.rcurly))) { 
	    ps.add(Term.readParameter(s));
	}

	// read subterms 
        ArrayList ts = new ArrayList ();
	s.mustbe(TermSyntax.lparen);
	while (s.maybe(TermSyntax.semicolon) || !(s.maybe(TermSyntax.rparen))) { 
	    ts.add(readTerm_aux(s));
	}

	return new Term(ps, ts);
    }

    // Could make a constructor with TermReader arg but this allows
    // some bracketing.
    public static Term readTerm(TermReader r) throws TermInputException {
	Term t = readTerm_aux(r);
	r.mustbe(TermSyntax.eot);
	return t;
    }

    private void writeTerm_aux(TermWriter w) throws Exception {

	Iterator itp = parms.iterator();
	Parameter p;

	// write parameters 
	w.writeByte((byte)TermSyntax.lcurly);
	while (itp.hasNext()) {
	    p = (Parameter)itp.next();
	    
	    if (p instanceof SParameter) {
		//System.out.println(((SParameter)p).getValue());
		w.write(((SParameter)p).getValue());
	    }
	    else if (p instanceof OParameter) {
		w.write(((OParameter)p).getValue().getKey());
	    }
	    else { throw new Exception("writeTerm parameter instance not SParameter or OParameter"); 
	    }

	    w.writeByte((byte)TermSyntax.colon);
	    
	    w.write(p.getType());
	    if (itp.hasNext()) { w.writeByte((byte)TermSyntax.comma); }
	}

	w.writeByte((byte)TermSyntax.rcurly);
	

	// write subterms
	Iterator itt = subterms.iterator();
	Term s;

	w.writeByte((byte)TermSyntax.lparen);
	while (itt.hasNext()) {
	    s = (Term)itt.next();

	    s.writeTerm_aux(w);
	    
	    if (itt.hasNext()) { w.writeByte((byte)TermSyntax.semicolon); }
	}
	w.writeByte((byte)TermSyntax.rparen);
    }

    public void writeTerm(TermWriter w) throws Exception {
	writeTerm_aux(w);
	w.writeByte(TermSyntax.eot);
    }


    public Term subtermn (int i) {
	i--;
	return (Term)subterms.get(i);
    }

    public Parameter parametern (int i) {
	i--;
	return (Parameter)parms.get(i);
    }

    public String firstParmOfType (String t) {

	Iterator it = parms.iterator();
	Parameter p;

	while (it.hasNext()) {
	    p = (Parameter)it.next();
	    
	    //System.out.println("firstParmOfType[" + t + "]: " + p.getValue() + ":" + p.getType());
	    
	    if ((p instanceof SParameter) & (t.equals(p.getType()))) {
		return ((SParameter)p).getValue();
	    }
	}
	return "";
    }

    public ObjectId firstObjectId () throws ObjectIdException {

	Iterator it = parms.iterator();
	Parameter p;
 
	while (it.hasNext()) {
	    p = (Parameter)it.next();
	    
	    if (p instanceof OParameter) { return ((OParameter)p).getValue(); }
	}

	throw (new ObjectIdException("Parameter.firstObjectId HaveNotObjectId"));
    }

    private static Term listToTerm_aux(ArrayList op, Iterator l) {
	Term t;
	if (l.hasNext()) {

	    ArrayList r;
	    r = new ArrayList();
	    r.add(l.next());
	    r.add(listToTerm_aux(op, l));

	    return new Term(op, r);
	}
	else { return new Term(op, noterms); }
    }

    public static Term listToTerm (Parameter[] op, Term[] ts) {
	ArrayList p = new ArrayList();
	p.addAll(Arrays.asList(op));

	if (ts.length == 0) {
	    return new Term(p, noterms);
	}
	else {

	    ArrayList l = new ArrayList();
	    l.addAll(Arrays.asList(ts));

	    return listToTerm_aux(p,l.iterator());
	}
    }

    // would be better to have icons_op be ArrayList.
    private final static Parameter[] icons_op = { SParameter.opidParm("!cons") };
    public static Term listToTerm(Term[] ts) {	return listToTerm(icons_op, ts); }


    //Lori Added XML here	  
    public String XMLStringOf() {
	String xml = "\n&lt;fdl:term xmlns=\"http://www.nuprl.org/ns/fdl\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.nuprl.org/fdl/fdl.xsd\"&gt";
		
	//do parameters
	xml = xml.concat("\n\t&lt;fdl:param_list&gt;");
	Iterator itp = parms.iterator();
	SParameter p;
	if (!(parms.isEmpty())) {		
		p = (SParameter)itp.next();
		xml = xml.concat(p.XMLStringOf());		
		while (itp.hasNext()) {
			p = (SParameter)itp.next();
			xml = xml.concat(p.XMLStringOf());
		};
	};
	xml = xml.concat("\n\t&lt;/fdl:param_list&gt;");
	
	//do subterms
	xml = xml.concat("\n&lt;fdl:term_list&gt;");
	Iterator itt = subterms.iterator();
	Term st;
	if (!(subterms.isEmpty())) { 
		xml = xml.concat(((Term)itt.next()).XMLStringOf());
		
		while (itp.hasNext()) {
		st = (Term)itp.next();
		xml = xml.concat(st.XMLStringOf());
		};
	};
	xml = xml.concat("\n&lt;/fdl:term_list&gt;");
       
	return xml.concat("\n&lt;/fdl:term&gt;");
    }
}

