package FDL.term;

import java.io.*;

//import java.util.ArrayList;

public class TermReader extends TermSyntax {

    private InputStream reader;
    private byte cur;
    private boolean readaheadp = false;

    private StringBuffer charsread = new StringBuffer ();

    public TermReader (InputStream s) { reader = s; }

    private void nextByte () throws TermInputException {
	int ibyte;

	try {
	    ibyte = reader.read();
	}
	catch (Exception e) {
	    throw (new TermInputException(charsread, "IOException read failed"));
	}
	    
	if (ibyte == -1) throw (new TermInputException(charsread, "EOF"));
	cur = (byte) ibyte;
	charsread.append((char)ibyte);
	readaheadp = true;
    }

    private byte curByte () throws TermInputException {
	if (!readaheadp) nextByte();
	return cur;
    }

    private byte readByte () throws TermInputException {
	nextByte ();
	return cur;
    }
	
    // convert ascii to Unicode!. Maybe later have a UTF8 reader/writer.
    // escapecode followed by four digits is unicode.
    String read () throws TermInputException { 

	byte c;
	StringBuffer b = new StringBuffer();

	boolean unip = false;
	char[] unibuffer = new char[4];
	int uniint;

	c = curByte();
	
	// read until unescaped special char.
	while (!(special((char)c))) {
	    if (c == escape) {
		c = readByte();
		
		if (unichar(c)) { 
		    
		    uniint = (Character.digit((char)c, 16)) * 4096;
		    uniint = uniint + ((Character.digit((char)readByte(),16)) * 256);
		    uniint = uniint + (Character.digit((char)readByte(),16) * 16);
		    uniint = uniint + Character.digit((char)readByte(),16);
			
		    System.out.println("read unicode char: " + uniint);
		    b.append((char)uniint);
		} else {
		    b.append((char)c);
		}
	    }
	    else { 
		b.append((char)c);
	    }
	    c = readByte();
	}
	return b.toString();
    }

    boolean check (byte c) throws TermInputException {
	if (curByte() == c) 
	    return true;
	else return false;
    }

    boolean maybe (byte c) throws TermInputException { 
	if (check(c)) { 
	    readaheadp = false;
	    return true;
	}
	else return false;
    }

    // if next char not d then fail.
    boolean mustbe (byte c) throws TermInputException {
	if (c == curByte()) {
	    readaheadp = false;
	    return true;
	}
	else throw (new TermInputException(charsread, ("Expected " + c + " but found " + cur)));
    }
}
