
(in-package "CL-USER")

(defparameter *system-package-name-suffix* (princ-to-string *system-major-version*))
(defparameter *system-package-name-root* *system-kind*)

(defparameter *system-package-name* 
  (concatenate 'string *system-package-name-root* *system-package-name-suffix*))

(defmacro in-system-package ()
  `(in-package ,*system-package-name*))


(defun load-expand ()
  (load (extend-pathname (pathname cl-user:*system-root*)
			 '("sys" "utils")
			 "expand"
			 "l")))


(defvar *current-system-name* nil)

(defun compile-current-system ()
  (if *current-system-name*
      (funcall (intern "COMPILE-SYSTEM" (find-package "MAKE")) *current-system-name*)
      (format t ";;;	No current system to compile~%")))

(defun ccs () (compile-current-system))

(export '(ccs compile-current-system))

(defun doorb ()

  ;;(setf *current-system-name* 'orb)
  (setf *current-system-name* 'fdl-ml-mb)
  (ccs)

  (funcall (intern "DO-INIT-ORB" (find-package *system-package-name*)))
  )

;;(load "~nuprl/nuprl4i/nuprl5/sys/defs.lsp") (dolib "~nuprl/nuprl4i/nuprl5/")
(defun dolib ()

  (setf *current-system-name* 'fdl-lib)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-INIT-LIB" (find-package *system-package-name*)) t t)
  )

(defun ddlib ()

  (setf *current-system-name* 'fdl-lib)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-DISK-INIT-LIB" (find-package *system-package-name*)))
  )

(defun doasvr (&optional files)

  (setf *current-system-name* 'fdl-appl-server)
  
  (ccs)
  
  (in-system-package)
  (funcall (intern "DO-INIT-APPL" (find-package *system-package-name*))
	   (or files
	       (list (cons "appl" (list "asm-bsc"))
		     (cons "top" (list "comm-ned")))))
  )
(defun ddasvr (&optional files)

  (setf *current-system-name* 'fdl-appl-server)
  
  (ccs)
  
  (in-system-package)
  (funcall (intern "DO-DISK-INIT-APPL" (find-package *system-package-name*))
	   (or files
	       (list (cons "appl" (list "asm-bsc"))
		     (cons "top" (list "comm-ned")))))
  )


(defun dooed ()

  (setf *current-system-name* 'fdl-edit)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-INIT-OED" (find-package *system-package-name*)))
  )

(defun ddoed ()

  (setf *current-system-name* 'fdl-edit)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-DISK-INIT-EDD" (find-package *system-package-name*)))
  )

(defun doref (&optional (holp t))

  (setf *current-system-name* 'nuprl5)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-INIT-REF" (find-package *system-package-name*)))
  (when holp
    (funcall (intern "DO-ML-HOL-COMPILE")))
  )

(defun ddref (&optional (holp t))

  (setf *current-system-name* 'nuprl5)
  (ccs)
  
  (in-system-package)

  (funcall (intern "DO-DISK-INIT-REF" (find-package *system-package-name*)))
  (when holp
    (funcall (intern "DO-ML-HOL-COMPILE")))
  )

(defun ddrefh ()  (ddref t))

(defvar *standard-choices* '("dolib" "dooed" "doref" "ddlib" "ddoed" "ddref" "ddrefh" "dopvs" "doasvr" "ddasvr"))
(defvar *local-choices* nil) ;; expect local-init.l to setf.

(defun interrogate (choices)

  (format t
	  "~%;;; You will get to choose one of the following:~%;;;	 ~a ~% \
;;;	You need to answer y or n to the following questions. ~%;;;~%~%"
	  choices
	  )

  (labels

      ((choose ()

	 (let ((choice (some #'(lambda (s)
				 (when (y-or-n-p (format nil "~a ? " s))
				   s))
			     choices)))

	   (unless (and (null choice)
			(y-or-n-p "abort ? "))
	       
	     (if (null choice)
		 (progn
		   (format t "~%;;;  That's all your options, we'll go through it again.~%~%")
		   (choose))
		 (let ((cs (intern (string-upcase choice))))
		   (let ((f (symbol-function cs)))
		     (if f
			 (funcall f)
			 (progn
			   (format t "~%;;; Well now I'm confused, you have apparently made an unsupported choice.")
			   (format t "~%;;; There's no function bound to that choice?!? pick another.~%~%")
			   (choose))))))))))
  (choose)))
 

(defun goo-goo-goo ()

  (load-expand)

  (let ((localpath (extend-pathname (pathname *system-path-prefix*) '("sys") "local-init" "l")))
    (when (probe-file localpath)
      (load localpath)))

  (when cl-user:*system-interrogate-p*
    (interrogate (append *local-choices* *standard-choices*)))

  (in-package "FDL0")

  )


(goo-goo-goo)

