
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	RLE TODO : Labels come from dtree, but need some type of label wrapping in dforms.
;;;;	RLE TODO : similar to margin, ie push/pop, parent pops etc?
;;;;	when dform wraps sequence of formats with presentation label, this is distributed
;;;;	over formats when formats interpreted. Ie need no wrapping structure for formats.
;;;;	

;;;;	RLE NAP : nifty debugging feature would be to explode dtree into term to
;;;;	RLE NAP : be able to view dtree.



;; need some rigid conventions for naming functions to automatically discern queries(state), side effects,
;; construct destructs lookups(environmnet) conversions access(abastract types pieces) ???


;;;;   structures, states, tables, and environments   


;;;;	Function name conventions :
;;;;
;;;;	Makes names more intuitive and gives some indications of implementation, ie a conversion
;;;;	can be expected to be more costly than an access. Also an access should be expected to
;;;;	return eq values in no intervening side effects.
;;;;
;;;;	makes searching easier.
;;;;
;;;;	need conventions for comments to indicate kind of entity ie state/type etc.
;;;;	need declare comment syntax to declare name kind and list of fields with optional
;;;;	type of fields. If explicit enough could macroize (lisp code at least). Maybe even
;;;;	make conventions for def of ml bodys so they simply call expected lisp functions.
;;;;	macroize sounds ok but may be limiting in special cases and can be more difficult
;;;;	to read if not done well.
;;;;
;;;;	type and state names should alleviate name space concerns.
;;;;
;;;;	Abstract types : a type has a list of fields
;;;;
;;;;	State : manipulated via side effects.
;;;;
;;;;	test is query of boolean.
;;;;
;;;;
;;;;
;;;;	construct :	make_<type>
;;;;
;;;;	access :	<field>_of_<type>
;;;;	
;;;;	conversion :	<type>_to_<type>
;;;;	
;;;;	test :		<type>_<field>_p
;;;;
;;;;	operation : 	<type>_<op>
;;;;
;;;;	
;;;;	State :
;;;;
;;;;	construct	new_<state>
;;;;
;;;;	discard	:	close_<state>
;;;;	
;;;;	query :		<state>_<field>_q
;;;;			<state>_<field>_at_<address>_q
;;;;
;;;;	operation :	<state>_<operation>
;;;;
;;;;	substantive op:	<state>_<operation>_x
;;;;	  * ie has significant side-effect.
;;;;
;;;;	assign :	<state>_set_<field>
;;;;
;;;;	test :		<state>_<field>_p
;;;;
;;;;	Environment :	(tables) some of this is handled implicitly, eg new_<state> may do implicit add to env.
;;;;	
;;;;	lookup : 	<type>_lookup
;;;;			<type>_lookup_by_<field>
;;;;
;;;;	extend :	add_<type>
;;;;
;;;;	limit : 	remove_<type>



;;;;	Display and Edit :
;;;;	
;;;;	Edit and Presentation
;;;;	
;;;;	Dtree : implementation structure for doing display.
;;;;
;;;;	

;;;;	Required capablilities :
;;;;
;;;;	  - robust modification
;;;;	  - robust display
;;;;	  - variable layout
;;;;
;;;;	  - Comprehensive ML edit interface.
;;;;	  - abstract implementation wrt ML.
;;;;
;;;;	  - PERFORMANCE Space and Time.
;;;;	  
;;;;	  * shared term structures.
;;;;	  * persistent (ie reuseable) layout structures.
;;;;	  * constructive modification wrt represented term.
;;;;
;;;;	  * display and edit structures same -> dtree.
;;;;	  * no sharing of dtrees.
;;;;	  

;;;;	Dtree < (Edit = (Presesentation < Macros))
;;;;
;;;;	Possibly presentation requires edit.
;;;;
;;;;	dtree is all lisp. 
;;;;	Edit is ML interface coded in lisp.
;;;;	 - lots of interaction with dtrees.
;;;;
;;;;	A lot of setfs in dtrees for flags layout etc.
;;;;	
;;;;	
;;;;    No destructive modification to dtree can change term represented.
;;;;	Persistence reuse of layout desired.
;;;;	No sharing of layout allowed.
;;;;	


;;
;;	term -> dtree - ptree - window.
;;
;;	ptree : presentation tree :
;;	 - tree of strings.
;;	 - presentation tags, ie fonts/colors/etc/
;;	  - mark stack will be presentation tags.
;;	 - edit tags, ie traversable modifiable.
;;
;;	dtree - ptree :
;;	 - ptree could be passed to emacs/java for front end.
;;	 - lots in dtree/ptree interaction.
;;


;;;;	
;;;;	Functions to define and use character mappings :
;;;;
;;;;	inform-label (<label> sexpr
;;;;		      <bool{layout-scope}>
;;;;		      <bool{presentation-scope}>
;;;;		      <tok{extent:tree|local}>)
;;;;
;;;;	 * <label> sexpr should be a label or a list of labels.
;;;;	   If a list then members of the list define a shadow class.
;;;;	




;;;;	Arrow notes :
;;;;
;;;;	arrows 2190 21ea  = => maps to 21d0 and <= = maps to 21d2 <= => by self map to 21e0 21e2??
;;;;	
;;;;	there are three sets of arrows
;;;;	small : left, right, and left and right
;;;;	 FTTB : map left to left right to same single arrows as medium
;;;;	  and map left and right to single left and right.
;;;;	I believe this should be sufficient as medium left and right
;;;;	should not occur without a middle? should check during conversion.
;;;;
;;;;	medium : left, right, and middle
;;;;	 FTTB : map left to left right to expected single arrows 
;;;;	  and map middle to form and chart line (2500)
;;;;
;;;;	large (double lined) : left, right, and middle
;;;;	 FTTB : map left to left right to expected double arrows 
;;;;	  and map middle to form and chart double line (2550)
;;;;	

;;;;	  * can map left-middle to double left and
;;;;	    middle right to double right
;;;;	    and right middle left to double left and right.
;;;;	  assumes no left and right alone.

;;;;	
;;;;	character-label-map (<label{tree}> list
;;;;			     <label{local}> list
;;;;			     <label{format}> list
;;;;			     <label{liveness:!dead|!live})
;;;;	  : <label> list
;;;;	 
;;;;
;;;;	inform-character-label-map ((<label> list . <label> list) list)	: NULL
;;;;	  * when mapping character labels, the first entry for which all lhs
;;;;	    labels occur unshadowed in the arguments will be used. Wrt shadowing
;;;;	    format binds tighter than local which is tighter than tree, while
;;;;	    liveness is tightest of all.
;;;;
;;;;
;;;;	character-glyph-map (<unicode> sequence <label> list)
;;;;	 : (BYTE16{font} . BYTE16{font-index}) array
;;;;	
;;;;	inform-character-glyph-map ((<unicode> <unicode> <label> list
;;;;				     . <string{font-name}> BYTE16{font-index offset}) list)
;;;;	  * Each entry : for range of unicode chararacters and character labels identifies a font and
;;;;			 a starting font index for the characters.
;;;;	    EG, #x2080 #x2089 '(bold large) . ("large-subscripts" . #x30)
;;;;	        #x2080 #x2089 '(normal large) . ("large-subscripts" . #x50)
;;;;	        #x2080 #x2089 '(underline large) . ("large-subscripts" . #x70)
;;;;	     might be some of entries in a glyph map.
;;;;
;;;;  -page-

;;;; -docs- (mod edd dform)
;;;;
;;;;	Edit : the creation, modification, and display of a term.
;;;;	
;;;;	dtree	: a term representation annotated with dform choice
;;;;		  tailored for display and modification.
;;;;
;;;; -doct- (mod edd)
;;;;
;;;;	          Dtrees are not directly accessible by the ML edit
;;;;	          functions.
;;;;
;;;;	A dtree actually contains two trees: 
;;;;	  - total : the total child list is created by matching the
;;;;	    dform model term against the instance. The children are
;;;;	    ordered by order of occurence of the display meta variables
;;;;	    in the model term.
;;;;	      * Some commands do work on the total tree, however, it's
;;;;	        probably better to work directly on the term than on the
;;;;	        total tree.
;;;;	  - permuted : the permuted child list is created by permuting
;;;;	    the total list to match the order of occurence of the
;;;;	    display vars in the format list of the dform.
;;;;	
;;;;  -page-
;;;;
;;;;	Dform :
;;;;
;;;;	The choice of dform to display an operator instance in a term
;;;;	may become stale through the addition or deletion of dforms,
;;;;	other changes to the edit state, or changes to the term. New
;;;;	dforms will be chosen only when explicitly requested during an
;;;;	edit operation. Thus if an edit function detects a dform at a
;;;;	point in the dtree it can be sure that it will not be changed by
;;;;	a side effect. This does allow an unfortunate condition in that
;;;;	a point in a dtree may have a dform which could never be chosen
;;;;	for it.  A dform which is not stale is said to be the optimal
;;;;	dform for the node. The capability of forcing a dform at a point
;;;;	during an edit evaluation is also supplied.
;;;;
;;;;	Uninstantiated Dtree's :
;;;;
;;;;	dtrees are lazily instantiated, for the most part this is hidden
;;;;	from the ML interface. The dtrees will be silently instantiated
;;;;	when they are referenced. It is possible to detect if a point
;;;;	has uninstantiated children if one wishes to avoid
;;;;	instantiation.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Edit is performed with primitive ML functions on primitive
;;;;	abstract types.  Many of these functions perform side effects on
;;;;	the abstract data.
;;;;
;;;;	view : abstract type containing a term and associated dtree.
;;;;
;;;;	Multitasking :
;;;;	At most one task or thread should have access to a view state at
;;;;	a time.  Ie, if a view is modified by an edit evaluation,
;;;;	then no other edit evaluation may modify the view until
;;;;	the first evaluation has completed. Ie, modification implicitly
;;;;	gets a lock which is not released until the evaluation
;;;;	completes. Thus one must be careful that lengthy computations
;;;;	such as a refinement are done asynchrounously if one is not
;;;;	prepared to wait for their completion.
;;;;	
;;;;	Substantive Modifications:
;;;;	A destructive side effect is a side effect which changes the
;;;;	term represented in the view. Dtrees themselves can not be
;;;;	destructively modified such that they change the term, thus a
;;;;	destructive side effect replaces the dtree in the view. It
;;;;	may be abusing the terminology to imply that other side effects
;;;;	are not destructive, however, destructive is descriptive here
;;;;	as the essential piece of the state, ie the term is being
;;;;	changed.
;;;;	
;;;;	Dependencies:
;;;;	A register containing the time-stamp of a destructive side
;;;;	effect will be available in the implementation. Thus functions
;;;;	which cache data can stamp the cache and thus be able to test if
;;;;	the cache is stale wrt the most recent destructive side effect.
;;;;	
;;;;	
;;;; -doct- (mod edd ml)
;;;;  -page-
;;;;
;;;;	VIEWCMD	: view -> unit
;;;;	  * many edit functions with side effects have this type.
;;;;
;;;; -doct- (mod edd)
;;;;
;;;;	Typically a view state has an associated object, an open window,
;;;;	and a history.  However, it is not necessary for a view to have
;;;;	any of these attributes.
;;;;
;;;;	  - (un)associated : view does (not) have an associated object.
;;;;	  - (in)visible : view does (not) have an open window.
;;;;	  - (un)historical : view does (not) have a history.
;;;;	  - lighweight : view does not have an associated object, an open
;;;;			 window, or a history.
;;;;
;;;;	Lightweight views are suitable for such uses as storing intermediate
;;;;	values during edit computations, or as buffers for storing constant
;;;;	dtrees.
;;;;
;;;;  -page-
;;;;
;;;;	Editing by Manipulating dtrees indirectly through the view
;;;;	is a compromise.  While it would be nice to be able to directly
;;;;	manipulate the dtrees functionally, I could not devise a method
;;;;	which would be both efficient and robust.  The indirect approach
;;;;	also allows a more abstract interface which should allow us some
;;;;	flexibility to tinker with the implementation without perturbing
;;;;	the interface.
;;;;
;;;;	There are various methods of getting persistent handles on
;;;;	specific points of the dtree.
;;;;	  - address : an int list address of the point in the dtree.
;;;;	      * address can be fragile as modifications may change the
;;;;		addresses of affected nodes plus all their descendents.
;;;;		Forces excessive querying to count children when
;;;;		navigating dtree.
;;;;	  - label : a token which can be used to tag a single point
;;;;	    within the dtree.
;;;;	      * robust but name-space problems may be a nuisance.
;;;;	  - tag : a token which can be used to tag multiple points
;;;;	    within the dtree.
;;;;	
;;;;	The dtrees indicated by labels may be cached between substantive
;;;;	modifications.
;;;;	
;;;;	All labels, tags, and conditions should be restricted to ascii characters.
;;;;
;;;;	Tags and labels are as persistent as possible, yet they can be lost.
;;;;	  - dtrees representing constant subterms of dforms
;;;;	    are ephemeral due to the ephemeral nature of dform choices.
;;;;	  - dtrees representing indirect library objects are similarly ephemeral 
;;;;	    due to dform choice, plus if the reference is modified or the object is
;;;;	    modified, then the dtree is replaced.
;;;;	      * RLE TODO : need to filter labels in object terms.
;;;;	
;;;;	
;;;;	editing operations will by default preserve labels but lose tags.
;;;;	presumption is that a label is simply intentional marker but a tag is a 
;;;;	intensional, ie place on the term due to some attribute of the term.
;;;;	Since editing modifies, then the attribute may have changed thus the 
;;;;	tags are treated more ephmerally. The labels though have the connatation of
;;;;	a marker on a map, where yes there may have been construction in the town
;;;;	but the town is still in the same place. To extend to tags, the construction
;;;;	on the town has in fact changed the town so that is is no longer the identical
;;;;	town even though it is still in the same place.
;;;;	
;;;;	TODO : the above may not put well practiced.
;;;;	
;;;;	edit-indices : tags of a sort which record last known position of label in text.
;;;;	  - presence of an edit index does not imply that leaf is labeled.
;;;;	  - labeled leaf does not need explicit index, implicit index is 0.
;;;;	  

;;;;
;;;; -doct- (mod edd dform)
;;;;
;;;;	Conditions and Condition expressions: 
;;;;	
;;;;	Conditions and conditions expressions are a general purpose method for
;;;;	encoding bits and bit testing programs in data to be evaluated at
;;;;	certain junctures.  For example, there may be several dforms which
;;;;	match a term to be displayed. A method to allow the dform author
;;;;	control over how a dform chosen is desirable. A condition expression
;;;;	can be attached to a dform which can be tested at instantiation time
;;;;	to determine if the dform is suitable for current display tree.
;;;;	
;;;;	There are various sources of conditions. The prescence of a condition
;;;;	tag on a dform is a condition. Also abstractions can have condition
;;;;	tags as well as display trees. The structure of the the display tree
;;;;	at a node can be tested using conditions. The type of a parameter is a
;;;;	condition.
;;;;
;;;;	Condition expressions are used to control suppression of dforms and
;;;;	choice of dforms. Condition expressions can be used in presentation
;;;;	macros to control applicability of macros. Certain edit functions take
;;;;	condition expressions as arguments to filter display trees or control
;;;;	motion through a display tree.
;;;;
;;;;	The same purpose could have been served by specifying hooks and
;;;;	predicate functions. However, the condition expression facility
;;;;	allows for a more abstract and efficient implementation.
;;;;
;;;;	While the expression syntax is robust, it does not allow for
;;;;	programmable navigation in the dtree. Instead a function is provided
;;;;	to walk the dtree and evaluate expressions.
;;;;	
;;;;	- interpretation of expression depends on context
;;;;	- avoids apriori specification of decisions
;;;;	  ie, allows customization by UI coder.
;;;;	
;;;;
;;;;	Condition expressions can be built directly with primitive
;;;;	functions or encoded in strings with a syntax to be presented
;;;;	later.
;;;;
;;;;	Translation and compilation of condition expressions is possible.
;;;;	
;;;;	Condition expressions will be used for various purposes including but not
;;;;	limited to:
;;;;	 - to test complex conditions at a dtree.
;;;;	    * walk
;;;;	    * paste filters
;;;;	 - to test suitability of dforms.
;;;;	    * suppression
;;;;	    * choice
;;;;	 - to decide applicability of presentation macros.
;;;;
;;;;  -page-
;;;;
;;;;	Expression operators:
;;;;	  The expression evaluator includes implicit point and mark
;;;;	  parameters, as well as an explicit dtree parameter.  All
;;;;	  bindings to the point and mark are dynamic, ie at exit,
;;;;	  entrance value is restored. Initialization of mark and point
;;;;	  depend on context of expression evaluation, but generally both
;;;;	  are initialized to the dtree arg.
;;;;
;;;;	Ops:
;;;;	  - not(<expr>)
;;;;	  - and(<expr>, <expr>)
;;;;	  - or (<expr>, <expr>)
;;;;	  - parent(<expr>)
;;;;	      * binds point to parent, then expression is evaluated.
;;;;	  - child(<expr{filter>, <int{i}>, <expr>)
;;;;	      * applys filter to each child to produce list of children for
;;;;		which filter is true.
;;;;	      * binds point to i'th child of filtered list, where 1 is first child.
;;;;		negative numbers mean i'th from end.
;;;;		If insufficient number of children then evals to false.
;;;;	      * expression is evaluated on point.
;;;;	  - mark(<expr>)
;;;;	      * binds mark to point and then expr is evaluated.
;;;;	  - Could have an induction form:
;;;;	    * ind(<expr{base}> <expr{ind}>)
;;;;	      - eval base on point. If true return true.
;;;;	      - if eval base false then
;;;;	        * bind mark to point
;;;;	        * eval ind on point
;;;;		  - if ind evals to false return false.
;;;;		  - if point = mark return false.
;;;;		  - otherwise eval ind(...) on point.
;;;;	    * EG. ind(ML or(not(top) zoomed parent(true)))
;;;;	      : tests for ML condition in ancestor.
;;;;	    * Not implemented:
;;;;	      - exceeds purpose: efficient method of testing multiple
;;;;		local conditions.
;;;;	        * distant conditions can be tested with walk functions.
;;;;	      - termination concerns.
;;;;	      - ancestor and descendent operators implemented instead.
;;;;	    * ancestor : ancestor(<expr>)
;;;;	      - true if expr is true on any ancestor.
;;;;		not(ancestor(not(<expr>))) can be used to test if expr is true on all ancestors.
;;;;		ancestor is reflexive.
;;;;	    * descendent : descendent(<expr>)
;;;;	      - true if expr is true on any descendent.
;;;;	        Sloppy use can be expensive ie compare |(<foo <goo) with <(|(foo goo))
;;;;		First requires two traversals of descendents, while second requires one.	
;;;;		An optimization function on condition expressions which transforms
;;;;		first to second would be nice.
;;;;	        This can be used to avoid expense of walk, when walking its use should
;;;;		be limited to avoid n-squared traversal.
;;;;		descendent is reflexive.
;;;;
;;;;  -page-
;;;;
;;;;	Condition modifiers: indicate how to interpret condition. By using modifiers
;;;;	 name space problems among the conditions should be alleviated.
;;;;	  - dtree	: default, see below for possible conditions.
;;;;	  - abs		: check if abs definition for term instance at
;;;;			  point includes condition.
;;;;	  - disp	: check if disp definition for dform at point
;;;;			  includes condition.
;;;;	  - label	: check if dtree at point has label similar
;;;;			  to condition.
;;;;	  - tag		: check if dtree at point has tag similar to
;;;;			  condition.
;;;;	  - parameter type	: check if dtree is parameter and has
;;;;				  type similar to condition.
;;;;	  - modifier expressions	 : an expression syntax for abs
;;;;					   and disp modifiers.
;;;;	      * allows for concise combinations of abs and disp tests
;;;;		for same condition.
;;;;
;;;;	
;;;;  -page-
;;;;
;;;;	Syntax: uses prefix notation and ()'s to make parsing simple.
;;;;
;;;;
;;;;	<token>		: any non-null alpha-numeric token excluding
;;;;			  characters !@#$%^&*()=+|\`~"':;?/>.<,{}[],
;;;;			  excluding whitespace, and starting with alpha
;;;;			  character.
;;;;	
;;;;			: ie token made from :
;;;;			   abcdefghijklmnopqrstuvwxyz
;;;;			   ABCDEFGHIJKLMNOPQRSTUVWXYZ
;;;;			   0123456789
;;;;			   _-
;;;;
;;;;	<mod_terminal>	: $ | # | !$ | !#
;;;;	<mod_expr>	: &<mod_terminal><mod_terminal>	{ lack of spaces }
;;;;			| |<mod_terminal><mod_terminal>	{  is important. }
;;;;
;;;;	<cond_expr>	: <token>			{ dtree }
;;;;	<cond_expr>	: <mod_expr><token>		{ }
;;;;
;;;;	<cond_expr>	: $<token>			{ abs }
;;;;	<cond_expr>	: #<token>			{ disp }
;;;;	<cond_expr>	: ~<token>			{ label }
;;;;	<cond_expr>	: +<token>			{ tag }
;;;;	<cond_expr>	: ,<token>			{ parameter type }
;;;;
;;;;	<cond_expr>	: .<cond_expr>			{ mark }
;;;;	<cond_expr>	: !<cond_expr>			{ not }
;;;;	<cond_expr>	: &(<cond_expr> <cond_expr>)	{ and }
;;;;	<cond_expr>	: |(<cond_expr> <cond_expr>)	{ or }
;;;;	<cond_expr>	: @<cond_expr>			{ parent }
;;;;	<cond_expr>	: *(<cond_expr{filter}>		{ child }
;;;;			    <int>
;;;;			    <cond_expr>)
;;;;    <cond_expr>	: ><cond_expr>			{ ancestor }
;;;;    <cond_expr>	: <<cond_expr>			{ descendant }
;;;;	
;;;;
;;;;	Noet use of space to separate args to n-ary operators.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Dtree conditions: conditions which can be tested at a particular
;;;;	  dtree.  Checking condition which requires instantiated dtree
;;;;	  will force instantiation.
;;;;	
;;;;	dtree conditions is a misnomer. Should be something like builtin conditions.
;;;;	Some apply to both dtrees and terms others to one or the other.
;;;;	
;;;;	
;;;;	
;;;;
;;;;	  true
;;;;	  false
;;;;	
;;;;	  parameter		: point is in text of a parameter dtree.
;;;;	  binding		: point is parameter and occurs in a
;;;;				  binding position in model term of
;;;;				  dform. (It is possible that it also
;;;;				  occurs in the parameter list of the
;;;;				  model term).
;;;;	  display-meta		: point is parameter and display-meta
;;;;				  bit is on.
;;;;	  abstraction-meta	: point is parameter and
;;;;				  abstraction-meta bit is on.
;;;;
;;;;	  slot			: dtree is a slot.
;;;;	  orphan-dform		: dform at node is not user defined, or
;;;;				  the def has been deleted.
;;;;	
;;;;	  top			: a top dtree of view state, ie has no
;;;;				  parent. Note that there may be
;;;;				  multiple tops: one for each dtree
;;;;				  zoomed on plus the root.  However,
;;;;				  only one is accessible at a time.
;;;;	  zoom			: dtree has been zoomed to and is at top
;;;;				  of zoom stack. Must also be top.
;;;;	   ** &(top !zoom) means absolute top or root.
;;;;
;;;;	  tree			: dtree has children. *(true 1 true)
;;;;	  elided		: dtree is elided. Descendents of an
;;;;				  elided dtree are not considered elided
;;;;				  because the dtree is. They may of
;;;;				  course be elided in their own right.
;;;;	  hidden		: dtree is a hidden. Descendents of a
;;;;				  hidden dtree are not considered hidden
;;;;				  because the dtree is.
;;;;	  instantiated		: dtree is instantiated, ie has dform
;;;;				  and children.
;;;;
;;;;	  modifiable		: false if node may not be modified.
;;;;
;;;;	  =			: true if point is same dtree as mark.
;;;;	
;;;;	  tag			: true if term mode and term is !label or !tag term.
;;;;	
;;;;
;;;;	 * I doubt following are applicable any longer.
;;;;	  textfirst		: point is parameter and at first text
;;;;				  postion.
;;;;	  textlast		: point is parameter and at last text
;;;;				  postion.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Examples:
;;;;	- Tests if number of children = n :
;;;;	  *(true n true)
;;;;	- Tests if number of term children = n :
;;;;	  *(!parameter n true)
;;;;	- Tests if i'th natural parameter is abstraction meta slot :
;;;;	  *(&(,n i &(abs-meta slot)))
;;;;	- Tests if last term child of parent :
;;;;	  .@*(!parameter -1 =)
;;;;
;;;; -doct- (mod edd)
;;;;	
;;;;	Flags : 
;;;;
;;;;	Labels on dtree nodes can be tested as conditions. We also
;;;;	desire the ability to test edit and view flags as conditions.
;;;;	Dtree labels, edit flags, and view flags are treated similarly.
;;;;	Dtree labels take precedence over view flags which take
;;;;	precedence over edit flags. Thus one can override a global flag
;;;;	in a view or a global or view flag at a dtree node.
;;;;	
;;;;
;;;;	Any error condition causes failure to top of condition expr evaluator
;;;;	which then returns false.
;;;;	 - unknown condition (only applies to dtree conditions).
;;;;	 - out of range child index.
;;;;	 - evaluating parent at root.
;;;;	 - evaluating disp conditions on leaf.
;;;;	 
;;;;
;;;;  -page-
;;;;
;;;;   There is some room for extensibility in both in condition
;;;;   expressions and conditions themselves.
;;;;	- Fairly robust now.
;;;;	    new dtree conditions can be added trivially.
;;;;	- some special chars are reserved.
;;;;	- abstract implementation in ML/lisp.
;;;;
;;;;
;;;;	cond_expr will be defined as a primitive abstract type.
;;;;
;;;;	Advantages of primitive abstract type compared to :
;;;;	  - strings
;;;;	      * expressions can be shared.  Advantageous as changing a
;;;;	        shared expression simultaneously changes all referencing
;;;;	        expressions. If you do not consider this a plus, then do
;;;;	        not write shared expressions.
;;;;	      * Does not need to be parsed at each use.
;;;;	 - absrectype
;;;;	      * Better ML/CL integration.
;;;;	      
;;;;	cond_exprs can be parsed from strings in ML.
;;;;
;;;;  -page-
;;;;
;;;;	Condition Expressions as terms:
;;;;	  - abstractions can be defined which expand to ml expressions
;;;;	    which eval to cond_expr.
;;;;	     * expand to parse of string.
;;;;	     * expand to functions using primitive cond_expr functions.
;;;;	  - no direct encoding.
;;;;	     * primarily because it isn't necessary.
;;;;	     * if some advantage is defined, then such an encoding can
;;;;	       be added.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	  Walk: Condition Expressions allow you to test complex
;;;;	  conditions locally within a dtree. Walk can visit each node of
;;;;	  the dtree and test a condition.  Walk also takes cond_expr
;;;;	  arguments to control which areas of a dtree can be visited.
;;;;  -page-
;;;;
;;;;	  - Preorder: Starting at a specific point walk visits points in the
;;;;	    tree in preorder.
;;;;	      * Eg: Tree[e (b (a) d (c))] -> Order[a b c d e]
;;;;	      * algorithm :
;;;;		- move; check stop; check halt; repeat.
;;;;		- move :
;;;;		  * if there is a next sibling then visit leftmost
;;;;		    descendent of sibling.  if sibling does not have
;;;;		    descendents then visit sibling.
;;;;		  * else if parent visit parent.
;;;;		  * else (ie root) visit leftmost descendent if there
;;;;		    are no children then visit self.
;;;;	      * total : the walk function can walk the total tree or the
;;;;	        permuted tree.  In order to visit hidden dtrees, the
;;;;	        total tree must be walked.
;;;;  -page-
;;;;
;;;;	  - Avoid : walk takes two cond_expr's used to limit areas of
;;;;	    the dtree visited.  The true avoid expressions limit the
;;;;	    nodes seen by the move part of the preorder algorithm.
;;;;	      * up : enforces a ceiling on walk. If the avoid up
;;;;	        condition is true at a point, then the node is treated
;;;;	        as though it has no parent.
;;;;	      * down : enforces a floor on walk. Used to filter child
;;;;	        list.  If the avoid down condition is true then the
;;;;	        dtree is not considered as a sibling or child.  Avoid
;;;;	        down prevents movement down to a point, it does not
;;;;	        prevent movement down from a point.  Ie, if true at
;;;;	        root, avoid down does not prevent visit of leftmost
;;;;	        descendent.
;;;;	      * point : each move could be expressed as a sequence of up
;;;;	        and down steps. At each step the appropriate avoid
;;;;	        conditon expression is evaluated with the point
;;;;	        initialized to the source of the step.
;;;;	      * mark : the condition evaluator's mark is initialized to
;;;;	        the start point of the walk prior to evaluating the
;;;;	        avoid conditions. This allows you to test position
;;;;	        relative to the start point. For example, if the start
;;;;	        point is not root, you could avoid visiting the start
;;;;	        point and any of its descendents by specifying avoid
;;;;	        down as "=". Similarly, you could avoid visiting any of
;;;;	        the start points ancestors by specifying avoid up as
;;;;	        "=".
;;;;  -page-
;;;;
;;;;	  - Stop : there are two levels to control stopping.
;;;;	      * cond_expr : a cond_expr arg must evaluate true to stop.
;;;;	      * function  : if the expr is true, then a stop ml predicate
;;;;		is run. If it also returns true, then the walk label is
;;;;		left at point and walk returns true. The function may be
;;;;		used to execute side-effects. In this way, walk may be
;;;;		used like a mapping function.  Destructive side effects
;;;;		are discouraged within stop functions.  Most likely
;;;;		consequence is that you will end up walking dtree which
;;;;		is no longer part of view state. Walking to a point
;;;;		making a modification and stopping would not be a
;;;;		problem.  Walking a dtree, tagging nodes, and then
;;;;		mapping a modification over the tags (see below) is
;;;;		safe.
;;;;	      * some stop condition idioms are optimized:
;;;;	          - &(!parameter <expr>): test only non parameter dtrees
;;;;	          - &(parameter <expr>)	: test only parameter dtrees.
;;;;	          - |(&(!parameter <expr1>) &(parameter <expr2>))
;;;;		    : test expr1 on non-parameter dtrees and expr2 on
;;;;		      parameter dtrees.
;;;;  -page-
;;;;
;;;;	  - Halting : prevents loop if stop condition not satisfied
;;;;	    after one traversal of tree.  A trivial check would be to
;;;;	    halt if attempting to move from the start point (other than
;;;;	    initial move). However, the avoid expressions may cause the
;;;;	    start point to be skipped thereby prevent halting. However,
;;;;	    a simple generalization of this trivial check is sufficient.
;;;;	    Rather than considering only the start point, the path from
;;;;	    the start point to the root is used.
;;;;	      * if avoid down is true and point is on start path then
;;;;		halt.
;;;;		  - if avoid had not been true then stop point would
;;;;		    have been encountered when traversing avoided tree.
;;;;	      * if avoid up is true and point is not on start path than
;;;;		halt.
;;;;	          - must have navigated entire tree below point if up is being
;;;;	            tested and start is not in said tree.
;;;;
;;;;	
;;;;	It would be possible to walk a term as a dtree as long as no dtree or
;;;;	dform specific conditions were tested. If stop conditon becomes true
;;;;	then would need to instantiate a path to point prior to calling stop func.
;;;;	
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Tag : primitive abstract type.
;;;;
;;;;	A tag may be used as a label and a tag. It is not an error to
;;;;	use the same tag for both purposes.
;;;;
;;;;	Tags come in two varieties, ephemeral and static. Ephemeral tags
;;;;	should be used when you do not want a specific name for a tag.
;;;;	Tags are simply symbols. Ephemeral tags are not interned, so
;;;;	only equality is eq. Tags are defined distinct from tokens to
;;;;	prevent any ML semantic inconsistencies wrt uninterned symbols
;;;;	as tokens.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Tags :  persistent handle on multiple dtree points.
;;;;
;;;;	Tags are used to approximate making a collection of dtree nodes.
;;;;	For the same reasons that we did not want to expose dtrees
;;;;	directly to the ML interface, tag collections are difficult to
;;;;	express. The ephemeral nature of the dtree pointers makes
;;;;	maintaining a collection of active pointers complicated.
;;;;
;;;;	One approach is to never explicitly produce the collection.
;;;;	Members could be accessed and removed from the collection
;;;;	individually.  No order can be assumed. This can be handled by
;;;;	the user with the walk function.
;;;;	
;;;;	A second approach is to produce snapshots of the collection upon
;;;;	request.  Such a snapshot would be a list whose members could be
;;;;	accessed sequentially. A snapshot would only be valid until the
;;;;	next destructive side effect.
;;;;
;;;;	It would be possible to assign index values to the members so
;;;;	that they could be distinquished. Such index values would allow
;;;;	an order to be defined among the members of a collection.
;;;;	    - Inorder : The index value could be defined to be the
;;;;	      address of the tagged dtree node.
;;;;	    - Sequence : A sequence number incremented at tag time could
;;;;	      be used. Then the order would be related to time of use
;;;;	      rather than structure.  Duplication of subterm through
;;;;	      modification could produce multiple nodes with the same
;;;;	      index value.  These could be disambiguated by appending
;;;;	      additional numbers, ie the index value is a list of
;;;;	      numbers where the first is a sequence number and the rest
;;;;	      are indices arbitrarily assigned to disambiguate duplicate
;;;;	      sequence numbers.
;;;;	      ***  Sequence ordering is not implemented.  *** 		
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Terms : terms can be exported from the view, modified,
;;;;	  and then imported.
;;;;
;;;;	Tags and labels will persist through exporting, importing, and
;;;;	most modification. It is likely that removal of some or all tags
;;;;	and labels may be desired. The export and import functions can
;;;;	filter tag and labels.
;;;;
;;;;	A filter is specified as a list of tags and a bool. If the bool
;;;;	is true than the specified tags are removed, if false then all
;;;;	but the specified tags are removed. Tags and labels use seperate
;;;;	filters to avoid name collisions. Also a seperate bool is used
;;;;	to control filtering of ephemeral tags. The tag filter takes
;;;;	precedence over the ephemeral filter if there is conflict.
;;;;	
;;;;	In order to directly support ephemeral tags, tag will be defined as a
;;;;	new parameter type. Converting an ephemeral tag in parameter form to a
;;;;	string will result in an arbitrary string.  A
;;;;	parameter-to-string/string-to-parameter cycle of an of an ephemeral tag
;;;;	will not result in equivalent tags.
;;;;
;;;;	!label{<tag>:token}(<term>)
;;;;	!tag{<tag>:token}(<term>)
;;;;	!tag{<tag>:tag}(<term>)
;;;;
;;;;
;;;;	If there are multiple labels or multiple tags, then there may be
;;;;	multiple tag parameters. Possibly allow for no parameters in
;;;;	case needed for filtering ephemeral tags.
;;;;	
;;;;	Would like these to be expanded away except on import to edd.
;;;;	Could define the quote versions as unconditional abstractions and 
;;;;	export from edd as quoted. Then any use except edd expands,
;;;;	but edd use unquotes.
;;;;
;;;;	Functions to directly filter tags and labels from terms are
;;;;	also supplied.
;;;;
;;;;	
;;;;	Consider imploding a term in the editor, the structures holding
;;;;	the exploded term may be tagged. At implode time we need to remove
;;;;	tags from the explode operators but not the exploded data.
;;;;	Twould be neat if general utilities were powerful enough to handle.
;;;;	Just filter labels is not sufficient as it would filter data.
;;;;	Need walk which can identify explode structures, in combo with filter.
;;;;	Could define abs with explode tags. Then floor of walk is when  
;;;;	
;;;;	descendent is tag op and termof is not explode
;;;;	
;;;;	<(&($tag *(true 1 !$explode))
;;;;	
;;;;	desire built-in abstraction conditions for ! primitives without
;;;;	need to define in abstraction object, or have built-in abstraction
;;;;	objects. Or have built-in defs from which we can derive
;;;;	read-only objects. 
;;;;	Or accept that we need some sys library with this stuff.
;;;;	
;;;;	
;;;;	so use walk to ephemeral tag tags to be removed 
;;;;	then map-term to remove or map term with cond-expr and avoid walk.
;;;;	
;;;;	
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Cut and Paste : modifying the term.
;;;;
;;;;	Non trivial, eg cutting a slot, pasting and cutting will
;;;;	have destructive side effects.
;;;;
;;;;	Pasting is the means of building term structure. Dforms can be
;;;;	pasted to create new structure. Dtrees and terms may be pasted
;;;;	in order to create new combinations of existing structure.
;;;;
;;;;	The structure being pasted into, the target, is always a dtree.
;;;;	The structure being pasted, the source, may be a dform, a term,
;;;;	or a dtree. There are two flavors of pasting, insert and
;;;;	replace. An insert paste, inserts the target dtree back into the
;;;;	source after the source is pasted at the target point. The point
;;;;	of reinsertion can be chosen with a cond_expr.  In a replace
;;;;	paste, the children of the target are reinserted back into the
;;;;	source after the paste. The target operator is lost. The target
;;;;	children are pasted in the permuted order of the target.
;;;;
;;;;	The order of insertion can be controlled with a bool argument.
;;;;	No reinsertion is done if the target is a slot. The points of
;;;;	reinsertion into the source are chosen by a cond_expr.  Also,
;;;;	the target children, if replace mode, or the target itself, if
;;;;	insert mode, may be filtered with a cond_expr.  It is possible
;;;;	that there are more dtrees to be reinserted than there are
;;;;	slots. Dependeng on a boolean argument paste will fail or
;;;;	continue silently.
;;;;
;;;;	Thus, the only ways to lose structure :
;;;;	  - paste with replace will lose the target operator.
;;;;	  - paste will lose the filtered target or target children.
;;;;	  - paste will lose the the structures at the reinsertion
;;;;	    points of the source.
;;;;	  - cut will lose the cut dtree.
;;;;	  
;;;;	Paste will optimize the filters for obvious cond_exprs.
;;;;	  - target filter
;;;;	    * true
;;;;	    * !parameter
;;;;	 - source filter
;;;;	    * slot
;;;;	    * &(slot, !parameter)
;;;;	
;;;;	
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Recall the label invariant:
;;;;
;;;;	** No label may occur in any dtree at more than one point **
;;;;
;;;;	Any ML evaluation which would result in violating this
;;;;	invariant will fail.
;;;;
;;;;	If paste fails, the dtree will be unaltered.
;;;;
;;;;	The source and destination may be and in fact are likely to be
;;;;	in distinct views. Lightweight views may be used as
;;;;	registers or buffers for source trees by pasting the dtree
;;;;	to the lightweight view, touching it up, and then
;;;;	pasting it to the target. This will leave the original untouched
;;;;	while allowing the source
;;;;
;;;;	Pasting copies the source dtree. This copying is done lazily.
;;;;	Cutting memoizes the dtree. When a lazy copy needs to be
;;;;	resolved, it may do so by using a memoized dtree rather then
;;;;	doing the copy.  The dtree is required for reinsertion, thus
;;;;	unless pasting to a slot the paste requires the copied dtree
;;;;	before the paste operation completes.  Thus, there is no
;;;;	opportunity to cut the source so that it may be reused.  To
;;;;	allow for reuse in this situation, the paste command for dtrees
;;;;	includes an arg to cause the the source dtree to be cut prior
;;;;	to re-insertion.  To avoid accumulating excessive garbage,
;;;;	memoized dtrees are not persistent. They will not survive
;;;;	outside of the top level ML evaluation in which they were
;;;;	created, and may be even shorter lived.
;;;;	
;;;;	For any destructive side effect the effected dtree must be in
;;;;	the current zoom frame.
;;;;	
;;;;	RLE TODO: Pasting should include tag and label filters for source.
;;;;
;;;;	RLE TODO : The target and the dtree pasted should have tags and labels unioned?
;;;;	
;;;;	RLE TODO : could approximate reinsetion sort by forcing a particular dform onto target prior
;;;;	  to paste. Could do filter same way.
;;;;	
;;;;	Source filter : If huge term want to avoid walking or instantiating dtree for it.
;;;;	      Walks dtree, if cond_expr true at a point then candidate.
;;;;		- true_ce for ceiling and floor. false_ce for stop
;;;;		  use direction of paste.
;;;;	      CondExpr initial mark will be root of source.
;;;;	      Full functionality of CondExpr walk can be accomplished by
;;;;	      first walking source tree and tagging points of re-insertion and then
;;;;	      supplying source predicate which test for such tags.
;;;;	    Parameters and trees are considered distinctly eg if at a tree node then
;;;;	    the first tree fragment is used even if the next fragment is a parameter.
;;;;	
;;;;	why not just take tag arg and expect caller to walk.
;;;;	'slot should then be an adequate tag. or take the ce and expect
;;;;	slot or a ce of a single tag to be optimized.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Dform suitability :
;;;;
;;;;	Condition expressions may be used to filter dforms at several
;;;;	levels:
;;;;	  - The view may have a condition expression used to test dform
;;;;	    conditions, if expression evaluates to true then dform may
;;;;	    be used.  The condition expression should consist only of
;;;;	    logical operators and dform conditions.  Any other operators
;;;;	    or conditions are considered to be an error,
;;;;	  - The edit state may have a similar condition expression.
;;;;	  - A condition expression may be supplied as a dform attribute.
;;;;	    For the dform to be used the expression must evaluate to
;;;;	    true on the dtree under construction.
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Suppression : Dforms may be suppressed at several levels:
;;;;	  - global : dform may not be used in any view.
;;;;	  - view : dform may not be used in a view.
;;;;	      * To survive edit sessions, suppression data could be saved
;;;;		as properties in the library object and the view
;;;;		suppression could then be restablished during
;;;;		initialization possibly by the init hook.
;;;;	  - dtree : dform may not be used at individual dtree node.
;;;;	      * Each dform has a unique tag automatically generated. If a
;;;;		dtree is tagged with this tag then the dform is suppressed.
;;;;		  - tag is guaraunteed absolutely unique (wrt runtime) at creation.
;;;;	      * If dform is named, then dform has a name label generated
;;;;		deterministically from it's object address and name.  If
;;;;		a dtree is tagged with this label then the dform at that
;;;;		address is suppressed. It is allowed to name more than one
;;;;		dform within an object with the same name. In such a case all
;;;;		similarly named dforms are suppressed.
;;;;	      * Note that this is distinct from the usual condition
;;;;		expression test for dform suitability.
;;;;
;;;;	Heretofore, it is ill defined exactly what is suppressed. Is a
;;;;	specific instance of a dform that is suppressed or is it the
;;;;	dform at a specific dform address that is suppressed. Both
;;;;	interpretations are supported.  In order for a dform address to
;;;;	be suppressed though, the dform must be named.
;;;;
;;;;	Stale dforms may be lazily removed from suppression lists. This
;;;;	includes removing dform tags from dtrees. This does not include
;;;;	removing named dforms from suppression lists even if the named
;;;;	dform does not exist.
;;;;
;;;;  -page-
;;;;
;;;;	While these measures, in conjunction with the built-in match and
;;;;	suitability testing appear adequate for controlling dform
;;;;	selection, it is possible that even more control may be
;;;;	required. The following are not implemented but are suggestions
;;;;	for future implementation as the need arises.
;;;;
;;;;	  - Hooks :
;;;;	      * Dform : A hook could be specified in the dform
;;;;		which could look at the term, the partial dtree and
;;;;		the dform to decide suitability.
;;;;	      * View or Global : Similar to dform hook but called on every
;;;;		dtree node. This would be probably be to expensive to be
;;;;		justified.
;;;;
;;;;	  - Recursive : tags which have recursive influence. It is expected
;;;;	    that the presentation layer capabilities obviate the need
;;;;	    for this in the edit layer. However, if required such needs
;;;;	    could be met by one of the following:
;;;;	      * Inductive conditions : implement the proposed induction
;;;;		condition operator.
;;;;	      * dfparms : Allow accumulation and testing of tags in the
;;;;		dfparms.
;;;;	   
;;;;	   - Not-suppress : opposite of suppress, ie dform is not used
;;;;	     unless dtree is tagged.
;;;;	
;;;;
;;;;
;;;;  -page-
;;;; -doct- (mod edd eddml)
;;;;
;;;;	Functions::
;;;;
;;;;	cond_expr :
;;;;
;;;;	edit_ce_not	: cond_expr -> cond_expr
;;;;	edit_and_not	: cond_expr -> cond_expr -> cond_expr
;;;;	edit_ce_or	: cond_expr -> cond_expr -> cond_expr
;;;;
;;;;	edit_ce_parent	: cond_expr -> cond_expr
;;;;	edit_ce_child	: cond_expr -> int -> cond_expr -> cond_expr
;;;;
;;;;	edit_ce_mark	: cond_expr -> cond_expr
;;;;	
;;;;	edit_ce_tok_to_condition	: tok -> tok(modifier} -> cond_expr
;;;;	  * modifier one of : `dtree`, `abs`, `disp`, `parameter`
;;;;
;;;;	edit_ce_tag_to_condition	: tok -> tag(modifier} -> cond_expr
;;;;	  * modifier one of : `label`, `tag`
;;;;	
;;;;	edit_ce_string_to_expression	: string -> cond_expr
;;;;	edit_ce_expression_to_string	: cond_expr -> string
;;;;	
;;;;	There are no predicates or destructors for cond_expr's. If the
;;;;	need arises they can be added.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Views :
;;;;	
;;;;
;;;;	tok_to_tag	: tok -> tag
;;;;	  * produces static tag.
;;;;	
;;;;	new_tag		: unit -> tag
;;;;	  * produces ephemeral tag.
;;;;	    This is only method to create an ephemeral tag,
;;;;	    tags in parsed cond expr's are static.
;;;;	
;;;;
;;;;	Labels:	labels can be moved relative to their current point or they
;;;;	  maybe assigned to arbitrary points.
;;;;
;;;;	** No label may occur in any dtree at more than one point **
;;;;
;;;;	Any ML evaluation which would result in violating this
;;;;	invariant will fail.
;;;;
;;;;
;;;;	edit_remove_label	: tag -> VIEWCMD
;;;;	edit_move_label		: tag -> tag{destination} -> VIEWCMD
;;;;	edit_swap_labels	: tag -> tag -> VIEWCMD
;;;;
;;;;	edit_move_label_to_address	: int list -> tag -> VIEWCMD
;;;;
;;;;	** move VIEWCMDs add label if not already present in dtree.
;;;;
;;;;	
;;;;	Label Index : labels can have an associated index to facilitate
;;;;	  text editing, ie the label + index comprise a character address.
;;;;	
;;;;	edit_label_set_index	: int -> tag{label} -> VIEWCMD
;;;;	edit_label_get_index	: tag{label} -> view -> int
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Moving labels relative to current position:
;;;;	  - motion commands commonly take a bool direction arg.
;;;;	     * true : move left to right.
;;;;	     * false : move right to left.
;;;;
;;;;	edit_up			: tag -> VIEWCMD
;;;;	 * fails if at top.
;;;;
;;;;	edit_down		: bool{direction} -> cond_expr
;;;;					-> tag -> VIEWCMD
;;;;	edit_sibling		: bool{direction} -> cond_expr
;;;;					-> tag -> VIEWCMD
;;;;	 * cond_expr is filter for child list.
;;;;	 * if no satisfying dtree then label is not moved.
;;;;
;;;;	edit_walk		: bool{total}
;;;;				    -> cond_expr {stop condition}
;;;;				    -> (unit -> bool) {stop function}
;;;;				    -> cond_expr {avoid up}
;;;;				    -> cond_expr {avoid down}
;;;;				    -> tag{label}
;;;;				    -> bool{direction}
;;;;				    -> view
;;;;				    -> bool
;;;;
;;;;	
;;;;	edit_walk_address	: bool{total}
;;;;				    -> cond_expr {stop condition}
;;;;				    -> (unit -> bool) {stop function}
;;;;				    -> cond_expr {avoid up}
;;;;				    -> cond_expr {avoid down}
;;;;				    -> int list
;;;;				    -> bool{direction}
;;;;				    -> view
;;;;				    -> int_list
;;;;	  * fails if halted, rather than stopped.
;;;;	
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Tags:
;;;;	
;;;;	edit_tag_label		: tok{label} -> tag -> VIEWCMD
;;;;	edit_tag_address	: int list -> tag -> VIEWCMD
;;;;	 * tag indicated point.
;;;;
;;;;	edit_tag_remove			: tag{label} -> bool{recursive}
;;;;						 -> tag -> VIEWCMD
;;;;	edit_tag_remove_at_address	: int list -> tag -> VIEWCMD
;;;;	  * remove tag at label.
;;;;	  * if recursive then removes tag in all descendents
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Tag Snapshots : Inorder order.
;;;;	
;;;;	edit_tag_snapshot	: tag -> cond_expr -> VIEWCMD
;;;;	  * cond_expr filters snapshot members.
;;;;
;;;;	edit_tag_ss_stale_p	: tag -> bool
;;;;	  * if snapshot is stale, other snapshot functions will fail.
;;;;	  * a snapshot becomes stale when a destructive side effect occurs
;;;;	    after the snapshot was taken.
;;;;
;;;;	edit_tag_ss_label	: tag -> VIEWCMD
;;;;	 * move label to top tag.
;;;;
;;;;	edit_tag_ss_address	: tag -> view -> int list
;;;;	 * address of top of snapshot list.
;;;;
;;;;	edit_tag_ss_rotate	: tag -> bool {direction} -> view -> bool
;;;;	 * direction controls direction of rotation.
;;;;	 * returns false if no rotation due to encountering end of list.
;;;;
;;;;	edit_tag_ss_preorder	: tag -> VIEWCMD
;;;;	 * orders snapshot as preorder.
;;;;
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	filter		: bool {ephemeral filter}
;;;;			    # tag list # bool {tag filter}
;;;;			    # tag list # bool {label filter}
;;;;					
;;;;	  ** RLE TODO : should be an abstract type.
;;;;	  ** RLE TODO : supply one constructor and one destructor. 
;;;;
;;;;
;;;;	Terms :
;;;;
;;;;	edit_term		: filter -> tag{label} -> view -> term
;;;;
;;;;	edit_parameter		: tag{label} -> view -> parameter
;;;;	  * no efficiency savings by filter at export time.
;;;;
;;;;
;;;;	edit_term_at_address	: filter -> int list -> view -> term
;;;;
;;;;	edit_parameter_at_address	: int list -> view -> parameter
;;;;
;;;;
;;;;	term_filter		: term -> filter -> term
;;;;
;;;;	parameter_filter	: parameter -> filter -> term
;;;;
;;;;
;;;;	make_tag_parameter	: tok -> parameter
;;;;
;;;;	destruct_tag_parameter	: parameter -> tok
;;;;	  * fails if tag ephemeral (ie uninterned).
;;;;
;;;;	ephemeral_tag_parameter_p	: parameter -> bool
;;;;
;;;;	
;;;;	edit_term_add_label		: term -> tag -> term
;;;;	edit_term_add_tag		: term -> tag -> term
;;;;
;;;;
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Zoom : Large terms can be unweildy to view. Zooming allows
;;;;	editing on subterms.
;;;;
;;;;	top : term zoomed on.
;;;;	
;;;;	The zoom stack is a list of terms. When a term is zoomed to, a
;;;;	special zoom variable replaces the zoom point in the current top
;;;;	and the result is pushed on the zoom stack.  The zoom point then
;;;;	becomes the new top. When the zoom stack is popped, the current
;;;;	top replaces the zoom variable in the popped term and the result
;;;;	becomes the new top.
;;;;
;;;;	We guarantee uniqueness of zoom variable in term by quoting
;;;;	similar operators when we replace point with zoom variable.
;;;;	
;;;;	Zooming fragments the term. All pieces may still be edited,
;;;;	however, destructive side effects are limited to the top.  A
;;;;	generalization which allows destructive side effects and a zoom
;;;;	tree rather than a zoom stack is possible, but this seems of
;;;;	limited practical use.
;;;;	
;;;;	
;;;;  -page-
;;;;
;;;;	Undo/Redo may implicitly change zoom stack. 
;;;;
;;;;
;;;;	edit_zoom		: tag{label} -> VIEWCMD
;;;;	edit_zoom_to_address	: int list -> VIEWCMD
;;;;	  * zooms to indicated point. Point must be a descendent of
;;;;	    current zoom top.
;;;;	  * pushes point on zoom stack.
;;;;	 
;;;;	edit_zoom_pop	: VIEWCMD
;;;;	 * pops zoom stack.
;;;;
;;;;	edit_zoom_address	: view -> int list
;;;;
;;;;	edit_zoom_address_convert_absolute : int list -> int list
;;;;	  * fails if absolute address does not address point within
;;;;	    current zoom.
;;;;	edit_zoom_address_convert_relative : int list -> int list
;;;;	 * converts addresses.
;;;;
;;;;	Using tags to implement a zoom history could be useful.
;;;;	
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;	Queries :
;;;;
;;;;	view_test_p		: cond_expr -> tag{label}
;;;;					-> view -> bool
;;;;
;;;;	view_num_children_q	: cond_expr -> tag{label}
;;;;					-> view -> int
;;;;	view_dform_q		: tag{label} -> view
;;;;					-> (object_id # int)
;;;;	view_parameter_q	: tag{label} -> view -> object_id
;;;;
;;;;
;;;;	view_num_children_at_address_q	: cond_expr -> int list 
;;;;						-> view -> int
;;;;	view_dform_at_address_q		: int list -> view
;;;;						-> (object_address # int)
;;;;	view_test_address_p		: cond_expr -> int list 
;;;;						-> view -> bool
;;;;
;;;;
;;;;	view_tags_q		: tag{label} -> bool {recursive}
;;;;					-> view -> tag list
;;;;	view_labels_q		: tag{label} -> bool {recursive}
;;;;					-> view -> tag list
;;;;	view_label_q		: tag{label} -> view -> bool
;;;;	  * true if label occurs anywhere in view.
;;;;
;;;;	view_tags_at_address_q		: int list -> bool {recursive}
;;;;						-> view -> tag list
;;;;	view_labels_at_address_q	: int list -> bool {recursive}
;;;;						-> view -> tag list
;;;;
;;;;	term_tags_q		: term -> bool {recursive}
;;;;					-> view -> tag list
;;;;	term_labels_q		: term -> bool {recursive}
;;;;					-> view -> tag list
;;;;
;;;;	  ** If recursive, then all tags or labels occuring in tree
;;;;	  ** rooted at specified point are returned. Otherwise, only the
;;;;	  ** tags or labels occuring in the node at the specified point
;;;;	  ** are returned. Duplicates are removed.
;;;;
;;;;
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Cut & Paste
;;;;
;;;;	edit_cut	: tag{label} -> VIEWCMD
;;;;	 * the label remains with the created slot.
;;;;
;;;;	Paste arguments : 
;;;;	  - Target Filter : filter children for reinsertion.
;;;;	  - Source Filter : locate points of reinsertion.
;;;;	  - Mode : Insert(true) or replace(false).
;;;;	  - Direction : Controls whether reinsertion is done left to
;;;;	    right (true) or right to left(false).
;;;;	  - Fail : when true if there are insufficient slots for
;;;;	    reinsertion then past fails.
;;;;	  - Cut : when true, source is cut from originating view prior to
;;;;	    reinsertion.
;;;;
;;;;	edit_paste_parameter	: tag{label} -> parameter -> VIEWCMD
;;;;
;;;;	edit_paste_dform	: object_address -> int
;;;;					-> bool{fail?}
;;;;					-> bool{mode}
;;;;					-> bool{direction}
;;;;					-> tag{label}
;;;;					-> VIEWCMD
;;;;
;;;;	edit_paste_dtree	: cond_expr {target filter}
;;;;					-> cond_expr {source filter}
;;;;					-> tags_filter {source tags filter}
;;;;					-> bool{fail?}
;;;;					-> bool{mode}
;;;;					-> bool{direction}
;;;;					-> bool{cut source}
;;;;					-> tag{target label}
;;;;					-> (tag{label} # view){source}
;;;;					-> VIEWCMD
;;;;
;;;;	edit_paste_term		: cond_expr {target filter}
;;;;					-> cond_expr {source filter}
;;;;					-> bool{fail?}
;;;;					-> bool{mode}
;;;;					-> bool{direction}
;;;;					-> tag {target label}
;;;;					-> term {source}
;;;;					-> VIEWCMD
;;;;
;;;;	edit_term_paste		: bool{direction} -> bool{mode}
;;;;					-> term{source} -> term{target}
;;;;					-> term
;;;;	  * works directly on terms.
;;;;	
;;;;
;;;;	edit_dependency		: view -> dependency
;;;;	  * dependency at last destructive modification.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Undo & Redo
;;;;	
;;;;	history : a stack of snapshots.
;;;;
;;;;	  - snapshot : a snapshot is taken after each edit evaluation in
;;;;	    which a destructive side-effect occured.  The snapshot
;;;;	    consists of the the current top term and the terms contained
;;;;	    on the zoom stack. The presentation interface must take care
;;;;	    to make changes at the proper granularity to allow the
;;;;	    proper discrete undos.  Ie, if several parameters are
;;;;	    changed within a single edit evaluation they can not be
;;;;	    individually undone.
;;;;
;;;;	  - undo: restores state to term of a previous snapshot.
;;;;
;;;;	  - redo : one might one to interactively search for a previous
;;;;	    state. If the state is overshot, ie you undo a few too many,
;;;;	    it is awkward to move forward again. Thus a redo operation
;;;;	    is also defined. Redo will succeed whenever there has been
;;;;	    no other destructive side effect and there are undos which
;;;;	    have not been redone.
;;;;
;;;;  -page-
;;;;
;;;;	An undo or redo operation itself causes a destructive side
;;;;	effect. Thus it should cause a snapshot to be added to the
;;;;	history. While this is necessary in order to allow the undo to
;;;;	be undone, there are circumstances where it is undesirable.  To
;;;;	avoid adding unnecessary snapshots to the history, undo and redo
;;;;	do not update the history until a new destructive side effect is
;;;;	detected. At that time, the segment of the history between the
;;;;	current snapshot, including the current snapshot, and the top of
;;;;	the history, excluding the top, is reversed and pushed onto the
;;;;	history. Thus you can undo undo's which at some point you moved
;;;;	forward from, but you will not have to undo undo's which you
;;;;	simply visited when searching for a point to move forward from.
;;;;
;;;;	For example, assume you have a history of s9, ... s1.  Then you
;;;;	execute 5 undos resulting in s4 becoming the current, then you
;;;;	execute two redo's such that s6 is current, then you make a
;;;;	modification to produce s10, the history stack would then be
;;;;	s10, s6, s7, s8, ,s9, ... , s1
;;;;
;;;;  -page-
;;;;
;;;;	Only the last paste_parameter of a contiguous sequence of 
;;;;	parameter pastes to the same address will be saved in the
;;;;	history.
;;;;	
;;;;	Non-destructive side-effects will be stored back into the
;;;;	history without adding snapshots.
;;;;
;;;;	Though it may seem extravagant to save the whole zoom stack in
;;;;	each snapshot, it would be a false economy to attempt to avoid
;;;;	it. Saving the zoom stack only costs one extra pointer in a
;;;;	snapshot. This is a small price compared to the extra complexity
;;;;	to only occasionally save the zoom stack.
;;;;
;;;;	The history will be of finite size. It is unfortunate to limit
;;;;	undo history but an infinite history has high potential
;;;;	accumulating too much uncollectable garbage.  There are some
;;;;	complex methods of ameliorating the history loss which at some
;;;;	point should be further investiagated:
;;;;	  - multiple tiers of history of decreasing granularity.
;;;;	  - multi-plexed history size :
;;;;	      * such that more active objects have longer histories.
;;;;	      * history are compressed and size is factor of some measure
;;;;		of actual space used. 
;;;;  -page-
;;;;	
;;;;	History and save do not interact, maybe they should. Ie if you
;;;;	undo to the last save you might want some indication.
;;;;
;;;;	History is optional in a view.
;;;;
;;;;	edit_undo	: VIEWCMD
;;;;	edit_redo	: VIEWCMD
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Instantiation :
;;;;
;;;;	Refreshing of dforms or layout is not required. The editor will
;;;;	implicitly refresh the layout following each edit. However,
;;;;	primitives are defined to allow explicit refresh during an edit
;;;;	evaluation. These primitives should only be used in unusual
;;;;	circumstances, re-instantiation, and particulary re-layout can
;;;;	be costly operations.
;;;;
;;;;	Refreshing the instantiation will do a top-down re-instantiation
;;;;	of stale nodes.
;;;;
;;;;	Stale Instantiation : 
;;;;	  - substantive modification
;;;;	  - change in dform table.
;;;;	  - non-substantive modification : eg local suppression, label
;;;;	    changes.
;;;;	  - view changes and edit_state changes, eg, suppression
;;;;	    and global suppression.
;;;;	  - contains a stale descendent
;;;;	
;;;;	Refreshing the instantiation will not cause instantiation of
;;;;	uninstantiated nodes.  Walk can be used to force instantiation.
;;;;	However walk does not refresh instantiated but stale nodes.
;;;;	Instantiating subtrees of stale nodes may result in non-optimal
;;;;	choices of dforms.  A refresh followed by a walking an
;;;;	uninstantiated tree will guarantee optimal dforms.
;;;;
;;;;
;;;;	Refreshing the layout will first cause a refresh instantiation
;;;;	and then do a re-layout of stale layout nodes. Refreshing a
;;;;	layout may cause instantiation of previously uninstantiated
;;;;	nodes and may nullify previously instantiated subtrees.
;;;;
;;;;	Stale Layout : 
;;;;	  - re-instantiated since last layout.
;;;;	  - some view or edit_state parameter change, such as height,
;;;;	    width, or elision depth. 
;;;;
;;;;	edit_refresh_instantiation	: VIEWCMD
;;;;
;;;;	edit_refresh_layout		: VIEWCMD
;;;;
;;;;
;;;;	
;;;;  -page-
;;;;
;;;;	Dforms:
;;;;
;;;;	dform : defined as an ML abstract primitive type.
;;;;	 
;;;; 	unique_tag_of_dform	: dform -> tag
;;;; 	name_label_of_dform	: dform -> tag
;;;;	  * tag for suppression.
;;;;	
;;;;
;;;;	dform_lookup		: object_address -> int -> dform
;;;;	dform_lookup_by_name 	: object_address -> token -> dform
;;;;
;;;;	dforms_lookup		: object_address -> dform list
;;;;	
;;;;	dform_model		: dform -> term	
;;;;	dform_formats		: dform -> term
;;;;	dform_object_address	: dform -> object_address
;;;;	dform_index		: dform -> int
;;;;	dform_name		: dform -> tok
;;;;
;;;;
;;;;	Flags :
;;;;	
;;;;	edit_set_flag		: tok -> bool -> unit
;;;;	view_set_flag		: tok -> bool -> VIEWCMD
;;;;
;;;;
;;;;	Suppressing dforms in view:
;;;;
;;;;	view_set_dform_filter		: cond_expr -> VIEWCMD
;;;;	view_dform_filter_q		: view -> cond_expr
;;;;
;;;;	view_suppress_dform		: dform -> view_cmd
;;;;	view_suppress_dform_at_address
;;;;		: object_address -> tok -> VIEWCMD
;;;;	
;;;;	view_unsuppress_dform		: dform -> view_cmd
;;;;	view_unsuppress_dform_at_address
;;;;		: object_address -> tok -> VIEWCMD
;;;;	
;;;;	view_suppressed_dforms_q	: view -> dform list
;;;;	view_suppressed_dform_addresses_q
;;;;		: view -> (object_address . tok) list
;;;;
;;;;	Choice of dform can be forced temporarily during edit
;;;;	evaluation:
;;;;	
;;;;	edit_force_dform	: dform -> tag {label} -> VIEWCMD
;;;;	  * fails if dform does not match term at label.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	View environment functions:
;;;;
;;;;	new_view		: bool{light} -> view
;;;;	  * restricted to use as lightweight view if bool true.
;;;;
;;;;	view_discard		: VIEWCMD
;;;;	  * fails if associated object or open window.
;;;;
;;;;	new_object_view		: object_id -> view
;;;;	 * reads geo, implicit, and term.
;;;;	
;;;;	view_clone		: view -> view
;;;;	  * resulting view is not modifiable.
;;;;
;;;;	view_lookup		: object_id -> view list
;;;;	views		: unit -> view list
;;;;	  * there is no significance to the order.
;;;;	  * views for which view_lightweight_p true are not accessible.
;;;;	
;;;;
;;;;	View state functions :
;;;;
;;;;	view_lightweight_p	: view -> bool
;;;;	  * true if view restricted to lightweight use.
;;;;	
;;;;	view_geometry_q		: view -> (int{height} # int{width})
;;;;	view_set_geometry	: int -> int -> VIEWCMD
;;;;	  * affects window ???
;;;;
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	view_implicit_q		: view -> variable list
;;;;	view_set_implicit	: variable list -> VIEWCMD
;;;;
;;;;	view_term_q		: view -> term
;;;;	  * exports term, ie may have some tags and other edit info stripped.
;;;;	view_set_term		: term -> bool{force} -> VIEWCMD
;;;;	  * fails if outstanding substantive modification unless force true.
;;;;	  * Why not just cut and paste term??? Maybe some import processing
;;;;	    to be done??? Or simple init for lightweight.
;;;;	
;;;;	view_modifiable_p	: view -> bool
;;;;	view_set_modifiable	: bool -> VIEWCMD
;;;;	  * default is true.
;;;;	
;;;;	
;;;;	view_associate_object		: object_address -> VIEWCMD
;;;;	  * inititializes term and implicit? from library.
;;;;	  * can be used to reuse view, ie when jumping from one obj to another
;;;;	    could replace object rather than kill view and open a new one.
;;;;	view_disassociate_object	: bool -> VIEWCMD
;;;;	  * if bool true then forces disassoc if unsaved data.
;;;;	    if bool false then fails if unsaved data.
;;;;	view_object_p			: view -> bool
;;;;	view_object_q			: view -> object_address
;;;;	
;;;;	view_open_window		: VIEWCMD
;;;;	  * uses geometry when last closed,
;;;;	    or uses geometry of associated object,
;;;;	    or 100 100 500 200.
;;;;	view_close_window		: VIEWCMD
;;;;	view_window_open_p		: view -> bool 
;;;;
;;;;	view_start_history		: VIEWCMD
;;;;	view_end_history		: VIEWCMD
;;;;	view_history_p			: view -> bool
;;;;	
;;;;
;;;; RLE TODO:
;;;;	Edit - Library : view reflects state of view wrt state of object.
;;;;
;;;;	  * lib_object_p : false if either no address associated or address does not correspond
;;;;	    to object in library.
;;;;	  * object_modified_p : library object modified since object read.
;;;;	      - when notified of object update, bit will be set unless nofitication
;;;;		associated with write request from view.
;;;;	  * view_modified_p : term modified since object read or term written.
;;;;      * bits to reflect dissonance of implicit and geo??? or bundle with source. individual better.
;;;;
;;;;	RLE TODO : Need broadcast notification of prop changes.
;;;;	RLE TODO : store broadcasts any source change?? substantive checked by comparing stamps ??
;;;;	
;;;;	  Object address initialized from associated object.
;;;;	    init, modified notification precedes read rsp.
;;;;	  need source stamp, and need source modification notify, at the moment
;;;;	 lib does not notify unless substantive change. We want notifies of and source change.
;;;;	property changes should be included as source change.
;;;;
;;;;
;;;;	elements of a view :
;;;;	  - dtree/implicit, object, window/geometry, history.
;;;;	  - connections :
;;;;	    if object then dtree is dtree of object.
;;;;	    if object then history is history of object.
;;;;	    geometry may come from object. (bits should tell)
;;;;	  ie changing object should reset dtree and history
;;;;  -page-
;;;;
;;;;	If view has an object address then following functions may be
;;;;	used.  These functions could be implemented directly using
;;;;	previously documented functions.
;;;;	
;;;;	view_read_geometry	: view -> VIEWCMD
;;;;	view_read_implicit	: view -> VIEWCMD
;;;;
;;;;	view_write_geometry	: view -> VIEWCMD
;;;;	view_write_implicit	: view -> VIEWCMD
;;;;
;;;;	view_read_term		: view -> bool{force} -> VIEWCMD
;;;;	  * fails if substantive mod to view since last read or write unless force true.
;;;;	  * fails if object not in library.
;;;;
;;;;	view_write_term		: view -> bool{force} -> VIEWCMD
;;;;	  * use force store in lib.
;;;;	  * fails if object not in library.
;;;;
;;;;	view_dependency_q	: view -> dependency
;;;;	  * dependency is set by read and write to match dependency of object.
;;;;	  * fails if object not in library.
;;;;
;;;;	view_object_modified_p	: view -> bool
;;;;	  * true if substantive store since last read or write.
;;;;	  * false if object not in library.
;;;;
;;;;	view_modified_p		: view -> bool
;;;;	  * true if substantive modification since last read or write.
;;;;	  * true if object not in library and any substantive modification.
;;;;
;;;;	It is expected that an ML layer will be written using these
;;;;	object functions to implement some safer ops. A sequence like
;;;;	clone, set oa and force write, can clobber object contents. Ie,
;;;;	you can do some dangerous things with these functions.
;;;;
;;;;	This may need to be extended to do red-like things???
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Edit State: Not much left here. Views are not considered part
;;;;	of edit state but rather part of environment. Might do the same
;;;;	with global suppress and then no such thing as edit state. Only
;;;;	purpose would be if there where some use for having more than one.
;;;;	Might want some grouping of views to swap in and out but that does
;;;;	not require edit state.
;;;;
;;;;	Global dform suppression :
;;;;	
;;;;	edit_set_dform_filter		: cond_expr -> EDITCMD
;;;;	edit_dform_filter_q		: edit_state -> cond_expr
;;;;
;;;;	edit_suppress_dform		: dform -> EDITCMD
;;;;	edit_supress_dform_at_address	: object_address -> tok -> EDITCMD 
;;;;
;;;;	edit_unsuppress_dform		: dform -> EDITCMD
;;;;	edit_unsupress_dform_at_address	: object_address -> tok -> EDITCMD 
;;;;
;;;;	edit_suppressed_dforms_q	: edit_state -> dform list
;;;;	edit_suppressed_dform_addresses_q	: edit_state -> (object_address . tok) list
;;;;	
;;;;	
;;;;	Hooks : Edit expects UI coder to define various hooks which will be called
;;;;	 in response to certain presentation events.
;;;;
;;;;	edit_text_hook		: string -> VIEWCMD
;;;;	edit_library_hook	: string -> VIEWCMD
;;;;	
;;;;
;;;;	Any function of type VIEWCMD can be called by presentation.
;;;;
;;;;	Edit functions may also call VIEWCMD's inline:
;;;;
;;;;	edit_viewcmd_type_p		: string{name} -> bool
;;;;	  * true if named function exists and is of type viewcmd.
;;;;	
;;;;	edit_call_cmd			: string -> VIEWCMD
;;;;	  * string must be name of ML function of type VIEWCMD.
;;;;	    Evals command inline, ie no parsing, etc.
;;;;	
;;;;	This allows a function to call a function whose name is encoded in the
;;;;	data.  Of course if the function is known apriori it should be called
;;;;	directly. 
;;;;
;;;;
;;;; -doce- 

;;;; 
;;;;
;;;;	***
;;;;	*** Following is preliminary
;;;;	***
;;;;
;;;;	Ptree-equalization : the process of equalizing ptrees between edit
;;;;	 and presentation. 
;;;;
;;;;	Edit evaluation : top level eval of edit command.
;;;;	 two flavors :
;;;;	  - light : does not automatically refresh layout.
;;;;			  Useful for minor text edits.
;;;;	  - heavy : does refresh.
;;;;	
;;;;	Beware that multiple ptrees may be affected by a single
;;;;	evaluation.
;;;;
;;;;	Single thread through presentation/edit, edit may perform
;;;;	computationally intensive operations outside of thread.
;;;;
;;;;	It would be nice if pres did not have to wait for edit to
;;;;	respond in cases where no ptree modification results. However,
;;;;	there are some big obstacles. How to predict no ptree
;;;;	modification results?  How to recover if ptree mod and did not
;;;;	wait. If no mod then likely to be quick response as no ptree
;;;;	mods come back and likely to be little computation. Summary:
;;;;	major complexity for little? gain.
;;;;
;;;;	But what about ptree modification but presentation doesn't need
;;;;	response to continue. Presentation can keep throwing commands
;;;;	down the pipe until it hits one where it has to wait for edit
;;;;	response.  This would allow presentation to move along and wait
;;;;	only when necessary allowing for pres and edit to run
;;;;	simultaneously.
;;;;
;;;;  -page-
;;;;
;;;;	An evaluation will change ptree Pi to a new ptree Pj.
;;;;
;;;;	Assume no destructive modification so that after evaluation
;;;;	Pi is still available.
;;;;
;;;;	  - compare Pi and Pj and find differences.
;;;;	      * eq check should be sufficient to detect change.
;;;;	  - communicate differences to remote partner.
;;;;
;;;;	Note that when partner is not remote this whole process is a no-op.
;;;;
;;;;	Need to restrict who is allowed to modify so that both do not
;;;;	simultaneously modify.  Or more difficult allow both to modify
;;;;	and do some sort of unification.
;;;;
;;;;  -page-


;;;;	Refresh dtree : due to possible distant conditions testable with dform
;;;;	 cond_expr's, any change to a dtree would require complete refresh
;;;;	 to insure absolutely optimal dform choices.
;;;;
;;;;	Refresh is terminated at a dtree under following conditions:
;;;;	  - not instantiated
;;;;	 OR
;;;;	  - parent dform is unchanged or dtree is root.
;;;;	  - dfparms are unchanged
;;;;	  - dtree is not modified,  modfication is a transitive closure
;;;;	    if a node is modified than all ancestors are modified. If
;;;;	    a node is not modified than no descendents are.
;;;;	      * change to labels or tag is modification.
;;;;	      * any structure or parameter value change.
;;;;	
;;;;	what about refresh of leaf, no dform, no dfparms, if not modified reuse.
;;;;	if modified, reuse,  At some point if indirect display then may need refresh.

;;;;	
;;;;	
;;;;	Vestigial : presentation capabilities make following moot.
;;;;	
;;;;	
;;;;	Mouse Clicks : mouse clicks are encoded as labels in the dtrees.
;;;;
;;;;	The labels MouseClick1, ... MouseClick8 are special. They can not be
;;;;	moved and each occurs only once in an edit environment. They do not
;;;;	survive cutting and pasting operations, and thus they may not always
;;;;	be present in the edit environment. Each mouse click received from
;;;;	the presentation layer changes the label of all preceding clicks.
;;;;	Eg, if a point has label MouseClick2 and a new mouse click is processed
;;;;	then that point has label MouseClick3.
;;;;
;;;;	
;;;;	edit_mouse_click_view		: tok{label} -> view
;;;;	
;;;;	edit_mouse_click_literal	: tok{label} -> tok
;;;;	  * the actual label on the dtrees differs from the labels named.
;;;;	    The enumerated labels are not legal as general purpose labels.
;;;;	    Eg, it is an error to attempt to explicitly label a point with such a label.
;;;;	    The encoded label will be of the form !mouse_click_<i> where i may
;;;;	    differ from the associated MouseClick<j>. Note that the encoded label
;;;;	    may not be used in a condition expression as ! is a reserved character
;;;;	    in the condition expression syntax.
;;;;



;;;;	object refs which survive rename???
;;;;	
;;;;	User ML edit code ought to be able to reference dform defs. Then when changing
;;;;	dforms they can find references. Could do this by putting in some expression
;;;;	taking an obref kind of thing which evaluates to a dform.
;;;;	ie need the ability to specifiy obrefs such that they show in the dependencies!!.


;;;;

;;;;	Notes about v4.2 vs v5.0 edd diffs. 

;;;;	Dtrees : 
;;;;	  * Old Library macro functionality replaced by edit_dform_paste.
;;;;

;;;;	Old Edit conditions not included in dtree condition list:
;;;;
;;;;	included for compatability: would be nice if they could be trashed.
;;;;	  - texttemplate : same as display meta.
;;;;	  - textparameter : same as abstraction meta.
;;;;	  - leaf : either parameter node or term node with no children. replace with (or parameter (not tree))
;;;;	  - termleaf : replace with (not tree)
;;;;
;;;;	  - termfirst : first non-parameter child of parent. Note not equivalent to (and (not parameter) first)
;;;;	                this will be true if at second child and first is parameter and second not while
;;;;			(and (not parameter) first) will be false.
;;;;	  - termlast : last non-parameter child of parent.
;;;;
;;;;	  - first : first child of parent.
;;;;	  - last : last child of parent.
;;;;
;;;;	
;;;;	List conditions : need to check if they can be encoded somehow or raised to ML.
;;;;	  - listtop
;;;;	  - listfirst
;;;;      - listlast
;;;;	  - toplevellist
;;;;	  - listelement
;;;;	  - list
;;;;	
;;;;	Removed and replaced with functional equivalents
;;;;	  - left
;;;;	  - insert
;;;;	  - ml_string
;;;;
;;;;	  - dispobject
;;;;	  - absobject
;;;;	  - thmobject
;;;;	  - mlobject
;;;;	  - comobject
;;;;	  - latobject
;;;;	  - rulebox
;;;;	  - transformation

;;;;	  - modified
;;;;	  - object-modified
;;;;	  - cmd
;;;;
;;;;	  - newfocus
;;;;	  - focusonmouse
;;;;	  - focusmarkisfocus
;;;;	  - pointsuppression
;;;;
;;;;	Stack :
;;;;	  - zoomstack is now part of ML state. Hydras. 
;;;;	  - stacktext
;;;;	  - stacktop
;;;;	  - cmdstacktop
;;;;	  - stackempty
;;;;	  - cmdstackempty
;;;;	
;;;;	Moved
;;;;	  - to presentation layer:
;;;;	  - screen
;;;;
;;;;
;;;;



;;;;	I have the sneaking suspicion that this point/mark register label push pop
;;;;	move swap text stuff is overkill and there is a just as powerful model
;;;;	which is less complex. However, I don't see it. 
;;;;	It's a difficult argument to justify the present complexity.
;;;;	






;;;;	!!!!!!!!!
;;;;	

;;;;	 
;;;;	
;;;;	Windows : 
;;;;	
;;;;	How to translate labels to modifiers such as bold italics color etc.
;;;;	
;;;;	  - wtree needs to be encoded or embedded in ptree.
;;;;	      * then if pres  and edit in same process they share structure.
;;;;	      * ,may not really have wtree, just traverse ptree and send wtree down a stream.
;;;;	
;;;;	presentation : string + labels + label-environment -> string + style
;;;;
;;;;	window : string + style -> glyph (font, font-index) list + colors (foreground + background colors)
;;;;	
;;;;	style : token or list of tokens.
;;;;	
;;;;	In order to do layout edit must be able to go from string + labels -> length & height.
;;;;	
;;;;	ptree ap
;;;;	
;;;;	
;;;;	Need translate table in window which recognizes labels.
;;;;	May pass simpler structure than ptree to window, certainly
;;;;	can filter some labels. Gcontext, glyph, review unicode.
;;;;
;;;;	Want character, emphasis(italic, bold, bold italic, colors, size, font)
;;;;	what are the parameters, Review unicode.
;;;;
;;;;	Multiple windows per view.
;;;;
;;;;	Output to window
;;;;
;;;;	<wstring>	: <witem> list
;;;;	
;;;;	<witem>		: <string>
;;;;			| (<wtag> list . <string>)
;;;;
;;;;	<wtag>		: (<tag> . <string>) | <tag>
;;;;
;;;;	<string>	: font-index array.	
;;;;
;;;;	Wtags will be things like (Font . "foo"), (ForegroundColor . "goo"), ReverseVideo, etc.
;;;;
;;;;
;;;;
;;;;	ptree-to-wstring-list(<ptree{dtree?}>
;;;;				INTEGER{start-row}
;;;;				INTEGER{start-col}
;;;;				INTEGER{height})
;;;;	  : <wstring> list
;;;;	 
;;;;
;;;;	<window>	: window[
;;;;				INTEGER{height}
;;;;				INTEGER{width}
;;;;				]
;;;;
;;;;	display-wstring(<window> <wstring> <bool{wrap-p}>)	: NULL
;;;;	 * wrap-p : wrap or truncate lines wider than window width.
;;;;	
;;;;	



;;;; Considered and Rejected::
;;;;
;;;;	EG:
;;;;	(MouseLeft)(MouseLeft)(MouseLeft) ==
;;;;		(m-x)edit-mouse-click3
;;;;		(m-x)edit-mouse-click2
;;;;		(m-x)edit-mouse-click1
;;;;		three_mouse_lefts (m-x)edit_ml
;;;;	Will result in labels MouseClick1, MouseClick2, and MouseClick3 
;;;;	on points clicked on from latest to earlier respectively.
;;;;	
;;;;	
;;;;	View stack : views in order of last focus, irrespective of focus register.
;;;;
;;;;

;;;;	???  rotate, raise, lower, focus-mark 
;;;;	
;;;;	Focus:	current view.
;;;;	
;;;;	A label may be associated with a view.
;;;;
;;;;	View : a register whose variables contain veiws as values.
;;;;
;;;;	The view is used as an implicit argument to any primitive which operates
;;;;	on a ptree. The current view is sometimes referred to as the focus.
;;;;	
;;;;	Thus, the current view can be changed by changing the view register, or by
;;;;	changing the value of the current view variable.
;;;;
;;;;	(m-x)set-view-register
;;;;	(m-x)push-view-register
;;;;
;;;;	(m-x)pop-view-register
;;;;	(m-x)rotate-view-register
;;;;	(m-x)reverse-rotate-view-register
;;;;	
;;;;	View assignment : 
;;;;
;;;;	These primitives affect the values of the indicated variables, they do not affect
;;;;	the view register.
;;;;
;;;;	(m-x)set-view
;;;;	(m-x)push-view
;;;;	(m-x)swap-view
;;;;	  * the input text variable is used as an argument to identify a 
;;;;	     view variable to be used as a second implicit argument to the primitive.
;;;;	
;;;;	(m-x)pop-view
;;;;	(m-x)rotate-view
;;;;	(m-x)reverse-rotate
;;;;	
;;;;	
;;;;	

;;;;	Top Level :
;;;;
;;;;	Input is tokenized into a stream of declared macros and text.
;;;;
;;;;	???Dig up v4 doc for tokenizing. ???
;;;;	??? need a syntax for tokenizing top level input.
;;;;	
;;;;	At top level, Text is placed in text register and (m-x)text-hook is called.
;;;;	Defined macros can also use the text register.	
;;;;
;;;;	Hooks:
;;;;	
;;;;	  - init	:
;;;;
;;;;	  - edit 	: allows edit to call presentation with single text arg.
;;;;
;;;;	  - cleanup :
;;;;	
;;;;	  - failure : failed to top. If a macro failure rhs succesfully catchs and completes
;;;;		then cleanup is called rather than failure.

;;;;	(m-x)set-mark-register
;;;;	(m-x)push-mark-register
;;;;	(m-x)pop-mark-register
;;;;
;;;;	In a 4.2 type of UI, it may be that the point and mark labels are
;;;;	set to point and mark and never	altered.
;;;;
;;;;
;;;;	 
;;;;	Mark Assignment : 
;;;;	
;;;;	(m-x)mark-to-point
;;;;	(m-x)swap-point-and-mark
;;;;
;;;;
;;;;	These could be simulated with other primitives:
;;;;	
;;;;	<label>(m-x)move-label-to-point
;;;;	   == 	(m-x)push-text-register
;;;;		temp (m-x)push-mark-register
;;;;		(m-x)mark-to-point
;;;;		<label> (m-x)push-point-register
;;;;		(m-x)swap-point-and-mark
;;;;		(m-x)pop-mark-register(m-x)pop-point-register
;;;;		(m-x)pop-text-register
;;;;	
;;;;	<label>(m-x)move-point-to-label
;;;;	   == 	(m-x)push-text-register
;;;;		<label> (m-x)push-mark-register
;;;;		(m-x)swap-point-and-mark
;;;;		(m-x)pop-mark-register
;;;;		(m-x)pop-text-register
;;;;	
;;;;
;;;;	(m-x)mark-to-mouse-click1
;;;;	(m-x)mark-to-mouse-click2
;;;;	(m-x)mark-to-mouse-click3
;;;;	(m-x)mark-to-mouse-click4
;;;;	(m-x)mark-to-mouse-click5
;;;;	(m-x)mark-to-mouse-click6
;;;;	(m-x)mark-to-mouse-click7
;;;;	(m-x)mark-to-mouse-click8
;;;;
;;;;	 mark-to-mouse-click<i> could be defined in terms of point-to-mouse-click.
;;;;	 Ie, == temp (m-x)push-point-register
;;;;		(m-x)point-to-mouse-click<i>(m-x)mark-to-point
;;;;		point (m-x)pop-point-register
;;;;

;;;;	 (m-x)edit-mouse-click1
;;;;	 (m-x)edit-mouse-click2
;;;;	 (m-x)edit-mouse-click3
;;;;	 (m-x)edit-mouse-click4
;;;;	 (m-x)edit-mouse-click5
;;;;	 (m-x)edit-mouse-click6
;;;;	 (m-x)edit-mouse-click7
;;;;	 (m-x)edit-mouse-click8
;;;;
;;;;	Point and mouse-click.
;;;;
;;;;	(m-x)point-to-mouse-click1
;;;;	(m-x)point-to-mouse-click2
;;;;	(m-x)point-to-mouse-click3
;;;;	(m-x)point-to-mouse-click4
;;;;	(m-x)point-to-mouse-click5
;;;;	(m-x)point-to-mouse-click6
;;;;	(m-x)point-to-mouse-click7
;;;;	(m-x)point-to-mouse-click8

;;;;
;;;;	
;;;;	GlobalPoint Deemed superfluous. UI coder can use global point operators
;;;;	to acheive same results.
;;;;	
;;;;	Global : ie shared among all views.
;;;;
;;;;	 GlobalPoint1, ..., GlobalPoint8 
;;;;
;;;;	  - predefined, case insensitive. Predefined so as to optimize implementation.
;;;;	    Implementation must now when a label is global so as to prevent dups in other views.
;;;;	    Global labels can be manipulated the same as view labels thus must be distinquishable
;;;;	    by implementation. Easiest way to distinquish is a fixed predefined set.
;;;;	  - UI defined globals can be coded, however they will be more costly
;;;;	    requiring a call to edit to use.
;;;;	
;;;;	To move point to a global point:
;;;;	   ==	(m-x)push-text-register GlobalPoint<i>
;;;;		(m-x)move-point-to-label
;;;;		(m-x)pop-text-register
;;;;	 ** fails if global point not in focus view.
;;;;
;;;;	To move a global point to point.
;;;;	
;;;;	  == 	(m-x)push-text-register GlobalPoint<i>
;;;;		(m-x)move-label-to-point
;;;;		(m-x)pop-text-register
;;;;
;;;;	





;;;;	From mail from sfa:
;;;;	But we should have the following functionality:
;;;;	We should be able to get the term-command assigned to a keyboard sequence.
;;;;	This is because this is often the principle mnemonic the user may have
;;;;	for the command. Perhaps the simplest thing would be a mode-toggle between
;;;;	interpret-the-command and insert-the-command.
;;;;	This makes it easy to create commands that would act like entering the
;;;;	kb-sequence normally would, but will not depend on how it is later bound.
;;;;	

;;;;	
;;;;	
;;;;	memoize dtree:
;;;;	dtree-term assoc : within a dynamic extent it is desirable to make a loose
;;;;	  association between some terms and their dtrees. EG, consider push-delete-yank-pop
;;;;	  sequence. It would be nice to reuse dtree.
;;;;	    - at time of push, dtree in use.
;;;;	    - at delete time it becomes free : make assoc.
;;;;	    - at yank time, cound find dtree and remove assoc.
;;;;	  adding mark to term is not suitable since if dtree is not used the pointer
;;;;	  remains and the dtree can not be gc'ed. Could use mark but nullify pointer
;;;;	  when dynamic-extent exited.  I think assoc clearer and I doubt much more
;;;;	  expensive as long as no perverse scenario where extent is to big, or a lot
;;;;      of assoc otherwise made.
;;;;	
;;;;	- to reuse dtree the up pointer must be modified?
;;;;	  modifying up-pointers of dtrees is allowed does not violate any invariants..
;;;;	
;;;;
;;;;	edit state :
;;;;	  - pointer click register (view-state . dtree) ??
;;;;	      * if dtree stale when register accessed then error.
;;;;	  - global suppressed dforms.
;;;;
;;;;	view state :
;;;;	 - width, height.
;;;;	 - object_address
;;;;	 - zoom stack
;;;;	 - undo stack : dtree/terms??
;;;;	 - suppressed dforms.


;;;;
;;;;	Presentation state :
;;;;	  - ptree
;;;;	  - window
;;;;	  - height width
;;;;	  - marks, encoded in ptree, maybe have list as well??
;;;;	  - left-right mode
;;;
;;;
;;;	macros are ml expressions:
;;;
;;;	keybindings should be terms !keybinding{"key"}(0{condition expr}; 0{ml-expr})
;;;
;;;
;;;
;;;
;;;
;;;;	 
;;;;	ML :
;;;;	  - dtrees
;;;;	    * partially functional , ie tree structure.
;;;;	    * partially side effects, ie marks.
;;;;	  - edit state and view states are affected via side effects.
;;;;
;;;;	
;;;;
;;;;
;;;;	Both :
;;;;	  - point suppression
;;;;	  - verified/evaled?
;;;;
;;;;
;;;;	term_to_dtree	: term -> dtree
;;;;	model_of_dform	: object_address -> int -> term
;;;



;;;;	
;;;;	Tag parameter type : for ephemeral (ie uninterned) tags.
;;;;	


(define-typeid (|tag| (tag) tag-typeid)
    #'(lambda (x)
	(and (symbolp x)
	     (null (symbol-package x))))
  #'eql
  #'string
  #'make-symbol
  #'sxhash)



;;;;	
;;;;	Trace dtree flags
;;;;	
;;;;	  the dtree-flag-trace function was a late add on. 
;;;;	  thus many routines print trace information directly.
;;;;	  when convenient they should be converted to call dtree-flag-trace.
;;;;	
;;;;	#-nodebug  : also a late idea.
;;;;	   whereever pratical debugging code should be conditionalized such so as
;;;;	   to allow elimination of overhead via compilation.
;;;;	
;;;;	
;;;;	
;;;;	


(defvar *dtree-flag-trace* nil)

(defvar *dtree-flag-trace-last* nil)
(defvar *dtree-flag-trace-last-count* nil)

(defun dtree-flag-trace (s &rest r)
  ;;(break "dft")
  (when *dtree-flag-trace*
    (cond
      (r (setf *dtree-flag-trace-last* nil
		*dtree-flag-trace-last-count* nil)
	 (format t "~a" s)
	 (dolist (s r)
	   (format t "~a" s)))

      ((and *dtree-flag-trace-last* (string= *dtree-flag-trace-last* s))
       (incf *dtree-flag-trace-last-count*))

      (t 
       (when *dtree-flag-trace-last*
	 (format t "... ~a. [~a]~%" *dtree-flag-trace-last-count* *dtree-flag-trace-last*))
       (setf *dtree-flag-trace-last* s
	     *dtree-flag-trace-last-count* 1)
       (format t "~a" s)
       ))))

(defun toggle-dtree-flag-trace ()
  (setf *dtree-flag-trace* (not *dtree-flag-trace*)))



;;;;
;;;;	condition expressions
;;;;
;;;;	
;;;;	
;;;;	
;;;;	

    
(defstruct ce)

(defstruct (not-ce (:include ce))
  (e nil))

(defun new-not-ce (e) (make-not-ce :e e))
(defun expr-of-not-ce (ce) (not-ce-e ce))

(defstruct (and-ce (:include ce))
  (l nil)
  (r nil))

(defun new-and-ce (l r) (make-and-ce :l l :r r))
(defun lexpr-of-and-ce (ce) (and-ce-l ce))
(defun rexpr-of-and-ce (ce) (and-ce-r ce))


(defstruct (or-ce (:include ce))
  (l nil)
  (r nil))

(defun new-or-ce (l r) (make-or-ce :l l :r r))
(defun lexpr-of-or-ce (ce) (or-ce-l ce))
(defun rexpr-of-or-ce (ce) (or-ce-r ce))


(defstruct (parent-ce (:include ce))
  (e nil))

(defun new-parent-ce (e) (make-parent-ce :e e))
(defun expr-of-parent-ce (ce) (parent-ce-e ce))


(defstruct (descendent-ce (:include ce))
  (e nil))

(defun new-descendent-ce (e) (make-descendent-ce :e e))
(defun expr-of-descendent-ce (ce) (descendent-ce-e ce))


(defstruct (ancestor-ce (:include ce))
  (e nil))

(defun new-ancestor-ce (e) (make-ancestor-ce :e e))
(defun expr-of-ancestor-ce (ce) (ancestor-ce-e ce))


(defstruct (child-ce (:include ce))
  (f nil)
  (i nil)
  (e nil))

(defun new-child-ce (f i e) (make-child-ce :f f :i i :e e))

(defun filter-of-child-ce (ce) (child-ce-f ce))
(defun int-of-child-ce (ce) (child-ce-i ce))
(defun expr-of-child-ce (ce) (child-ce-e ce))


(defstruct (mark-ce (:include ce))
  (e nil))

(defun new-mark-ce (e) (make-mark-ce :e e))
(defun expr-of-mark-ce (ce) (mark-ce-e ce))

;; modifier expressions are raised to condition expressions
(defstruct (token-ce (:include ce))
  (modifier nil)	; one of nil{dtree} abs disp label tag parameter-type.
  (token nil)
  )

(defun new-token-ce (mod tok)
  (when (eql '|| tok)
    (scan-error '(token null)))
  (make-token-ce :modifier mod :token tok))

(defun modifier-of-token-ce (ce) (token-ce-modifier ce))
(defun token-of-token-ce (ce) (token-ce-token ce))

(defun true-ce ()	*true-ce*)
(defun false-ce ()	*false-ce*)
(defun slot-ce ()	*slot-ce*)

(defun string-to-cond-expr (s)
  (if (or (null s)
	  (string= "" s))
      *true-ce*
      (with-string-scanner (s)
	(with-tag '(cond_expr)
	  (prog1
	      (ce-scan)
	    (unless (scan-eof-p)
	      (message-emit
	       (warn-message '(cond-expr scan residual) (princ-to-string (scan-position))))))))))


(defun text-to-cond-expr (text)
  (with-text-scanner (text)
    (with-tag '(cond_expr)
      (ce-scan))))

(defvar *cond-expr-sbits*
  (standard-character-sbits
   (map 'list #'character-to-code
	"_-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789")))

;; f : string -> token
(defun ce-scan-token (mod &optional f)
  (let ((s (scan-string *cond-expr-sbits* t)))
    (new-token-ce mod
		  (if f
		      (funcall f s)
		      (intern-system
		       (string-upcase s))))))

   

(defun ce-scan-abs ()
  (scan-byte idollar)
  (ce-scan-token 'abs))

(defun ce-scan-disp ()
  (scan-byte isplat)
  (ce-scan-token 'disp))

(defun ce-scan-label ()
  (scan-byte itilde)
  (ce-scan-token 'label))

(defun ce-scan-tag ()
  (scan-byte iplus)
  (ce-scan-token 'tag))

(defun ce-scan-parameter-type ()
  (scan-byte icomma)
  (ce-scan-token 'parameter-type #'(lambda (s) (unalias-typeid (intern-system s)))))


(defun ce-scan-not ()
  (scan-byte iexclaimation)
  (new-not-ce (cond
		((eql ilparen (scan-cur-byte))
		 (prog2 (scan-byte ilparen)
		     (ce-scan)
		   (scan-byte irparen)))
		((eql idollar (scan-cur-byte))
		 (ce-scan-abs))
		((eql isplat (scan-cur-byte))
		 (ce-scan-disp))
		(t (scan-error '(not))))))

	
(defun ce-scan-and ()
  (scan-byte iampersand)
  (cond
    ((eql ilparen (scan-cur-byte))
     (prog2 (scan-byte ilparen)
	 (new-and-ce (ce-scan)
		     (progn (scan-whitespace)
			    (ce-scan)))
       (scan-byte irparen)))
    
    ((member (scan-cur-byte) #.'(list iexclaimation idollar isplat))
     (new-and-ce (ce-scan)
		 (ce-scan)))
    (t (scan-error '(and)))))


(defun ce-scan-or ()
  (scan-byte ibar)
  (cond
    ((eql ilparen (scan-cur-byte))
     (prog2 (scan-byte ilparen)
	 (new-or-ce (ce-scan)
		    (progn (scan-whitespace)
			   (ce-scan)))
       (scan-byte irparen)))
    
    ((member (scan-cur-byte) #.'(list iexclaimation idollar isplat))
     (new-or-ce (ce-scan)
		       (ce-scan)))
    (t (scan-error '(or)))))


(defun ce-scan-mark ()
  (scan-byte idot)
  (prog2
      (scan-byte ilparen)
      (new-mark-ce (ce-scan))
    (scan-byte irparen)))


(defun ce-scan-parent ()
  (scan-byte iat)
  (prog2
      (scan-byte ilparen)
      (new-parent-ce (ce-scan))
    (scan-byte irparen)))


(defun ce-scan-ancestor ()
  (scan-byte irangle)
  (prog2
      (scan-byte ilparen)
      (new-ancestor-ce (ce-scan))
    (scan-byte irparen)))


(defun ce-scan-child ()
  (scan-byte istar)
  (prog2
      (scan-byte ilparen)
      (new-child-ce (ce-scan)
			   (progn (scan-whitespace)
				  (scan-decimal-num))
			   (progn (scan-whitespace)
				  (ce-scan)))
    (scan-byte irparen)))

(defun ce-scan-descendent ()
  (scan-byte ilangle)
  (prog2
      (scan-byte ilparen)
      (new-descendent-ce (ce-scan))
    (scan-byte irparen)))

(defvar *ce-scan-dispatch*
  (let ((a (make-array 128
		       :element-type 'function
		       :initial-element #'(lambda () (ce-scan-token nil)))))
    (setf (aref a itilde) #'ce-scan-label
	  (aref a idollar) #'ce-scan-abs
	  (aref a isplat) #'ce-scan-disp
	  (aref a iplus) #'ce-scan-tag
	  (aref a icomma) #'ce-scan-parameter-type
	  (aref a iexclaimation) #'ce-scan-not
	  (aref a iampersand) #'ce-scan-and
	  (aref a ibar) #'ce-scan-or
	  (aref a idot) #'ce-scan-mark
	  (aref a iat) #'ce-scan-parent
	  (aref a istar) #'ce-scan-child
	  (aref a ilangle) #'ce-scan-descendent
	  (aref a irangle) #'ce-scan-ancestor)
    a))
    

(defun ce-scan ()
  (declare (simple-vector *ce-scan-dispatch*))
  
  (let ((i (scan-cur-byte)))
    (if (< i 128)
	(funcall (aref *ce-scan-dispatch* i))
	(raise-error (error-message '(term cond_expr character unexpected) i)))))



;;; use type case to eval cond-exprs.


(defun term-to-cond-expr (term)
  (cond

    ((itext-term-p term)
     (string-to-cond-expr (string-of-itext-term-r term)))

    ((ievalet-term-p term)
     (unless (eql 'import (time-of-ievalet-term term))
       (raise-error (error-message '(term cond_expr evalet time) (time-of-ievalet-term term))))
     (let ((ce (eval-evalet (type-of-ievalet-term term)
			    (expr-of-ievalet-term term))))
       (unless (ce-p ce)
	 (raise-error (error-message '(term cond_expr evalet not) term)))))

    (t (text-to-cond-expr (term-to-text term)))))


;;;
;;;	Dforms:
;;;
;;;;	
;;;;	Dform Model
;;;;	
;;;;	

;;;;	iparms is a list of (variables ids or nil) or nil.
;;;;	A nil list is an abbreviation for a list of nils.
;;;;	there is a bool for each binding of the term variable in the model.
;;;;	A variable id  means binding was iparm, nil means it was not an iparm.


(defstruct dform-model-variable
  (flags) 
  (id nil)				; display-meta id.
  (iparms nil)
  (part-indices nil)
  )

(define-flags (dform-model-variable)
    ((iterate) (term) (hidden)))


(defun id-of-dform-model-variable (mv) (dform-model-variable-id mv))
(defun iparms-of-dform-model-variable (mv) (dform-model-variable-iparms mv))
(defun push-model-variable-part-index (mv i) (push i (dform-model-variable-part-indices mv)))

;; could assume indices go from high to low.
(defun model-variable-of-part-index-p (mv i)
  (member i (dform-model-variable-part-indices mv)))


(defun new-dform-model-variable (id &optional (term-p nil) (iparms nil))
  (init-dform-model-variable-flags (make-dform-model-variable :id id
							      :iparms iparms)
				   (when term-p
				     (if (iterate-p id)
					 '((term . t)
					   (iterate . t))
					 '((term . t)))) ))



;;;;	
;;;;	variables : 
;;;;	  - no duplicates
;;;;	  - same order as dtree child array.
;;;;	    in fact used by instantiation to build child array.
;;;;	preorder-indices :
;;;;	  - may contain duplicates.
;;;;	  - array of indices to model variables in preorder of occurrence of variable
;;;;	    in model term. subterms are considered to precede bindings for this purpose.
;;;;	  - used to guide dtree-to-term by incrementing through array to find child
;;;;	    dtrees corresponding to meta vars in model term as term is instantiated.
;;;;	parameter indices: 
;;;;	 - may contain duplicates.
;;;;	 - array of indices to dtree children corresponding to meta parameters in model term.
;;;;	 - used to lookup abstraction defs from dtree instance.
;;;;	part indices: the immediate parameters, bindings, and subterms are the parts of the term.
;;;;	  - the part indices of a model variable corresponds to the positions in the term at which
;;;;	    the variable occurs.
;;;;	  - variable-of-part-index : find variable with part index.
;;;;	  - start at 1 not 0.
;;;;	
;;;;	

(defstruct dform-model
  (flags nil)

  (term nil)

  (variables (make-array 0) :type vector)
  (preorder-indices (make-array 0) :type vector)
  (parameter-indices (make-array 0) :type vector)

  (iparms nil :type list)		; list of variable ids of iparms in model.
  (floatdown-index nil)
  (dummy-tests nil :type list)
  )


(define-flags (dform-model)
    ((meta-parameter)			; t when meta parameter exists in model
     (meta-bound-term)))		; t when meta binding or subterm exists in model



(defun term-of-dform-model (m) (dform-model-term m))
(defun variables-of-dform-model (m) (dform-model-variables m))
(defun preorder-indices-of-dform-model (m) (dform-model-preorder-indices m))
(defun count-of-variables-of-dform-model (model) (array-dimension (variables-of-dform-model model) 0))
(defun parameter-indices-of-dform-model (m) (dform-model-parameter-indices m))
(defun iparms-of-dform-model (m) (dform-model-iparms m))
(defun floatdown-index-of-dform-model (m) (dform-model-floatdown-index m))
(defun dummy-tests-of-dform-model (m) (dform-model-dummy-tests m))

(eval-when (compile)
  (proclaim '(function variables-of-dform-model (dform-model) (vector dform-model-variable)))
  (proclaim '(function parameter-indices-of-dform-model (dform-model) (vector integer)))
  (proclaim '(function preorder-indices-of-dform-model (dform-model) (vector integer)))
  )

;;;  parameter indices 
;;;   if not for the possibility of duplicate display meta variables this would
;;;   not be necessary as the parameter display meta variables in the model
;;;   would be in one-to-one correspondence with some prefix of the model
;;;   variables of the dform.
        

;; vars should not contain duplicates.
(defun new-dform-model (term
			vars preorder-vars parameter-vars
			iparms floatdown-index dummy-tests
			meta-parameter-p meta-bound-term-p)
  (declare (list vars preorder-vars))
  
  (init-dform-model-flags
   (make-dform-model :term term
		     :variables (let ((variables (make-array (length vars))))
				  (dotimeslist (i v vars)
					       (setf (aref variables i) v))
				  variables)
		     :preorder-indices (let ((indices (make-array (length preorder-vars))))
					 (dotimeslist (i v preorder-vars)
						      (setf (aref indices i)
							    (position v vars
								      :key #'id-of-dform-model-variable)))
					 indices)
		     :parameter-indices (let ((parameter-indices (make-array (length parameter-vars))))
					  (dotimeslist (i v parameter-vars)
						       (setf (aref parameter-indices i)
							     (position v vars
								       :key #'id-of-dform-model-variable)))
					  parameter-indices)
		     :iparms iparms
		     :floatdown-index floatdown-index
		     :dummy-tests dummy-tests
		     )

   (list (cons 'meta-parameter  meta-parameter-p)
	 (cons 'meta-bound-term meta-bound-term-p))
	 ))

;; PERF could be cached in dform model
;; may return nil if no variable parameters in model.
(defun parameter-types-of-dform-model (dform)
  (let* ((model (model-of-dform dform))
	 (pindices (parameter-indices-of-dform-model model))
	 (l (length pindices)))

    (unless (zerop l)
      (let ((vars (variables-of-dform-model model))
	    (types (make-array l)))

	(dotimes (i l)
	  (setf a i c vars d model e pindices)
	  (let ((v (id-of-dform-model-variable (aref vars (aref pindices i)))))
	    ;;(setf b v) (break)
	    (setf (aref types i)
		  (find-first #'(lambda (p)
				  (when (and (display-meta-parameter-p p)
					     (eql v (value-of-parameter-m p)))
				    (type-id-of-parameter p)))
			      (parameters-of-term (term-of-dform-model model))))))
	types))))


(defun model-variable-of-dform (v dform)
  (let ((variables (variables-of-dform-model (model-of-dform dform))))

    (some #'(lambda (mv)
	      (and (eql (id-of-dform-model-variable mv) v)
		   mv))
	  variables)))



;;;;
;;;;	Formats
;;;;

(defstruct dform-formats

  (array (make-array 0) :type vector)	; layouts (includes parens).

  (constants (make-array 0) :type vector)
  (libraries (make-array 0) :type vector)

  ;; used to lookup dtrees in permuted order. Each child has dtree index, thus to
  ;; map over permuted children
  ;; (dotimes (i n)
  ;;   (funcall f
  ;;           (aref (children-of-dtree dtree)
  ;;                 (dtree-index-of-dform-child (aref (children-of-formats formats) i)))))
  (children (make-array 0) :type vector)			; just the variable child formats.
  )


(eval-when (compile)
  (proclaim '(function array-of-dform-formats (dform-formats) vector))
  (proclaim '(function children-of-dform-formats (dform-formats) vector))
  (proclaim '(function constants-of-dform-formats (dform-formats) vector))
  (proclaim '(function libraries-of-dform-formats (dform-formats) vector))
  )

(defun array-of-dform-formats (df) (dform-formats-array df))
(defun children-of-dform-formats (df) (dform-formats-children df))
(defun constants-of-dform-formats (df) (dform-formats-constants df))
(defun libraries-of-dform-formats (df) (dform-formats-libraries df))

(defun count-of-dform-formats (df) (array-dimension (array-of-dform-formats df) 0))
(defun count-of-children-of-dform-formats (df) (array-dimension (children-of-dform-formats df) 0))



;;;;	
;;;;	Formats
;;;;	

(defstruct dformat
  kind)

(defun kind-of-format (f) (dformat-kind f))

(defstruct (labeled-format (:include dformat))
  (labels nil))

(defun labels-of-format (f) (labeled-format-labels f))

(defun set-format-labels (f labels)
  (when (labeled-format-p f)
    (setf (labeled-format-labels f) labels))
  f)

;;;
;;; Text
;;;


(defstruct (text-format (:include labeled-format (kind 'text)))
  (string nil)
  (length nil)
  (liveness nil)
  ;;(text-labels nil)
  (cached-ptree nil)			; last ptree, cons of font and glyph array.

  ;; oed 
  (istring nil)
  )
  
(defun string-of-text-format (f) (text-format-string f))
(defun length-of-text-format (f) (text-format-length f))
(defun liveness-of-text-format (f) (text-format-liveness f))
(defun cached-ptree-of-text-format (f) (text-format-cached-ptree f))

(defun string-to-unicode-istring (s)
  (with-string-scanner (s)
    (scan-unicode-istring)))

(defun istring-of-text-format (f)
  ;;(setf -f f ) (break "iotf")
  ;; init if nil
  ;; convert ascii to unicode.
  (or (text-format-istring f)
      (let ((s (text-format-string f)))
	(unless (zerop (length s))
	  (let ((uistr  (string-to-unicode-istring s)))
	    (setf (text-format-length f) (length uistr))
	    (setf (text-format-istring f) uistr)
	    )))))



(defun new-text-format (s &optional live-p length)
  (let ((str (if (symbolp s)
		 (string s)
		 s)))
    (unless (string= "" str)
      (make-text-format :string str 
			:length (or length (length str))
			:liveness (if live-p '!live '!dead)
			:istring(when length
				   (unless (zerop (length s))
				     (string-to-unicode-istring s)))))))



;;;; 	RLE ??? may want to segment formats to allow dtree to inherit segments directly.
;;;;	RLE ??? Ie if there are adjacent constants in the formats then dtree might
;;;;	RLE ??? be able to use the segment directly.

;;;;	child format has pointer to dtree via dtree index. For some purposes,
;;;;	it would be convenient to have pointer in dtree back to format to be
;;;;	able to easily access data such as descriptor and flags.
;;;;	- better solution would be to have parallel format array in dform
;;;;	 then index of dtree in dtree child array would index format in
;;;;	 parallel format array. But do we know index when looking up needed data?
;;;;	 just as model variable array parallels dtree child array.
;;;;	 - or put format index or direct pointer in model variable.
;;;; 	wait for use before deciding. FTTB, try to be abstract about accessing format from dtree.

;; not all flags are applicable to all children.

(defstruct (dform-child (:include labeled-format))
  (flags nil)

  (conditions nil)
  (dtree-index nil)			; index of corresponding dtree in child array of dtree.
  ;;(item nil)
  )

(define-flags (dform-child)
    ((hidden nil t)

     (elide nil t)

     ;;(constant nil t)
     (iterate nil t)
     ;;(term)
     (mode any multi linear preflinear)

     (non-modifiable nil t)))



(defstruct (dform-parameter-child (:include dform-child (kind 'child-parameter)))
  (variable nil)
  (descriptor nil)
  )

(defstruct (dform-term-child (:include dform-child (kind 'child-term)))
  (parens nil)
  (width nil)
  )

(defstruct (dform-variable-child (:include dform-term-child))
  variable
  descriptor				; format or array of formats.
  )

(defstruct (dform-constant-child (:include dform-child (kind 'child-constant)))
  term
  )

(defstruct (dform-library-child (:include dform-term-child))
  pointer				; display meta id of model variable
  index					; index of corresponding child dtree.
  )

(defun conditions-of-dform-child (df) (dform-child-conditions df))
(defun dtree-index-of-dform-child (df) (dform-child-dtree-index df))

(defun pointer-of-dform-library-child (c) (dform-library-child-pointer c))
(defun index-of-dform-library-child (c) (dform-library-child-index c))

(defun variable-of-dform-parameter-child (df) (dform-parameter-child-variable df))
(defun variable-of-dform-variable-child (df) (dform-variable-child-variable df))

(defun variable-of-dform-child (c)
  (cond
    ((dform-variable-child-p c)
     (variable-of-dform-variable-child c))
    ((dform-parameter-child-p c)
     (variable-of-dform-parameter-child c))
    ((dform-library-child-p c)
     (pointer-of-dform-library-child c))
    (t (raise-error (error-message  '(dform child variable not))))))

(defun term-of-dform-constant-child (df) (dform-constant-child-term df))

(defun descriptor-of-dform-variable-child (df) (dform-variable-child-descriptor df))
(defun descriptor-of-dform-parameter-child (df) (dform-parameter-child-descriptor df))

(defun parens-of-dform-term-child (df) (dform-term-child-parens df))
(defun width-of-dform-term-child (df) (dform-term-child-width df))

(defun new-dform-parameter-child (variable descriptor)
  (init-dform-child-flags
   (make-dform-parameter-child :variable variable
			      :descriptor descriptor)))


(defun new-dform-variable-child (variable descriptor)
  (init-dform-child-flags
   (make-dform-variable-child :variable variable
			      :descriptor (new-text-format descriptor))
   (when (iterate-p variable)
     '((iterate . t)))))

(defun new-dform-constant-child (term)
  (init-dform-child-flags
   (make-dform-constant-child :term term)))

(defun new-dform-library-child (pointer)
  (init-dform-child-flags
   (make-dform-library-child :pointer pointer)))




(defun new-dform-formats (formats)
  (declare (list formats))
  
  (let ((array (make-array (length formats))))

    (dotimeslist (i f formats)
		 (setf (aref array i) f))

    (let ((child-list nil))

      ;;(setf d array) (break "ba")
      (dotimes (i (array-dimension array 0))
	(let ((format (aref array i)))
	  ;;(setf c format) (break "ndf")
	  (when (or (dform-variable-child-p format)
		    (dform-parameter-child-p format)
		    (dform-library-child-p format))
	    (push format child-list))))

      (let ((children (make-array (length child-list))))
	(dotimeslist (i c (nreverse child-list))
		     (setf (aref children i) c))

	(make-dform-formats :array array
			    :children children
			    )))))


;;;
;;; break-control
;;;

(defstruct (break-control-format (:include dformat (kind 'break-control)))
  (type nil)				; could be done as flags??
  )

(defun new-break-control-format (type)
  (make-break-control-format :type type))

(defun type-of-break-control-format (f) (break-control-format-type f))


;;;
;;; break
;;;

(defstruct (cut-break-format (:include dformat (kind 'cut-break)))
  )

(defstruct (break-format (:include dformat (kind 'break)))
  (string "")
  (prefix "")
  (suffix ""))

(defun new-break-format (string prefix suffix)
  (make-break-format :string string
		     :prefix prefix
		     :suffix suffix))

(defun string-of-break-format (f) (break-format-string f))
(defun prefix-of-break-format (f) (break-format-prefix f))
(defun suffix-of-break-format (f) (break-format-suffix f))


;;;
;;; space
;;;

(defstruct (space-format (:include dformat (kind 'space)))
  (text (new-text-format " " nil )))

(defun text-of-space-format (s) (space-format-text s))

(defparameter *space-format* (make-space-format))

(defun new-space-format () *space-format*)


;;;
;;; push/pop
;;;

(defstruct (push-format (:include dformat (kind 'push)))
  (amt nil)
  (ptree nil))

(defun new-push-format (i) (make-push-format :amt i
					     :ptree (new-pindent (* i 13) ; completely bogus kludge fttb.
								 )))
(defun amt-of-push-format (f) (push-format-amt f))
(defun ptree-of-push-format (f) (push-format-ptree f))


(defstruct (pop-format (:include dformat (kind 'pop)))
  (ptree (new-pindent nil)))

(defun ptree-of-pop-format (f) (pop-format-ptree f))

(defparameter *pop-format* (make-pop-format))

(defun new-pop-format () *pop-format*)


(defstruct (dform-parentheses (:include dformat (kind 'parentheses)))
  (relation nil)			; could be flags.
  (injection-address nil)				; may be nil
  (precedence-address nil)				; may be nil
  (wrapper nil))
   
(defun new-dform-parentheses (relation pointer variable formats)
  (mlet* (((prefix suffix) (do ((formats formats (cdr formats))
				(acc nil (cons (car formats) acc)))
			       ((or (null formats) (and (variable-id-p (car formats))
							(eql variable (car formats))))
				(values (nreverse acc) (cdr formats))))))

	 (make-dform-parentheses :relation relation
				 :injection-address pointer
				 :wrapper (cons
					   (when prefix
					     (if (null (cdr prefix))
						 (car prefix)
						 (let* ((l (length prefix))
							(prefix-array (make-array l)))
						   (dotimeslist (i f prefix)
								(setf (aref prefix-array i) f))
						   prefix-array)))
					   (when suffix
					     (if (null (cdr suffix))
						 (car suffix)
						 (let* ((l (length suffix))
							(suffix-array (make-array l)))
						   (dotimeslist (i f suffix)
								(setf (aref suffix-array i) f))
						   suffix-array)))))))



(defun relation-of-dform-parentheses (dp) (dform-parentheses-relation dp))
(defun injection-address-of-dform-parentheses (dp) (dform-parentheses-injection-address dp))
;; precedence-address-of-dform-parentheses : see edd-dform, does lazy update.
(defun wrapper-of-dform-parentheses (dp) (dform-parentheses-wrapper dp))




;;;;	
;;;;	Dform
;;;;	
;;;;	

	     
;; tags of object address should uniquely identify object. We just add punctuation.
(defun generate-suppress-tag ()
  (let ((sym (gensym)))
    (setf (get sym 'dtree-suppression) t)
    sym))

(defun generate-name-suppress-label (oid name)
  (let ((sym (intern-system (concatenate 'string (string-of-oid oid) name))))
    (setf (get sym 'dtree-suppression) t)
    sym))
  


(defstruct (dform ;;(:include dms-dform)
		  (:print-function
		   (lambda (dform stream depth)
		     (declare (ignore depth))
		     (format stream "DFORM[~a] ~a"
			     (or (name-of-dform dform) "")
			     (term-sig-of-term (model-term-of-dform dform))))))

  (dforms nil)				; definition containing dform

  ;; flags
  (flags nil)
  
  (stale nil)				; not in flags as 

  ;; attributes

  ;; dform conditions
  (conditions nil)

  ;; string to be used to index pointer in a dform address.
  (name nil)

  ;; string to be used to create edit macro to instantiate dform.
  (macro-name nil)

  ;; choice
  (cond-expr nil)
  (hidden-cond-expr nil)

  ;; predicates

  ;; RLE ??? : does it make sense for both to be set.? I don't think so.
  ;; RLE ??? : could define flag and reuse field?
  ;; RLE TODO : at least report inclusion of both as error. Lib or Edd?
  (family nil)
  (families nil)

  (floatup-index nil)

  (dummy-tests nil)			; list of (subterm . binding) indices for dummy tests.

  ;; parenthesization
  (precedence-injection nil)		; dform address or precedence label.
  (precedence-address nil)
  
  ;; formats
  (formats nil)

  ;; model
  (model nil)				; rhs template term
  
  ;; number of children ; num match vars + num lib + num constants
  (num-children nil)
  

  ;; dform suppression.
  (oid nil)				; object address of dform.
  (suppress-tag nil)
  (suppress-label nil)			; generated by term-to-dform if dform named.

  ;; more attributes :  list of terms 
  ;; includes !pform_name{<tok>}
  (others nil)
  )


(defun print-dform-to-string (dform)
  (format-string "DFORM[~a] ~a"
		 (or (name-of-dform dform) "")
		 (term-sig-of-term (model-term-of-dform dform))))

(define-flags (dform)
    ((parens-passthru)
     (precedence-exception t nil)
     (floatup-continued)		; t when FLOATUP in model but not formats.
     (iterate)

     (globally-suppressed-dform)
     (globally-suppressed-address)
     ))


(defun new-dform ()
  (init-dform-flags 
   (make-dform 
    ;; :model (make-dform-model :term model)
    )))


;; rle todo : add hidden indices field to dform, warn if hidden cond-expr defined
;; but no hidden indices and no dummy tests.

(defun dform-stale-p (dform) (dform-stale dform))

(defun dforms-of-dform (d) (dform-dforms d))

(defun dform-precedence-exception-p (dform) (dform-flag-precedence-exception-p dform))
(defun dform-parens-passthru-p (dform) (dform-flag-parens-passthru-p dform))
(defun precedence-injection-of-dform (dform) (dform-precedence-injection dform))
;;(defun precedence-address-of-dform (dform) (dform-precedence-address dform))
(defun macro-name-of-dform (dform) (dform-macro-name dform))
(defun name-of-dform (dform) (dform-name dform))

(defun cond-expr-of-dform (dform) (dform-cond-expr dform))
(defun hidden-cond-expr-of-dform (dform) (dform-hidden-cond-expr dform))
(defun families-of-dform (dform) (dform-families dform))
(defun family-of-dform (dform) (dform-family dform))
(defun floatup-index-of-dform (dform) (dform-floatup-index dform))
(defun dform-floatup-continued-p (dform) (dform-flag-floatup-continued-p  dform))
(defun conditions-of-dform (dform) (dform-conditions dform))

(defun other-attributes-of-dform (dform) (dform-others dform))

(defun formats-of-dform (dform) (dform-formats dform))
(defun num-children-of-dform (dform) (dform-num-children dform))

(defun oid-of-dform (dform) (dform-oid dform))
(defun suppress-tag-of-dform (dform) (dform-suppress-tag dform))
(defun suppress-label-of-dform (dform) (dform-suppress-label dform))


(defun model-of-dform (dform) (dform-model dform))
(defun model-term-of-dform (dform) (term-of-dform-model (dform-model dform)))
(defun model-iparms-of-dform (dform) (iparms-of-dform-model (dform-model dform)))
(defun model-variables-of-dform (dform) (variables-of-dform-model (dform-model dform)))


(eval-when (compile)
  (proclaim '(function model-variables-of-dform (dform) (vector dform-model-variable)))
  (proclaim '(function child-formats-of-dform (dform) (vector dform-child)))
  (proclaim '(function constant-formats-of-dform (dform) (vector dform-child)))
  (proclaim '(function library-formats-of-dform (dform) (vector dform-child)))
  )

(defun formats-array-of-dform (dform) (array-of-dform-formats (dform-formats dform)))
(defun child-formats-of-dform (dform) (children-of-dform-formats (dform-formats dform)))
(defun constant-formats-of-dform (dform) (constants-of-dform-formats (dform-formats dform)))
(defun library-formats-of-dform (dform) (libraries-of-dform-formats (dform-formats dform)))


(defstruct (dforms (:include definition))
  (list nil)
  (permuted-list nil)
  )

(defun list-of-dforms (dforms) (dforms-list dforms))
(defun model-of-dforms (dforms) (model-of-display-substance (substance-of-definition dforms 'display-substance)))
(defun name-of-dforms (dforms) (name-of-display-substance (substance-of-definition dforms 'display-substance)))

(defun new-edd-dforms (substance list)

  (let ((dforms (make-dforms :substance substance
			     :keys (list (model-of-display-substance substance))
			     :list list
			     :permuted-list (reverse list)
			     )))

      (dolist (d list)
	(when d 
	  (setf (dform-dforms d) dforms)))

      dforms))

    

;;;;	All Format children include index of corresponding dtree in child array.
;;;;
;;;;	Library-child-indices : 
;;;;	  - order is unimportant.
;;;;	  - dtree indices for refresh.
;;;;	  - RLE TODO : probably can accomplish easily enough through lib formats.
;;;;	  - RLE TODO : ie just use dtree indices in lib formats.
;;;;	
;;;;	Library-formats :
;;;;	  - order is unimportant.
;;;;	  - library formats for instantiate.
;;;;	
;;;;	Constant-formats: 
;;;;	  - order is unimportant.
;;;;	  - constant formats for instantiate.
;;;;	
;;;;
;;;;	All indices could be format indices which are then used to lookup up
;;;;	formats and then lookup up dtree using format index. Conceptually
;;;;	simpler? Extra indirection in heavily used area.
;;;;	
;;;;	Flag non-primary duplicate formats as non-modifiable. At the momemnt the
;;;;	first format in the format array will be considered primary. If there is
;;;;	demand, and attribute could be added to child attributes to indicate a
;;;;	primary duplicate.
;;;;	
;;;;	Flag all libraries and constants as non-modifiable.

(defun dform-formats-update (dform)
  ;;(setf -dform dform) (break "dfu")
  (let* ((formats (formats-of-dform dform))
	 (model (model-of-dform dform))
	 (variables (variables-of-dform-model model)))
      
    (let ((child-formats (children-of-dform-formats formats))
	  (constants nil)
	  (libs nil))
	
      (dotimes (i (array-dimension child-formats 0))
	(let ((f (aref child-formats i)))
	    
	  (when (dform-constant-child-p f)
	    (push f constants))
	  (when (dform-library-child-p f)
	    (push f libs))))
      
      
      (setf (dform-num-children dform)
	    (+ (length variables) (length constants) (length libs)))

      (let* ((first-constant-index (length variables))
	     (constant-index 0)
	     (constant-array (make-array (length constants)))
	     (first-library-index (+ first-constant-index (length constants)))
	     (library-index 0)
	     (library-array (make-array (length libs))))

	(let ((indices-seen nil))
	  (dotimes (i (array-dimension child-formats 0))
	    (let ((f (aref child-formats i)))
	      ;;(setf -f f) (break "dfuf")
	      (cond
		((dform-parameter-child-p f)
		 (let ((index (position (variable-of-dform-parameter-child f)
					variables
					:key #'id-of-dform-model-variable)))
		   (setf (dform-child-dtree-index f) index)
		   (if (member index indices-seen)
		       (dform-child-flag-set-non-modifiable f t)
		       (push index indices-seen))))

		((dform-variable-child-p f)
		 (let ((index (position (variable-of-dform-variable-child f)
					variables
					:key #'id-of-dform-model-variable)))
		   (setf (dform-child-dtree-index f) index)
		   (if (member index indices-seen)
		       (dform-child-flag-set-non-modifiable f t)
		       (push index indices-seen))))

		((dform-constant-child-p f)
		 (dform-child-flag-set-non-modifiable f t)
		 (setf (aref constant-array constant-index) f)
		 (setf (dform-child-dtree-index f)
		       (+ first-constant-index constant-index))
		 (incf constant-index))
		
		((dform-library-child-p f)
		 ;;(setf -f f -variables variables -library-index library-index -library-array library-array		       -libs libs)
		 ;;(break "dlc")
		 (dform-child-flag-set-non-modifiable f t)
		 (setf (aref library-array library-index) f)
		 (setf (dform-child-dtree-index f) (+ first-library-index library-index))
		 (setf (dform-library-child-index f) (position (pointer-of-dform-library-child f)
							       variables
							       :key #'id-of-dform-model-variable))
		 (incf library-index))))))

	(setf (dform-formats-libraries formats) library-array
	      (dform-formats-constants formats) constant-array)
	  
	))))


(defun format-of-dtree (d)
  (let ((p (parent-of-dtree d)))
		
    (when p
      (let ((children (children-of-dtree-c p)))
	(some #'(lambda (f)
		  (let ((c (aref children (dtree-index-of-dform-child f))))
		    (when (eql d c)
		      f)))
	      (child-formats-of-dform (dform-of-dtree-c p)))))))



;;;;	
;;;;	Dform Addresses.
;;;;	
;;;;	


(defstruct (dform-address)  ;;(:include object-address)
  (oid nil)
  (id nil))

(defun oid-of-dform-address (d) (dform-address-oid d))
(defun id-of-dform-address (d) (dform-address-id d))
(defun dform-address-indexed-p (d) (integerp (id-of-dform-address d)))
(defun dform-address-named-p (d) (stringp (id-of-dform-address d)))

(defun stamp-of-dform-address (d) (stamp-of-oid (dform-address-oid d)))

(defun equal-dform-addresses-p (daddr1 daddr2)
  (and (equal-oids-p (oid-of-dform-address daddr1)
		     (oid-of-dform-address daddr2))
       (let ((id1 (id-of-dform-address daddr1)))
	 (if (stringp id1)
	     (let ((id2 (id-of-dform-address daddr2)))
	       (and (stringp id2)
		    (string= id1 id2)))
	     (eql id1 (id-of-dform-address daddr2))))))


(defun dform-address-of-dform (dform)
  (new-dform-address (oid-of-dform dform)
		     (position dform (list-of-dforms (dforms-of-dform dform)))))


(defun nth-dform (dforms i)
  (let ((l (length dforms)))
    (unless (and (> i 0) (< (1- i) l))
      (raise-error (error-message '(dform nth range) i l)))
    (nth (1- i) dforms)))

;;; RLE TODO unit test
(defun lookup-dform-in-list (list daddr &optional (error-p t))
  ;; members of the list may be nil if dform failed to import.
  (let ((dform (cond
		 ((dform-address-indexed-p daddr)
		  (with-oids ((list (oid-of-dform-address daddr)) '(lookup))
		    (nth-dform list (id-of-dform-address daddr))))
		 ((dform-address-named-p daddr)
		  (let ((name (id-of-dform-address daddr)))
		    (find-first #'(lambda (dform)
				    (when (string= name (name-of-dform dform))
				      dform))
				list)))
		 (t (car list)))))

    (unless (or dform (not error-p))
      (raise-error (oid-error-message (list (oid-of-dform-address daddr))
				      '(dform lookup address nil)
				      (id-of-dform-address daddr))))

    dform))



(defun new-dform-address (oid id)
  (unless (oid-p oid)
    (raise-error (error-message '(dform address object-id))))
    
  (make-dform-address :oid oid :id id))



(defun term-to-dform-address (term &optional (void-ok-p nil))
  (with-backtrace "term-to-dform-address"
    (cond
      ((relative-idform-address-term-p term)
       (new-dform-address (current-object-id)
			  (id-of-idform-address-term term)))

      ((idform-address-term-p term)
       (new-dform-address (oid-of-idform-address-term term)
			  (let ((id (id-of-idform-address-term term)))
			    (cond
			      ((not (stringp id))
			       (raise-error (error-message '(dform-address term id) term)))
			      ((every #'(lambda (ch) (digit-char-p ch))
				      id)
			       (parse-integer id))
			      ((string= "" id) 1)
			      (t id)))))

      ((and (ivoid-term-p term)
	    void-ok-p)
       nil)

      (t (raise-error (error-message '(dform-address term) term))))))


(defun dform-address-to-term (da)
  (if da
      (idform-address-term (id-of-dform-address da)
			   (oid-of-idform-address da))
      (ivoid-term)))


(defun find-duplicate-dforms ()
  (let ((table (environment-resource 'dforms))
	(duplicates nil))
    
    (name-table-map-2 table (current-transaction-stamp)
		      #'(lambda (x defs) 
			  (when (cdr defs)
			    ;;(setf vv defs) (break)
			    (let ((oids (sort-oids-by-time
					 (mapcan #'(lambda (x) (when x (list (oid-of-definition x))))
						 defs))))
	       
			      ;;(setf ii (cdr oids)) (break)
			      (setf duplicates (append (cdr oids) duplicates))))))
    duplicates))

(defunml  (|find_duplicate_dforms| (unit))
    (unit -> (object_id list))
  (find-duplicate-dforms))
  

				
  



;;;;	
;;;;	History
;;;;	
;;;;	destructive ops :
;;;;	
;;;;	cut, paste, lift text, ie set-view-dtree.
;;;;	
;;;;	Some prefix of history should be dtrees. but beyond
;;;;	that they should be terms. 
;;;;	
;;;;	interval indicates sample rate from one generation to the next.
;;;;	
;;;;	(new-history-generation 1024 0 t) produces a dynamic  infinite and complete history.
;;;;	new-history ((size interval f) list) produces a static history of specified generations.
;;;;	
;;;;	

;; when accessing dtrees of history need some type of clean to clear
;; text-mods, but need to make sure no mods active. Ie maybe
;; first step of undo is to lift current text mods.

;; an array with a fill pointer is sufficient for history.

(defclass history ()
  (
   (array :reader array-of-history
	  :initarg array)

   ;; meaningless if null next.
   (sample-interval :reader interval-of-history
		    :initform 16
		    :initarg interval)

   ;; count of overflow
   (sample-count :reader count-of-history
		 :writer set-history-count
		 :initform 0)

   ;; if t, then when overflow add another generation similar to current.
   (next	:reader next-of-history
		:writer set-history-next
		:initform nil
		:initarg next)

   (conversion	:reader conversion-of-history
		:writer set-history-conversion
		:initform #'(lambda (x) x)
		:initarg conversion)

   (walks	:reader walks-of-history ; active walks.
		:writer set-history-walks
		:initform nil)
   ))

;; generations : (int . int . func{conversion}) list
(defun new-history (generations)
  (let* ((gen-size (caar generations))
	 (gen-interval (or (cadar generations) gen-size))
	 (gen-conversion (cddar generations))
	 (next-gen (cdr generations)))
    
    (make-instance 'history
		   'array (make-array gen-size :fill-pointer 0 :initial-element nil)
		   'interval gen-interval
		   'next (when next-gen (new-history next-gen))
		   'conversion (or gen-conversion #'(lambda (x) x)))))

(defun new-history-generation (size interval next-gen)
  (make-instance 'history
		   'array (make-array size :fill-pointer 0 :initial-element nil)
		   'interval interval
		   'next next-gen))
	




;;;;	
;;;;	Walk history :
;;;;	
;;;;	  traverse history generations from most recent to least.
;;;;	  traverse history array from most recent to least.
;;;;	
;;;;	  when moving to an older generation remember the more recent
;;;;	  so that you may walk backwards.
;;;;	
;;;;	when history update all active walks become stale.
;;;;	
;;;;	 forward in history == backward in time == decrement
;;;;	 next generation == backward in time.
;;;;	 prev generation == foreward in time.


      ;; consider history of size three 0 1 2, assume fill is one, ie a(1) is oldest of this generation.
      ;; if moving forward then first stop is 0 then 2 then 1.
      ;; if moving backward then 1 - 2 - 0, but if we init index to be 1 then go back we go to 2 whereas
      ;; so if we init to 0 then good. When moving up to previous we would init to 1.
      ;;   attempt to move back from 0 should result in nil
      ;;   attempt to mvoe fore from 2 should result in nextgen.



(defstruct history-walk
  (stale   nil)
  (history nil)
  (index 0)
  (previous nil)			; up pointer to walk of more recent history generation.
  (adjustable nil)
  )

(defun history-of-history-walk (hw) (history-walk-history hw))
(defun index-of-history-walk (hw) (history-walk-index hw))
(defun previous-of-history-walk (hw) (history-walk-previous hw))
(defun history-walk-stale-p (hw) (history-walk-stale hw))
(defun history-walk-adjustable-p (hw) (history-walk-adjustable hw))

(defmethod fill-of-history ((h history))
  (let ((a (array-of-history h)))
    (fill-pointer a)))

(defmethod size-of-history ((h history))
  (let ((a (array-of-history h)))
    (array-dimension a 0)))

(defun first-of-history (h)
  (let ((a (array-of-history h)))
    (aref a (mod (1- (fill-pointer a)) (array-dimension a 0)))))

(defun second-of-history (h)
  (let ((a (array-of-history h)))
    (aref a (mod (- (fill-pointer a) 2) (array-dimension a 0)))))


(defun history-walk-begin (h &optional adjustable)
  ;; add to active walks
  (let ((w (make-history-walk :history h
			      :adjustable adjustable
			      :index (mod (1- (fill-of-history h)) (size-of-history h)))))
    (set-history-walks (cons w (walks-of-history h)) h)
    w))

(defun history-walk-end (hwalk)

  (setf (history-walk-stale hwalk) t)
  (let ((h (history-of-history-walk hwalk)))
    (set-history-walks (delete hwalk (walks-of-history h)) h))

  nil)

(defun history-walk-clone (hwalk)
  (when (history-walk-stale-p hwalk)
    (raise-error (error-message '(history walk clone stale))))
  (make-history-walk :history	(history-of-history-walk hwalk)
		     :index	(index-of-history-walk hwalk)
		     :previous	(previous-of-history-walk hwalk)))  


;; fail if stale.
(defun history-walk-peek (hwalk)
  (aref (array-of-history (history-of-history-walk hwalk))
	(index-of-history-walk hwalk)))


;; questionable :
;;
;; if walk back to a point in history and then continue from there.
;; this function will reverse and push onto history the walk thru history
;; assume less jarring when next walking history as changes will be
;; more gradual.
;; only does least recent generation walked into. NFG since all mods to all more recent generations are completely skipped
;; but then have regular steps. Ie huge hole followed by regular spacing. Should sample more recent historys/
;; FTTB, just update last.
;;

(defun history-walk-jump-back (hwalk)
  (let* ((index (index-of-history-walk hwalk))
	 (hh (history-of-history-walk hwalk))
	 (h (or (car (last (previous-of-history-walk hwalk)))
		hh))
	 (a (array-of-history hh))
	 (f (fill-pointer a))
	 (d (array-dimension a 0))
	 (modf (mod (- f 1) d))
	 )

    (unless (and (eql a (array-of-history hh))
		 (= index modf))
    ;;(setf -a a -f f -d d -h h -i index) (break "hwba")

      (setf (history-walk-history hwalk) h
	    (history-walk-previous hwalk) nil
	    (history-walk-index hwalk) modf)
      t)))



(defun history-walk-reverse (hwalk)
  (let* ((index (index-of-history-walk hwalk))
	 (hh (history-of-history-walk hwalk))
	 (a (array-of-history hh))
	 (f (fill-pointer a))
	 (d (array-dimension a 0))
	 (h (or (car (last (previous-of-history-walk hwalk)))
		hh)))

    
    ;;(setf -index index -hh hh -a a -f f -d d -h h) (break "hwr")
    (unless (and (eql a (array-of-history h))
		 (= index (mod (- f 1) d)))

      ;; FTTB, just update last.
      (history-update h (aref a index))
      (when nil 
	(do ((i (mod (- f
			;; if a is from most recent generation then do not duplicate first foreward.
			(if (eql a (array-of-history h)) 2 1))
		     d)
		(mod (1- i) d)))
	    ((= i index))
	  (history-update h (aref a i)))))))
      

;; history update called. Adjust walk index so that still points at same element.
;; returns hwalk if adjusted.
(defun history-walk-adjust (hwalk)
  (let* ((index (index-of-history-walk hwalk))
	 (h (history-of-history-walk hwalk))
	 (a (array-of-history h))
	 (f (fill-pointer a))
	 (d (array-dimension a 0)))

    (if (not (null (previous-of-history-walk hwalk)))
	(progn 
	  (setf (history-walk-stale hwalk) t)
	  nil)
	
	;; similar to walk forward but really staying in place.
	(cond
	  ;; if walk index at fill then we've gone all the way around. So go to next generation.
	  ((= index f)
	   ;; give it up.
	   (setf (history-walk-stale hwalk) t)
	   nil)

	  (t hwalk)))))


;; assumes nil mean unused history slot.
;; forward in history == backward in time == decrement
(defun history-walk-forward (hwalk)
  (let* ((index (index-of-history-walk hwalk))
	 (h (history-of-history-walk hwalk))
	 (a (array-of-history h))
	 (f (fill-pointer a))
	 (d (array-dimension a 0)))
    
    ;;(setf -a a -f f -d d -h h -i index) (break "hwf")

    (cond
      ;; if walk index at fill then we've gone all the way around. So go to next generation.
      ((= index f)
       (let ((ng (next-of-history h)))
	 (when ng
	   (let* ((a (array-of-history ng))
		  (f (fill-pointer a))
		  (d (array-dimension a 0)))

	     (setf (history-walk-history hwalk) ng
		   (history-walk-previous hwalk) (cons h (previous-of-history-walk hwalk))
		   (history-walk-index hwalk) (mod (1- f) d))
	     (history-walk-forward hwalk)))))

      (t (let ((i (mod (1- index) d)))
	   (unless (null (aref a i))
	     (setf (history-walk-index hwalk) i)
	     t))))))


;; backward in history == forward in time == increment
(defun history-walk-backward (hwalk)
  ;; if move to more recent generation then end previous walk of older generation.
  (let* ((index (index-of-history-walk hwalk))
	 (h (history-of-history-walk hwalk))
	 (a (array-of-history h))
	 (f (fill-pointer a))
	 (d (array-dimension a 0)))

    ;;(setf -a a -f f -d d -h h -i index) (break "hwb")
    (cond
      
      ;; if walk index one less then fill then we've gone all the way back. So go to previous generation.
      ((= (mod (1- f) d) index)
       (let ((pg (car (previous-of-history-walk hwalk))))
	 (when pg
	   (let* ((a (array-of-history pg))
		  (f (fill-pointer a)))

	     (setf (history-walk-history hwalk) pg
		   (history-walk-previous hwalk) (cdr (previous-of-history-walk hwalk))
		   (history-walk-index hwalk) f)
	     (history-walk-backward hwalk)))))

      ;; otherwise simply move backward 1
      (t (let ((i (mod (1+ index) d)))
	   ;; null if history slot unused, ie history has not yet wrapped at least once.
	   (unless (null (aref a i))
	     (setf (history-walk-index hwalk) i)
	     t))))))


(defmethod history-ding-walks ((h history) &optional old)

  (set-history-walks
   (mapcan #'(lambda (w)
	       (cond
		 ((and (not old) (history-walk-adjustable-p w))
		  (let ((ahw (history-walk-adjust w)))
		    (when ahw
		      (list ahw))))
		 (t (setf (history-walk-stale w) t)
		    nil)))
	   (walks-of-history h))
   h)

  (let ((older (next-of-history h)))
    (when older (history-ding-walks older t))))


(defmethod history-update ((h history) item)
  (let* ((a (array-of-history h))
	 (fill (fill-pointer a))
	 (len (array-dimension a 0))
	 (next (next-of-history h)))

    ;;(format t "#~%~%")
    ;;(break "hu")

    (when next
      (let ((c (count-of-history h))
	    (i (interval-of-history h)))
	(if (= c i)
	    (let ((old (aref a fill)))
	      (when old
		(when (eql next t)
		  (setf next (set-history-next (new-history-generation len i t) h)))
		(history-update next (funcall (conversion-of-history h) old))
		(set-history-count 0 h)))
	    (set-history-count (1+ c) h))))
    
    
    ;; may be possible to update some walks if in first generation by simply updating walk index.
    (history-ding-walks h)

    (setf (aref a fill) item)
    ;;(format t "#~%~%") (break)
    (setf (fill-pointer a)
	  (if (= (1+ fill) len)
	      0
	      (1+ fill)))))




;;;;
;;;;	view state : a view has single dtree and is formatted for a single
;;;;	 geometry. Could still allow multiple windows. Need some type of
;;;;	 super-view to allow multiple views of same oa/term.

;;;;    RLE TODO :
;;;;    RLE TODO : In response to broadcast, should
;;;;    RLE TODO : refresh source, implicit, and geo? of open views for modified object.

(eval-when (compile)
  (proclaim '(function suppressed-addresses-of-view (t) list))
  (proclaim '(function suppressed-dforms-of-view (t) list)))

;;; RLE TODO : need dtree modified flag to indicate ptree refresh needed.
;;; RLE TODO : this may be spec'd out somewhere already???
;;; RLE TODO :  may be as simple as running *views* list and finding modified dtrees.
;;; RLE TODO :  ie, passive  but need to know when to check.

(defstruct base-view-state

  (flags nil)

  (suppressed-addresses nil)
  (suppressed-dforms nil)

  (implicit)
  (dtree)
  (label-cache nil)
  )

(define-flags (base-view-state view)
    ((layout-required nil)
     (present-required nil)

     (history t nil)
     (history-required)

     (open nil)	;; view_open -> t, view_close -> nil, after reset if t open_window.

     ;; oed
     (display-required nil)
     (cursor-layout-required nil)
     (cursor-present-required nil)
     (cursor-display-required nil)

     (cursor-visible nil)
     (echo-display-required nil)

     (modified nil local remote both)	;; modified since last load/save.
     (touched t)	;; transaction touched oid of view. Or edit updated dynamic term.
     (title-present-required nil)
     ))

;;;;	A view may be restricted to always be a lightweight view.
;;;;	Otherwise object, window, and history components may be
;;;;	manupulated via functions.
;;;;	

;; twould be neat if two views could share same object and history.
;; then simultaneous edits would be easier to untangle. Need to share more ?
;; destructive mods should affect both. maybe two views of diff zooms of same term.
(defstruct (view-state (:include base-view-state))
  (object nil)
  (window nil)				; fttb only one, but maybe later more than one.
  (history nil)
  (history-walk nil)
  (zoom-stack nil)

  ;; title
  (titles nil)	;; cached string to detect if title update needed.

  ;; allow ui coders to hang terms on view.
  (properties nil)
  )
  
(defun zoom-stack-of-view (v) ;(view-state-zoom-stack v)
  nil)
(defun history-walk-of-view (v) (view-state-history-walk v))
(defun suppressed-addresses-of-view (v) (view-state-suppressed-addresses v))
(defun suppressed-dforms-of-view (v) (view-state-suppressed-dforms v))
(defun titles-of-view (v) (view-state-titles v))
(defun properties-of-view (v) (view-state-properties v))

(defun dtree-of-view (v) (view-state-dtree v))

(defun lightweight-view-p (v) (not (view-state-p v)))

;; todo: may have vobject without being assoc'd? ie have address not corresponding
;; todo: to an object in lib??
(defun view-object-p (v)
  (and (view-state-p v)
       (view-state-object v)))

(defun view-window-p (v)
  (and (view-state-p v)
       (view-state-window v)))

(defun check-not-lightweight (v s)
  (unless (view-state-p v)
    (raise-error (error-message '(edit view lightweight) s))))

(defun label-cache-of-view (v) (view-state-label-cache v))
(defun set-view-label-cache (v c)
  ;;(format t "set-view-label-cache ~a~%" c)
  ;;(break)
  (setf (base-view-state-label-cache v) c))

(defun history-of-view (v)
  (check-not-lightweight v "object-of-view")
  (view-state-history v))

(defun object-of-view (v)
  (check-not-lightweight v "object-of-view")
  (view-state-object v))


(defun window-of-view (v &optional nil-ok-p)
  (check-not-lightweight v "window-of-view")
  (or (view-state-window v)
      (unless nil-ok-p
	(raise-error (error-message '(view window not)))
	)))

(defun view-window-open-p (v)
  (let ((ewin (when (view-window-p v)
		(window-of-view v))))
    (and ewin (window-open-p ewin))))

(defun set-view-window (v w)
  (check-not-lightweight v "set-view-window")
  (setf (view-state-window v) w))



;;;
;;;	props.
;;;
;;;;	
;;;;	view_property_push	: tok{name} -> term{prop} -> view -> unit
;;;;	view_property_replace	: tok{name} -> term{prop} -> view -> unit
;;;;	  - removes a single previous prop with same name if present
;;;;	view_property_pop	: tok{name} -> view -> unit
;;;;	  - removes a single prop with name if present
;;;;	view_property_lookup	: tok{name} -> view -> term
;;;;	
;;;;	

(defunml (|view_property_push| (name prop v))
    (tok -> (term -> (view -> unit)))

  (setf (view-state-properties v)
	(acons name prop (view-state-properties v))))


(defunml (|view_property_replace| (name prop v))
    (tok -> (term -> (view -> unit)))

  (setf (view-state-properties v)
	(acons name prop (delete name (view-state-properties v) :key #'car :count 1))))

(defunml (|view_property_pop| (name v))
    (tok -> (view -> unit))

  (setf (view-state-properties v)
	(delete name (view-state-properties v) :key #'car :count 1)))

(defunml (|view_property_lookup| (name v))
    (tok -> (view -> term))

  (or (cdr (assoc name (view-state-properties v)))
      (raise-error (oid-error-message (let ((o (oid-of-view v))) (when o (list o)))
				      '(view property lookup not)
				      name)))) 


	


;; should reset history but not delete.
;; ie need ability to have empty history.
;;  and need to be able to distinquish empty from none.

(defun view-history-init (v)
  (setf (view-state-history v) (new-edit-history))
  )

(defun view-history-reset (v)
  (setf (view-state-history v) nil))


(defun view-begin-history-walk (v)

  (let ((h (history-of-view v)))
    (when h
      (let ((w (history-walk-begin h)))

	(setf (view-state-history-walk v) w)
	(view-flag-set-history v nil)

	;; assume first of history is current so take one step forward.
	;; no-no edit-undo by default will take step forward
	;;(history-walk-forward w)

	w))))


;; maybe setting dtree
(defun view-end-history-walk (v)

  (let ((w (history-walk-of-view v)))
    (when w
      (history-walk-reverse w)
      (unless (null w)
	(history-walk-end w)
	(setf (view-state-history-walk v) nil)))

    )

  (when (history-of-view v)
    (view-flag-set-history v t)))


(defun view-abort-history-walk (v)
  (let ((w (history-walk-of-view v)))
    (unless (null w)
      (history-walk-end w)
      (setf (view-state-history-walk v) nil)
      ))
  (break "ahw")
  (view-flag-set-history v t))

(defun view-verify-modified (v)
  ;;(break "vvm")
  (let ((vobj (object-of-view v)))
    (if vobj
	;; may want to remove/ignore labels.
	(when (without-dependencies
	       (compare-terms-p (setf -oterm (source-reduce (term-of-vobject vobj) '(unconditional edit)))
				(setf -vterm (source-reduce (term-of-view v) '(unconditional edit)))))
	  (view-flag-set-modified v nil))
	(view-flag-set-modified v nil))
	    
    ;;(setf -vobj vobj -v v) (break "vvm")
    (view-refresh-title v)))


(defun set-view-dtree (v dtree &optional skip-history-end)
  ;;(when (eql v -myview) (format t "SetViewDtree~%") ;(break "svd")
  ;;)
  (when (dtree-leaf-p dtree) (setf -dtree dtree) (break "svd"))
  (unless (eql dtree (dtree-of-view v))

    (let ((view-mod-q (view-flag-modified-q v)))
      (unless (member view-mod-q '(local both))
	(when (or (dtree-flag-text-modified-p v)
		  (require-dtree-refresh-p (dtree-flag-term-modified-q dtree) 'text)
		  skip-history-end)
	  
	  (if (eql 'remote view-mod-q)
	      (view-flag-set-modified v 'both)
	      (view-flag-set-modified v 'local)
	      )

	  (view-refresh-title v) )))
    
    (unless skip-history-end
      (view-end-history-walk v))
    (set-view-label-cache v nil)
    (setf (base-view-state-dtree v) dtree)
    (when (view-flag-history-p v)
      (view-flag-set-history-required v t))
    ;;(break "svdi")
    (view-flag-set-present-required v t)
    ))


  

;;;
;;;	view object
;;;

;; todo: need flags for dissonance bits.
(defstruct vobject
  oid

  ;; following correspond to last values read from or written to lib.
  term
  implicit
  geo
  )

(defun oid-of-vobject (vobj) (vobject-oid vobj))
(defun term-of-vobject (vobj) (vobject-term vobj))
(defun geo-of-vobject (vobj) (vobject-geo vobj))
(defun implicit-of-vobject (vobj) (vobject-implicit vobj))

(defun new-vobject (oid term implicit geo)
  (make-vobject :oid oid :term term :implicit implicit :geo geo))

(defun oid-of-view-r (v)
  (let ((vobj (object-of-view v)))
    (if vobj
	(or (oid-of-vobject vobj)
	    (raise-error (error-message '(edit view object unassociated address)))))))

(defun oid-of-view (v)
  (let ((vobj (object-of-view v)))
    ;;(when (proof-object-p vobj)(break))
    (when vobj
      (oid-of-vobject vobj))))
	

(defun geometry-of-view-object (v)
  (let ((vobj (object-of-view v)))
    (if vobj
	(geo-of-vobject vobj)
	(raise-error (error-message '(edit view object unassociated geometry))))))

(defun implicit-of-view-object (v)
  (let ((vobj (object-of-view v)))
    (if vobj
	(implicit-of-vobject vobj)
	(raise-error (error-message '(edit view object unassociated implicit))))))


;;;;	
;;;;	If oid corresponds to dynamic or ObjectIdDAG data
;;;;	then vobject shows pushed data rather than lib data.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	

(defun edit-indirect-oid-p (oid)
  (and oid 
       (or (dag-directory-p oid)
	   (edit-refresh-oid-p oid))))

(defun edit-proof-oid-p (o)
  (or (eql 'prf (kind-of-ostate o))
      ;; kludge pvs
      (eql '|pvs-proof| (name-property-of-ostate o))))

(defun edit-stm-oid-p (o)
  (eql 'stm (kind-of-ostate o)))


(defun instantiate-vobject (oid)
  (if (or (null-oid-p oid) (dummy-object-id-p oid))
      (new-vobject oid (ivoid-term) nil
		   ;; twould be nice actually to look at term initialized with
		   ;; and make some guess as to size.
		   nil)
      (new-vobject oid
		   (edit-read-source oid)
		   (let ((imp (property-of-ostate 'implicit oid)))
		     (when imp
		       (map-isexpr-to-list imp (icons-op) #'id-of-ivariable-term)))
		   (let ((geo (property-of-ostate 'geometry oid)))
		     (when geo
		       (map-isexpr-to-list geo (icons-op) #'int-of-iint-term))))))


;; make sure show terms do not get a history?
;; they should not be modifiable either.
(defun view-assign-oid (v oid &optional litep)
  (let ((vobj
	 (cond
	   
	  ((or litep (dummy-object-id-p oid))
	   (view-history-init v)
	   (new-vobject oid
			(iplaceholder-term)
			nil
			nil))

	  ((edit-indirect-oid-p oid)
	   (view-history-init v)
	   ;;(view-flag-set-history v nil)
	   (instantiate-dynamic-object oid))

	  ((edit-proof-oid-p oid)
	   ;;(break "opening proof")
	   (view-history-init v)
	   (instantiate-proof-object oid))

	  ((edit-stm-oid-p oid)
	   ;;(break "opening stm")
	   (view-history-init v)
	   (let ((poid (funmlcall (ml-text "stm_to_prf") oid)))	      
	     (instantiate-proof-object poid (list oid poid))))

	  (t
	   (view-history-init v)
	   (instantiate-vobject oid)))))
	 
    ;;(setf -vo vobj)  (break "vao2")

    (set-view-object v vobj)
    (set-view-title v (new-view-titles v))
	     
    (view-dtree-init v
		     (term-of-vobject vobj)
		     (implicit-of-vobject vobj))
    ))



(defun view-assign-prf-oid (v poid soid)
  (view-history-init v)
  (let ((vobj
	 (instantiate-proof-object poid (list soid poid))))

    (set-view-object v vobj)
    (set-view-title v (new-view-titles v))
	     
    (view-dtree-init v
		     (term-of-vobject vobj)
		     (implicit-of-vobject vobj))
    ))



(defun view-set-term (v term)
  (let ((vobj (object-of-view v)))
    (setf (vobject-term vobj) term)
    ;; flag
    ))



(defun view-set-geometry (v x y w h)
  (let ((ewin (window-of-view v)))
    (if ewin
	(set-ewin-geometry ewin x y w h)
	(set-view-window v (new-ewin x y w h)))))

(defun view-get-geometry (v)
  (let ((ewin (window-of-view v)))
    (get-ewin-geometry ewin)))



(defunml (|view_object_p| (v))
  (view -> bool)
  (and (oid-of-view v) t))

(defunml (|view_object_q| (v))
  (view -> object_id)
  ;;(setf -v v) (break "v")
  (or (oid-of-view v)
      (progn ;;(setf -v v)(break "nn")
	     (raise-error (error-message '(edit view object unassociated oid q))) )))

(defunml (|prf_view_object_stm| (v))
  (view -> object_id)

  (let ((vobj (object-of-view v)))
    (unless (proof-object-p vobj)
      (raise-error (error-message '(edit view object not prf))))
    
    (let ((soid (car (oid-list-of-proof-object vobj))))
      (unless (and soid (edit-stm-oid-p soid))
	(setf ll (oid-list-of-proof-object vobj))(break)
	(raise-error (error-message '(edit prf object no stm oid))))

      soid)))

(defunml (|view_set_geometry| (v x y w h))
  (view -> (int -> (int -> (int -> (int -> unit)))))
  (view-set-geometry v x y w h))

(defun view-error-message (v tags &rest rest)
  (raise-error
   (let ((o (oid-of-view v)))
     (if v
	 (funcall #'oid-error-message (list o) tags rest)
	 (funcall #'error-message tags rest)))))


(defunml (|view_object_geometry_q| (v))
  (view -> (int list))
  (geometry-of-view-object v))

(defunml (|view_window_geometry_q| (v))
  (view -> (int list))
  (view-get-geometry v))

(defunml (|view_implicit_q| (v))
  (view -> (variable list))
  (implicit-of-view-object v))

(defun term-of-view (v)
  (dtree-to-term (dtree-of-view v)))

(defunml (|view_term_q| (v))
  (view -> term)
  (term-of-view v))
  
;;;;	view_label_q		: tag{label} -> view -> bool
(defunml (|view_label_q| (tag v))
  (tag -> (view -> bool))

  ;;(setf -tag tag -v v)(break "vq")
  (and (address-of-label (dtree-of-view v) tag) t))



(defun view-dtree-init (v term implicit)
  ;;(break "vdi")
  ;;(when (eql v -myview) (format t "ViewDtreeInit~%"))
  (setf (base-view-state-implicit v) implicit
	(base-view-state-label-cache v) nil
	(base-view-state-dtree v) (new-dtree term implicit)
	)

  (view-flag-set-layout-required v t)
  (view-flag-set-cursor-layout-required v t)
  (view-flag-set-modified v nil)
  (when (view-flag-history-p v)
    (view-flag-set-history-required v t)))

;; view -> view. inits dtree with !placeholder().
(defun view-dtree-reset (v)
  /(view-dtree-init v (iplaceholder-term) nil)
  (set-view-label-cache v nil)
  v)


;;;;	
;;;;	focus/focus stack/view stack
;;;;	
;;;;	multi-view ops will take views explicitly as args.
;;;;	
;;;;	left to presentation to handle focus stack.
;;;;	
;;;;	
;;;;	
;;;;	

(defvar *views* nil)

(defvar *current-view*)

(defun current-view ()
  (and (boundp '*current-view*)
       *current-view*))

(defmacro with-view ((v) &body body)
  `(let ((*current-view* ,v))
    ,@body))
	 

(defun set-current-view (v)
  ;;(break "scv")
  (setf *current-view* v))

(defunml (|current_view| (unit) :declare ((declare (ignore unit))))
    (unit -> view)

  (or (current-view)
      (raise-error (error-message '(current view not))))
  )


;;;;	RLE TODO : Might want to prevent suppression of lib-end-address dforms
;;;;	RLE TODO : ie, no point to suppressing defaults.

(defvar *make-view-f* nil)

(defun new-view (lightweight-p)
  (init-view-flags
   (view-dtree-reset 
    (if lightweight-p
	(make-base-view-state)
	(let ((v (funcall *make-view-f*)))
	  ;;(setf -vv v)(break"n")
	  (push v *views*)
	  v)))))

(defun suppress-dform-in-view (dform view)
  (pushnew dform (view-state-suppressed-dforms view))
  (let ((dtree (dtree-of-view view)))
    (unless (zerop (dtree-suppress-dform dtree dform))
      (view-flag-set-layout-required view t))))

(defun unsuppress-dform-in-view (dform view)
  (setf (view-state-suppressed-dforms view)
	(delete dform (suppressed-dforms-of-view view)))
  (let ((dtree (dtree-of-view view)))
    (unless (zerop (dtree-unsuppress-dform dtree dform))
      (view-flag-set-layout-required view t))))


(defun suppress-dform-address-in-view (daddr view)
  (pushnew daddr (view-state-suppressed-addresses view)
	   :test #'equal-dform-addresses-p))

(defun unsuppress-dform-address-in-view (daddr view)
  (setf (view-state-suppressed-addresses view)
	(delete daddr (suppressed-addresses-of-view view)
		:test #'equal-dform-addresses-p)))

(defun view-suppressed-dform-p (dform view)
  (and view
       nil
       (or (member dform (suppressed-dforms-of-view view))
	   (let ((addr (oid-of-dform dform))
		 (name (name-of-dform dform)))
	     (when name
	       (some #'(lambda (daddr)
			 (and (equal-oids-p addr (oid-of-dform-address daddr))
			      (eql name (id-of-dform-address daddr))))
		     (suppressed-addresses-of-view view)))))))

;; print-function for view, for ml possibly for defstruct.
(defun view-to-string (view)
  (format-string "View[~a]"
		 (cond
		   ((lightweight-view-p view)	"Lightweight")
		   ((not (view-object-p view))	"Unassociated")
		   (t (or (name-property-of-ostate (oid-of-view-r view)) "NONE")))))


(defun define-ml-basic-edd-primitive-types ()
  (add-primitive-type '|view|
		      #'(lambda (view) (view-to-string view))
		      ;;:member-p #'view-state-p
		      ;;:eq-func #'eq
		      )
  (add-primitive-type '|dform|
		      #'(lambda (dform) (print-dform-to-string dform)))
  )

(define-ml-basic-edd-primitive-types)


;;;;	
;;;;	Dfparms
;;;;	
;;;;	
;;;;	

;;;;	From sfa note: mail nuprl5/doc Subject: iparms. ~sfa/prl/edit/timt/display
;;;;
;;;;	for IParms,
;;;;	   add to IParms all variables binding this slot that
;;;;	   are explicit in the model for D (rather than filling slots for binding vars),
;;;;	   and remove from IParms all vars binding this slot that are filling
;;;;	   binding slots in the model for D (rather than occurring explicitly);
;;;;
;;;;	What if both happens ie in model d,<d>.<t> in instance d,d.t
;;;;	 Then d should be added as it is explicit in the model, but it
;;;;	 should also be removed as it is it is bound to <d>.
;;;;	Answer, depends on order in this case add d then remove it so effectively removed.
;;;;	 but if model <d>,d.<t> in instance d,d.t then remove and add so effectively added.
;;;;	

(defun compute-iparms (cur-iparms cur-bindings dform-iparms)
  (if (null dform-iparms)
      ;; null dform-iparms may be an indication of no iparms, there may still be bindings.
      (if (null cur-bindings)
	  cur-iparms
	  (diff-vars cur-iparms cur-bindings))

      ;;; RLE PERF : could do something with variable invocation to do following in linear time.
      (let ((new-iparms cur-iparms))
	(do ((iparms dform-iparms (cdr iparms))
	     (bindings cur-bindings (cdr bindings)))
	    ((null bindings) new-iparms)
	  (if (car iparms)
	      ;; add
	      (push (car iparms) new-iparms)
	      ;; remove: note that binding may be a slot
	      (setf new-iparms (remove (car bindings) new-iparms)))))))



(defstruct dfparms
  (implicit nil)	; variable ids.
  (float nil)		; term
  (cursor nil)		; family cursor.
  )

(defun implicit-of-dfparms (d) (dfparms-implicit d))
(defun float-of-dfparms (d) (dfparms-float d))
(defun cursor-of-dfparms (d) (dfparms-cursor d))

(defun new-dfparms (dfparms old-dfparms dform mv bindings float)
  ;; dfparms is parent
  ;; old-dfparms is former child during refresh.

  ;; RLE TODO PERF : make quick check if nothing is changing and return dfparms arg if so.

  (let* ((iterate-p (when mv (dform-model-variable-flag-iterate-p mv)))
	 (implicit (compute-iparms (implicit-of-dfparms dfparms)
				   bindings
				   (when mv (iparms-of-dform-model-variable mv))))
	 (float (if (eql t float)
		    (float-of-dfparms dfparms)
		    float))
	 (cursor (when iterate-p
		   (or (family-of-dform dform)
		       (cursor-of-dfparms dfparms)))))	 
    
    (cond
      ;; kind of an expensive test here,
      ;; but it seems a good bet that if successful it will be used,
      ;; and if used may prevent further refresh.
      ((and old-dfparms
	    (equal implicit (implicit-of-dfparms old-dfparms))
	    (let ((old-cursor (cursor-of-dfparms old-dfparms)))
	      (or (and (null cursor) (null old-cursor))
		  (and cursor old-cursor
		       (eql cursor old-cursor))))
	    ;; RLE PERF : if not modified but refreshing due to dform update, we can
	    ;; RLE PERF : avoid this check if same dform was chosen.
	    ;; RLE PERF : might not be big win as float terms are generally small.
	    (let ((old-float (float-of-dfparms old-dfparms)))
	      (or (and (null float) (null old-float))
		  (and float old-float
		       (edit-equal-terms-p float old-float)))))
       old-dfparms)

      (t 
       (make-dfparms :implicit implicit
		     :float float
		     :cursor cursor)))))

;;;
;;;	Global suppression
;;;

;; members of list are either dform addresses or actual dforms.

(defvar *global-suppressed* (cons nil nil))

(defun global-suppressed-addresses ()
  (car *global-suppressed*))

(defun global-suppressed-dforms ()
  (cdr *global-suppressed*))


(eval-when (compile)
  (proclaim '(function global-suppressed-dforms () list))
  (proclaim '(function global-suppressed-addresses () list))
  )

(defun globally-suppress-dform (dform)
  (unless (or (dform-stale-p dform)
	      (dform-flag-globally-suppressed-dform-p dform))
    (dform-flag-set-globally-suppressed-dform dform t)
    (setf *global-suppressed*
	  (cons (global-suppressed-addresses)
		(cons dform (global-suppressed-dforms))))))

(defun globally-unsuppress-dform (dform)
    (dform-flag-set-globally-suppressed-dform dform nil)
    (setf *global-suppressed*
	  (cons (global-suppressed-addresses)
		(delete dform (global-suppressed-dforms)))))

(defun globally-suppress-address (daddr)
  (let ((daddrs (global-suppressed-addresses)))
    (unless (member daddr daddrs :test #'equal-dform-addresses-p)
      (setf *global-suppressed*
	    (cons (cons daddr daddrs)
		  (global-suppressed-dforms)))

      (named-dform-map daddr
		       #'(lambda (dform)
			   (dform-flag-set-globally-suppressed-address dform t))))))


(defun globally-unsuppress-address (daddr)
  (setf *global-suppressed*
	(cons (delete daddr (global-suppressed-addresses)
		      :test #'equal-dform-addresses-p)
	      (global-suppressed-dforms)))

  (named-dform-map daddr
		   #'(lambda (dform)
		       (dform-flag-set-globally-suppressed-address dform nil))))


(defun globally-suppressed-address-p (oid name)
  (some #'(lambda (daddr)
	    (and (equal-oids-p oid (oid-of-dform-address daddr))
		 (eql name (id-of-dform-address daddr))))
	(global-suppressed-addresses)))


(defun globally-suppressed-dform-p (dform)
  (or (dform-flag-globally-suppressed-dform-p dform)
      (dform-flag-globally-suppressed-address-p dform)))


;;;;	
;;;;	label summaries : to avoid traversing large terms to test labels
;;;;	  label summarys may be inserted into terms arbitrarily.
;;;;	  - invalid summaries
;;;;	    a summary is invalid after :
;;;;	      * substitution
;;;;	      * filter-tags
;;;;
;;;;	    rather than attempt to modify code which invalidates summaries to identify
;;;;	    or remove such summaries, we require that constructive term modification 
;;;;	    result in identifiable invalid summaries. The obvious way of doing this
;;;;	    would be to mark terms with summaries and then constructive update during
;;;;	    substitution would naturally lose summary marks.
;;;;	
;;;;	  (eq 'summary (id-of-term <gu>)) less costly then (null (markp <gu> 'summary)) ??
;;;;	   average id-of-term	: (caar (term-sexpr <gu>))
;;;;	   optimal markp	: (caar (marks-alist <gu>))
;;;;	     - optimal case would be common.
;;;;
;;;;	marks are the way to go.
;;;;	
;;;;	!summary-labels-tags (<term>; <labels>; <tags>)
;;;;	
;;;;	summary invalid after :
;;;;	  - substitution
;;;;	  - filter-tags
;;;;	  etc.
;;;;	
;;;;	


(defvar *tag-and-label-summary-interval* 128)

(defvar *cons-nil-nil* (cons nil nil))


(defun summary-labels-tags-of-term (term)
  ;;(break "hello")
  (mark-value term 'summary-labels-tags))

(defmacro labels-of-summary (s) `(car ,s))
(defmacro tags-of-summary (s)  `(cdr ,s))

(defun summary-labels-tags (term labels tags)
  (mark term 'summary-labels-tags
	(if (or labels tags)
	    (cons labels tags)
	    *cons-nil-nil*)))


(defun unmark-term (term mark)
  (term-walk term #'(lambda (term)
		      (unmark term mark)
		      nil))
  nil)

;; summarize when ce tested on term in lazy dtree.
;; return if summary encountered, ie use summary as result of traversing subtree.
;; traverse term and summarize after every whenever count exeeeds n.
(defun summarize-term-tags-and-labels (term)

  (let ((total 0)
	(summaries 0)
	(old 0)
	)

    (labels
	((visit (term)
	   (let ((summary (summary-labels-tags-of-term term)))
	     (if summary
		 (progn (incf old)
			(values 0 (labels-of-summary summary) (tags-of-summary summary)))

		 (let ((tcount 1)
		       (labels nil)
		       (tags nil)
		       )
	   
		   (incf total)

		   ;; we will not see labels on parameters of label encodings.
		   ;; which I cannot forsee a use for.
		   ;; if value is meta no problema, just end up with meta variable in label list.
		   (cond
		     ((real-ilabel-term-p term)
		      (setf labels (mapcar #'value-of-parameter-f (parameters-of-term term))))
		     ((real-itag-term-p term)
		      (setf tags (mapcar #'value-of-parameter-f (parameters-of-term term))))

		     ;; get labels tags in parameters
		     (t (dolist (p (parameters-of-term term))
			  (let ((tags (tags-and-labels-of-parameter p)))

			    (when tags
			      (setf labels (append (labels-of-tags tags) labels))
			      (setf tags (append (tags-of-tags tags) tags)))))))

	   
		   ;; could do some kind of loop to avoid consing when no new.
		   (dolist (bt (bound-terms-of-term term))
		     (mlet* (((count nlabels ntags) (visit (term-of-bound-term bt))))

			    (incf tcount count)
			    (when (or nlabels ntags)
			      (setf labels (nunion labels nlabels)
				    tags (nunion tags ntags)))
			    ))
			  
		   (when (> tcount *tag-and-label-summary-interval*)
		     (incf summaries)
		     (setf tcount 0)
		     (summary-labels-tags term labels tags))
		   
		   (values tcount labels tags)
		   )))))
	 
      (if nil
	  (let ((r (time (visit term))))
	    (format t "~%;;;; label summary ~%;;;; Total   ~a~%;;;; Visited ~a~%;;;; Summaries ~a~%;;;; Old ~a~%"
		    (term-op-count term) total summaries old)
	    r)

	  (visit term))
      
      (mlet* (((count labels tags) (visit term) (declare (ignore count))))

	     (summary-labels-tags term labels tags)

	     term)))
  )



;;(define-primitive '|!label| ((tag . token)) (term))
;;(define-primitive '|!tag| ((tag . token | tag)) (term))

(defconstant *ilabel* '|!label|)
(defconstant *itag* '|!tag|)


(defun real-ilabel-term-p (term)
  (and (eql (id-of-term term) *ilabel*)
       (forall-p #'(lambda (p)
		     (and (token-parameter-p p)
			  (real-parameter-value-p (value-of-parameter p) *token-type*)))
		 (parameters-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (and bound-terms
	      (null (cdr bound-terms))
	      (null (bindings-of-bound-term (car bound-terms)))))))

(defun real-itag-term-p (term)
  (and (eql (id-of-term term) *itag*)
       (forall-p #'(lambda (p)
		     (and (or (token-parameter-p p)
			      (tag-parameter-p p))
			  (real-parameter-value-p (value-of-parameter p)
						  (type-of-parameter p))))
		 (parameters-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (and bound-terms
	      (null (cdr bound-terms))
	      (null (bindings-of-bound-term (car bound-terms)))))))


(defun term-of-itags-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))


(defun ilabel-term (label term)
  ;;(break "ilt")
  (instantiate-term (instantiate-operator *ilabel*
					  (list (instantiate-parameter-r label *token-type*)))
		    (list (instantiate-bound-term term))))

(defun copy-term-labels (src dest &optional extra)
  (mlet* (((term labels tags) (decode-dtree-tags src) (declare (ignore term tags)))
	  ((dterm dlabels dtags) (decode-dtree-tags dest) (declare (ignore dtags))))

	 (encode-dtree-tags dterm
			    (union labels
				   (if extra
				       (union dlabels extra)
				       dlabels))
				   
			    nil)))


(defun labels-of-term (term)
  (mlet* (((term labels tags) (decode-dtree-tags term) (declare (ignore term tags))))

	 labels))




(defun encode-dtree-tags (term labels tags)
  (when (member 'point tags) (break "edt"))
  ;;(when (member 'point labels) (break "edtl"))

  (let ((itag (if tags
		  (instantiate-term (instantiate-operator *itag*
							  (mapcar #'(lambda (tag)
								      (instantiate-parameter-r
								       tag
								       (if (symbol-package tag)
									   *token-type*
									   *tag-type*)))
								  tags))
				    (list (instantiate-bound-term term)))
		  term)))

    (if labels
	(instantiate-term (instantiate-operator *ilabel*
						(mapcar #'(lambda (label)
							    (instantiate-parameter-r label *token-type*))
							labels))
			  (list (instantiate-bound-term itag)))
	itag)))


(defun decode-dtree-tags (term)
  (if (or (real-ilabel-term-p term)
	  (real-itag-term-p term)
	  )

      (let ((labels nil)
	    (tags nil))
	(labels
	    ((visit (term)
	       (cond
		 ((real-ilabel-term-p term)
		  (dolist (p (parameters-of-term term))
		    (push (value-of-parameter p) labels))
		  (visit (term-of-itags-term term)))
		 ((real-itag-term-p term)
		  (dolist (p (parameters-of-term term))
		    (push (value-of-parameter p) tags))
		  (visit (term-of-itags-term term)))
		 (t term))))
      
	  (values (visit term) labels tags)))
      term))



(defun term-from-dtree-tags-term (term)
  (cond
    ((real-ilabel-term-p term)
     (term-from-dtree-tags-term (term-of-itags-term term)))
    ((real-itag-term-p term)
     (term-from-dtree-tags-term (term-of-itags-term term)))
    (t term)))

(defun term-of-maybe-itag-term (term)
  (term-from-dtree-tags-term term))
  
(defun tag-member-of-dtree-tags-term-p (term tag)
  (cond
    ((real-ilabel-term-p term)
     (tag-member-of-dtree-tags-term-p (term-of-itags-term term) tag))
    ((real-itag-term-p term)
     (and (member tag (parameters-of-term term) :key #'value-of-parameter-f)
	  t))
    (t nil)))

(defun label-member-of-dtree-tags-term-p (term label)
  (cond
    ((real-ilabel-term-p term)
     (and (member label (parameters-of-term term) :key #'value-of-parameter-f)
	  t))
    ((real-itag-term-p term)
     (label-member-of-dtree-tags-term-p (term-of-itags-term term) label))
    (t nil)))


(defun edit-equal-terms-p (a b)
  ;;(setf -a a -b b) (break "eetp")
  (equal-terms-with-transparencies-p a b
				     #'term-from-dtree-tags-term))

  



(defvar *character-label-map* nil)
      

(defun inform-character-label-map (maps)
  (setf *character-label-map*
	(mapcar #'(lambda (map)
		    (cons (first map) (second map)))
		maps)))


;; should take formats arg??
(defun character-label-map-lookup (context local format liveness)
  (map-labels *character-label-map* context local format liveness))







;;;;	string server: aids in management of temporary labels or tags.
;;;;	
;;;;	generates strings of form : str_s-<i>
;;;;	
;;;;	<i> is string representation of an integer.
;;;;	Each time a string is used as a 
;;;;	
;;;;	
;;;;	








;;;;	
;;;;	Explode/Implode
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	



(define-primitive |!term| () (opid parameters subterms))
(define-primitive |!subterm| () (bindings term))
(define-primitive |!binding| ((v . variable)))
(define-primitive |!binding_cons| () (car cdr))
(define-primitive |!subterm_cons| () (car cdr))
(define-primitive |!parm_cons| () (car cdr))
(define-primitive |!opid| ((t . id)))
(define-primitive |!time| ((time . utime)))
(define-primitive |!string| ((s . string)))
(define-primitive |!quote| ((q . id)))
(define-primitive |!level_expression| ((l . expression)))
(defconstant *iparameter-list* '|!parameter_list|)

  

;;;;	
;;;;	term-walk-dce (<cond-expr{floor}> <cond-expr{permute}> <closure{permute}> <term>)
;;;;	  : <term>
;;;;	
;;;;	if floor or permute 
;;;;	   then if permute
;;;;		     then r = call permutes
;;;;			  if floor r  then stop else continue
;;;;		     else stop
;;;;	

(defun term-walk-dce (floor-ce perm-ce permute term)
  (let ((walk-ce (new-or-ce floor-ce perm-ce)))
    (term-walk-d term
		 #'(lambda (term)
		     ;;(setf -dceterm term) (break "twd1")
		     (test-condition-expression walk-ce 'term term))
		 #'(lambda (term cont)
		     ;;(setf -dceterm term -cont cont) (break "twd2")
		     (if (test-condition-expression perm-ce 'term term)
			 (let ((nterm (funcall permute term)))
			   (if (test-condition-expression floor-ce 'term nterm)
			       nterm
			       ;; if same arg term then will loop.
			       (maybe-instantiate-term nterm
						       (operator-of-term nterm)
						       (mapcar #'(lambda (bt)
								   (maybe-instantiate-bound-term
								    bt
								    (bindings-of-bound-term bt)
								    (funcall cont (term-of-bound-term bt))))
							       (bound-terms-of-term nterm))
						       )))
			 term))) ))


;; not explode.
(defvar *explode-scaffold-floor-ce*
  (string-to-cond-expr "!$explode"))

;; if tagged explode removes tags.
;; really needs to be an inductive form. this allow intervening non-tagged and non-explode terms.
;; could add descendent(ancestor)-path such that condition must be true on some path
;; but that is very specific. induction shouldn't be too difficult or at least enough induction to
;; satisfy this need.
(defvar *explode-scaffold-permute-ce*
  ;; but does not catch mutiple layers of labels.
  (string-to-cond-expr "<(&(&(tree tag) *(tree 1 $explode)))"))

(setf *my-ce*
  ;; but does not catch mutiple layers of labels.
  ;;(string-to-cond-expr "<(*(true 1 $explode))")
      (string-to-cond-expr "$tag")
  )

;; may go to far ie if exploded imbedded in exploded,
;; this will inappropriately strip imbedded.
;; strip tags if tagged explode and continue.
;; stop if
;;  - not tagged and not explode
;;  - tagged and not explode
;; permute and continue if
;;  - tagged and explode
;; continue if explode.

(defun clean-explode-scaffold (term)
  (term-walk-dce *explode-scaffold-floor-ce*
		 *explode-scaffold-permute-ce*
		 #'term-from-dtree-tags-term
		 term))


(defun explode-bound-term (b)
  (setf -isubterm
  (isubterm-term
   (map-list-to-ilist (bindings-of-bound-term b)
		       (ibinding-nil-term)
		       #'(lambda (v)
			   (ibinding-term v)))
   (term-of-bound-term b)))
)

(defun explode-parameter (p)
  (case (type-id-of-parameter p)
    (|token|	(instantiate-term (instantiate-operator *itoken* (list p))))
    (|oid|	(instantiate-term (instantiate-operator *ioid* (list p))))
    (|string|	(instantiate-term (instantiate-operator *istring* (list p))))
    (|variable|	(instantiate-term (instantiate-operator *ivariable* (list p))))
    (|natural|	(instantiate-term (instantiate-operator *inatural* (list p))))
    (|bool|	(instantiate-term (instantiate-operator *ibool* (list p))))
    (|time|	(instantiate-term (instantiate-operator *itime* (list p))))
    (|quote|	(instantiate-term (instantiate-operator *iquote* (list p))))
    (|level-expression|	(instantiate-term (instantiate-operator *ilevel-expression* (list p))))
    (|parameter-list| (if (real-parameter-p p)
			  (instantiate-term
			   (instantiate-operator *iparameter-list* nil)
			   (list (instantiate-bound-term
				  (map-list-to-ilist (value-of-parameter p)
						      (iparm-nil-term)
						      #'explode-parameter))))
			  
			  (instantiate-term
			   (instantiate-operator *iparameter-list*
						 (list p)))))
    (otherwise	(instantiate-term
		 (instantiate-operator (intern-system (concatenate 'string
								  "!"
								  (string
								   (type-id-of-parameter p))))
				       (list p))))))

(defun explode-term (term)

  (let ((term (term-from-dtree-tags-term term)))

    (iterm-term

     (iopid-term (id-of-term term))
	 
     (map-list-to-ilist (parameters-of-term term)
			 (iparm-nil-term)
			 #'explode-parameter)
	 
     (map-list-to-ilist (bound-terms-of-term term)
			 (isubterm-nil-term)
			 #'explode-bound-term))))



(defun implode-bound-term (term)

  (unless (isubterm-term-p term)
    (raise-error (error-message '(implode term !subterm) term)))

  (instantiate-bound-term

   (term-of-isubterm-term term)

   (map-isexpr-to-list (bindings-of-isubterm-term term)
		       (ibinding-cons-op)
		       #'(lambda (term)
			   (unless (ibinding-term-p term)
			     (raise-error (error-message '(implode term !binding) term)))

			   (variable-of-ibinding-term term)))))

(defun implode-parameter (term)
  (let ((term (term-from-dtree-tags-term term)))
    (let ((parms (parameters-of-term term))
	  (bts (bound-terms-of-term term)))

      (if (eql *iparameter-list* (id-of-term term))

	  (cond
	    ;; parameter list meta parameter
	    ((and (null bts)
		  (null (cdr parms))
		  (parameter-list-parameter-p (car parms)))

	     (car parms))

	    ((and (null parms)
		  bts
		  (null (cdr bts)))
	     (parameter-list-parameter (map-isexpr-to-list (term-of-bound-term (car bts))
							   (iparm-cons-op)
							   #'implode-parameter)))

	    (t (raise-error (error-message '(implode parameter-list) term))))

      (if (and parms (null (cdr parms)) (null bts))
	  (car parms)
	  (raise-error (error-message '(implode parameter) term)))))))
  


(defun implode-term (term)

  ;; (setf -term term) (break "it")
  ;; if implode term is not working, check that the iterm abstraction definition is active

  (let ((term (clean-explode-scaffold term)))

    (unless (and (iterm-term-p term)
		 (iopid-term-p (opid-of-iterm-term term)))
      (raise-error (error-message '(implode term !term) term)))

    ;; need to filter itags off of !parm-cons !subterm-cons and !binding_cons

    (instantiate-term

     (instantiate-operator (id-of-iopid-term (opid-of-iterm-term term))
			   (map-isexpr-to-list (parameters-of-iterm-term term)
					       (iparm-cons-op)
					       #'implode-parameter))

     (map-isexpr-to-list (subterms-of-iterm-term term)
			 (isubterm-cons-op)
			 #'implode-bound-term))))

;;;;
;;;;	layout wrappers : (<prefix> . <suffix>)
;;;;
;;;;	<prefix> and <suffix> are arrays of non-child formats.
;;;;	or a single non-child format.

(defun prefix-of-layout-wrapper (w) (car w))
(defun suffix-of-layout-wrapper (w) (cdr w))

(defvar *layout-abstraction-meta-wrapper*
  (cons (new-text-format "$")
	nil))

(defvar *layout-display-meta-wrapper*
  (cons (new-text-format "<")
	(new-text-format ">")))

(defvar *layout-slot-wrapper*
  (cons (new-text-format "[")
	(new-text-format "]")))

;; there is no need for these to be arrays, but it is possible more
;; formats will be added later.
(defvar *layout-error-wrapper*
  (cons (make-array 1 :initial-contents (list (new-text-format "Error: ->")))
	(make-array 1 :initial-contents (list (new-text-format "<-")))))

(defun layout-meta-wrapper (p type)
  (declare (ignore p))
  (if (eql type 'abstraction)
      *layout-abstraction-meta-wrapper*
      *layout-display-meta-wrapper*))

(defun layout-parameter-slot-wrapper (p)
  (declare (ignore p))
  *layout-slot-wrapper*)

(defun layout-term-slot-wrapper (dtree)
  (declare (ignore dtree))
  *layout-slot-wrapper*)

(defun layout-error-wrapper (p)
  (declare (ignore p))
  *layout-error-wrapper*)




;;;;	modified-q	: nil | local | remote | both 
;;;;	
;;;;	  view vobject has cached library term.
;;;;	    - transaction touch causes update.
;;;;	        * if mod-q of view is nil then becomes remote.
;;;;	        * if mod-q of view is local then becomes both.
;;;;	        * if mod-q of view is remote or both then unchanged.
;;;;	    - edit modifies dtree version of term:
;;;;	        * if mod-q of view is nil then becomes local.
;;;;	        * if mod-q of view is remote then becomes both.
;;;;	        * if mod-q of view is local or both then unchanged.
;;;;	
;;;;	(m-x)mod-check 
;;;;	  * tis possible that edit has modified term but then remodified or undone to match lib.
;;;;	    in that case this forces eq test on terms to see if modified.
;;;;	    need to worry about tags affecting equality?
;;;;	 
;;;;	
;;;;	Activation status :
;;;;	- inactive	:
;;;;	+ active	:
;;;;	* hyper-active	:
;;;;	
;;;;	Mod status:
;;;;	  unmodified.
;;;;	+ local
;;;;	- remote
;;;;	* both
;;;;	




(defun new-view-titles (v)
  ;; status
  (without-dependencies
   (let ((oid (oid-of-view v)))
     (when (and oid (not (dummy-object-id-p oid)))
       (let ((kind (kind-of-ostate oid))
	     (active-p (active-of-ostate oid))
	     (name (name-property-of-ostate oid))
	     (modq (view-flag-modified-q v))
	     )

	 ;;(setf -a kind -b active-p -c name -d modq) (break "nvt")

	 ;; view-modified : not -  , local - +, remote - -, both *.
	 (cons
	  (format-string "~a~a ~a: ~a"
			 (if (not active-p)
			     "-"
			     (if (or (edit-indirect-oid-p oid)
				     (edit-proof-oid-p oid))
				 "*"
				 "+" ))
			 (case modq
			   (both "*") (remote "-") (local "+") (otherwise " "))
			 (pad-string (string kind) 4)
			 (or name "Unnamed"))
	  (or (string name) "Unnamed")))))))


(defun name-of-environment (env)
  (let ((a (last (address-of-environment env) 2)))
    (format-string "~a.~a" (car a) (cadr a))))


(defun view-set-window-title (v)

  (let ((titles (titles-of-view v)))

    (let ((envname (name-of-environment (current-environment))))
      (when (view-window-p v)
	(view-flag-set-title-present-required v t)
	(xwin-set-window-title (window-of-view v)
			       (concatenate 'string (car titles) " @" envname)
			       (concatenate 'string (cdr titles) " @" envname))))
    ))


(defun view-modify-window-title (v s)

  (let ((titles (titles-of-view v)))
  ;;(setf tt titles) (break)
      (when (view-window-p v)
	(view-flag-set-title-present-required v t)
	;; lal, want to mod view titles as well.
	(modify-window-title-bar (window-of-view v) 0 (concatenate 'string (car titles) s " @" (name-of-environment (current-environment))) t))))

(defunml (|modify_view_title| (v))
    (view -> unit)
  (view-modify-window-title v " main")
  ;;(forall others (view-modify-window-title v " backup")
  )

;; probably only works if set prior to opening window.
(defunml (|set_view_geo| (geo v))
    ((int list) -> (view -> unit))

  (let ((vobj (object-of-view v)))
    (setf (vobject-geo vobj) geo)))
  

(defun set-view-title (v newtitles)
  (setf (view-state-titles v) newtitles))


(defun view-refresh-title (v &optional new-titles)

  ;; set title.
  (let ((oldtitles (titles-of-view v))
	(newtitles (or new-titles (new-view-titles v))))

    ;;(setf -o oldtitles -n newtitles) (break "vrt")
    (when (and new-titles (or (null oldtitles) (not (string= (car oldtitles) (car newtitles)))))
      (set-view-title v newtitles)
      (view-set-window-title v))))

(defunml (|set_view_title| (s v))
    (string -> (view -> unit))

  (view-refresh-title v (cons s s))
  )



;; maybe should be lazy. ie set bit then let view-present or some such check bit
;; and call refresh.

;; may need to allow for extensions. maybe view would be better as class.
;; then edit-state would be subclass.
(defun view-touched (v)

  ;; update vobject. save currently goes direct to lib.
  ;; we can detect mod here. update vobject and reset view-modified-p appropriately.
  ;; if asynch update (ie term from lib does not match edit term) then need to reflect that.
  ;; possibly save should go through view to however if fails then view needs to recover. This
  ;; way visible only if save succeeds.

  ;;(setf -v v) (break "vt")

  (let ((oid (oid-of-view v)))

    (cond
      ((edit-indirect-oid-p oid) (edit-dynamic-refresh v))
      ((edit-proof-oid-p oid)
       ;; proof-editor expects to handle on its own.
       ;;(edit-proof-refresh v)
       )
      (t (view-refresh-object v)))

    (view-refresh-title v)

    (view-flag-set-touched v nil)
    ))









(defunml (|object_state| (oid))
  (object_id -> term)

  (or (lookup-ostate oid)
      (raise-error (oid-error-message (list oid) '(|ObjectState| not)))))


(defunml (|name_property| (oid))
  (object_id -> tok)

  (or (name-property-of-ostate oid)
      (raise-error (oid-error-message (list oid) '(|ObjectState| property name not)))))


(defunml (|object_state_property| (prop oid))
  (tok -> (object_id -> term))

  (or (property-of-ostate prop oid)
      (raise-error (oid-error-message (list oid) '(|ObjectState| property not) prop))))

(defunml (|object_state_kind| (oid))
    (object_id -> tok)

  (or (kind-of-ostate oid)
      (raise-error (oid-error-message (list oid) '(|ObjectState| kind not)))))

(defunml (|object_state_active| (oid))
    (object_id -> bool)

  (active-of-ostate-r oid))


(defunml (|property_of_ostate| (name oid))
    (tok -> (object_id -> term))

  (or (property-of-ostate name oid)
      (raise-error (oid-error-message (list oid) '(ml ostates property not)))))

(defunml (|ostate_active_p| (oid))
    (object_id -> bool)

  (active-of-ostate oid))

(defunml (|description_of_ostate| (oid))
    (object_id -> term)

  (or (description-of-ostate oid)
      (raise-error (oid-error-message (list oid) '(description object_state not)))))

