%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%
%[
*****************************************************************************
*****************************************************************************
NEW-UTILITIES.ML
*****************************************************************************
*****************************************************************************
]%

%[
*****************************************************************************
Display Functions
*****************************************************************************
Defined in Lisp. 

 display_message : string -> unit
 display_string : string -> unit
]%

%let disp_newline (():unit) = display_string (tok_to_string newline) ;;%
let display_line str = display_message str ;;

let term_to_print_strings_with_suppression ce dfs_to_suppress t n = 
  pp_divide_into_lines 
     (term_to_print_string_with_suppression ce t n dfs_to_suppress) (2*n)
;;

%let term_to_print_strings = term_to_print_strings_with_suppression [] ;;%
let term_to_print_strings ce = term_to_print_strings_with_suppression ce [] ;;



%[
-----------------------------------------------------------------------------
Examining proof-scripts.
-----------------------------------------------------------------------------
]%

% name#kind#status # oidtree list %
absrectype oidtree =
  (tok # tok # tok) # ((oidtree list) + term)
  
  with
    make_oidtree stuff = abs_oidtree stuff
    and oidtree_to_toks ot   = fst (rep_oidtree ot) ? failwith `oidtree_to_toks`
    and oidtree_to_tree ot = outl (snd (rep_oidtree ot)) ? failwith `oidtree_to_tree`
    and oidtree_to_source ot = outr (snd (rep_oidtree ot)) ? failwith `oidtree_to_source`
 
;;

let mk_oidtree name kind status substance children =
  if (kind = `DIR`) or (kind = `GRP`) then make_oidtree ((name, kind, status), (inl children)) %DIR has kind TERM??%
  else make_oidtree ((name, kind, status), (inr substance))
;;

let get_oidtree_ap  = null_ap (itext_term "directory_object_tree  ");;
let get_oidtree oid = lib_eval_to_term (oid_ap get_oidtree_ap oid);;

let get_oidtree_short_ap  = null_ap (itext_term "directory_object_tree_short  ");;
let get_oidtree_short oid = lib_eval_to_term (oid_ap get_oidtree_short_ap oid);;

let get_object_tree_ap  = null_ap (itext_term "object_tree  ");;
let get_object_tree oid = lib_eval_to_term (oid_ap get_object_tree_ap oid);;



