
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;;;


(defvar *lisp-intermediate-stream*)

#|
(defunml (|compile| (name prflag))
	  (token -> (bool -> void))
	  
  (let ((%f 'compile))
    (let* ((ml-file (make-ml-filename name :ml))
	   (lisp-file (make-ml-filename name :lisp))
	   (bin-file (make-ml-filename name :bin))
	   (error-occured t))
      (when (null (probe-file ml-file))
	    (raise-error (error-message '(file not-found) name)))
      ;;(msg-failwith 'compile ml-file '|ml file not found|)

      (tag loaderror
	(with-ml-file-scanner (ml-file)
	  (with-open-file (*lisp-intermediate-stream*
			   lisp-file
			   :direction :output
			   :if-exists :supersede)
	    (write (format-string "(in-package \"~a\")" *system-package-name*)
		   :stream *lisp-intermediate-stream*)
	    ;;(with-tranpt-xref (*lisp-intermediate-stream*))
	    (let (%pt %ty %pr %val %head)
	      (compiloop))
	    (setq error-occured nil)))
	(compile-lisp-file lisp-file)
	(delete-file lisp-file)
	(let ((prflag nil))		; suppress print.
	  (load-lisp-file bin-file)))
      (when error-occured
	(msg-failwith 'compile))
      (when prflag
	(llterpri)(llprins "File ")(llprinc name)(llprins " compiled")(llterpri)))))
|#


(defun compiloop ()
  (tag tmltag
       (tag eoftag
	    (do () (nil nil)
	      (let ((%thisdec nil)
		    (%thistydec nil)
		    (%compfns nil)
		    (*ml-will-eval-p* nil))
		(initlean)
		(okpass 'parse)
		(setq %head (car %pt))
		(let ((proclaim-p (ml-proclaimation-p %pt)))
		  (okpass 'typecheck)
		  (okpass 'translation)
		  (dolist (fn %compfns)
		    ;;(eval fn)
		    ;; pretty should be nil, orelse intermediate lisp files written
		    ;; by KCL may be huge.
		    (terpri *lisp-intermediate-stream*)
		    ;;(setf a fn) (break "lis")
		    (write (fix-uninterned-t fn) :stream *lisp-intermediate-stream*
			   :gensym nil :pretty nil :escape t :level nil :length nil))
		  (let ((execute-form 
			 `(execute ',(if (isdecl) %thisdec %ty) ',%thistydec ',%head ',%pr)))
		    (when proclaim-p
		      (eval execute-form))
		    (updatetypedecs)
		    (terpri *lisp-intermediate-stream*)
		    (write (fix-uninterned-t execute-form)
			   :stream *lisp-intermediate-stream*
			   :gensym nil :pretty nil :escape t :level nil :length nil)
		    ;;(flush-tranpt-xref)
		    )))))))


; Execute a statement and store in the output file if compiling
; For example, the putprops used to store abstract type information
(defun eval-remember (x)
  (if (eql %f 'compile)
      (progn (eval x)
	     (write (fix-uninterned-t x) :stream *lisp-intermediate-stream*
		    :gensym nil :pretty nil :escape t :level nil :length nil))
      (eval x)))


; Execute a compiled ML statement
(defun execute (%ty %thistydec %head %pr)
  (and prflag (top%f) (llterpri))
  (let ((init-time (runtimems))
	(%compfns nil))
    (okpass 'evaluation)
    (let ((final-time (runtimems)))
      (let ((%thisdec (if (isdecl) %ty nil)))
	(updatemldefs)
	(updatetypes))
      (updatevalues)
      (printresults)
      (printtime final-time init-time))))


; Fix up the particularly bad variable T, which is ok while uninterned,
; but has rather specific meanings when read back
(defun fix-uninterned-t (x)
  (subst-if '|rEpLaCeMeNt-for-T|
	    #'(lambda (y) (and (symbolp y) (null (symbol-package y))
			       (string= (symbol-name y) "T")))
	    x))




;;;;	load_system 
;;;;	  : bool{delete} -> bool{force} -> bool{print}
;;;;	     -> string{path} -> ((string{dir} list) # (string{file} list)) list -> unit
;;;;	
;;;;	delete : delete intermediate lisp file.
;;;;	force : force compilation even if no file modifications.
;;;;	print : print ml output during compile.
;;;;	
;;;;	compiles any file for which the binary is older than the source.
;;;;	compiles any file for which the predecessor's bin is newer.
;;;;    places bin files in directories specific to platform.
;;;;
;;;;	An ML file depends on another if the former contains the definition of a
;;;;	function or variable used by the latter. Any dependent file must be
;;;;	compiled after the file depended upon. Load_system loads a sequence of
;;;;	files and compiles if a file in the sequence has a bin date earlier than
;;;;	the immediate predecessor in the sequence.
;;;;	
;;;;	Eg, consider files a - d where b depends on a and c depends on b, etc.
;;;;	load_system [a; b; c; d] could be used to load.
;;;;	(load_system [a; b; c]; load_system [c; d]) would also be ok.
;;;;
;;;;	(load_system [a; b]; load_system [c; d]) would not be ok as the
;;;;	dependency between b and c is not apparent.
;;;;
;;;;	NB: Recursive calls to load_system are not generally effective
;;;;	since a call may not be evaluated if the caller is not
;;;;	recompiled. They are effective for loading but not recompilation.
;;;;
;;;;	Recursive calls to load_system inherit the predecessor at the time of the
;;;;	call but after returning the predecessor is unchanged. In other words a
;;;;	recursive call is not equivalent to inlining.  Thus recursive calls can
;;;;	be used as a method of defining a tree of dependencies rather than a
;;;;	single sequence.  A recursive call can be effected by call to
;;;;	load_system in a file being loaded by load_system.
;;;;	
;;;;	Trees can also be simulated by calling load_system sequentially with
;;;;	non-disjoint sequences. Eg if e depends on c but not on d then
;;;;
;;;;	(load_system [a; b; c]; load_system [c; d]; load_system [c; e])
;;;;	
;;;;	would not cause recompilation of e if only d changed or of d if only e
;;;;	changed. 
;;;;	
;;;;	
;;;;	
;;;;	What if some later file depends on to disjoint sets of precursors :
;;;;	 for exampe e depends on a and b and c and d but a and b and c and d
;;;;	 are disjoint.
;;;;	
;;;;	( load_system [a; b; c; d; e])
;;;;	 is not good since then c and d may be recompiled
;;;;	 unnecessarily if a or b change.
;;;;	
;;;;	( load_system [a; b; e]
;;;;	; load_system [c; d; e])
;;;;	 is not sufficient since e can not be compiled without c and d first being loaded.
;;;;
;;;;	( load_system [a; b]
;;;;	; load_system [c; d]
;;;;	; load_system [b; e]
;;;;	; load_system [c; e]
;;;;	) would be sufficient.
;;;;	Actually, two pre-reqs does not work since if
;;;;     if b causes e to compile and c is recompiles then e is
;;;;	 calling the old c binaries.
;;;;	
;;;;	would be nice to allow arbitrarily complicated trees for files.
;;;;	would be nice to provide tools to allow coders to code arbitrary
;;;;	 load_system's. (load system is that tool?).
;;;;	

;; (<string{bin-name}> . <int{write-date}>) list
(defvar *loaded-bin-dates* nil)

(defun show-bin-dates ()
  (terpri)
  (dolist (f (sort (copy-list *loaded-bin-dates*) #'> :key #'cdr))
    (format t "~a ~a ~%" (datetime-string (cdr f)) (car f))))

;; date of last file loaded is dynamic history of make_system.
(defvar *predecessor-bin-date* nil)

(defun find-loaded-bin-date (bin-file)
  (cdr (assoc bin-file *loaded-bin-dates* :test #'string=)))

(defun load-bin-file (bin-file &optional forcep)

  (let ((bin-date (file-write-date bin-file))
	(loaded-bin-date nil))
    (if (or forcep
	    (progn
	      (setf loaded-bin-date (find-loaded-bin-date bin-file))
	      (or (null loaded-bin-date)
		  (> bin-date loaded-bin-date))))
	(progn
	  (format t "Loading bin ~a.~%" bin-file)

	  (setf *loaded-bin-dates* (acons bin-file
					  bin-date
					  *loaded-bin-dates*))
	  (load-lisp-file bin-file)
	  (setf *predecessor-bin-date* bin-date)
	  t)
	(progn
	  (format t "Not loading bin ~a.~%" bin-file)
	  (setf *predecessor-bin-date* loaded-bin-date)
	  nil))))


;; src date embedded in bin file at compile time. At bin load *ml-src-file-date* will
;; be set.
(defvar *ml-src-file-date*)
(defvar *ml-bin-file-date*)
(defvar *ml-filename*)
(defvar *ml-file-description-term*)

(defmacro with-ml-file ((src-name) &body body)
  `(let ((*ml-filename* ,src-name)
	 (*ml-src-file-date* nil)
	 (*ml-bin-file-date* nil)
	 (*ml-file-description-term* nil))
    ,@body))

(defun set-ml-src-file-date (d)
  (when (boundp '*ml-src-file-date*)
    (setf *ml-src-file-date* d)))


(defun get-ml-file-description-term ()
  (or (when (boundp '*ml-file-description-term*)
	(or *ml-file-description-term*
	    (setf *ml-file-description-term*
		  (iml-file-description-term (or *ml-filename* "unknown")
					     (or *ml-src-file-date* 0)
					     (or *ml-bin-file-date* 0)))))
      (ivoid-term)))

(defun write-ml-src-file-date-expression (stream)
  (when (boundp '*ml-src-file-date*)
    (write `(set-ml-src-file-date ,*ml-src-file-date*)
	   :stream stream
	   :gensym nil :pretty nil :escape t :level nil :length nil)))
    
(defun load-ml-bin-file-aux (bin-file forcep)
  (with-ml-definitions (nil)
    (load-bin-file bin-file forcep)
    (dolist (d (reverse (get-current-ml-definitions)))
      (set-mldef-source (cdr d) (get-ml-file-description-term))
      (add-global-mldef (cdr d))) ))

(defun load-ml-bin-file (bin-file printp)

  (let ((prflag printp)			; prflag is special
	(errorp t)
	(loadp nil))

    (tag loaderror
	 (setf loadp
	       (load-ml-bin-file-aux bin-file nil))

	 (setf errorp nil))

    (when errorp
      (raise-error (error-message '(load file) bin-file)))
    
    (when printp
      (llterpri)
      (llprins "File ")
      (llprinc bin-file)
      (if loadp
	  (llprins " loaded.")
	  (llprins " not loaded."))
      (llterpri))))

(defun compile-ml-src-file (src-file lisp-file bin-file deletep printp)
  (let ((prflag printp)
	(errorp t)
	(%f 'compile))

    (format t "Compiling ML ~a.~%" src-file)
    ;;(file-write-date src-file)
    
    (tag loaderror
	 (with-ml-file-scanner (src-file)
	   (with-open-file (*lisp-intermediate-stream*
			    lisp-file
			    :direction :output
			    :if-exists :supersede)
	     (write-string (format-string "(in-package \"~a\")" *system-package-name*)
			   *lisp-intermediate-stream*)
	     (write-ml-src-file-date-expression *lisp-intermediate-stream*)
	     ;;(with-tranpt-xref (*lisp-intermediate-stream*))
	     (let (%pt %ty %pr %val %head)
	       (with-ml-definitions (nil)
		 (compiloop)
		 ;;(break "compiloop")
		 ))

	     (setq errorp nil))
	   
	   (compile-lisp-file lisp-file :output-file bin-file)

	   (when (and t deletep)
	     (delete-file lisp-file))

	   (let ((prflag nil))		; suppress print.
	     (setf *ml-bin-file-date* (file-write-date bin-file))
	     (load-ml-bin-file-aux bin-file t))

	   (setf errorp nil)))

    (when errorp
      (raise-error (error-message '(compile file) src-file)))

    (when printp
      (llterpri)
      (llprins "File ")
      (llprinc src-file)
      (llprins " compiled.")
      (llterpri))))


;; 9/2003 changed bin path to be relative to system bin path instead of src path.
(defunml (|load_system| (deletep forcep printp path filenames))
    (bool -> (bool -> (bool -> ((string list) -> ((((string list) |#| (string list)) list) -> unit)))))

  (format t "~%~%    CURRENT TIME : ~a.~%~%~%" (datetime-string (get-universal-time)))
  ;;(setf -f filenames) (break "ls")

  (let ((bin-file-extension (bin-file-extension))
	(bin-path (system-bin-path-list))
	(*predecessor-bin-date* *predecessor-bin-date*)
	(compile-p forcep))

    (dolist (dir filenames)
      (let* ((path-suffix (car dir))
	     (bin-path-suffix (append path-suffix bin-path)))
	 
	(dolist (fname (cdr dir))
	  (let ((src-file (complete-system-path (append path path-suffix) fname "ml"))
		(bin-file (complete-system-path (cons "binaries" bin-path)
						fname
						bin-file-extension)))

	    (format t "~%Src: ~a~%Bin: ~a~%Probe : ~a~%Write Date ~a~%"
		    src-file bin-file  (probe-file bin-file)
		    (when (probe-file bin-file)	(file-write-date bin-file)))

	    (when (null (probe-file src-file))
	      ;;(setf -src-file src-file -path path -fname fname) (break)
	      (raise-error (error-message '(file not-found)
					  (list src-file path path-suffix fname))))

	    (let ((src-date (file-write-date src-file))
		  (bin-date (unless compile-p
			      (when (probe-file bin-file)
				(file-write-date bin-file)))))
	      
	      (with-ml-file (src-file)
		(if (or compile-p
		      
			;; bin file does not exist?
			(null bin-date)

			;; > -> newer
			(or
			 ;; bin file older than source file?
			 (> src-date bin-date)

			 ;; bin file older than predecessor?
			 (and *predecessor-bin-date*
			      (> *predecessor-bin-date* bin-date))))
			 
		    
		    ;; compile
		    (progn
		      (when (boundp '*ml-src-file-date*)
			(setf *ml-src-file-date* src-date))

		      (format t "~%Compile start : ~a" (get-universal-time))
		      ;;(compile-lisp-file
		      ;; "/home/fdl/sys/refiners/nuprl5/tactics/standard/sup-inf.lisp"
		      ;; :output-file "/home/fdl/sys/binaries/linux86/cmucl18e/sup-inf.fasl")
		      (compile-ml-src-file src-file
					   (complete-system-path (append path path-suffix) fname "lisp")
					   ;;(prl-make-filename path path-suffix fname "lisp")
					   bin-file deletep printp)
		      
		      (format t "~%Compile finish: ~a" (get-universal-time))
		      (format t "~%Sleep start: ~a ~a ODD~a" (get-universal-time) (file-write-date bin-file)
			      (if (and (< (file-write-date bin-file) (get-universal-time))
				       (> (- (get-universal-time) (file-write-date bin-file)) 2))
				  "YES"
				  "NO"))
		      (sleep 1)
		      (format t "~%Sleep done : ~a ~a" (get-universal-time) (file-write-date bin-file))
		      )


		    (progn
		      (when (boundp '*ml-bin-file-date*)
			(setf *ml-bin-file-date* bin-date))

		      ;; load existing binary if new than current loaded.
		      (load-ml-bin-file bin-file printp))))))))))
  nil)
	    

