
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;**************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************

; F-lis.lisp      Original code: lis (lisp 1.6) part of Edinburgh LCF
;                 by M. Gordon, R. Milner and C. Wadsworth   (1978)
;                 Transported by G. Huet in Maclisp on Multics, Fall 1981
;
; V2.2: breakout & tag instead of err & errset
; V3.2: cleaning-up of functions

#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      ml-mem ml-flat ml-map ml-exists ml-forall succeeds
	      )))



;;;
;;; RLE NAP might be able to remove some (ap and replace
;;;  with (funcall. Need a macro which access funcs etc.
;;;

(dml |length| 1 length ((%a list) -> int) )

(dml |rev| 1 reverse ((%a list) -> (%a list)))

(defunml (|mem| (a l) :error-wrap-p nil) (%a -> ((%a list) -> bool)) (member a l))

(defunml (|flat| (ll) :error-wrap-p nil)
	  (((%a list) list)->(%a list))
  ;; TODO could be more efficient ?
  ;; also maybe redefine flatten in general.ml = flat.
  (apply (function append) ll))

(defunml (|map| (f l) :error-wrap-p nil)
	  ((%a -> %b) -> ((%a list) -> (%b list)))
  (mapcar #'(lambda (x) (ap f x)) l))

(defunml (|exists| (p l) :error-wrap-p nil)
	  ((%a -> bool) -> ((%a list) -> bool))
  (block found
    (dolist (item l)
      (if (ap p item) (return-from found t)))
    nil))

(defunml (|forall| (p l) :error-wrap-p nil)
    	  ((%a -> bool) -> ((%a list) -> bool))
  (block found
    (dolist (item l)
      (ifn (ap p item) (return-from found nil)))
    t))


(defunml (|rev_itlist| (f l x) :error-wrap-p nil) 
	  ((%a -> (%b -> %b)) -> ((%a list) -> (%b -> %b)))
  (dolist (item l)
    (setq x (ap f item x))
    )
  x)

;(defunml (|rev_itlist| (f l x) :error-wrap-p nil) 
;	  ((%a -> (%b -> %b)) -> ((%a list) -> (%b -> %b)))
;  (dolist (item l)
;    (setq x (ap f x item)))
;  x)

(defunml (|find| (p l) :error-wrap-p nil)
	  ((%a -> bool) -> ((%a list) -> %a))
 (block found
   (dolist (item l)
     (if (ap p item) (return-from found item)))
   (breakout evaluation '|find|)))

(defunml (|tryfind| (f l) :error-wrap-p nil)
	  ((%a -> %b) -> ((%a list) -> %b))
  (block found
    (dolist (item l)
      (tag evaluation (return-from found (ap f item))))
    (breakout evaluation 'tryfind)))

(defunml (|filter| (p l) :error-wrap-p nil)
	  ((%a -> bool) -> ((%a list) -> (%a list)))
  (let ((r nil))
    (dolist (item l)
      (if (ap p item) (push item r)))
    (nreverse r)))

(defun succeeds (f x)
  (block OK
    (tag evaluation (ap f x) (return-from OK t))
    nil))

(defunml (|mapfilter| (f l) :error-wrap-p nil)
	  ((%a -> %b) -> ((%a list) -> (%b list)))
  (let ((r nil))
    (dolist (item l)
      (tag evaluation (push (ap f item) r)))
    (nreverse r)))
