
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;**************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************

; F-tml.lisp      Original code: tml (lisp 1.6) part of Edinburgh LCF
;                 by M. Gordon, R. Milner and C. Wadsworth   (1978)
;                 Transported by G. Huet in Maclisp on Multics, Fall 1981
;
; V2.1 : begin and end renamed as ml-begin and ml-end
; V2.2 : errset and err replaced with tag and breakout
;        top1, ctrlgfn no more used
; V2.3 : compiler added  July 82   GH
; V3.1 : optimization of lisp code L. Paulson
; V3.2 : compatibility VAX-Unix/Multics
; V4.2 : message functions gone
; to do:  in load/compile, close input file in a clean way
;         put infilepop where it will always be executed, despite errors
;
; 2/87  Changed to work with the new compiler.  MB


#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      top%f istmlop isdefty isdecl typechpt tranpt extend-env ml-timer
	      )))


(eval-when (compile load)
  (proclaim '(special %f %dev %pt %ty %pr %val %compfns
	      %sections %dump %emt %temt
	      %p %lb %e tenv
	      %compfile %head %time %debug
	      ;; Globals
	      initial%load  %timestamp  %symcount
	      msgflag initsection nosecname nill
	      )))



;  Uses Manifests:  eof  [iox/din]
;                   nullty  [typeml]
;                   nill  [tran]

;  Sets Manifests:  initsection, initenv, nosecname, lastvalname

;  Uses Globals:  %f  [iox/din]
;                 %emt, %temt  [typeml]
;                 prflag  [System load]
;                 ibase, base
; Globals:  %pt, %ty, %pr, %val  [in top1/okpass]
;                 %sections, %dump

;  Specials:  %p, %e, %thisdec, %thistydec, tenv



(when initial%load                          ;  Globals
 (setq %f nil)
 (setq %sections nil)
 (setq %dump nil)
 (setq %time 10000.)                ;NEW
 (setq %compfile nil)               ;NEW
 )


;                  Error and message functions

;;;;                  Top level of ml interpreter

(defun top%f () (member %f '(nil load compile)))  ;top%f

(defun istmlop () (member %head '(mk-begin mk-end)))  ;istmlop

(defun isdefty () (eql %head 'mk-deftype))  ;isdefty

(defun isdecl ()
 (member %head '(mk-let mk-letref mk-letrec mk-abstype mk-absrectype)))  ;isdecl

(defun typechpt () (typecheck %pt))  ;typechpt

(defun tranpt () (let ((%p nil)) (tran %pt)))  ;tranpt  new look

;; defines primitive ml function.
(defmacro funmlcall (closure &rest args)
  `(handle-error 'evaluation
    #'(lambda (err) (raise-error (error-message '(ml ap) err)))
    (ap ,closure ,@args)))

;; ml reverses args at ap so need to reverse args.
(defmacro mlclosure (f numargs)
  (let ((args nil))
    (dotimes (i numargs)
      (push (make-symbol (concatenate 'string "a" (princ-to-string i))) args))
    (let ((ff (gensym)))
      `(let ((,ff ,f)) ; force evaluation of f.
	(make-closure #'(lambda (,@args) (funcall ,ff ,@(reverse args)))
	 ,numargs)))))
  


;; lists defined ml function to lisp
(defmacro defml (name args)

  (let* ((lisp-name (_->- name))
	 (lisp-global (intern (concatenate 'string "*" (string lisp-name) "*")))
	 (mlargs (or args (list nil))))

    `(progn

      (defvar ,lisp-global nil)

      (defun ,(intern lisp-name) (,@args) ; reverse?
	;; catch evaluation breakouts and coerce to error?
	(funmlcall (or ,lisp-global
		       (setf ,lisp-global (ml-text (string ',name))))
		   ,@mlargs)))))


(defun okpass (pass)
 (tag ok        ; prog/return does not work in Franzlisp
   (let ((b (case pass
       (parse (tag parse (setf -pt (setq %pt (parseml0))) (breakout ok t)))
       (typecheck (tag typecheck
                       (setq %ty (typechpt)) (breakout ok t)))
       (translation (tag translation
                         (setq %pr (tranpt)) (breakout ok t)))
       (evaluation (tag evaluation
                        (setq %val (evalpr)) (breakout ok t)))
       (evtmlop (tag evaluation
                     (setq %val (evtmlop %pt)) (breakout ok t)))
       (otherwise (syserror (cons pass '(unknown pass)))))))
    ; Fall through here if pass failed
     (let ((line-no (ml-line-count)))
       (when line-no
	 (llterpri)
	 (llprins (format-string "On line ~a, " line-no))
	 ))
    (llprins pass)(llprins " failed     ")(if b (llprinc b))
    (llterpri)
    (ifn (member %f '(load compile))(breakout tmllooptag %f))
    ; propagate failure if performing load or compile
    (setq %it nil)			 ;to prevent abscope type
;   (putprop lastvalname nil 'mlval)     ;to prevent abscope type
    ;; (setf (get lastvalname 'mltype) nullty) ;problems on automatic ending
    (last-val-reset)
    (breakout loaderror nil))))  ;okpass  ;new look

(defun parseml0 ()
  (let* ((ok nil)
	 (result (tag eoftag
		      (prog1 (parseml 0)
			(setf ok t)))))
    (if ok
	result
	(progn
	  (llprins "Error: Premature end of input during parse. ")
	  (breakout parse nil)))))
      


(defun evalpr ()
  (when  (neq %f 'compile)
    ;; These definitions have already been compiled.
    (dolist (defun-form %compfns)
      ;; Compile any function definitions.  The interpreter appears to exhibit
      ;; exponential behavior on complicated function definitions.
      ;;(setf  a defun-form) (break)
      (compile-lisp-form (second defun-form) (cons 'lambda (cddr defun-form)))))
  (with-system-error ('(ml eval uncaught-error))
    (eval %pr)))


; Top-level entry to ML
; Sets time stamp to allow the generation of symbols unique to this session
; Necessary to avoid conflict when loading ML code
;    compiled in different sessions
(defun tml ()
   (let ((*print-base* 10.)
         (*read-base* 10.))
    (banner)
    (tag eoftag (tag tmltag (tmlloop)))   ;so as to implement exit in ml
;;    (llterpri)(llprins "Back to lisp, folks!")(llterpri) Not that for video
    (finalize-tml)              ; prepare Lisp re-entry (system dependent)
    ))  ;tml newlook

(defvar *ml-will-eval-p* t)

(defvar *global-updater* nil)
(defvar *global-local-updates* nil)

(defmacro with-global-updater ((updater) &body body)
  `(let ((*global-updater* ,updater)
	(*global-local-updates* nil))
    ,@body))
  
;;(defun extend-env (descriptors)
;;  (setf -d descriptors) (break "ee")
;;  (if *global-updater*
;;      (funcall *global-updater* descriptors)
;;      (setf *global-env* (append descriptors *global-env*))))

(defun updatemldefs ()
  (when (and (not %sections) %thisdec)
    (dolist (x (cdr %thisdec))
      (maybe-new-mldef (car x)))))

(defun updatemldesc (a)
  (when a
    ;;(setf -a a ) (break "umd")
    (dolist (desc (eval a))
      (let ((mldef (find-mldef (desc-id desc))))
	(set-mldef-description mldef desc)))))

; Enter bindings in environment.
(defun updatevalues ()
  ;;(break "uv")
  (cond
    ((isdefty))
    ((isdecl)
     ;;(break "updatevalues")
     ;;(extend-env %val)
     (dolist (desc %val)
       (let ((mldef (find-mldef (desc-id desc))))
	 (set-mldef-description mldef desc)
	 (when (is-function desc)
	   (let ((n (name-for-desc desc)))
	     (let ((cl (make-closure (symbol-function n)
				     (ml-function-arity desc))))
	       (set-mldef-closure mldef cl)
	       ;;TODO : find who look's this up and smack'em up the side of the head.
	       ;; but until then proclaim symbol to be special.
	       (proclaim `(special ,n))
	       (setf (symbol-value n) cl))
	 ))) ))
    (t (set-mldef-value *last-val-mldef* %val)
       (set-mldef-type *last-val-mldef* %ty))
    ))

(defun printresults ()
  (cond ((not prflag) (llprins "."))
	((isdefty) (prdefty %thistydec))
	((isdecl) (prlet %val))
	(t (prvalty %val %ty))))  ;printresults


(defun vml-printresults ()
  (cond ((not prflag) (llprins "."))
	((isdefty) (prdefty %thistydec))
	(t (printmty %ty) (pnewline))))


; Print runtime and GC time if either exceeds the threshhold %time
(defun printtime (final-times init-times)       
   (cond 
     (prflag
        (let ((runtime (- (car final-times) (car init-times)))
              (gctime (- (cdr final-times) (cdr init-times))))
          (cond ((> runtime %time)
                 (llprins "Runtime: ")(llprin1 (truncate runtime 10))
                 (llprins " ms")(llterpri)))
          (cond ((> gctime %time)
                 (llprins "GC: ")(llprin1 gctime)
                 (llprins " ms")(llterpri))))))
 )              ; printtime

(defun evtmlop (pt)
  (case (car pt)
    (mk-begin (ml-begin (if (cdr pt) (cadr pt) nosecname)))
    (mk-end
      (ml-end (cond
          ((null (cdr pt)) (if %dump (car %dump)
            (msg-failwith 'end " not in a section")))
          ((assoc (cadr pt) %dump))
          (t (msg-failwith 'end "no section " (cadr pt)))
          )))
    (otherwise (syserror (cons (car pt) '(not a tmlop))))
    ))  ;evtmlop

(defun ml-begin (tok)
  (push (list tok %sections *global-env* %emt %temt %dump) %dump)
  (setq %sections t)
  (cond (prflag (llprins "Section ")(llprinc tok)(llprins " begun")(llterpri)))
  )        ;ml-begin


; Unix -- used Franz Lisp "varstruct" in let
(defun ml-end (x)
  (let ((tok (car x))
        (new-sections (cadr x))
        (new-global-env (caddr x))
        (new-emt (cadddr x))
        (new-temt (car (cddddr x)))
        (new-dump (cadr (cddddr x)))
        (tenv nil))
       (setq tenv new-temt)  ;  for absscopechk
       (ifn (tag typecheck (absscopechk (type-of-mldef *last-val-mldef*)))
          (failwith 'end)) ; prevents result of section of local type
       (setq %sections new-sections)
       (setq *global-env* new-global-env)
       (setq %emt new-emt)
       (setq %temt new-temt)
       (setq %dump new-dump)
       (cond (prflag (llprins "Section ")(llprinc tok)(llprins " ended")(llterpri)))
       ))  ;ml-end

(defunml (|timer| (thresh)) (int -> void)
  (setq %time thresh))

;; lisp from ml disabled for security reasons.
#|
(defunml (|lisp| (str)) (string -> string)
  (errortrap
    '(lambda (errtok) (msg-failwith 'lisp errtok))
    (princ-to-string (eval (with-input-from-string (*standard-input* str)
			     (read))))))
|#

;;;;
;;;; Overwriting load.
;;;;


(defconstant *ml-object-property-names*
  '(ARITY ABSNAME))

(defun get-ml-object-properties (name)
  (mapcar #'(lambda (prop) (get name prop))
	  *ml-object-property-names*))

(defun put-ml-object-properties (name properties)
    (mapc #'(lambda (prop prop-value)
	      (cond ((not (null prop-value))
		     (setf (get name prop) prop-value))))
	  *ml-object-property-names*
	  properties)
    nil)



;;; First do a regular load.  If it is successful, for each object added to the environment (the value
;;; env *global-env*, i.e. typedefs and dml'd objects are not included) overwrite the most recent previous
;;; definition (if it exists) with the newest one.  Return a list of the names of the objects
;;; overwritten.  If the load is not successful, roll back the environment (see above restriction) to
;;; what is was before load was called.  The function is uncurried for historical reasons.
;;;	TODO: 	can it.

(defunml (|overwriting_load| (fname-flag-pair))
     ( (tok |#| bool) -> (tok list) )
  
  ;; the 'absname and 'arity crap needs to be fixed before this is reliable
  (break "overwriting_load ")
  (let* ((fname (car fname-flag-pair))
	 (flag (cdr fname-flag-pair))
	 ;;(starting-properties (get-ML-properties))
         (starting-env *global-env*))
    ;; Load the file normally, rolling things back if the load fails
    (let ((unwindabortflag t))
      (unwind-protect 
	  (progn
	    (cnmf (string fname))	; reversed since ml-load defunml'd
	    (setf unwindabortflag nil))
      (when unwindabortflag
        ;;(remove-ML-properties)
        (setq *global-env* starting-env)
        ;;(put-ML-properties starting-properties)
	)))
    (let* ((number-of-additions (- (length *global-env*) (length starting-env)))
	   (env-additions (subseq *global-env* 0 number-of-additions))	   
	   (overwritten-object-names nil))
      ;; Check that all redefinitions respect types, etc.
      (mapc #'(lambda (p)
		(let ((starting-props (assoc (car p) nil))) ;;starting-properties
		  (when (and (assoc (car p) starting-env)
			     (not (equal (mapcar #'(lambda (prop) (get (car p) prop)) *ML-object-property-names*)
					 (cdr starting-props))))
		    ;;(setf -enva env-additions -se starting-env -p p)
		    (break "owl")
		    ;;(remove-ML-properties)
		    (setq *global-env* starting-env)
		    ;;(put-ML-properties starting-properties)
		    (breakout evaluation '|overwriting_load: new version of object has different type.|))))
	    env-additions)
      (setq *global-env* starting-env)
      ;; For each new item, overwrite the old version, or, if it's new, add it to the current
      ;; environment.
      (mapc #'(lambda (item)
		(let* ((old-item (assoc (car item) starting-env)))
		  (if old-item
		      (progn (setf (third old-item) (symbol-value (third item)))
			     (if (eql (second old-item) 'ML-FUNCTION)
				 (setf (symbol-function (third old-item)) (caar (symbol-value (third item)))))
			     (push (car item) overwritten-object-names))
		      (push item *global-env*))))
	    (reverse env-additions))
      overwritten-object-names)))


