%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
;;;;
;;;;	migrate_nuprl4_object : term -> object_address # object_contents list
;;;;	migrate_and_save_nuprl4_objects : object_address -> terms -> UNIT

;;;;	RLE TODO : should rename objects so that all names have prefix token of thy name. not.
;;;;	RLE TODO : ie boot_begin becomes ``boot begin`` and foo in boot thy becomes
;;;;	RLE TODO : ``boot foo``;;
;;;;	RLE TODO : but then references to objects by proof are wrong!

;;;;	build a tree a'la nuprl-light standard root containing standard theories
;;;;	each member of standard root is a term listing the objects of the theory.
;;;;	also have an algebra theories, actually maybe one theory root with
;;;;	algebra, standard, caldwell, etc.
%


let default_migrate_nuprl4_object install name kind properties data =
 install
   (name, (kind, (data, (term_to_property_list properties))))
 ; ()
;;

let migrate_nuprl4_rule_object install name kind properties data =
 install
  (name, (kind, ((snd (rule_def_fixup data)), (term_to_property_list properties))))
 ; ()
;;


let migrate_nuprl4_thm_object install name properties data =
  let (op, [([],stm); ([],itree)]) = destruct_term data in
    tty_print "migrate_nuprl4_thm_object tttt";	     
    install (name, (`STM`, (stm, ((`DESCRIPTION`, nuprl5_refiner_description_term)
				  . ((`tttt`, itree)
				     . (term_to_property_list properties))))))
    ; ()
;;
%
let fixup_migrate_le_term soid = 
  let found = ref false in 
  let maybe_replace_le_term t = 
  let (text, bts) = destruct_term tac in
  if subterm_p le_term text then 
    (mk_text_term ; found:= true)
  else  in

  let itree = get_property soid `migrate_proof` in
    let (s, (tac, (a, c))) = destruct_itree t in 
    if null c then ()
    else let tac = maybe_replace_le_term tac in 
  
 
  put_property soid `migrate_proof` then

;;

let map_fixup_migrate_le_term soids = 
  map fixup_migrate_le_term soids
;;
%
let migrate_nuprl4_ml_object install name properties data =
  install
      (name, (`CODE`, (data, ((`LANGUAGE`, (itoken_term `ML`))
			   . ((`REDUCE`, (itoken_term `ML`))
			   . ((`DESCRIPTION`, nuprl5_refiner_description_term)
			      . (term_to_property_list properties)))))))
  ; ()
;;

let migrate_nuprl4_lat_object install name properties data =
  install (name, (`PREC`, (data, ((`DESCRIPTION`, nuprl5_edit_description_term)
				  . (term_to_property_list properties)))))
  ; ()
;;

let migrate_nuprl4_disp_object install name properties data =
  install (name, (`DISP`, (data, ((`DESCRIPTION`, nuprl5_edit_description_term)
				  . (term_to_property_list properties)))))
  ; ()
;;

let migrate_nuprl4_object install term =
  let ((id, [n; k]), [([], properties); ([], data)]) = destruct_term term in
   let name = destruct_token_parameter n and
       kind = destruct_token_parameter k in

    if `ABS` = kind
        then default_migrate_nuprl4_object install name kind properties data
    else if `COM` = kind
        then default_migrate_nuprl4_object install name kind properties data
    else if `DISP` = kind
        then migrate_nuprl4_disp_object install name properties data
    else if `LAT` = kind
        then migrate_nuprl4_lat_object install name properties data
    else if `PREC` = kind
        then default_migrate_nuprl4_object install name kind properties data
    else if `RULE` = kind
        then migrate_nuprl4_rule_object install name kind properties data
    else if `ML` = kind
        then migrate_nuprl4_ml_object install name properties data
    else if `THM` = kind
        then migrate_nuprl4_thm_object install name properties data
    else failwith (concat `migrate_object` kind)
;;

%

build theory tree :

(theories (standard <thy> list) (algebra, <thy> list))

<thy> : <prfs> ( <obj> list)
<prfs> : <obj> list
then theory then theory objects.

%

% dir is standard or algebra ... %


let migrate_nuprl4_object_list objlist dir =

 % do not expect proofs any longer %
 letref proofs = []
 and acc = [] in
  let mig_install stuff = 
   (let (name, (type, (term, props))) = stuff in
	   let nprops = ((`NAME`, (itoken_term name)) . props) in
	   let oid =
		(if (lex_equal_terms ivoid_term term)
		     then create_with_properties type nprops
		   else create_with_term type term nprops)
	    in if (type = `PRF`)
		then (proofs := ((name, oid) . proofs))
		else (acc := ((name, oid) . acc))
		) in

 (deactivate dir);
 (map (\term. migrate_nuprl4_object mig_install term)
      objlist);

  % order ? %
  dag_inserts dir (rev acc);

  (if not (proofs = [])
    then let proid = dag_make_named_directory dir `proofs` (tok_to_string `proofs`) in
          dag_inserts proid proofs);

  (activate dir);

 ()
;;


let migrate_nuprl4_objects objsterm dir =
  migrate_nuprl4_object_list
     (map_isexpr_to_term_list icons_op objsterm)
     dir
;;



let fixup_rule_defs (():unit) = 
  map (\oid. let oc = lib_object_contents oid in
	    let (b, source) = rule_def_fixup (objc_source oc) in
	     if b then save oid (objc_translate (objc_modify_source oc source)))

 (lib_list ());
 ()
;;


let direct_nuprl4_import fname dir name =
   migrate_nuprl4_object_list (nuprl4_import fname)
			      (dag_make_named_directory dir name (tok_to_string name))
;;


let migrate_nuprl4_object_term objlist target =
 % do not expect proofs any longer %
 letref acc = ivoid_term in
  let mig_install stuff = 
   (let (name, (type, (term, props))) = stuff in
     if name = target then (acc := term; ()) )  in

   (map (\term. ((migrate_nuprl4_object mig_install term) ? ()))
        objlist);

   acc
;;


let direct_nuprl4_migrated_term fname name=
   migrate_nuprl4_object_term (nuprl4_import fname) name   
;;



letref mig4updates = nil : ((tok # object_id) # term) list;;

let nuprl4_update_source fname p f =
 letref acc = nil : ((tok # object_id) # term) list in 
  map_omitting_failures
   (\t.
   (let ((id, [n; k]), [([], properties); ([], data)]) = destruct_term t in
    let name = destruct_token_parameter n and
        kind = destruct_token_parameter k in
    let oid = p name kind in

    migrate_nuprl4_object
           (\name, kind, term, props.
	      % tty_print ("UPDATESOURCE " J (tok_to_string kind) J " " J (tok_to_string name));%
              acc := ((name, oid), (f oid kind term)) . acc;
	      ())
	   t))
           
  (nuprl4_import fname);

  rev acc
;;

let nuprl4_update_dforms fname =
 mig4updates := 
   (nuprl4_update_source fname
	(\name kind.
           if not (kind = `DISP`) then fail;

           let oids = filter (\oid. kind_of_oid oid = `DISP`)
                             (lib_find_oids_by_name name) in

     	    %tty_print ("UPDATEDFORMS " J (tok_to_string kind) J " " J (int_to_string (length oids)) );%
	    if (length oids = 1)
	        then ( tty_print ("UPDATEDFORMS " J (tok_to_string kind) J " " J (int_to_string (length oids)) )
                     ; hd oids)
		else fail)
        (\oid kind term. if (lex_equal_terms term (get_term oid)) then fail else term))
 ; 
  mig4updates
;;


let nuprl4_do_updates_aux updates =
 map (\((name,oid), term). put_term oid term; activate oid; ())
  updates			      
;;

let nuprl4_do_updates () = nuprl4_do_updates_aux mig4updates;;

let do_nuprl4_update_dforms fname =
 nuprl4_do_updates_aux ( nuprl4_update_dforms fname)
;;
