%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
;;;;	
;;;;	(tok # oid) list -> (tok # oid) list  -> (tok # oid) list
;;;;	
;;;;	dup oids ok, dup names not, 
;;;;	but rename conflict if oids differ.
;;;;	
;;;;	could add old subdir to dir to contain conflicts!! and old of old 
;;;;	but rm old old old. or add old_<sortable_date>.
;;;;	and remove oldest greater than some arbtitrary number?
;;;;	or leave then have separate gc that runs at collect time.
;;;;	  - beyond current scope. keep in mind when doing more sophisticated wm.
;;;;	
;;;;	toks same oids differ   : rename the other.
;;;;	toks differ oids same	: keep both
;;;;	toks and oids same	: keep one lose other.
;;;;	  - beyond the scope to attempt rebinding at this point.
;;;;
;;;;	
;;;;	
;;;;	
;;;;	dump/load :
;;;;	  - single file separate from database.
;;;;	      * could allow use of global compression table
;;;;	      * could have no compression whatsoever, twould be interesting.
;;;;	      * could have pointers into database as long as some procedure
;;;;		is also supplied which would extract such files. FTTB seperate.
;;;;	  - dump : dumps list of objects and all statically referenced objects.
;;;;	      * source
;;;;	      * some properties ? all properties
;;;;	      * proof list
;;;;	      * inf tree
;;;;	  - load : overwrite similar objects.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	-------------------
;;;;	
;;;;	Normally at connect library dumps state snapshot to connecting component. 
;;;;	
;;;;	A library can be checkpointed. This creates a discrete point for which the library
;;;;	can compare time stamps.
;;;;	  - lib would need to remember sequence of process-ids or trust that it can
;;;;	     accurately order process-ids by time.
;;;;	      * merging data complicates
;;;;	        bind at merge has stamp of merging pid!
;;;;	      * import would complicate, lib being imported to must stamp imported objects somehow (bind?).
;;;;	        whatever stamp we add to object to order graph references. 
;;;;	
;;;;	<component-state-segment> : library snapshot of component state between two checkpoints.
;;;;	  - component can read prior to connect.
;;;;	    connect need only send update from component's last loaded checkpoint.
;;;;	
;;;;	<database-closure>	: filesystem snapshot of library state between two checkpoints.
;;;;	  - copy relevant portion of filesystem to new directory.
;;;;	  - may desire multiple lib environments, but for each need checkpoints. 
;;;;	
;;;;	
;;;;	Desire ability to export library updates to remote libraries : lib state-segment and database-closure.
;;;;	Desire ability to synch component checkpoints and to update local components wo connecting.
;;;;	  -component state-segment.	
;;;;	
;;;;	Exporting Database :
;;;;	  given set of seed logs, copy files necessary to export db.
;;;;	  similar to gc.
;;;;	
;;;;	  given checkpoint and set of seed logs copy files necessary to export diff.
;;;;	
;;;;	
;;;;	Export objects :
;;;;	  given checkpoint, and list of objects, create a lib update and export files
;;;;	  needed to update remote lib.
;;;;	
;;;;	
;;;;	Exporting component : 
;;;;	  for a given library environment and checkpoint, create file and new checkpoint
;;;;	  needed to bring component level with checkpoint.
;;;;	
;;;;	
;;;;	Primary Goal FTTB is to allow single checkpoint to facilitate quickstart disksaves.
;;;;	  - require checkpoint cause library_close
;;;;	  - assume all subsequent are quick close or somehow ignore the close summaries.
;;;;	  - copy hash table at checkpoint time.
;;;;	  - at restartconnection s
;;;;	  
;;;;	  - library state built from sequence of checkpoints
;;;;	  
;;;;	  
;;;;	  Assume bind stamp and can precisely order all bind wrt checkpoints.
;;;;	    - but then there are no records of unbinds/deacts.
;;;;	  
;;;;	Checkpoint adds object to local which consists of list of oid # activep # collectp # objc stamp
;;;;	  - allows lib to diff checkpoint agains current state.
;;;;	  - ignores infs & ?prfs? - lib needs to know if inf/prf activated?
;;;;	   
;;;;	  
%
%

 inf; prf; stm -> (inf, prf); (prf, stm)

 - desire maintain any sharing of infs.
 fttb 
  - there is no sharing.  
  - no first class prfs
  - no first class infs.
;;;;	: oid{stm} # (oid{prf} # (oid{inf} list)) list
;;;;	| oid{not stm}, []

;;;;	
;;;;	make_save : oid{dir} -> tok{name} -> (term -> bool){predicate} -> unit  
;;;;	 creates .save <name> theory in oid dir which are copies of source.
;;;;	  (may need to have some mapping funcs avoid .save dirs (like find inactive kind) 
;;;;	
;;;;	
;;;;	maybe extra object which is list of original oids with names? corresponding to copies.
;;;;	.save original object ids
;;;;	
;;;;	
;;;;	build : makes wip dir with ml object and save dir.
;;;;	 ml object is predicate arg to make_save.
;;;;	 allow mulitple preds, eg make some modes fixup but in fixup modify some lemmas.
;;;;	 want add callers of modified lemmas to save.  maybe multiple save dirs.
;;;;	
;;;
;;;;	 lock copies??
;;;;	 buttons : 
;;;;	  - show objects for which pred is true.
;;;;	  - run pred and build save dir
;;;;	  - deactivate originals.
;;;;	  - map some ml object on originals.
;;;;	  - some status funcs
;;;;	  - some consistency updates (ie proof dependents).
;;;;	  - some info shows.
;;;;	
;;;;	map_term : (term -> bool) -> (term -> (term -> term) -> term) -> term -> term 
;;;;	
;;;;	map_term_p : ((term -> bool) -> term -> bool
;;;;	
;;;;	make_save_list		: object_id -> tok -> (term -> bool) -> unit
;;;;	save_save_list		: object_id -> tok -> (term -> bool) -> unit
;;;;	apply_save_list		: object_id -> tok
;;;;					-> (term -> bool) -> (term -> (term -> term) -> term) 
;;;;					-> unit
%

let dump_objects oids compressp =
 ()
;;



%
;;;;	
;;;;	wmmod : working map mod.
;;;;	
;;;;	
;;;;	desire : merge directories.
;;;;	
;;;;	if conflict then keep one with later source timestamp?
;;;;	better still to use shadow merge concept.
;;;;	
;;;;	if conflict then allow for examination of older.
;;;;	 
;;;;	
;;;;	build conflict root which will contain shadowed objects.
;;;;	orphan conficts ??
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
%


let type_of_wmmod mod =
 let id = (id_of_term mod) in
  if (id = `!definition_insert`)	then `insert`
  else if (id = `!definition_disallow_collection`)	then `disallow`
  else if (id = `!definition_activate`)	then `activate`
  else (raise_error [] ``working_map mod type unknown`` [mod]; `ignore`)
;;

let definition_of_insert_wmmod mod = subterm_of_term mod 1;;
let oid_of_wmmod mod = destruct_object_id_parameter (parameter_of_term mod 2);;

let dependency_of_idefinition idef =	(subterm_of_term idef 1);;
let objc_of_idefinition idef =		(subterm_of_term idef 2);;

let oid_of_idefinition idef =
 first_oid_of_term (dependency_of_idefinition idef)
;;


% TODO : obid_closure : given list of obids returns dependency (ie those depended upon) closure. %
% wm_thin : object_id list -> unit,  delete all but listed oids %

% wm_clean : unit -> unit,  deactivate all non-root directories which are not referenced. 
  see collect_orphans
%

let merge_objcs a b =
  tty_print "merge objc's";

(
  if not ((objc_kind a) = `TERM`) & ((objc_kind b) = `TERM`) then a else

  let asrc =  objc_reduced_source a in
    if not (`!directory` = id_of_term asrc) then a else

  let bsrc =  objc_reduced_source b in
    if not (`!directory` = id_of_term bsrc) then a else

    objc_modify_source a 
      (dag_dir_children_replace asrc
         (directory_merge (dag_dir_children asrc) (dag_dir_children bsrc)))
) ? a
;;  
 
let activate_lite oid =
 let objc = oc oid in
  if (objc_kind objc) = `TERM` then
    let src = objc_reduced_source objc in
      if (`!directory` = id_of_term src) then
         (activate oid ? ())
;;

%
;;;;	
;;;;	merge_insert_obj : bool{keep} -> object_id -> object_contents -> unit
;;;;	merge_activate	 : bool{lite} -> object_id -> unit
;;;;	merge_collection : object_id -> unit
;;;;	
;;;;	
;;;;	type_of_wm_mod	:
;;;;	oid_of_wm_mod	:
;;;;	objc_of_wm_mod	:
;;;;	
%

let merge_insert keep oid objc = 
  tty_print (if keep then "insert keep" else "insert not keep");
   % detect if objc very simlilar then noop %
     if (lib_bound_p oid)
	then let oobjc = (oc oid) in
	     let nobjc = if keep
		           then (merge_objcs oobjc objc)
			   else (merge_objcs objc oobjc) in
	      if (false & (objc_very_similar_p (oobjc) nobjc))
	         then (allow_collection oid; deactivate oid)		
		 else (delete_strong oid; lib_insert oid nobjc; ())
	else ((lib_insert oid objc); ())
;;

let merge_disallow oid =
  tty_print "disallow";
  disallow_collection oid;;

% lite : only activate dirs %
let merge_activate litep oid =
  tty_print (if litep then "activate lite" else "activate not lite");
  if litep 
     then activate_lite oid
     else ((activate oid) ? ())
;;


let merge_apply keep litep hook = 
 tty_print (concatenate_strings ["merge_apply "; if keep then "keep " else "not keep "; if litep then "lite" else "not lite"]);
 hook (merge_insert keep)
      merge_disallow
      (merge_activate litep)
;;

let make_merge_mod keep litep =
  merge_apply keep litep
    (\insert disallow activate . 
        (\mod. let type = (type_of_wmmod mod) in
	         %tty_print (concatenate_strings ["merge_mod "; (tok_to_string type)]);%
		 if type = `insert`		then (let idef = (definition_of_insert_wmmod mod) in
						       insert (oid_of_idefinition idef) 
							      (term_to_objc (objc_of_idefinition idef))
						       ; ())
		 else if type = `disallow`	then (disallow (oid_of_wmmod mod); ())
		 else if type = `activate`	then (activate (oid_of_wmmod mod))
		 else (raise_error [] ``overwriting_merge mod type unknown`` [mod]; ())))
;;


% useful for retrying activate after load in case objects failed to activate during load. %
letref active_load = [] : (string # object_id list) list;;

let react_load ghostp fname =
 letref i = 0 in
 let l = ( apply_alist active_load fname
         ? (letref acc = nil in 
              load_object_term_list nil fname
                (\collectp activep term oid.
                   if not (activep = (lib_active_p oid ? false)) 
                      then (acc := oid . acc; ()))
             ; rev acc)) in

  active_load :=
   update_alist active_load
    fname
    (filter 
     (\oid.
       if (not (lib_active_p oid ? false))
         then ( i := i + 1
              ; tty_print ( "ActNotOK" J " "
                          J ((tok_to_string (name_property oid)) ? "NOName"))
              ; if not ghostp then (activate oid ? ())
              ; true)
         else false)
     l)

  ; tty_print ("Total " J (int_to_string i))
;; 

letref load_will_overwrite_list = nil : object_id list;;
let load_will_overwrite fname =
  letref i = 0 in 
  load_will_overwrite_list := nil;
  load_object_term_list nil fname
           (\collectp activep term oid.
             i := 1+i;
             if lib_bound_p oid 
                then (load_will_overwrite_list := oid . load_will_overwrite_list; ()))

  ; tty_print ("Total " J (int_to_string (length load_will_overwrite_list)))
  ; i, length load_will_overwrite_list
;; 

%;;;	
;;;;		
;;;;	refresh-objects (mods)
;;;;	   - compute ordered closure from mods
;;;;	   - check closure in order while apply mods.
;;;;		- closure should be some union of dependencies form old and new for mod objects.
;;;;		
;;;;	for each component 
;;;;	  code sort and find closure
;;;;	    map but when replacement deact replace act otherwise deact act to refresh callers.
;;;;	!! integrate with lib_open? to replace prior to compile?
;;;;	    - but involves breaking up start broadcasts 
;;;;	      compute diff of all - mod closure and broadcast that
;;;;	      then 
;;;;	
;;;;	
;;;;	
;;;%
let load_object_list_aux fname = 
  (\insert disallow activate .
    (load_object_list fname
      (\collect active objc oid . 
        tty_print (concatenate_strings ["load_object_list_aux0 "; if active then "active " else "not active"; if collect then "collect" else "not collect"]);
          (insert oid objc)
        ; tty_print (concatenate_strings ["load_object_list_aux1 "; if active then "active " else "not active"; if collect then "collect" else "not collect"])
	; (if active then activate oid)
        ; tty_print (concatenate_strings ["load_object_list_aux2 "; if active then "active " else "not active"; if collect then "collect" else "not collect"])
        ; (if not collect then disallow oid))))
;;

let overwriting_load fname =	 (merge_apply false false (load_object_list_aux fname));;
let shadowing_load litep fname = (merge_apply true  litep (load_object_list_aux fname));;

let load_objects overwritep activatep fname =
 without_dependencies
  (\(). merge_apply (not overwritep) (not activatep) (load_object_list_aux fname));;


% perhaps patch is from a different database, need to supply dbpath %
%
let load_objects_path dbpath overwritep activatep fname = 
  merge_apply (not overwritep) (not activatep) (load_object_path_list_aux dbpath fname);;
%

 
%
	overwriting_merge 	: prefers foreign objects.
	shadowing_merge		: prefers native objects.
%

let overwriting_merge_aux import = (import (make_merge_mod false false));;
let overwriting_merge = overwriting_merge_aux import_environment_by_match;;

let shadowing_merge_aux litep import = (import (make_merge_mod true litep));;

let shadowing_merge =	   shadowing_merge_aux false import_environment_by_match;;
let shadowing_merge_lite = shadowing_merge_aux true  import_environment_by_match;;



let make_lsystem () =
 dag_remove_tree_danger (root `system`);
 dag_remove_tree_danger (root `local`);
 dag_remove_tree_danger (root `theories`)
;;

let make_envl () =
 dag_remove_tree_danger (descendent (root `theories`) ``markb so_lam``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb pattern_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb label_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb collection_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb declaration_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb record_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb state_machine_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb list_extra``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb tree_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb automata_1``);
 dag_remove_tree_danger (descendent (root `theories`) ``markb ensemble_env``)
 
;;


% 
let rename_lib lib = 
  rename_library_environment lib
;;
%


%
;;;;
;;;;	check and copy proofs
;;;;
;;;;	re run proofs in a given directory, collecting failures
;;;;
;;;;	make_check_list		: object_id -> tok -> (object_id -> bool) -> unit
;;;;	save_check_list		: object_id -> tok -> (object_id -> bool) -> unit
;;;;	apply_check_list	: object_id -> tok -> (object_id -> bool) ->
;;;;					(object_id -> (object_id -> object_id) -> object_id) 
;;;;					-> unit
%


let map_oid_source f oids = 
 let do_oid_src oids oid =
    (f (oid . oids) oid) 
     ? () in

 letrec do_oid oid =
   (let objc = oc oid in
    let k = objc_kind objc in
      if (`PRF` = k) 
	 then do_prf [] oid
	 else ( do_oid_src [] oid
	      ; if (`STM` = k) then (map (do_prf [oid]) (stm_objc_src_proofs objc); ())
	      )
    ? ())

 and do_itree oids itree = 
   do_oid_src oids (inf_tree_object_id itree)
   ; map (do_itree oids) (inf_tree_children itree)
   ; ()
    
 and do_prf oids oid = do_itree (oid . oids) (prf_objc_src_inf_tree (oc oid))

  in
   map do_oid oids
;;


let flat_oid_src_p p oid = 
 letref acc = [] in
    (map_oid_source (\oids oid. if (p oid) then (acc := (oids . acc);()))
			 (subtree_oids false oid))
   ; flatten acc
;;

let oid_src_p p oids = 
 let turnonhead l =
 (let a, b = divide_list (\x. null (tl x)) l in
  append (map (\x. (hd x), []) a)
    (letrec paux l = 
      if (null l) then []
      else let oid = hd (hd l) in
           let some, others = divide_list (\x. (equal_oids_p oid (hd x))) l in
             (oid, (map (\x. hd (tl x)) some)) . paux others
      in
     letrec aux l = 
      if (null l) then []
      else let oid = hd (hd l) in
           let some, others = divide_list (\x. (equal_oids_p oid (hd x))) l in
             (oid, (paux (map tl some))) . aux others

       in aux (map rev b)))

  in
 
  letref acc = [] in
    let f oids = % may want to pass in to make abstract%
    length oids = 3 &
    (let ioid = (hd oids) and poid = (hd (tl (oids))) and soid = (hd (tl (tl oids))) in
      not (inf_checks_p ioid (objc_property (oc poid) `DESCRIPTION`) [soid; poid]))
      in   
    (map_oid_source (\oids oid. if (p oid) & f oids then (acc := (oids . acc);()))
		oids)
   ;

  (turnonhead acc)
;;

%
;;;;	
;;;;	
;;;;	duplicate_named_oids : term{description} -> object_id list -> object_id list
;;;;	  * result is list of active objects with matching descriptions  which clash
;;;;	    with names of objects in arg list.
;;;;	
;;;;	
;;;;	filter_kind : tok -> (object_id list -> object_id list)
;;;;	filter_description : term{description} -> term{description} -> bool
;;;;	
;;;;	view_show_oids : object_id list -> unit
;;;;	  * must have connected editor. Pops up window with list of oids.
;;;;
;;;;	thus to deactivate all duplicate abs defs :
;;;;	
;;;;	map deactivate
;;;;	    (filter_kind `ABS` (duplicate_named_oids nuprl5_ref_description_term
;;;;						     (subtree_oids (descendent_s ``system theories``))))
;;;;	
;;;;	or to find inactive comments :
;;;;
;;;;	let inactive_comments oids =
;;;;	  (filter (\oid. not (lib_active_p oid)) 
;;;;		  (filter_description nuprl5_ref_description_term 
;;;;				      (filter_kind `COM` oids));;
;;;;	
%

let filter_kind k = filter (\oid. k = (objc_kind (oc oid)));;

let filter_description d oids = 
  let m = build_description_match d in
    filter (\oid. m (description_of_objc (oc oid))) oids
;;

let duplicate_named_oids_not_prf d oids =
  (filter (\oid. let k = objc_kind (oc oid) in (not (`PRF` = k)) & (not (`INF` = k))))
  	  (duplicate_named_oids d oids)
;;

let inactive_subtree_oids oid = 
 filter (\oid. not (lib_active_p oid)) (subtree_oids false oid)
;;




%
;;;;	
;;;;	map_source : 
;;;;	  not prf : get_term
;;;;	  prf : map_prf get_term inf
;;;;	
;;;;	
;;;;	f : oid list -> term -> unit
;;;;	
;;;;	  * oid list : first is oid containing term.
;;;;	    then if inf then next is prf containing inf if available.
;;;;	    then if prf then next is stm containing prf if available.
;;;;	
;;;;	
;;;;	want to modify inf objects without destructive update of prf.
;;;;	
;;;;	
;;;;	: oid{stm} # (oid{prf} # (oid{inf} list)) list
;;;;	| oid{not stm}, []
% 


% f : object_id list -> tok{kind} -> bool{cont}
  if stm and cont true then visit proofs
  if prf and cont true then visit infs.
%

let eoc = lib_object_contents_ephemeral;;

let map_object_aux f oids = 
 let do_oid_src oids k oid oc =
   (f (oid . oids) k oc)
   ? false in

 letrec do_oid oid =
  ((let objc = eoc oid in
    let k = objc_kind objc in
      if (`PRF` = k) 
	 then do_prf [] oid
	 else (if do_oid_src [] k oid (inr objc)
		  then (if (`STM` = k) then (map (do_prf [oid]) (stm_objc_src_proofs objc); ()))
                  else ()))
    ? ())

 and do_itree oids itree = 
   do_oid_src oids `INF` (inf_tree_object_id itree) (inl())
   ; map (do_itree oids) (inf_tree_children itree)
   ; ()
    
 and do_prf oids oid =
  if (do_oid_src oids `PRF` oid (inl ()))
     then ((do_itree (oid . oids) (prf_objc_src_inf_tree (eoc oid))) ? ())
     else ()

  in
   map do_oid oids
;;

let map_source f oids = 
 let do_oid_src oids oid =
   ((let objc = oc oid in
     (f (oid . oids) (get_term oid))) 
     ? ()) in

 letrec do_oid oid =
  ((let objc = oc oid in
    let k = objc_kind objc in
      if (`PRF` = k) 
	 then do_prf [] oid
	 else ( do_oid_src [] oid
	      ; if (`STM` = k) then (map (do_prf [oid]) (stm_objc_src_proofs objc); ())
	      ))
    ? ())

 and do_itree oids itree = 
   do_oid_src oids (inf_tree_object_id itree)
   ; map (do_itree oids) (inf_tree_children itree)
   ; ()
    
 and do_prf oids oid =
  ((do_itree (oid . oids) (prf_objc_src_inf_tree (oc oid))) ? ())

  in
   map do_oid oids
;;


let flat_src_p p oid = 
 letref acc = [] in
    (map_source (\oids t. if (p t) then (acc := (oids . acc);()))
			 (subtree_oids false oid))
   ; flatten acc
;;


% returns oid{stm}     # (oid{prf} # oid{infs} list) list
  or      oid{not stm} # nil
%
let turnonhead l =
 (let a, b = divide_list (\x. null (tl x)) l in
   append (map (\x. (hd x), []) a)
    (letrec paux l = 
      if (null l) then []
      else let oid = hd (hd l) in
           let some, others = divide_list (\x. (equal_oids_p oid (hd x))) l in
             (oid, (map_omitting_failures (\x. hd (tl x)) some)) . paux others
      in
     letrec aux l = 
      if (null l) then []
      else let oid = hd (hd l) in
           let some, others = divide_list (\x. (equal_oids_p oid (hd x))) l in
             (oid, (paux (map tl some))) . aux others

       in aux (map rev b)))
;;

let src_p p oids = 
 
  letref acc = [] in
    (map_source (\oids t. if (p (hd oids) t) then (acc := (oids . acc);()))
		oids)
   ;

  (turnonhead acc)
;;

let map_object_p p oids = 
 
  letref acc = [] in
    (map_object_aux (\oids k oco.
                   let keepp,contp = p (hd oids) k (\():unit. if isl oco then (eoc (hd oids)) else (outr oco)) in
                    if keepp then (acc := (oids . acc); ());
                    contp)
		oids)
   ;
  
 (turnonhead acc)
;;


let prfs_src_p p oid = filter_kind `PRF` (flat_src_p p oid);;



%

 inf; prf; stm -> (inf, prf); (prf, stm)

 - desire maintain any sharing of infs.
 fttb 
  - there is no sharing.  
  - no first class prfs
  - no first class infs.
;;;;	: oid{stm} # (oid{prf} # (oid{inf} list)) list
;;;;	| oid{not stm}, []

;;;;	
;;;;	make_save : oid{dir} -> tok{name} -> (term -> bool){predicate} -> unit  
;;;;	 creates .save <name> theory in oid dir which are copies of source.
;;;;	  (may need to have some mapping funcs avoid .save dirs (like find inactive kind) 
;;;;	
;;;;	
;;;;	maybe extra object which is list of original oids with names? corresponding to copies.
;;;;	.save original object ids
;;;;	
;;;;	
;;;;	build : makes wip dir with ml object and save dir.
;;;;	 ml object is predicate arg to make_save.
;;;;	 allow mulitple preds, eg make some modes fixup but in fixup modify some lemmas.
;;;;	 want add callers of modified lemmas to save.  maybe multiple save dirs.
;;;;	
;;;
;;;;	 lock copies??
;;;;	 buttons : 
;;;;	  - show objects for which pred is true.
;;;;	  - run pred and build save dir
;;;;	  - deactivate originals.
;;;;	  - map some ml object on originals.
;;;;	  - some status funcs
;;;;	  - some consistency updates (ie proof dependents).
;;;;	  - some info shows.
;;;;	
;;;;	map_term : (term -> bool) -> (term -> (term -> term) -> term) -> term -> term 
;;;;	
;;;;	map_term_p : ((term -> bool) -> term -> bool
;;;;	
;;;;	make_save_list		: object_id -> tok -> (term -> bool) -> unit
;;;;	save_save_list		: object_id -> tok -> (term -> bool) -> unit
;;;;	apply_save_list		: object_id -> tok
;;;;					-> (term -> bool) -> (term -> (term -> term) -> term) 
;;;;					-> unit
%


% applies continue on children of modified term. 
  loop is possible if modification adds subterm satisfying predicate.

 another possible variant would be to apply continue to modification 
 however that is even more likely to loop if modify does not cause
 predicate to be false.
%

let src_filter_aux_aux f p oids =

 let l = f p oids in

 let aux e =
  let eoid = fst e in
  let objc = oc eoid in
  let kind = objc_kind objc in
    if (kind = `INF`) or (kind = `PRF`)
       then (raise_error [eoid] [`make_save`; kind] []; fail)  % not an error just not prepared for it%

       else ((token_of_itoken_term (name_of_objc objc) ? `noname`), eoid)

 in (map aux l)
;;

let src_filter_aux = src_filter_aux_aux src_p;;

let remove_duplicates p l =
 letrec aux r =
   if null r then r
   else
   let tail = tl r in
   if (member_p (hd r) tail p)
      then aux tail
      else (hd r) . (aux tail)
   in rev (aux (rev l))
;;
   
let make_targets_aux destoid oids p =

 let l = (src_filter_aux p oids) in

 if (null l) then (raise_error [destoid] ``make_save none`` []; fail);

 let odir = dag_make_named_directory destoid `Targets` "Targets" in 
   directory_append_children odir (remove_duplicates (\a b. equal_oids_p (snd a) (snd b)) l)
;;

let make_targets milloid srcoid excludef p =
  %(p (dummy_object_id()) ivoid_term);% % to check if always fails%
  make_targets_aux milloid (subtree_oids_avoid false srcoid excludef) p
;;

% (object_id -> tok{kind} -> (unit -> object_contents) -> (bool{keep} # bool{cont})) ->
   object_id list ->
    (tok{name} # object_id) list)
%
let filter_objects = src_filter_aux_aux map_object_p;;

let filter_subtree_objects srcoid excludef p =
 filter_objects p
  (subtree_oids_avoid false srcoid excludef)
;;
  

let make_save_list oid name p =

 let l = src_p p (subtree_oids false oid) in

 if (null l) then (raise_error [oid] ``make_save none`` []; fail);


 let sname = concatenate_strings [".save "; tok_to_string name] in
 let sdir = dag_make_named_directory_before oid null_token (string_to_tok sname) in

   make_targets_aux sdir (subtree_oids false oid) p
;;


let copy_targets_aux sdir tdir p =

 let l = directory_children tdir in
 let oids = src_p p (map snd l) in

 let cdir = dag_make_named_directory sdir `Copies` "Copies" in
  
 let doprf (poid,infs) =
  let pobjc = oc poid in
  let noid = create_object_id () in
  let itree = inf_tree_replace_oids (prf_objc_src_inf_tree pobjc)
				    (map (\oid. oid,cpobj oid) infs) 
   in save noid (prf_objc_src_modify_inf_tree pobjc itree)
  
   ; noid

 in

 let dostm (soid, prfs) = 
  let sobjc = oc soid in
  let noid = create_object_id () in

  save noid
    (stm_objc_src_modify_proofs sobjc
      (map (\poid. 
             (doprf (find (\prf. equal_oids_p poid (fst prf)) prfs)
	     ) ? poid)
           (stm_objc_src_proofs sobjc)))
  ; noid

  in

 let aux e =
  let eoid = fst e in
  let objc = oc eoid in
  let kind = objc_kind objc in
    if (kind = `INF`) or (kind = `PRF`)
       then (raise_error [eoid] [`make_save`; kind] []; fail)  % not an error just not prepared for it%
    else if (snd e) = nil
       then ((token_of_itoken_term (name_of_objc objc) ? failwith `move_save unnamed object`), cpobj eoid)
    else if (not (`STM` = kind))
       then (raise_error [eoid] [`make_save`; `complex`; `STM`; `not`] []; fail)  % not an error just not prepared for it%
    else

      % cp prfs and with inf replacements %
      ((token_of_itoken_term (name_of_objc objc) ? failwith `move_save unnamed object`), dostm e)

 in directory_append_children cdir (map aux oids)

;;
   
let copy_targets milloid srcoid p = 
 copy_targets_aux milloid (child milloid `Targets`) p
;;


let save_save_list oid name p =
 let sname = concatenate_strings [".save "; tok_to_string name] in
 let snametok = string_to_tok sname in
 let sdir =  (descendent oid [snametok]) in

 copy_targets_aux sdir (descendent sdir [`Targets`]) p
;;   

%
;;;;	
;;;;	to cp or not to cp.
;;;;	  - it is possible for inf objects to be shared.
;;;;	  - transform rebinds inf objects.
;;;;	
;;;;	 optimal is to duplicate inf object and to maintain sharing among
;;;;	 set being transformed with new and leave those proofs not
;;;;	 being transformed sharing the old.
;;;;	
;;;;	 ok would be to duplicate inf objects and rebuild proof trees
;;;;	 of those being transformed.
;;;;	 
;;;;	 not good but current practice is to modify inf objects
;;;;	 without regard to sharing.
;;;;	 
%

let do_transform p f item =
 let doinf oids ioid =
   put_inf_tactic false (map_term p f (get_term ioid))
     ioid oids
   in
   
 let doobj ioid = 
   put_term ioid (map_term p f (get_term ioid))
  ; ()
 in

 let doprf soid (poid,infs) =
   % if shared infs then this will change for all since rebinding to inf. %
   map (doinf [poid; soid]) infs
  ; ()
 in

 let dostm (soid, prfs) = 
   doobj soid;
   map (doprf soid) prfs
  ; ()
 in

 let aux e =
  let eoid = fst e in
  let objc = oc eoid in
  let kind = objc_kind objc in
    if (kind = `INF`) or (kind = `PRF`)
       then (raise_error [eoid] [`make_save`; kind] []; fail)  % not an error just not prepared for it%
    else if (snd e) = nil
       then ((token_of_itoken_term (name_of_objc objc) ? failwith `move_save unnamed object`), doobj eoid)
    else if (not (`STM` = kind))
       then (raise_error [eoid] [`make_save`; `complex`; `STM`; `not`] []; fail)  % not an error just not prepared for it%
    else

      % cp prfs and with inf replacements %
      ((token_of_itoken_term (name_of_objc objc) ? failwith `move_save unnamed object`), dostm e)

 in (aux item)
;;


let list_transform_targets tdir p = 

 let l = directory_children tdir in

 letref acc = [] in
    (map_source (\oids t. if (map_term_p p t) then (acc := (oids . acc);()))
                (map snd l))
 ; (rev acc)

  % PERF: could include in update pass %
  %
  src_p (\oid t. (map_term_p p t)) (map snd l) 
  %
;;

let transform_targets_aux b tdir p f = 

 let l = directory_children tdir in

 % PERF: could include in update pass %
 let oids = if b
               then src_p (\oid t. (map_term_p p t)) (map snd l)
	       else mapfilter (\n,oid. if (map_term_p p (get_term oid)) then (oid,nil)
				        else fail) l
	       in

  (map (\item. do_transform p f item ? (name_of_oid (fst item),()))  oids) ; ()
;;

let transform_targets = transform_targets_aux true;; 


let apply_save_list oid name p f = 

 let sname = concatenate_strings [".save "; tok_to_string name] in
 let snametok = string_to_tok sname in
 let sdir =  (descendent oid [snametok]) in

 transform_targets (descendent sdir [`Targets`]) p f
;;


let save_dir oid = 
 ( child oid `.save` 
 ? let soid = dag_make_directory_oid () in
    dag_insert oid `.save` soid;
    put_name soid ".save";
    soid  
 )
;;

let copy_to_save dir name =

 let nname = string_to_tok (J (tok_to_string name) (J " " (datetime_sortable (utime())))) in
 let noid = copy_object_strong nname (child dir name) in

 let sdir = save_dir dir in
  dag_insert_first sdir nname noid
;;

% if proxy then don't want to cause blow-up by calling prf_objc_src_inf_tree%
let inf_oids_of_proof_wo_proxy poid =
 letrec aux itree =
   ( inf_tree_object_id itree
   . (flatten (map aux (inf_tree_children itree)))
   ) in
 let objc = oc poid in
  if prf_objc_src_inf_tree_proxied_p objc then nil
  if prf_objc_src_inf_tree_proxizeable_p objc then nil
  else ( (aux (prf_objc_src_inf_tree objc))
       ? nil)
;;

% adds prf oids and inf oids from proofs of stm src %
let proof_oids_closure_wo_proxy oids =
 letrec aux oids =
   if null oids then oids 
   else
   let oid = hd oids in
    if (kind_of_oid oid) = `STM`
       then (oid . (append (flatten (map (\poid. (poid . inf_oids_of_proof_wo_proxy poid))
                                    (stm_objc_src_proofs (oc oid))))
		           (aux (tl oids))))
       else (oid . (aux (tl oids)))
   in aux oids
;;

let proofs_of_list l = flatten (map (\oid. stm_objc_src_proofs (eoc oid) ? nil) l);;

% find stms with corrupt proof oids. %
let corrupt_stms oids =
 without_dependencies
   (\ ().
       filter (\oid. exists (\oid. not (can lib_object_contents oid))
		            (stm_objc_src_proofs (eoc oid))
		     ? false)
       oids)
;;
% find stms with proofs containing corrupt infs. %
let corrupt_prfs oids =
 without_dependencies
   (\ ().
       filter (\oid. exists (\poid. not (can inf_oids_of_proof_wo_proxy poid))
		            (stm_objc_src_proofs (eoc oid))
		     ? false)
       oids)
;;

% first list is closure second is frontier
  closure includes frontier
%   
let static_oids_closure maxdepth l =
 letrec aux l =
  if null l then [] else 
   ( ( (static_oids_of_term ( get_substance_term (hd l)
                            ? get_term (hd l)))
     ? nil)
   @ aux (tl l)) 
 
 and auxbite ol l =
  tty_print ( "bite "
	    J (int_to_string (length ol))
	    J " "
	    J (int_to_string (length l)));
  if null l then [] else
  let (pre,suf) = split 1000 l ? (l,nil) in
  let r = fast_diff_oids (fast_remove_duplicate_oids (aux pre)) ol in
  let rr = auxbite ol suf in
   fast_remove_duplicate_oids (r @ rr)
 
 and bigaux maxd l r = 
  if (maxd = 0) then l,r else
  let newrr = auxbite r r in
  let newr = fast_diff_oids newrr l in
   tty_print ( "StaticOidsClosure " J (int_to_string (length l))
             J  " " J (int_to_string (length r))
             J  " " J (int_to_string (length newrr))
             J  " " J (int_to_string (length newr)));
   if null newr then l,[]
   else bigaux (maxd - 1) (newr @ l) newr

 in without_dependencies (\(). bigaux maxdepth l l)
;;
			
letref dump_closure_max_depth = -1;;

let dump_object_list_wprfs cp mp fname oids =
 let noids = proof_oids_closure_wo_proxy oids in
  tty_print (concatenate_strings [ "wprfs "
				 ; int_to_string (length oids)
				 ; "  "
				 ; int_to_string (length noids)]);
  tty_print ("dump_object_list_wprfs " J (if cp then  "closure" else "not"));
  dump_object_list false mp fname
     (if cp
	 then (fst (static_oids_closure dump_closure_max_depth noids))
	 else noids)
;;

let dump_object_wstatic kind mp fname oids = 
 dump_object_list false mp fname (fst (static_oids_closure (-1) oids))
;;

let dump_object_with_kind kind cp mp fname oids = 
  dump_object_list_wkind kind cp mp fname (proof_oids_closure_wo_proxy oids)
;;


 
%
;;;;	
;;;;	Asynch eval. 
;;;;	
;;;;	Each process may have an asynch link.
;;;;	
;;;;	  - recv : queue of requests received.
;;;;	  - pend : pending reqs waiting for responeses.
;;;;	
;;;;	  - An expr to be evaluated asynch, is first placed on the recv queue.
;;;;	  - When the asynch link is polled the req will be moved to the pend queue and
;;;;	    then returned as answer to the poll.
;;;;	  - When the rsp is received the req is removed from the pend queue and the completion
;;;;	    hook is invoked on the req and rsp.
;;;;	  - if there is a pending request then poll returns nil, even if the recv queue is
;;;;	    not empty.
;;;;	      * makes asynch transactions seqential rather than stacked.
;;;;	      * need not limit multiprocessing
;;;;		eg. suppose two refiners connected and want to drive both asynch.
;;;;		then the lib should send a req to the ref to have the ref asynch eval
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	<asynch-call>	: <environment> <ac-hook>
;;;;	<ac-hook>	: term -> *
;;;;	
;;;;	asynch-call (<asynch-call> <term>)	: *
;;;;	  * calls the ac-hook with term as arg. 
;;;;	
;;;;	Notify : inter-transaction evaluation.
;;;;	
;;;;	add_notify	: (term{arg} -> unit){hook} -> term{cookie}
;;;;	notify		: term{cookie} -> term{arg} -> unit
;;;;	
;;;;	 notify will call the associated hook and then unassoc it.
;;;;	 the hook is evaluated in the environment of the add_notify in a new transaction
;;;;	 distinct from either the transaction current at add_notify or notify.
;;;;	   It is anticipated that notify will be called from the completion hook of an
;;;;	   asynch request.
;;;;	
;;;;	orb_eval_args_asynch_with_completion
;;;;	  :  term{description}
;;;;	  -> (term # term list){posure}
;;;;	  -> (term{result} -> unit){completion}
;;;;	  -> unit
;;;;	
;;;;	orb_eval_asynch_iterator
;;;;	  : term{rsp} ->
;;;;	    (unit + (term # term list){posure} ->
;;;;	    (term -> unit){completion} ->
;;;;	    unit
;;;;	  * evals posure on rsp (!void to prime) 
;;;;	
;;;;	
;;;;	asynch_eval/notify
;;;;	  - notify serves as continuation mechanism after asynch eval.
;;;;	
;;;;	
;;;;	
;;;;	


;;;;	
;;;;	Transaction iterator : 
;;;;	
;;;;	
;;;;	
;;;;	add end-hook which sees last diasy transaction ending and schedules next.
;;;;	bots : 
;;;;	  - find tasks
;;;;	  - schedule tasks
;;;;	  - meta-transactional
;;;;	  - could show status in edit window.
;;;;	
;;;;	bot apps :
;;;;	  - delayed refinement.
;;;;	  - check-theory.
;;;;	  - gc - logs, environments, binds, orphans.
;;;;	  
;;;;
;;;;	
;;;;	bot instance : 
;;;;	 object-id : status term 
;;;;	   - can be modified to control bot
;;;;	   - reflects status of bot.
;;;;	   - to avoid race conditions on update of status vs update of control
;;;;	     they should be distinct objects.
;;;;	     the bot status oid should container a reference to the controller oid.
;;;;	controls :
;;;;	  - halt
;;;;	  - restart
;;;;	  - pause resume
;;;;	
;;;;	
;;;;	sample is : fiat for now expansion
;;;;	  - input : list of stm's. 
;;;;   
;;;;	bot : object_id
;;;;	bot_resume : object_id -> unit
;;;;   
;;;;	
;;;;	Notification of asynch completion :
;;;;	  - orginate : eval_asynch but with completion which 
;;;;	  - eval asynch with cookie
;;;;	  - asych completion generates request 
;;;;	  - 
;;;;	      * expr : description # posure 
;;;;	      * 
;;;;	
;;;;	   completion 
;;;;	
;;;;	
;;;;	
;;;;	  - generate cookie and pass as arg to request.
;;;;	  - in completion of request, send notification request with cookie to orignator
;;;;	  - originator finds notify hook and calls on cookie.
;;;;	  - have alist of cookies and nofication hooks.
;;;;	  
;;;;	is this just a way of avoid multi-tasking. if process did not block to wait for rsp  
;;;;	then would this be useful. Ie just queue asynch request and use completion as notification
;;;;	would have same behaviour if evaling request did not block waiting for rsp.
;;;;	
;;;;	orb_eval_asynch_cookie
;;;;	  : term{description} ->
;;;;	    (unit + (term # term list){posure} -> (term -> unit)) {completion} ->
;;;;	    (term{description} -> ((term # term list){posure} -> (term -> unit)) {callback}
;;;;	     ->
;;;;	    unit
;;;;	
;;;;   
;;;;   launch_bot : f { -> posure} # c {completion}
;;;;	 bot_update : term{rsp} -> term{status} -> (term{status} # *)
;;;;	 bot_next   : (term{status} # *) -> posure
;;;;	  - update state
;;;;	  - launch next
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	Example : arf bot 
;;;;	  - edd invokes bot
;;;;	    synch call to lib
;;;;	    add_notify for bot completion
;;;;	    launchs bot, ie asynch call in lib
;;;;	     with_transaction:
;;;;	      completion of bot results in new asynch call
;;;;	        begins refinement and creates posure to peform refinement,
;;;;		   add_notify to continue with refine finish after refinement.
;;;;		asynch call posure sent to ref by orb.
;;;;		ref begins a transaction and performs refinement during transaction callback
;;;;		  *** ref could itself do refinement asynch
;;;;		  *** if so completion of bot would need to add_notify then wait for ref to post.
;;;;	        returns result asynch queue which then passes to asynch completion.
;;;;		  completion finishes refinement via notify then starts next.
;;;;	      when bot finishes posts notify which sends message to edd.
;;;;	
;;;;	
;;;;	ref asynch ??
;;;;	  - easier multiplexing of refiners by lib???
;;;;	      * reduces pending reqs in lib
;;;;	  - allow local ref transactions for refinement then reduces 
;;;;	    transaction stacking.
;;;;	  - inf_objc_refine_begin inf_objc_refine_complete already work asynch
;;;;	fttb : since single refiner just use the pending -> none-queued hack to avoid transaction stacking.
;;;;	
;;;;	multiple asynch refines of same proof,
;;;;	
;;;;	  - need sequential transaction access to inf_tree/prf objc
;;;;	  - stacked transactions since then have conflict when saving tree.
;;;;	    thus refine_complete should not remember inf_tree or prf.
;;;;	
;;;;	
;;;;	

%


%
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
%

let prf_proxy_inf_tree poid =
 save poid (prf_objc_src_proxy_inf_tree (oc poid))
;;

let prf_proxy_aux i =
 let l = filter lib_active_p (lib_prf_proxies()) in
 let ll = if ((length l) > i) then (firstn i l) else l in
  tty_print ("prf_proxy " J (int_to_string (length l)));
  let (g,b) = divide_list (\oid. (prf_proxy_inf_tree oid;true) ? false)  ll in
   (length b), ((length l) - (length g))
;;  

let prf_proxy_100 () = prf_proxy_aux 100;;

