
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


(defstruct (com-library-object (:include definition))
  (active-p nil))

(defmacro new-com-library (stamp tag
				 import-f
				 &rest keys
				 &key &allow-other-keys)

  `(define-definition-table
    ,stamp
    (list ,tag)
    nil
    :import-f ,(if import-f
		`,import-f
		`#'(lambda (term)
		     (make-com-lib-definition (new-common-library-object))))
    ,@keys))


(defun library-oid-bound-p (oid)
  (and (definition-lookup-by-oid (resource 'library) oid t nil t) t))

(defun library-lookup (oid &optional dont-note)
  (definition-lookup-by-oid (resource 'library) (oid-lookup oid) nil nil dont-note))
      
(defun maybe-library-lookup (oid &optional (dont-note t))
  (definition-lookup-by-oid (resource 'library) oid t nil dont-note))
      

#|
(define-primitive |!oid_map|  ((natural . sequence) (oid . old)  (oid . new)))

(defun apply-broadcast-to-oid-map-table (term omt touch-history auto-commit)
  (declare (ignore touch-history))
  
  (let ((*oid-map* (map-of-oid-map-table omt)))
    (case (id-of-term term)

      (|!oid_map|	(progn
			  (oid-map-update (current-transaction-stamp)
					  (sequence-of-ibroadcast-term term)
					  (old-of-ioid-map-term term)
					  (new-of-ioid-map-term term)
					  *oid-map*)

			  (when auto-commit
			    (oid-map-commit auto-commit
					    (sequence-of-ibroadcast-term term)
					    (old-of-ioid-map-term term)
					    *oid-map*))))

      (|!commit|	(oid-map-commit (term-to-stamp (stamp-of-icommit-term term))
					(sequence-of-ibroadcast-term term)
					(oid-of-icommit-term term)
					*oid-map*))

      (|!undo|		(oid-map-undo (current-transaction-stamp)
				      (sequence-of-ibroadcast-term term)
				      (oid-of-iundo-term term)
				      *oid-map*))
      
      ;; could just use oid-map in environment??? yes but this more robust if for some
      ;; reason more than one map.
      )))
|#




;;;;	
;;;;	<tree-listing>	: tok{name} # <object_id> # tok list{path(reversed)}
;;;;	  * considered including position in path for least dir but overhead
;;;;	    and including extra int for all listings outweighs benefit.
;;;;	  * cache but reset cache after any objectiddag broadcast.
;;;;	
;;;;	tree-listings : tok list{path} -> <tree-listing> list
;;;;	  
;;;;	tree-listing-next : <tree-listing> -> <tree-listing>
;;;;	tree-listing-prev : <tree-listing> -> <tree-listing>
;;;;	
;;;;	

;; preorder (ie visit node first) listing.
;; orphans? dynamic do not include in cache.
;; not orphans but not listed in a directory, ie anchored by some object in a dir.

;; requires objectiddag.


(defun tree-listings ()
  (let ((terms (resource 'terms)))
    (or (term-table-listings terms)
	(setf (term-table-listings terms)
	      (without-dependencies

	       (let ((ohash (make-hash-table :test #'equal)))
	       
		 (labels ((visit (path nameoid)
			    (let ((oid (cdr nameoid))
				  (npath (cons (car nameoid) path)))
			      (cons (list* (name-of-oid oid) oid npath)
				    (unless (equal npath '(|queue| |garbage| |local|))
				      (with-ignore
					  (let ((def (lookup-term-def oid t)))
					    (when (and def (directory-def-p def))
					      (unless (gethash (stamp-of-oid oid) ohash)
						(setf (gethash (stamp-of-oid oid) ohash) t)
						(mapcan #'(lambda (no) (visit npath no))
							(children-of-directory-def def)))))))))))
   
   
		   (let ((l (mapcan #'(lambda (no) (visit nil no))
				    (dag-roots))))
		     (make-array (length l) :initial-contents l)))))))))

(defun subtree-oids (oid &optional avoidf)
  (without-dependencies

   (let ((ohash (make-hash-table :test #'equal)))
	       
     (labels ((visit (nameoid)
		(let ((oid (cdr nameoid)))

		  (unless (or (and avoidf (funcall avoidf oid))
			      (gethash (stamp-of-oid oid) ohash))

		    (setf (gethash (stamp-of-oid oid) ohash) t)		    
		    ;;(setf -path path -oid oid) (break "tls")
		    (cons oid
			  (let ((def (lookup-term-def oid t)))
			    (when (and def (directory-def-p def))
			      (mapcan #'(lambda (no) (visit no))
				      (children-of-directory-def def)))))))))
   
       (visit (cons nil oid))))))

;; need to include inf trees of proofs!!
(defun directory-reachable-oids (&optional avoidoids)

  (without-dependencies

   (let ((ohash (make-hash-table :test #'equal)))

     (dolist (ao avoidoids) (hashoid-set ohash ao t))
	       
     (labels ((visit (nameoid)
		(let ((oid (cdr nameoid)))

		  (unless (gethash (stamp-of-oid oid) ohash)

		    (setf (gethash (stamp-of-oid oid) ohash) t)		    

		    (let ((def (lookup-term-def oid t)))
		      (or (when (and def (directory-def-p def))
			    (dolist (no (children-of-directory-def def)) (visit no))
			    t)
			  ;; add prfs of stms.
			  (dolist (poid (maybe-stm-to-prfs oid))
			    (unless (gethash (stamp-of-oid poid) ohash)
			      (setf (gethash (stamp-of-oid poid) ohash) t)))))))))

   
       (dolist (ro (dag-roots)) (visit ro)))

     ohash)))


(defun subtree-listings (path &optional include-dir)
  (let ((tl (tree-listings))
	(lp (length path)))
    (let ((acc nil))
      (dotimes (i (length tl))
	(let ((e (aref tl i)))
	  (let ((suffix (reverse (last (cddr e) lp))))
	    ;;(setf -i i -e e -lp lp -suffix suffix) ;(break)
	    (when (and (equal path suffix)
		       (progn ;;(setf -path path -suffix suffix) (break "sll")
			      (or include-dir
				  (not (= lp (length (cddr e)))) ; do not include directory itself.
				  )))
	      (push e acc)))))
      (nreverse acc))))

(defun subtree-oids-tree-old (oid)
  (without-dependencies

   (let ((ohash (make-hash-table :test #'equal)))
	       
     (labels ((visit (nameoid)
		(let ((oid (cdr nameoid)))

		  ;;(setf -oid oid) (break "tls")
		  (cons oid
			(let ((def (lookup-term-def oid t)))
			  (when (and def (directory-def-p def))
			    (unless (gethash (stamp-of-oid oid) ohash)
			      (setf (gethash (stamp-of-oid oid) ohash) t)
			      (mapcar #'(lambda (no) (visit no))
				      (children-of-directory-def def)))))))))
   
       (visit (cons nil oid))))))

(defun subtree-oids-tree2 (diroid)
  (setf ddd diroid)
  (without-dependencies

   (let ((ohash (make-hash-table :test #'equal)))
	       
     (labels ((visit (noid)	
		(let* ((oid (cdr noid))
		       (def (lookup-term-def oid t)))
		  (if (and def (directory-def-p def))
		      (unless (gethash (stamp-of-oid oid) ohash)
			(setf (gethash (stamp-of-oid oid) ohash) t)
			(cons oid (mapcar #'(lambda (no) (visit no)) (children-of-directory-def def))))
		      (list oid)))))
   
       (setf lll (cons diroid (mapcar #'(lambda (no) (visit no))
				      (dag-directory-children diroid))))))) lll)

(defun oid-ap (m oid)
  (cons (wrap-parens (iml-cons-term (itext_term "Oid_ap ") (car m)))
  (cons (ioid-term oid) (cdr m))))

(defun wrap-parens (term)
  (iml-cons-term (itext-term "(") (iml-cons-term term (itext-term ")"))))

;;maybe just define this as defunml in lib and call from ml fun in edd, easier?
(defun subtree-oids-tree (diroid)
  (setf ddd diroid)
  (without-dependencies

   (let ((ohash (make-hash-table :test #'equal)))
	       
     (labels ((visit (noid)	
		(let* ((oid (cdr noid))
		       (def (lookup-term-def oid t)))
		  (if (and def (directory-def-p def))
		      (unless (gethash (stamp-of-oid oid) ohash)
			(setf (gethash (stamp-of-oid oid) ohash) t)
			(cons (cons (car noid) (cons (kind-of-oid oid) def))
			      (mapcar #'(lambda (no) (visit no)) (children-of-directory-def def))))
		      (list oid)))))
   
       (setf lll (cons diroid (mapcar #'(lambda (no) (visit no))
				      (dag-directory-children diroid))))))) lll)


;; inclusive means include oid of dir at path.
(defunml (|subtree_oids| (inclusive oid))
    (bool -> (object_id -> (object_id list)))

  (if inclusive
      (subtree-oids oid)
      (cdr (subtree-oids oid))))


(defunml (|subtree_oids_avoid| (inclusive oid avoid))
    (bool -> (object_id -> ((object_id -> bool) -> (object_id list))))

  (if inclusive
      (subtree-oids oid #'(lambda (oid)
			    (funmlcall avoid oid)))
      (cdr (subtree-oids oid #'(lambda (oid)
				 (funmlcall avoid oid))))))


(defunml (|subtree_oids_tree| (oid))
    (object_id -> *)

    (subtree-oids-tree oid))


(defunml (|kind_subtree_listings| (kind path))
    (tok -> ((tok list) -> ((tok |#| object_id) list)))
  
  (without-dependencies
   (mapcan #'(lambda (e)
	       (let ((oid (cadr e)))
		 (when (eql kind (kind-of-oid oid))
		   (list (cons (car e) oid)))))

	   (subtree-listings path))))


(defun lastequaln (i a b)
  ;;(break)
  (let ((la (length a))
	(lb (length b)))
    (let ((r t))
      (labels ((aux (i a b)
		 (unless (zerop i)
		   (unless (eql (car a) (car b))
		     (setf r nil))
		   (aux (1- i) (cdr a) (cdr b)))))
	(when (and (>= la i)
		   (>= lb i))
	  (aux i
	       (nthcdr (- la i) a)
	       (nthcdr (- lb i) b))
	  r)))))

;; scope :
;;   - nil -> global.
;;   - ('tree . tok list) -> must be descendent of directory of path.
;;   - ('dir  . tok list) -> must be child of directory of path.
;; pointoid   : null -> start at beginning.
;; pointindex : suggestion as to where pointoid might be found. need not
;;		be supplied or accurate, but if it is then more efficient.
;; dirp : direction
(defun tree-listing-search (predicate oid index dirp scope)
  ;;(format t "tlss")
  (let ((l (tree-listings))
	(scope-kind (or (car scope) 'global))
	(path (cdr scope))
	)
    (let ((ll (length l))
	  (lp (length path)))

      ;; start pos when tree or dir and traversing in reverse order
      ;; needs to find last applicable descendent.
      ;;(format t "tls2 ~a " (and oid t))
      (let ((startpos (if (null oid)
			  (case scope-kind
			    (global
			     (if dirp 0 (1- ll)))

			    (tree
			     (let ((r nil)) ;; (format t "startpos")
			       (do ((i (if dirp 0 (1- ll)) (if dirp (1+ i) (1- i))))
				   ((or (if dirp (>= i ll) (< i 0))
					(when (equal path (last (cddr (aref l i)) lp))
					  (setf r i)
					  t))))
			       r))

			    (dir
			     (let ((r nil))
			       (do ((i (if dirp 0 (1- ll))
				       (if dirp (1+ i) (1- i))))
				   ((or (if dirp (>= i ll) (< i 0))
					(when (equal path (cdr (cddr (aref l i))))
					  (setf r i)
					  t))))
			       r)))
			  (let ((curpos (if (and index (equal-oids-p oid (cadr (aref l index))))
					    index
					    (position oid l :key #'cadr :test #'equal-oids-p))))
			    (when curpos
			      (if dirp
				  (unless (= curpos (1- (length l))) (1+ curpos))
				  (unless (= curpos 0) (1- curpos)))			      
			      )))))
	
	;; (format t "tls3 ~a " startpos)
	(if startpos
	    (do ((npos startpos
		       (if dirp
			   (unless (= npos (1- (length l))) (1+ npos))
			   (unless (= npos 0) (1- npos)))))
		((null npos)
		 (unless (null oid)
		   ;;(format t "tls recurse ")
		   (tree-listing-search predicate nil nil dirp scope)))
	
	      (let ((n (case scope-kind
			 (global
			  (aref l npos))

			 (tree
			  (let* ((n (aref l npos))
				 (npath (cddr n)))
			    (when (lastequaln lp path npath) ;;(equal path (last npath lp))
			      n)))

			 (dir
			  (let* ((n (aref l npos))
				 (npath (cddr n)))
			    (when (equal path (cdr npath)) ; parents path
			      n)))
			 (otherwise ;; prevent loop
			  (raise-error (error-message '(tree-listing-search scope bad) scope-kind))))))
		;;(format t "tls5 ~a " (and n t))
		(cond
		  ((null n)
		   ;;(format " ~a " startpos)
		   ;;(setf -oid oid) (break "fu")
		   ;;(when (null oid)
		   ;;  (return-from tree-listing-search nil))
		   ;;(when recursep (format t "."))
		   nil)
		  ((funcall predicate n)
		   ;;(when recursep (format t ","))
		   (return-from tree-listing-search (values n npos)))
		  (t ;;(when recursep (format t "_"))
		     nil))))

	;;(unless (null oid)
	      ;;(setf -predicate predicate -oid oid -index index -dirp dirp -scope scope) (break "yo")
	;;(tree-listing-search predicate nil nil dirp scope))
	)))))




;; TODO. if name is null might match first token of path.
(defun make-name-string-match (pattern &optional match-case-p)
   (string-pattern-search #'car (string pattern) match-case-p))

	    
(defunml (|make_name_search| (pattern casep globalp treep dirp path))
    (string ->
	    (bool -> (bool -> (bool -> (bool -> 
				    ((tok list) -> ((unit |+| (object_id |#| int)) ->
									      ((tok list) |#| (object_id |#| int)))))))))

  (let ((patternf (make-name-string-match pattern casep)))
    (make-closure #'(lambda (args)
		      ;;(setf -args args)
		      (mlet* (((e pos) (tree-listing-search patternf (cadr args) (cddr args) dirp
							    (unless globalp
							      (cons (if treep 'tree 'dir)
								    path)))))
			     ;;(when (null e) (setf -e e -pos pos -f patternf) (break "mns2"))
			     (if e
				 (cons (cddr e) (cons (cadr e) pos))
				 (breakout evaluation 'name_search)
				 )))
		  1)))



(defun invert-graph (g)

  (let ((ohash (new-oid-table)))

    (dolist (e g)
      (let ((r (car e)))
	(dolist (d (cdr e))
	  (hashoid-set ohash d (cons d (cons r (cdr (hashoid-get ohash d))))))))

    (let ((acc nil))
      (maphash #'(lambda (k v)
		   (declare (ignore k))
		   (push v acc)) ohash)
      acc)))


(defunml (|fast_invert_graph| (g))
    (((object_id |#| (object_id list)) list) ->
     ((object_id |#| (object_id list)) list))
  (invert-graph g))
	  
