%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
	Functions for interacting with term-table dag.


  Any component implement ObjectIdDag would load this code.


  Rename dag functions

  Justification for the roots/directory_children asymmetry wrt type of result.
  An object_id of root can have only one name, but the object_id of a child
  can have many if in many directories. 
 
%

let root_p = dag_root_p;;
let roots = dag_roots;;
let root_name = dag_root_name;;
let directory_p = dag_directory_p;;
let directory_children = dag_directory_children;;

let directory_obids oid = map snd (directory_children oid);;
let directory_names oid = map fst (directory_children oid);;

let root n = snd (assoc n (roots()));;

let child oid n = snd (assoc n (directory_children oid));;
let child_name poid coid = fst (rev_assoc coid (directory_children poid));;

let child_and_position oid name =
 letrec aux i l =
   if (null l) then failwith `child_and_position` 
   else if (name = (fst (hd l))) then (i, (snd (hd l)))
   else aux (1 + i) (tl l) in
  aux 0 (directory_children oid)
;;

let child_p oid n = can (\n. (assoc n (directory_children oid))) n;;

letrec descendent oid names = 
  if names = [] 
	then oid
	 else descendent (child oid (hd names)) (tl names);;


let descendent_s names =
 descendent (root (hd names)) (tl names)
;;

% returns path from descendent to root as list of oids. %
let object_id_path oid names  = 
  letrec aux names path = 
   if names = [] 
	then path
        else aux (tl names) ((child (hd path) (hd names)) . path) 
  in aux names [oid]
;;


let descendents oid names = directory_obids (descendent oid names);;

