let mp_eval_command_to_term_aux desc = orb_eval_command_to_term  `ANY` desc;;
let mp_eval_command_to_term =
  mp_eval_command_to_term_aux metaprl_refiner_description_term;;


% conversions used for jprover calls %

let mp_to_nuprl_var_term term =
  (let [p1; p2],() = dest_term_with_opid `!metaprl_implementation` term in
  let v = destruct_variable_parameter p2 in
  mk_var_term v) ? term
;;
  
let nuprl_to_mp_var_term term =
  let v = dest_var term in
  make_term (imp_implementation_op
	     [(make_parameter_list_parameter (map make_string_parameter ["var"]));
	      (make_variable_parameter v)])
            nil  
;;

let mp_to_nuprl_apply_term term =
  (let ([p1], [([],f); ([],b)]) = dest_term_with_opid `!metaprl_implementation` term in
     (mk_apply_term f b)) ?

      term
;;

let nuprl_to_mp_apply_term term =
  let (f,v) = dest_apply term in
  make_term (imp_implementation_op
	     [(make_parameter_list_parameter (map make_string_parameter ["apply"]));	      
	     ])
	    [(nil, f); (nil, v)]
        
;;
let is_mp_var_term term =
  (let [p1; p2],[] = dest_term_with_opid `!metaprl_implementation` term in
  let v = destruct_variable_parameter p2 in
  let [p3] = destruct_parameter_list_parameter p1 in
  let s = destruct_string_parameter p3 in
  s = "var")
  ? false
;;
  
let is_mp_apply_term term =
  (let [p1], [t1; t2] = dest_term_with_opid `!metaprl_implementation` term in
  let [p2] = destruct_parameter_list_parameter p1 in
  let s = destruct_string_parameter p2 in
  s = "apply")
  ? false
;;
    
let mp_to_nuprl_term term =
  if is_mp_apply_term term then mp_to_nuprl_apply_term term
  else if is_mp_var_term term then mp_to_nuprl_var_term term
  else fail
;;
	      
let nuprl_to_mp_term term =
  if is_apply_term term then nuprl_to_mp_apply_term term
  else if is_variable_term term then nuprl_to_mp_var_term term
  else fail
;;

let mp_string_to_nuprl_var_term term =
  let [p1; p2],() = dest_term_with_opid `!metaprl_implementation` term in
  let s = destruct_string_parameter p2 in
  mk_var_term (tok_to_var (string_to_tok s))
;;
	
let nuprl_map_var term =
  map_term_bottom_up is_mp_var_term mp_to_nuprl_var_term term
;;
  
let nuprl_map_apply term =
  map_term_bottom_up is_mp_apply_term mp_to_nuprl_apply_term term
;;


let mp_quit_loop = make_term (`!quit_loop`, nil) nil;;

let mp_eval_command term = orb_eval_command_to_term `ANY` metaprl_refiner_description_term term;;%lal changed from one to any%

let mp_add a b =
  number_of_inatural_term
    (mp_eval_command (make_term (`!test_add`, [])
			    [[], inatural_term a; [], inatural_term b]))
;;


let mp_quit (():unit) = mp_eval_command mp_quit_loop;;
			     
%let jp_quit (():unit) = orb_eval_command_to_term `ANY` jprover_refiner_description_term mp_quit_loop;;%
