
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

#-(or dontinline dontinlinerefi)
(eval-when (compile)
  (proclaim '(inline
	      lhs-of-let rhs-of-let
	      syntax-directives-of-let
	      goal-of-primitive-rule-definition
	      rule-of-primitive-rule-definition
	      let-of-primitive-rule-definition
	      subgoals-of-primitive-rule-definition
	      input-constraints-of-primitive-rule-definition
	      arg-syntax-of-primitive-rule-definition
	      call-lisp-syntax-of-primitive-rule-definition
	      unhide-assums-of-primitive-rule-definition-p
	      hidden-propagation-of-primitive-rule-definition
	      hidden-error-of-primitive-rule-definition
	      call-lisp-args-of-primitive-rule-definition
	      primitive-rule-definition-overwrite-p
	      arg-syntax-of-primitive-rule
	      call-lisp-syntax-of-primitive-rule
	      ;;variable-assumption-p
	      ;;variable-subgoals-p
	      ;;id-of-variable-subgoals
	      ;;refiner-variable-term-p
	      ;;hide-assumption
	      ;;unhide-assumption
	      ;;satisfies-apriori-constraint
	      ;;refiner-lookup
	      ;;refiner-lookup-term
	      ;;refiner-lookup-binding
	      ;;refiner-match-hidden-assumption
	      refiner-hidden-id-p
	      ;;refiner-hidden-variables
	      ;;refiner-bind
	      ;;delay-substitution-match
	      ;;delay-occurs-free-check
	      ;;;refiner-binding-match
	      ;;refiner-assumption-match
	      ;;refiner-rule-match
	      assumption-index-terms-of-rule
	      ;;refiner-instantiate-binding
	      ;;refiner-instantiate-assumption
	      id-of-subbend
	      ;;semantic-unhide-check
	      ;;refiner-instantiate-child
	      ;;pick-assumption
	      get-first-arg-value
	      get-second-arg-value
	      get-third-arg-value
	      get-fourth-arg-value
	      )))


;; RLE TODO  lib-rule check / rule translation??
;; RLE NAP make changes to support args directly in interpreter
;;  and to accept new rule def syntac.

;;; RLE PERF require rule to be refreshed when function executable changed then
;;;	do not need to look up function at runtime.

;;; RLE PERF	may be able to do a little tuning with checking free vars at runtime by
;;; RLE PERF	looking at rule def.



;;;	RLE NAP  could be cleaned up in conjuction with cleaning up
;;;	RLE NAP	 primitive-rule defs. In particular, lib
;;;	RLE NAP	 checks syntax, so we need only translate here.


;;;
;;;	ref-import-rule-def : translate to internal representation.
;;;
;;;



;;;;
;;;;	Operators of rule interpreter syntax not used in rule source syntax.
;;;;

;;;
;;;  primitive rule definition.
;;;

;;;	RLE NAP  could be cleaned up in conjuction with cleaning up
;;;	RLE NAP	 rule interpreter.


(defstruct (primitive-rule-definition (:include rule-specification))
  goal					; initialized at scan time
  rule
  let
  subgoals
  input-constraints			; at definition validation
  arg-syntax
  unhide-assums-p
  hidden-propagation
  hidden-error
  overwrite
  source)


;; let x:(A->B) = t,
;;     J, x:(A->B), K = H ;
;; let t = x:(A->B)  ;no
;; let subgoals = lisp(arith) 


(defstruct rule-let
  (lhs nil)
  (rhs nil)
  (syntax-directives))


(defun lhs-of-let (let)
  (rule-let-lhs let))

(defun rhs-of-let (let)
  (rule-let-rhs let))

(defun syntax-directives-of-let (let)
  (rule-let-syntax-directives let))

(defun goal-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-goal rule-def))

(defun rule-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-rule rule-def))

(defun let-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-let rule-def))

(defun subgoals-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-subgoals rule-def))

(defun input-constraints-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-input-constraints rule-def))

(defun arg-syntax-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-arg-syntax rule-def))

(defun call-lisp-syntax-of-primitive-rule-definition (def)
  (when (and (let-of-primitive-rule-definition def)
	     (icall-lisp-term-p
	      (rhs-of-let (let-of-primitive-rule-definition def))))
      (syntax-directives-of-let (let-of-primitive-rule-definition def))))

(defun unhide-assums-of-primitive-rule-definition-p (rule-def)
  (primitive-rule-definition-unhide-assums-p rule-def))

(defun hidden-propagation-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-hidden-propagation rule-def))

(defun hidden-error-of-primitive-rule-definition (rule-def)
  (primitive-rule-definition-hidden-error rule-def))

(defun call-lisp-args-of-primitive-rule-definition (def)
  (when (let-of-primitive-rule-definition def)
    (when (icall-lisp-term-p
	   (rhs-of-let (let-of-primitive-rule-definition def)))
      (lhs-of-let (let-of-primitive-rule-definition def)))))

(defun primitive-rule-definition-overwrite-p (rule-def)
  (primitive-rule-definition-overwrite rule-def))



(defun arg-syntax-of-primitive-rule (rule)
  (arg-syntax-of-primitive-rule-definition (definition-of-rule rule)))

(defun call-lisp-syntax-of-primitive-rule (rule)
  (call-lisp-syntax-of-primitive-rule-definition (definition-of-rule rule)))


;;; utilities.


;; substitution-assumption : H[t/x] ... >> C
(defun substitution-assumption-p (assum)
  (and (term-p assum)
       (or (and (iold-subst-term-p assum)
		(variable-p (subbee-of-iold-subst-term assum)))
	   (and (isubst-term-p assum)
		(variable-p (term-of-isubst-term assum))))))

;; variable-assumption : H, x:t, J >> C
;; H and J are variable-assumptions
(defun variable-assumption-p (assum)
  (or (substitution-assumption-p assum)
      (and (term-p assum)
	   (variable-p assum))))

(defun id-of-variable-assumption (assum)
  (if (variable-p assum)
      (id-of-variable-term assum)
      (if (iold-subst-term-p assum)
	  (id-of-variable-term (subbee-of-iold-subst-term assum))
	  (id-of-variable-term (term-of-isubst-term assum)))))


;; trivial assumptions : H >> C
(defun trivial-assumptions-p (assumptions)
  (and (null (cdr assumptions))
       (car assumptions)
       (term-p (car assumptions))
       (variable-p (car assumptions))))

;; H >> C
;;    by r;
;;   Let S = CallLisp(foo);
;;  S
(defun variable-subgoals-p (subgoals)
  (and (term-p subgoals)
       (variable-p subgoals)))

(defun id-of-variable-subgoals (subgoals)
  (id-of-variable-term subgoals))

(defun refiner-variable-term-p (term)
  (and (variable-p term)
       (not (abstraction-meta-parameter-p
	     (car (parameters-of-operator (operator-of-term term)))))))


(defun hide-assumption (assum)
  (if (hidden-assumption-p assum)
      assum
      (instantiate-assumption (assumption-id assum)
			      (assumption-type assum)
			      t)))

(defun unhide-assumption (assum)
  (if (hidden-assumption-p assum)
      (instantiate-assumption (assumption-id assum)
			      (assumption-type assum)
			      nil)
      assum))


(defstruct sequent-template
  assumptions
  conclusion
  extract)


(defun term-to-assumption (term)
  (if (variable-assumption-p term)
      term
      (if (not (iassumption-term-p term))
	  (ref-error '(assumption term) term)
	  (instantiate-assumption (id-of-iassumption-term term)
				  (type-of-iassumption-term term)
				  (hidden-of-iassumption-term term)))))


(defun term-to-sequent (term)
  (if (not (isequent-term-p term))
      (ref-error '(sequent term) term)
      (make-sequent-template
       :assumptions (map-isexpr-to-list (assumptions-of-isequent-term term)
					(iassum-cons-op)
					#'term-to-assumption)
       :conclusion (conclusion-of-isequent-term term)
       :extract (extract-of-isequent-term term))))


(defun term-to-rule-let (term)
  (cond
    ((inil-term-p term) nil)
    ((ilet-term-p term)
     (make-rule-let :lhs (map-isexpr-to-list (lhs-of-ilet-term term)
					     (irule-arg-cons-op))
		    :rhs (rhs-of-ilet-term term)))
    (t (ref-error '(let term) term))))


(defun term-to-primitive-rule (term)
  (if (not (irule-term-p term))
      (ref-error '(rule term) term)
      (make-primitive-rule
       :args (mapcan #'(lambda (term)
			 (if (ibound-id-term-p term)
			     (nconc (mapcar #'variable-term
					    (bindings-of-term-of-ibound-id-term term))
				    (list (term-of-ibound-id-term term)))
			     (list term)))
		     (map-isexpr-to-list (args-of-irule-term term)
					 (irule-arg-cons-op))))))


;;; RLE TODO do away with constraints by noting that input comes from trusted sources, ie
;;; either ML or call functions.
(defstruct apriori-constraint
  (id nil)
  (satisfaction-f #'(lambda (value) (declare (ignore value)) nil)))

;; if satisfying value is nil, ie as it could be with an assumption-list
;; constraint then these scheme fails.
(defun satisfies-apriori-constraint (constraint value)
  (with-handle-error (() (ref-error '(match constraint)))
    (funcall (apriori-constraint-satisfaction-f constraint) value)))


;; theres a hack here in that the assumptions are not marshalled/unmarshalled into terms.
(defun assumption-list-constraint ()
  (make-apriori-constraint
   :id 'assumption-index
   :satisfaction-f #'(lambda (value)  value)))

(defun subgoal-constraint ()
  (make-apriori-constraint
   :id 'subgoal
   :satisfaction-f
   #'(lambda (value)
       ;;(unless (and (listp value)
       ;;(forall-p #'vectorp value))
       ;;(break "pfft"))
       value)))


(defun ref-import-rule-definition (term)
  
  (let ((def (make-primitive-rule-definition)))
    (provide-rule-spec def term)

      
    ;;(definition-of-irule-specification-wdef-term (spec-of-rule-specification def))
    ;; at some point want this to be spec. if some other source translation defined
    ;; then this bombs.
    (let ((term (term-of-substance (substance-of-definition def 'rule-substance))))
      (if (not (irule-definition-term-p term))
	  (ref-error '(import rule) term)

	  (progn
	    (setf

	     (primitive-rule-definition-goal def)
	     (term-to-sequent (goal-of-irule-definition-term term))

	     (primitive-rule-definition-rule def)
	     (term-to-primitive-rule (rule-of-irule-definition-term term))
		      
	     (primitive-rule-definition-let def)
	     (term-to-rule-let (let-of-irule-definition-term term))
		      
	     (primitive-rule-definition-subgoals def)
	     (if (variable-p (subgoals-of-irule-definition-term term))
		 (subgoals-of-irule-definition-term term)
		 (map-isexpr-to-list (subgoals-of-irule-definition-term term)
				     (isubgoal-cons-op)
				     #'term-to-sequent)))

	    (setf (rule-definition-name def) (id-of-irule-term  (rule-of-irule-definition-term term))
		  (rule-definition (rule-of-primitive-rule-definition def)) def)

	    (validate-rule-definition def)
	    def)))))


(defun hidden-of-primitive-rule-definition (def)
  (labels
    ((occurs-p (v term)
       (or (exists-p #'(lambda (parameter)
		     (and (variable-parameter-p parameter)
			  (eql v (value-of-parameter-m parameter))))
		 (parameters-of-operator (operator-of-term term)))
	   (exists-p #'(lambda (bound-term)
		     (or (member v (bindings-of-bound-term-r bound-term))
			 (occurs-p v (term-of-bound-term bound-term))))
		 (bound-terms-of-term term))))

     (do-child (child)
       (or (null (sequent-template-extract
		  (goal-of-primitive-rule-definition def)))
	   (null (sequent-template-extract child))
	   (axiom-term-p (sequent-template-extract child))
	   (not (occurs-p (id-of-variable-term
			   (sequent-template-extract child))
			  (sequent-template-extract
			   (goal-of-primitive-rule-definition def)))))))

    ;; it's up to the producer of the subgoals to unhide assumptions
    ;; when subgoals are variable.
    (unless (variable-subgoals-p (subgoals-of-primitive-rule-definition def))
      (mapcar #'do-child
	      (subgoals-of-primitive-rule-definition def)))))


(defun validate-rule-definition (def)

  ;; Check Syntactic Types of meta-variables.
  (type-check-rule-def def)

  ;; Check that all variables occuring in InstantiationRegions are bound
  ;; in MatchRegions.
  (validate-occurences def)

  (setf (primitive-rule-definition-unhide-assums-p def)
	(hidden-of-primitive-rule-definition def))

  (let ((extract (sequent-template-extract (goal-of-primitive-rule-definition def)))
	(subgoals (subgoals-of-primitive-rule-definition def)))
    (when (and (not (variable-subgoals-p subgoals))
	       (= 1 (length subgoals))
	       (or (null extract)
		   (axiom-term-p extract)
		   (and (variable-p extract)
			(equal-terms-p extract (sequent-template-extract (car subgoals))))))
      (setf (primitive-rule-definition-overwrite def) t))))




(defun type-check-rule-def (def)
  (with-backtrace "TypeCheckRuleDefinition"
    (with-variable-invocation

      ;; annotate variables with usage.
      (annotate-rule-definition def)

      (setf (primitive-rule-definition-hidden-error def)
	    (create-hidden-error-list def))

      ;; update syntax to reflect usage.
      (fixup-rule-definition def))))



(defun assumption-index-terms-of-rule (rule)
  (mapcan #'(lambda (arg)
	      (when (assumption-index-term-p arg)
		(list arg)))
	  (args-of-primitive-rule rule)))


;;;
;;; Annotate-Rule-Definition : rule-definition 
;;;
;;;  - marks meta-variables in rule-definition with their types.
;;;  - marks those meta-variables within pick goal assumptions.
;;;
;;; uses variable-invocation
;;;  

(defun annotate-rule-definition (def)
  (labels
      ((validate-type (var type)
	 (let ((old-type (markv var 'type type)))
	   (unless (or (null old-type)
		       (eql old-type type))
	     (raise-error (error-message (list 'rule-definition 'type-check
					       (intern-system (string var)) type old-type))))))

       (validate-binding (var)
	 (let ((old-type (markv var 'type 'binding)))
	   (unless (or (null old-type)
		       (eql old-type 'binding)
		       (eql old-type 'term))
	     (raise-error (error-message (list 'rule-definition 'type-check
					       (intern-system (string var)) 'binding old-type))))))
    
       (visit-variable-of-term (var)
	 (let ((old-type (markv-value var 'type)))
	   (unless (eql old-type 'binding)
	     (validate-type var 'term))))

       (visit-parameter (parameter)
	 (let ((value (value-of-parameter-m parameter)))
	   (when (abstraction-meta-variable-id-p value)
	     (if (variable-type-p (type-of-parameter parameter))
		 (validate-binding (get-variable-id value))
		 (validate-type value (type-id-of-parameter parameter))))))

       (visit-term (term)
	 (if (refiner-variable-term-p term)
	     (visit-variable-of-term (id-of-variable-term term))
	     (mapcar #'visit-parameter
		     (parameters-of-operator (operator-of-term term))))
	 (mapcar #'visit-bound-term
		 (bound-terms-of-term term)))

       (visit-assumption (assumption)
	 (if (variable-assumption-p assumption)
	     (validate-type (id-of-variable-assumption assumption)
			    'assumption-list)
	     (progn
	       (validate-binding (assumption-id assumption))
	       (visit-term (assumption-type assumption)))))
	
       (visit-bound-term (bound-term)
	 (mapc #'(lambda (var) (validate-binding var))
	       (bindings-of-bound-term-r bound-term))
	 (visit-term (term-of-bound-term bound-term)))
		       
       (visit-sequent (seq)
	 (mapc #'visit-assumption (sequent-template-assumptions seq))
	 (visit-term (sequent-template-conclusion seq))
	 (when (sequent-template-extract seq)
	   (visit-term (sequent-template-extract seq))))

       (visit-args (args)
	 (mapc #'(lambda (arg)
		   (cond
		     ((variable-p arg) nil)
		     ((term-p arg) (visit-term arg))
		     ((bound-term-p arg) (visit-bound-term arg))))
	       args))

       (revisit-goal-assumptions (assumptions rule)
	 ;; H, x:t, J, K, y:s, a:r, L
	 ;;    i     j    k    k+1
	 (let ((l (do ((i 0)
		       (assums assumptions))
		      ((null assums) i)
		    (if (variable-assumption-p (car assums))
			(progn (setf assums (cdr assums))
			       (when (variable-assumption-p (car assums))
				 (incf i)))
			(progn (incf i)
			       (setf assums (cdr assums)))))))
	   (unless (= l (length (assumption-index-terms-of-rule rule)))
	       (raise-error (error-message '(rule-definition assumption indices)
					   (princ-to-string l)
					   (princ-to-string (length (assumption-index-terms-of-rule rule)))))))))


   (visit-sequent (goal-of-primitive-rule-definition def))

   (visit-args
    (args-of-primitive-rule (rule-of-primitive-rule-definition def)))
     
   (when (let-of-primitive-rule-definition def)
     (visit-args (lhs-of-let (let-of-primitive-rule-definition def))))
    
   (if (variable-subgoals-p (subgoals-of-primitive-rule-definition def))
       (validate-type (id-of-variable-term
		       (subgoals-of-primitive-rule-definition def))
		      'subgoals)
       (mapc #'visit-sequent (subgoals-of-primitive-rule-definition def)))
       
   (revisit-goal-assumptions (sequent-template-assumptions 
			      (goal-of-primitive-rule-definition def))
			     (rule-of-primitive-rule-definition def))))


;;; error if instantiation of variable contains free variables which are
;;; hidden.

;;; list of term variables which are not subgoal extracts, but occur in main goal extract.
;;; 
;;;;	
;;;;	To ensure that no hidden id occurs in the extract, the interpreter must
;;;;	check that all terms bound to !term{v} operators occuring free in the
;;;;	extract do not contain free occurences of hidden ids at refinement time.
;;;;
;; rle tode this is wrong if there is a bound variable in the extract template.
;; however is it wrong to have a bound var in extract template.?? in so fix above doc.
(defun create-hidden-error-list (def)
  (let ((subgoal-extracts nil)
	(result nil))
    (labels
	((visit (term)
	   (cond
	     ;; funky like this to catch case where var is meta variable id.
	     ((and (eql *variable* (id-of-term term))
		   (null (bound-terms-of-term term))
		   (let ((parameters (parameters-of-term term)))
		     (and parameters
			  (null (cdr parameters)))))
	      (let ((v (get-variable-id (id-of-variable-term term)) ))
		(unless (member v subgoal-extracts)
		  (pushnew v result))))
	     (t (dolist (bound-term (bound-terms-of-term term))
		  (visit (term-of-bound-term bound-term)))))))
	       
      (unless (variable-subgoals-p (subgoals-of-primitive-rule-definition def))
	(dolist (child (subgoals-of-primitive-rule-definition def))
	  (when (and (sequent-template-extract child)
		     (not (axiom-term-p (sequent-template-extract child))))
	    (pushnew (id-of-variable-term (sequent-template-extract child))
		     subgoal-extracts)))

	(when (sequent-template-extract (goal-of-primitive-rule-definition def))
	  (visit (sequent-template-extract
		  (goal-of-primitive-rule-definition def)))))

      result)))


;; map some variable occurences to parameter variables.
;; build input constraints.
(defun fixup-rule-definition (def)
  (labels

      ((variable-constrained-to-binding-p (var)
	 (eql (markv-value var 'type) 'binding))

       (variable-unconstrained-p (var)
	 (null (markv-value var 'type)))

       (variable-constrained-to-term-p (var)
	 (eql (markv-value var 'type) 'term))

       (variable-constrained-to-assumption-list-p (var)
	 (eql (markv-value var 'type) 'assumption-list))

       (variable-constrained-to-assumption-index-p (var)
	 (eql (markv-value var 'type) 'assumption-index))

       (constrained-parameter-type-of-variable (var)
	 (markv-value var 'type))

       (variable-constrained-to-subgoals-p (var)
	 (eql (markv-value var 'type) 'subgoals))

       ;; meta variables used as subgoals may occur only as subgoals and
       ;; in lets. (restriction h).
       (check-arg-subgoal-error (arg)
	 (when (and (variable-p arg)
		    (variable-constrained-to-subgoals-p (id-of-variable-term arg)))
	   (raise-error (error-message '(rule-interpreter subgoal instantiate)))))

       (build-input-constraints (x)
	 (when (variable-p x)
	   (let ((v (id-of-variable-term x)))
	     (cond ((variable-constrained-to-subgoals-p v)
		    (list (cons v (subgoal-constraint))))
		   ((variable-constrained-to-assumption-list-p v)
		    (list (cons v (assumption-list-constraint)))) )))))

    (let ((rule (rule-of-primitive-rule-definition def))
	  (let (let-of-primitive-rule-definition def)))

      ;; check for type errors.
      (dolist (arg (args-of-primitive-rule rule))
	(check-arg-subgoal-error arg))

      ;; build input constraints.
      (setf (primitive-rule-definition-input-constraints def)
	    (nconc (mapcan #'build-input-constraints
			   (args-of-primitive-rule rule))
		   (when (and let (icall-lisp-term-p (rhs-of-let let)))
		     (mapcan #'build-input-constraints
			     (lhs-of-let let))))))))



;;;;
;;;;  The rule definition can be validated to insure that all
;;;;  InstantiationOccurences are also MatchOccurences.
;;;;
;;;;
;;;; Refinement MatchRegion : goal sequent, rule args, and let clauses.
;;;; Refinement InstantiationRegion : child sequents.
;;;; Extraction MatchRegion : goal sequent, rule args, let clauses, 
;;;;			  and child extracts.
;;;; Extraction InstantiationRegion : goal extract.
;;;;


(defun validate-occurences (def)

  (labels
    ((err-r (var)
       (unless (or (dummy-variable-id-p var)
		   (variable-minor-use-p var))
	 (raise-error (error-message '(rule-definition unbound)  (intern-system (string var))))))

     (visit-variable (var)
       (unless (dummy-variable-id-p var)
	 (set-variable-minor-use var)))
     
     (visit-parameter (parameter)
       (let ((value (value-of-parameter-m parameter)))
	 (when (abstraction-meta-variable-id-p value)
	   (if (variable-type-p (type-of-parameter parameter))
	       (visit-variable (get-variable-id value))
	       (visit-variable value)))))

     (visit-term (term)
       (if (refiner-variable-term-p term)
	   (visit-variable (id-of-variable-term term))
	   (mapcar #'visit-parameter
		   (parameters-of-operator (operator-of-term term))))
       (mapcar #'visit-bound-term
	       (bound-terms-of-term term)))

     (visit-bound-term (bound-term)
       (mapc #'(lambda (var) (visit-variable var))
	     (bindings-of-bound-term-r bound-term))
       (visit-term (term-of-bound-term bound-term)))
		       
     (visit-assumption (assumption)
       (if (variable-assumption-p assumption)
	   (visit-variable (id-of-variable-assumption assumption))
	   (progn
	     (visit-variable (assumption-id assumption))
	     (visit-term (assumption-type assumption)))))

     (visit-sequent (seq)
       (mapc #'visit-assumption (sequent-template-assumptions seq))
       (visit-term (sequent-template-conclusion seq)))

     (visit-args (args)
       (mapc #'(lambda (arg)
		 (cond
		   ((term-p arg) (visit-term arg))
		   ((bound-term-p arg) (visit-bound-term arg))
		   ((or (variable-id-p arg)
			(meta-variable-id-p arg))
		    (visit-variable arg))))
	     args))

     (parameter-visited-r (parameter)
       (let ((value (value-of-parameter-m parameter)))
	 (when (abstraction-meta-variable-id-p value)
	   (if (variable-type-p (type-of-parameter parameter))
	       (err-r (get-variable-id value))
	       (err-r value)))))

     (term-visited-r (term)
       (if (refiner-variable-term-p term)
	   (err-r (id-of-variable-term term))
	   (mapcar #'parameter-visited-r 
		   (parameters-of-operator (operator-of-term term))))
       (mapcar #'bound-term-visited-r
	       (bound-terms-of-term term)))

     (bound-term-visited-r (bound-term)
       (mapc #'(lambda (var) (err-r var))
	     (bindings-of-bound-term-r bound-term))
       (term-visited-r (term-of-bound-term bound-term)))
		       
     (assumption-visited-r (assumption)
       (cond
	 ((substitution-assumption-p assumption)  ;; substitution -> variable
	  (err-r (id-of-variable-assumption assumption))
	  (mapcar #'bound-term-visited-r
		  (subbends-of-iold-subst-term assumption)))
	 ((variable-assumption-p assumption)
	  (err-r (id-of-variable-assumption assumption)))
	 (t (err-r (assumption-id assumption))
	    (term-visited-r (assumption-type assumption)))))

     (sequent-visited-r (seq)
       (mapc #'assumption-visited-r (sequent-template-assumptions seq))
       (term-visited-r (sequent-template-conclusion seq)))

     (children-visited-r (subgoals)
       (if (variable-subgoals-p subgoals)
	   (err-r (id-of-variable-subgoals subgoals))
	   (mapc #'sequent-visited-r subgoals)))
     )

    (let ((rule (rule-of-primitive-rule-definition def))
	  (let (let-of-primitive-rule-definition def))
	  (subgoals (subgoals-of-primitive-rule-definition def)))
      
      (with-variable-minor-invocation
	;; visit match regions
	(visit-sequent (goal-of-primitive-rule-definition def))
	(visit-args (args-of-primitive-rule rule))

	;; interleave match and instantiation of let clauses.
	(when let
	  (term-visited-r (rhs-of-let let))
	  (visit-args (lhs-of-let let)))

	;; visit instantiation regions
	(children-visited-r subgoals)

	;; visit subgoal extracts.
	(unless (variable-subgoals-p subgoals)
	  (mapc #'(lambda (subgoal) 
		    (when (and (sequent-template-extract subgoal)
			       (not (axiom-term-p (sequent-template-extract subgoal))))
		      (unless (variable-p (sequent-template-extract subgoal))
			(raise-error (error-message '(rule-definition subgoal extract) subgoal)))
		      (visit-term (sequent-template-extract subgoal))))
		subgoals))

	(when (sequent-template-extract
	       (goal-of-primitive-rule-definition def))
	  (term-visited-r (sequent-template-extract
			    (goal-of-primitive-rule-definition def))))))))




;;;
;;;	Interpeter.
;;;
(defvar *ref-interpreter-long-error-p* nil)
(defvar *ref-interpretor-short-err* nil)

(defmacro ref-error (tags &rest rest)
  `(if *ref-interpreter-long-error-p*
    (raise-error (error-message (cons 'ref-interpreter ,tags) ,@rest))
    (raise-error (or *ref-interpretor-short-err*
		  (setf *ref-interpretor-short-err* (error-message '(ref-interpreter))))))) 

(defmacro ref-match-error (tags &rest rest)
  `(if *ref-interpreter-long-error-p*
    (raise-error (error-message (cons 'ref-interpreter (cons 'match ,tags)) ,@rest)) 
    (raise-error (or *ref-interpretor-short-err*
		  (setf *ref-interpretor-short-err* (error-message '(ref-interpreter)))))))
  

(defvar *rule-interpreter-environment* nil)

;; RLE PERF. results in suprising amount of consing. Is there an alternative? hash table/ reusable arrays?
;; could compute max by looking at rule defs! and then have reusable arrays.
;; could even assign indices to vars (!rule_var{n}) in defs so no search necessary.
;; could create vars in special package and assign values.
(defun update-environment (var value)
  (setf *rule-interpreter-environment*
	(acons var value *rule-interpreter-environment*)))

(defun refiner-lookup (id)
  (cdr (assoc id  *rule-interpreter-environment*)))

(defun refiner-lookup-term (id)
  (let ((val (refiner-lookup id)))
    (cond ((dummy-variable-id-p val)
	   (ref-error '(instantiate dummy)))
	  ((variable-id-p val) (variable-term val))
	  (t val))))

(defun refiner-lookup-binding (var)
  (let ((val (refiner-lookup var)))
    (cond
      ((variable-id-p val) val)
      ((variable-p val) (id-of-variable-term val))
      (t ;;(break "riu")
	 (system-error (error-message '(ref-interpreter unbound)))))))


(defmacro with-rule-interpreter-environment ((apriori-constraints) &body body)
  `(unwind-protect
       (let ((*rule-interpreter-environment* ,apriori-constraints)
	     (*refiner-hidden* nil))
	 (declare (special *refiner-hidden*))
	 ,@body)))


(defun refiner-match-hidden-assumption (id)
  (declare (special *refiner-hidden*))
  (push id *refiner-hidden*))

(defun refiner-hidden-id-p (id)
  (declare (special *refiner-hidden*))
  (member id *refiner-hidden*))

(defun refiner-hidden-variables ()
  (declare (special *refiner-hidden*))
  *refiner-hidden*)

(defun refiner-bind (var bindee)
  (let ((value (refiner-lookup var)))
    (cond
      ((apriori-constraint-p value)
       ;; fails otherwise, if constraint not satisfied.
       (update-environment var (satisfies-apriori-constraint value bindee)))

      (value
       (refiner-equals value bindee))

      (t (update-environment var bindee)))))



;;;
;;; equality
;;;

(defun refiner-equals (x y)
  (cond
    ((and (term-p x) (term-p y))
     (when (not (equal-terms-p x y))
       ;;(break "ref eqs")
       (ref-match-error '(term) x y)))
    
    ((and (parameter-p x) (parameter-p y))
     (when (not (equal-parameters-p x y))
       (ref-match-error '(parameter)
			(iparameter-term x)
			(iparameter-term y))))

    ((and (variable-id-p x) (term-p y) (variable-p y))
     (when (not (eql x (id-of-variable-term y)))
       (ref-match-error '(variable) x y)))

    ((and (variable-id-p y) (term-p x) (variable-p x))
     (when (not (eql y (id-of-variable-term x)))
       (ref-match-error '(variable) x y)))

    ((eql x y) t)

    (t (ref-match-error '(otherwise)))))

    

;;;;
;;;;   Matching.
;;;;

(defvar *refiner-delay*)
(defvar *refiner-delayed-substitution-matches*)

(defun delay-substitution-match (template term)
  (push (cons 'substitution (cons template term)) *refiner-delay*))
;  (push (cons template term) *refiner-delayed-substitution-matches*)

;; RLE PERF does fair amount of consing.
(defun delay-occurs-free-check (id template-term)
  (push (cons 'occurs-free (cons id template-term)) *refiner-delay*))

(defmacro with-delay (&body body)
  `(let ((*refiner-delay* nil))
    ,@body
    (dolist (delay *refiner-delay*)
      (case (car delay)
	(substitution
	 (let ((term (refiner-instantiate-term (cadr delay))))
	   (unless (equal-terms-p term (cddr delay))
	     (ref-match-error '(term substitution) term (cddr delay)))))

	;; RLE PERF may be possible not to delay check so long. ie bail out quicker.
	(occurs-free
	 (let ((term (refiner-instantiate-term (cddr delay))))
 	 (when (occurs-free-p (cadr delay) term)
	   (ref-match-error '(occurs) (cadr delay) term))))))))

;;;
;;; Structure Matching
;;; 

;;; dummy variables only match dummy variables
;;; If dummy in bound term then implies an occurs free check which
;;; circumvents this match.
(defun refiner-binding-match (template instance)
  (if (dummy-variable-id-p template)
      (unless (dummy-variable-id-p instance)
	(ref-match-error '(dummy) instance))
      (refiner-bind template instance))
  t)

(defun refiner-assumption-match (template instance)
  (when (and (hidden-assumption-p template)
	     (not (hidden-assumption-p instance)))
      (ref-match-error '(assumption not-hidden)))
  (refiner-binding-match (assumption-id template) (assumption-id instance))
  (refiner-term-match (assumption-type template) (assumption-type instance)))


(defun refiner-parameter-match (template instance)
  (unless (equal-types-p (type-of-parameter template) (type-of-parameter instance))
    (ref-match-error '(parameter type)
		     (type-id-of-parameter template)
		     (iparameter-term instance)))
  
  (with-backtrace "Refiner Parameter Match"
    (let ((value (value-of-parameter-m template)))
      (if (or (abstraction-meta-variable-id-p value)
	      (and (level-expression-parameter-p template)
		   (level-variable-p value)))
	(refiner-bind value instance)
	(unless (equal-real-parameter-values value
					     (value-of-parameter-r instance)
					     (parameter-type template))
	  (ref-match-error '(parameter value)
			   (iparameter-term template)
			   (iparameter-term instance))))))
  t)


(defun refiner-bound-term-match (template instance)
  (unless (apply-predicate-to-list-pair-optimized
	   (bindings-of-bound-term-r template)
	   (bindings-of-bound-term-r instance)
	   (lambda (binding-template binding-instance)
	     (if (dummy-variable-id-p binding-template)
		 (delay-occurs-free-check binding-instance
					  (term-of-bound-term template))
		 (refiner-binding-match binding-template binding-instance))))
    (ref-match-error '(bindings)
		     (bindings-of-bound-term-n template)
		     (bindings-of-bound-term-n instance)))
  (refiner-term-match (term-of-bound-term template)
		      (term-of-bound-term instance))
  t)


(defun refiner-term-match (template instance)
  ;;(when (null instance) (break "tm"))
  (when (and (not (or (isubst-term-p template) (iold-subst-term-p template)
		      (refiner-variable-term-p template)))
	     (or (iparameter-term-p template) (iparameter-term-p instance))
	     (not (eql (id-of-operator (operator-of-term template))
		       (id-of-operator (operator-of-term instance)))))
    (setf tt template ii instance) ;;(format t "opid parameter match")
    )
  (let ((val (cond
	       ((isubst-term-p template)
		(delay-substitution-match template instance))

	       ((iold-subst-term-p template)
		(delay-substitution-match template instance))

	       ((refiner-variable-term-p template)
		(refiner-bind (id-of-variable-term template) instance)
		)

	       (t (unless (eql (id-of-operator (operator-of-term template))
			       (id-of-operator (operator-of-term instance)))
		    (unless (or (and (eql '|!parameter| (id-of-operator (operator-of-term template)))
				     (eql '|!level-expression| (id-of-operator (operator-of-term instance))))
				(and (eql '|!level-expression| (id-of-operator (operator-of-term template)))
				     (eql '|!parameter| (id-of-operator (operator-of-term instance)))))
				     
		      ;;(break "opid")
		      (ref-match-error '(opid)
				       (id-of-operator (operator-of-term template))
				       (id-of-operator (operator-of-term instance)))))
                   
		  (unless (apply-predicate-to-list-pair-optimized
			   (parameters-of-operator (operator-of-term template))
			   (parameters-of-operator (operator-of-term instance))
			   refiner-parameter-match)
		    (ref-match-error '(parameter-list) template instance))

		  (unless (apply-predicate-to-list-pair-optimized (bound-terms-of-term template)
							(bound-terms-of-term instance)
							refiner-bound-term-match)
		    (ref-match-error '(bound-terms) template instance))
		  t))))
    
    val))

;; no need to match rule-id to template as instance rule-id chose the template.
(defun refiner-rule-match (template instance)
  (unless (apply-predicate-to-list-pair (args-of-primitive-rule template)
					(args-of-primitive-rule instance)
					#'refiner-term-match)
    ;;(break)
    (ref-match-error '(rule))))

(defun refiner-hidden-check (vars hidden)
  (let ((err-vars (intersect-vars
		   (unionl-vars (mapcar #'(lambda (v)
					    (free-vars (refiner-lookup-term v)))
					vars))
		   hidden)))
    (when err-vars
      (ref-match-error '(hidden free) err-vars))))


;;;;
;;;;  Assumptions Match
;;;;


;; RLE TODO : assume strict increasing order, make sure assumptions match fails
;;  meaningfully in order is incorrect.
;; RLE TODO also ensure failure when 0 used to index non-variable assumption.
(defun assumption-indices-of-rule (rule)
  (sort	(mapcar #'(lambda (index-term)
		    (if (abstraction-meta-parameter-p (car (parameters-of-term index-term)))
			(value-of-parameter-m 
			 (refiner-lookup (index-of-assumption-index-term index-term)))
			(index-of-assumption-index-term index-term)))
		(assumption-index-terms-of-rule
		 (rule-of-primitive-rule-definition (definition-of-rule rule))))
	#'<))

;; It is assumed : number of non variable templates matches length of indices.
;;               : only called on goal assumptions.
(defun refiner-assumptions-match (templates instances indices)
  (labels
      ((assumptions-match (templates instances partial index indices pick-index)
	 (cond
	   ;; end.
	   ((and (null templates) (null instances) (null indices)))
    

	   ((and (car templates) (null (cdr templates)) (null indices))
	    (refiner-bind (id-of-variable-assumption (car templates))
			  instances)
	    nil)
	       
	   ;; match variable assumption.
	   ((and (variable-assumption-p (car templates))
		 (null instances))
	    (refiner-bind (id-of-variable-assumption (car templates))
			  (nreverse partial))
	    (assumptions-match (cdr templates) instances
			       nil index indices pick-index))

	   ;; match variable assumption.
	   ((and (variable-assumption-p (car templates))
		 indices
		 (= index (car indices)))
	    (if (variable-assumption-p (cadr templates))
		(progn
		  (refiner-bind (id-of-variable-assumption (car templates))
				(nreverse (cons (car instances) partial)))
		  (when (hidden-assumption-p (car instances))
		    (refiner-match-hidden-assumption
		     (assumption-id (car instances))))
		  (assumptions-match (cdr templates) (cdr instances)
				     nil (1+ index) (cdr indices) pick-index))
		(progn
		  (refiner-bind (id-of-variable-assumption (car templates))
				(nreverse partial))
		  (assumptions-match (cdr templates) instances
				     nil index indices pick-index))))

	   ;; partially match variable assumption.
	   ((variable-assumption-p (car templates))
	    (when (hidden-assumption-p (car instances))
	      (refiner-match-hidden-assumption (assumption-id (car instances))))
	    (assumptions-match templates (cdr instances)
			       (cons (car instances) partial)
			       (1+ index) indices pick-index))

	   ;; index out of range - null instances.
	   ;; more indices than templates -> null templates  (impossible)
	   ;; more templates than indices -> null indices    (impossible)
	   ((or (null instances) (null indices) (null templates))
	    (ref-match-error '(assumptions indices)))

	   ;; match chosen assumption.
	   ((= index (car indices))
	    (when (hidden-assumption-p (car instances))
	      (refiner-match-hidden-assumption (assumption-id (car instances))))
	    (refiner-assumption-match (car templates) (car instances))
	    (assumptions-match (cdr templates) (cdr instances)
			       nil (1+ index) (cdr indices) (1+ pick-index)))
    
	   ;; sequence error, ie two sequential assumptions to be matched
	   ;; but indices not sequential.
	   (t (ref-match-error '(assumptions))))))

    ;; do trivial case.
    (if (trivial-assumptions-p templates)
	(progn
	  (mapc #'(lambda (assum) 
		    (when (hidden-assumption-p assum)
		      (refiner-match-hidden-assumption (assumption-id assum))))
		instances)
	  (refiner-bind (id-of-variable-assumption (car templates))
			instances))
	(if (and indices (zerop (car indices))
		 (variable-assumption-p (car templates)))
	    (progn
	      (refiner-bind (id-of-variable-assumption (car templates))
			    nil)
	      (assumptions-match (cdr templates) instances
				 nil 1 (cdr indices) 1))
	    (assumptions-match templates instances nil 1 indices 1)))))


(defun refiner-eval-let (rhs proof-node rule)
  (cond
    ((icall-lisp-term-p rhs)
     (funcall (symbol-function (name-of-icall-lisp-term rhs))
	      proof-node
	      rule))
     (t (list (refiner-instantiate-term rhs)))))

(defun refiner-let-match (let proof-node rule)
  (if let
      (let ((rhs-instance-list (refiner-eval-let (rhs-of-let let) proof-node rule)))
	(apply-predicate-to-list-pair-optimized (lhs-of-let let)
						rhs-instance-list
						refiner-term-match)
	(if rhs-instance-list
	    (refined-primitive-rule rule rhs-instance-list)
	    rule))
      rule))

(defun extractor-let-match (let rule)
  (when (and let (lhs-of-let let))
    (let ((rhs-instance-list (results-of-refined-primitive-rule rule)))
      (apply-predicate-to-list-pair-optimized (lhs-of-let let)
					      rhs-instance-list
					      refiner-term-match))))


(defun semantic-unhide-check (concl)
  (member (id-of-operator (operator-of-term concl))
	  '#.(list *equal* *less-than* *void*))) ;; LAL


;; invariant assumptions and conclusion are well formed
(defun refiner-instantiate-child (template unhide-p)
  (let ((concl (refiner-instantiate-term
		(sequent-template-conclusion template))))
    (setf c concl)
    (setf a (refiner-instantiate-assumptions (sequent-template-assumptions template)
					     (or unhide-p
						 (semantic-unhide-check concl))))
    ;;(break "sh")
    (instantiate-sequent-r a concl)))

;; LAL
(defun my-print-term (term)
   (let ((l (operator-of-term term)))
      (cons l (mapcar #'my-print-term (mapcar #'term-of-bound-term-f (bound-terms-of-term term))))))

;;(defvar myi 0)

;;(defvar *proof* nil)
(defun refine-primitive-rule (proof-node rule)
  (let (;;(*process-break* nil)
	)

    (incf-rule-count)
    (when nil 
      (let ((ruleid (id-of-rule rule)))
	(when (or (eql ruleid '|quotientElimination|)
		  (eql ruleid '|quotientElimination_2|))
	(format t "~%;;;~%;;; ~a~%;;;~%;;;~%" ruleid))))
    ;;(format t "~s ~%~a %"  (conclusion-of-proof-node proof-node) (id-of-rule rule))
    ;;(incf myi)
    ;;(setf a proof-node b rule c (conclusion-of-proof-node proof-node))
    (when (equal (id-of-rule rule) '|arith|)
      ;;(break "a lemma")
      )
    ;;(break "myi")
  
    (let ((rule-def (definition-of-rule rule))
	  (result-rule nil))

      ;; superseded by primitive references
      ;;(dependency-note-quick-reference 'rule rule-def)

      (with-backtrace (id-of-rule-definition rule-def)

	(with-rule-interpreter-environment ((input-constraints-of-primitive-rule-definition rule-def))

    ;;; match
	  (with-delay

	      (refiner-term-match (sequent-template-conclusion
				   (goal-of-primitive-rule-definition rule-def))
				  (conclusion-of-proof-node proof-node))

	    (refiner-rule-match (rule-of-primitive-rule-definition rule-def)
				rule)

	    (refiner-assumptions-match (sequent-template-assumptions
					(goal-of-primitive-rule-definition rule-def))
				       (assumptions-of-proof-node proof-node)
				       (assumption-indices-of-rule rule))

	    (setf result-rule (refiner-let-match (let-of-primitive-rule-definition rule-def)
						 proof-node
						 rule))

	    ;; hidden check must follow match.
	    (refiner-hidden-check
	     (hidden-error-of-primitive-rule-definition rule-def)
	     (refiner-hidden-variables)))

	  ;; instantiation
	  (values result-rule
		  (if (variable-subgoals-p (subgoals-of-primitive-rule-definition rule-def))
		      (refiner-lookup
		       (id-of-variable-term 
			(subgoals-of-primitive-rule-definition rule-def)))
		      (mapcar #'refiner-instantiate-child;;LAL basic-message problem starts here
			      (subgoals-of-primitive-rule-definition rule-def)
			      (unhide-assums-of-primitive-rule-definition-p rule-def) ))))))))
	


;;;
;;;	instantiation
;;;

(defun refiner-instantiate-binding (template)
  (if (dummy-variable-id-p template)
      template
      (refiner-lookup-binding template)))


;; RLE PERF check this out to make sure not quadratic with subst terms.
(defun refiner-instantiate-term (template)
  (labels
    ((ref-instantiate-parameter (template)
       (let ((value (value-of-parameter-m template)))
	 (refiner-lookup value)))

     (ref-instantiate-operator (template)
       (if (exists-p #'(lambda (p)
			 (or (abstraction-meta-parameter-p p)
			     (and (level-expression-parameter-p p)
				  (level-variable-p (value-of-parameter-m p)))))
		     (parameters-of-operator template))
	   (instantiate-operator (id-of-operator template)
				 (mapcar #'ref-instantiate-parameter
					 (parameters-of-operator template)))
	   template))
     
     (ref-reduce-term (term)
       (cond
	 ;;old 
	 ((iold-subst-term-p term)
	  (substitute (subbee-of-iold-subst-term term)
		      (mapcar #'(lambda (subbend)
				  (cons (car (bindings-of-bound-term-r subbend))

					(term-of-bound-term subbend)))
			      (subbends-of-iold-subst-term term))))
	 ;; new
	 ((isubst-term-p term)
	  (let ((psubs nil)
		(tsubs nil)
		(target (term-of-isubst-term term)))

	    (map-isexpr (subs-of-isubst-term term) 
			(isub-cons-op)
			#'(lambda (term)
			    (cond
			      ((iparameter-sub-term-p term)
			       (let* ((parameters (parameters-of-term term))
				      (v (value-of-parameter-r (car parameters)))
				      (val (cadr parameters)))
				 (push (cons (if (level-expression-parameter-p val)
						 v
						 (get-abstraction-meta-variable-id v))
					     (cadr parameters)) psubs)))
			      ((iterm-sub-term-p term)
			       (push (cons (id-of-iterm-sub-term term)
					   (term-of-iterm-sub-term term))
				     tsubs))
			      (t (system-error (error-message '(ref-interpreter substitute)))))))
	    (cond
	      ((and (null psubs) (null tsubs))
	       target)
	      ((null tsubs)
	       (substitute-parameters-in-term target psubs))
	      ((null psubs)
	       (substitute target tsubs))
	      (t (substitute-parameters-in-term (substitute target tsubs) psubs)))))

	 (t term)))

     (ref-instantiate-term (template)
       (if (refiner-variable-term-p template)
	   (refiner-lookup-term (id-of-variable-term template))
	   (ref-reduce-term
	    (instantiate-term (ref-instantiate-operator (operator-of-term template))
			      (mapcar #'ref-instantiate-bound-term
				      (bound-terms-of-term template))))))

     (ref-instantiate-bound-term (template)
       (instantiate-bound-term (ref-instantiate-term (term-of-bound-term template))
			     (mapcar #'refiner-instantiate-binding
				     (bindings-of-bound-term-r template)))))

    (ref-instantiate-term template)))


(defun refiner-instantiate-assumption (template unhide-p)
  (let ((id (refiner-instantiate-binding (assumption-id template))))
    (instantiate-assumption id
			    (refiner-instantiate-term (assumption-type template))
			    (and (not unhide-p)
				 (or (hidden-assumption-p template)
				     (member id (refiner-hidden-variables)))))))

(defun substitute-into-assumption (assum subs unhide-p)
  (instantiate-assumption
   (or (find-first #'(lambda (sub)
		       (when (eql (assumption-id assum) (car sub))
			 (if (variable-p (cdr sub))
			     (id-of-variable-term (cdr sub))
			     (ref-match-error '(assumption substitute)))))
		   subs)
       (assumption-id assum))
   (substitute (assumption-type assum) subs)
   (unless unhide-p
     (hidden-assumption-p assum))))

(defun id-of-subbend (bound-term)
  (car (bindings-of-bound-term-r bound-term)))

(defun refiner-instantiate-variable-assumption (template unhide-p)
  (with-backtrace "InstantiateVariableAssumption" ;; LAL  put this in refiner-instantiate-assumption?already
		   ;; in backtrace, could be culprit of basic-message problem
    (if (substitution-assumption-p template)
	(let* ((ids (mapcar #'(lambda (subbend)
				(refiner-instantiate-binding
				 (id-of-subbend subbend)))
			    (subbends-of-iold-subst-term template)))
	       (terms (mapcar #'(lambda (subbend)
				  (refiner-instantiate-term
				   (term-of-bound-term subbend)))
			      (subbends-of-iold-subst-term template)))
	       (subs (mapcar #'(lambda (id term)
				 (cons id term))
			     ids terms)))
	  (mapcar #'(lambda (assum)
		      (substitute-into-assumption assum subs unhide-p))
		  (refiner-lookup
		   (id-of-variable-assumption template))))
      
	(let ((assums (refiner-lookup
		       (id-of-variable-assumption template))))
	  (if unhide-p
	      (mapcar #'unhide-assumption assums)
	      (progn ;;(break)
		     (copy-list assums)))))))


;; invariant : each assumption is well formed. 
;;               by induction and construct assumption invariant.

(defun refiner-instantiate-assumptions (templates unhide-p)
   ;;(break "ia")
  (if (trivial-assumptions-p templates)
      (let ((trivial-assumptions (refiner-lookup (id-of-variable-assumption (car templates)))))
	(if (or (not unhide-p)
		(not (exists-p #'hidden-assumption-p trivial-assumptions)))
	    trivial-assumptions
	  (mapcar #'unhide-assumption trivial-assumptions)))
    (let ((tail-template (car (last templates))))
      (if (and (not (substitution-assumption-p tail-template))
	       (variable-assumption-p tail-template))
	  (let ((tail-assumptions (refiner-lookup (id-of-variable-assumption tail-template))))
	    (if (null tail-assumptions)
		(mapcan #'(lambda (template)
			    (if (variable-assumption-p template)
				(refiner-instantiate-variable-assumption template
									 unhide-p)
			      (list (refiner-instantiate-assumption template
								    unhide-p))))
			(butlast templates))
	      (mapcan #'(lambda (template)
			  (if (eql tail-template template)
			      (if (or (not unhide-p)
				      (not (exists-p #'hidden-assumption-p tail-assumptions)))
				  tail-assumptions
				(mapcar #'unhide-assumption tail-assumptions))
			    (if (variable-assumption-p template)
				(refiner-instantiate-variable-assumption template
									 unhide-p)
			      (list (refiner-instantiate-assumption template
								    unhide-p)))))
		      templates)))
	(mapcan #'(lambda (template)
		    (if (variable-assumption-p template)
			(refiner-instantiate-variable-assumption template
								 unhide-p)
		      (list (refiner-instantiate-assumption template
							    unhide-p))))
		templates)))))



;;;;;;     EXTRACT
(defun pick-assumption (proof-node index)
  (or (nth (1- index) (assumptions-of-proof-node proof-node))
      (ref-error '(assumption pick) (princ-to-string index))))
    


;; for extractor need a easy way to choose assumptions to be matched.
;; assumption indices may be used to break list for adjacent assumption
;; list variables as well as to pick assumptions.
;;  - returns a list of bools indicating which assumption index variables
;;    are used to pick variables.
;; could be optimized to return true only for assumptions instantiatiing
;; a meta variable used in the extract.
(defun find-pick-assumption-index-variables (goal-assumption-templates)
  (do* ((cur (car goal-assumption-templates) (car rest))
	(next (cadr goal-assumption-templates) (cadr rest))
	(rest (cdr goal-assumption-templates) (cdr rest))
	(accumulator nil))
      ((null rest) (nreverse accumulator))
    (cond
      ((not (variable-assumption-p cur))
       (push t accumulator))
      ((and (variable-assumption-p cur)
	    (variable-assumption-p next))
       (push nil accumulator)))))

;; we need only match against the chosen assumptions, since the extract
;; meta term will not contain assumption-list variables.
;; However, it seems possible that we might in the future need these assumption
;; list variables as an argument to some process which returns a value which
;; may be needed to determine the extract term.
(defun extractor-assumptions-match (templates assumptions assumption-indices)
  (labels
    ((select-template ()
       (prog2
	 (setf templates (find-cdr #'(lambda (x) (not (variable-assumption-p x))) 
				   templates))
	   (car templates)
	 (setf templates (cdr templates)))))

    (mapc #'(lambda (index pick-p)
	      (when pick-p
		(refiner-assumption-match (select-template)
					    (nth (1- index) assumptions))))
	  assumption-indices
	  (find-pick-assumption-index-variables templates))))



;;;
;;;  Primitive Rule Extraction
;;;


(defun primitive-extract (proof-node children)
  (let ((def (definition-of-rule (rule-of-proof-node proof-node))))
    (with-rule-interpreter-environment (nil)
      (with-delay

	;; match rule.
	  (refiner-rule-match (rule-of-primitive-rule-definition def)
			      (rule-of-proof-node proof-node))

	;; match goal assumptions
	(extractor-assumptions-match
	 (sequent-template-assumptions (goal-of-primitive-rule-definition def))
	 (assumptions-of-proof-node proof-node)
	 (assumption-indices-of-rule (rule-of-proof-node proof-node)))

	;; match let
	(extractor-let-match (let-of-primitive-rule-definition def)
			   (rule-of-proof-node proof-node))
      
	;; match children extracts.
	(unless (variable-subgoals-p (subgoals-of-primitive-rule-definition def))
	  (mapc #'(lambda (s p)
		    (when (and (sequent-template-extract s)
			       (not (axiom-term-p (sequent-template-extract s))))
		      (refiner-term-match (sequent-template-extract s) p)))
		(subgoals-of-primitive-rule-definition def)
		children)))

      ;; instantiate extract.
      (let* ((sextract (sequent-template-extract
		       (goal-of-primitive-rule-definition def)))
	     (extract (refiner-instantiate-term sextract)))
	;; if actual extract is iincomplet then quote but must be careful not to
	;; quote some child passed in as incomplete and returned as extract.
	(if (or (and (iincomplete-term-p sextract)
		     (iincomplete-term-p extract))
		(opquoted-term-p extract 'extract))
	    (opquote-term extract 'extract)
	    extract)))))






;;;
;;; CallLisp let clauses.
;;;



(defun get-first-arg-value (rule)
  (car (args-of-primitive-rule rule)))

(defun get-second-arg-value (rule)
  (cadr (args-of-primitive-rule rule)))

(defun get-third-arg-value (rule)
  (caddr (args-of-primitive-rule rule)))

(defun get-fourth-arg-value (rule)
  (cadddr (args-of-primitive-rule rule)))

(defmacro with-promote-ephemeral-dependencies (kindsmap &body body)
  `(if (ephemeral-dependencies-p)
    (with-ephemeral-dependencies
	  (prog1 (progn ,@body)
	    (mapcar #'(lambda (kindmap)
			;;(setf -k kindmap) (break "wped")
			(let ((deps (find-first #'(lambda (dp)
						    (when (eql (tag-of-dependencies dp) (car kindmap))
						      dp))
						(ephemeral-dependencies))))
			  (when deps
			    (note-ephemeral-dependencies (cdr kindmap)
							 (remove-duplicate-dependencies
							  (list-of-dependencies deps))))))
		    ,kindsmap)))
    (progn ,@body)))

(defun direct-computation (proof-node rule)
  (let ((using-term (get-first-arg-value rule)))
    (when (not (equal-terms-p (conclusion-of-proof-node proof-node)
			      (erase-tags using-term)))
      (ref-error '(direct-computation)))

    (list
     (with-promote-ephemeral-dependencies '((abstraction . direct_computation_abstraction))
       (do-indicated-computations using-term))
     )))
     

(defun reverse-direct-computation (proof-node rule)
  (let* ((using-term (get-first-arg-value rule))
	 (term (with-promote-ephemeral-dependencies '((abstraction . reverse_direct_computation_abstraction))
		 (do-indicated-computations using-term))))

    (when (not (equal-terms-p (conclusion-of-proof-node proof-node) term))
      (ref-error '(reverse-direct-computation)))

    (list (erase-tags using-term))))


(defun direct-computation-hypothesis (proof-node rule)
  (let ((term (assumption-type
		(nth (1- (index-of-assumption-index-term (get-first-arg-value rule)))
		     (assumptions-of-proof-node proof-node))))
	(using-term (get-second-arg-value rule)))
    
    (when (not (equal-terms-p term (erase-tags using-term)))
      (ref-error '(direct-computation hypothesis)))

    (list (with-promote-ephemeral-dependencies '((abstraction . direct_computation_abstraction))
	    (do-indicated-computations using-term)))))

(defun reverse-direct-computation-hypothesis (proof-node rule)
  (let* ((term (assumption-type
		 (nth (1- (index-of-assumption-index-term (get-first-arg-value rule)))
		      (assumptions-of-proof-node proof-node))))
	 (using-term (get-second-arg-value rule))
	 (computed-term (with-promote-ephemeral-dependencies '((abstraction . reverse_direct_computation_abstraction))
			  (do-indicated-computations using-term))))
	
    (when (not (equal-terms-p term computed-term))
      (ref-error '(reverse-direct-computation hypothesis)))

    (list (erase-tags using-term))))


(defun universe-formation (proof-node rule)
  (unless (less-level-expression-p (get-first-arg-value rule)
				   (level-of-universe-term (conclusion-of-proof-node proof-node)))
    (ref-error '(universe-formation))))

(defun le-universe-equality (proof-node rule)
  (declare (ignore rule))
  (unless (less-level-expression-p (level-of-universe-term
				    (leftterm-of-equal-term
				     (conclusion-of-proof-node proof-node)))
				   (level-of-universe-term
				    (type-of-equal-term
				     (conclusion-of-proof-node proof-node))))
    (ref-error '(universe-equality))))


(define-primitive |level-expression| ((level-expression . le)))

(defun le_cumulativity (proof-node rule)
  (unless (equal-less-level-expression-p
	   (le-of-level-expression-term (get-first-arg-value rule))
	   (level-of-universe-term
	    (type-of-equal-term (conclusion-of-proof-node proof-node))))
    (ref-error '(cumulativity))))


(defun le-lemma (proof-node rule)
  (declare (ignore proof-node))

  ;;(setf a proof-node b rule) ;;(break "lel")

  (with-backtrace "LemmaRule"
    (let ((name (atom-of-token-term (get-first-arg-value rule))))
      (format t "Lemma ~a~%" name)
      (let ((oid (lemma-lookup name)))

	(when (member oid (ref-current-objects t) :test #'equal-oids-p)
	  (ref-error '(lemma self-reference)))
	
	;;(lemma-use-named oid)
	(lemma-use oid)	))))

(defun le-lemma-o (proof-node rule)
  (declare (ignore proof-node))

  ;;(setf a proof-node b rule) (break "lelo")

  (with-backtrace "LemmaRuleByObid"
    (let ((oid (first-oid-of-term (get-first-arg-value rule))))

      ;;(format t "oLemma ~a~%" (name-of-lemma (lookup-statement-def oid nil t)))

      (when (member oid (ref-current-objects t) :test #'equal-oids-p)
	(ref-error '(lemma self-reference)))
	
      ;;(lemma-use-named oid)
      (lemma-use oid)	)))


(defun equality (proof-node rule)
  (declare (ignore rule))
  (let ((concl-type-equivalence-class
	 (or (find-first #'(lambda (class)
			     (when (member (type-of-equal-term
					    (conclusion-of-proof-node proof-node))
					   class :test #'equal-terms-p)
			       class))
			 ;; equivalence classes of in some universe (from assumptions).
			 (reduce-equalities-to-equivalence-classes
			  ;; a list of terms of equalities in any universe from assumptions.
			  (mapcan #'(lambda (assum)
				      (when (and (equal-term-p (assumption-type assum))
						 (universe-term-p
						  (type-of-equal-term (assumption-type assum))))
					(list (terms-of-equal-term (assumption-type assum)))))
				  (assumptions-of-proof-node proof-node))))
	     (list (type-of-equal-term (conclusion-of-proof-node proof-node))))))

    (unless (exists-p #'(lambda (class)
			  (forall-p #'(lambda (term)
				     (member term class :test #'equal-terms-p))
				 (terms-of-equal-term (conclusion-of-proof-node proof-node))))

		      (reduce-equalities-to-equivalence-classes
		       ;; equalities of assumptions whose type is in concl-type-equivalence-class.
		       (mapcan #'(lambda (assum)
				   (cond
				     ((and (equal-term-p (assumption-type assum))
					   (member (type-of-equal-term (assumption-type assum))
						   concl-type-equivalence-class
						   :test #'equal-terms-p))
				      (list (terms-of-equal-term (assumption-type assum))))
				     ((member (assumption-type assum)
					      concl-type-equivalence-class
					      :test #'equal-terms-p)
				      (list (list (variable-term (assumption-id assum)))))
				     (t nil)))
			       (assumptions-of-proof-node proof-node))))
      (ref-error '(equality)))
    nil))

(defun le_equality (proof-node rule)
  (declare (ignore rule))
  (let ((concl-type-equivalence-class
	 (or (find-first #'(lambda (class)
			     (when (member (type-of-equal-term
					    (conclusion-of-proof-node proof-node))
					   class :test #'equal-terms-p)
			       class))
			 ;; equivalence classes of in some universe (from assumptions).
			 (reduce-equalities-to-equivalence-classes
			  ;; a list of terms of equalities in any universe from assumptions.
			  (mapcan #'(lambda (assum)
				      (when (and (equal-term-p (assumption-type assum))
						 (universe-term-p
						  (type-of-equal-term (assumption-type assum))))
					(list (terms-of-equal-term (assumption-type assum)))))
				  (assumptions-of-proof-node proof-node))))
	     (list (type-of-equal-term (conclusion-of-proof-node proof-node))))))

     ;;(setf c concl-type-equivalence-class) (break "le") 
    (unless (exists-p #'(lambda (class)
			  (forall-p #'(lambda (term)
					(member term class :test #'equal-terms-p))
				    (terms-of-equal-term (conclusion-of-proof-node proof-node))))

		  (reduce-equalities-to-equivalence-classes
		   ;; equalities of assumptions whose type is in concl-type-equivalence-class.
		   (mapcan #'(lambda (assum)
			       (cond
				 ((and (equal-term-p (assumption-type assum))
				       (member (type-of-equal-term (assumption-type assum))
					       concl-type-equivalence-class
					       :test #'equal-terms-p))
				  (list (terms-of-equal-term (assumption-type assum))))
				 ((member (assumption-type assum)
					  concl-type-equivalence-class
					  :test #'equal-terms-p)
				  (list (list (variable-term (assumption-id assum)))))
				 (t nil)))
			   (assumptions-of-proof-node proof-node))))
      (ref-error '(equality le)))

    nil))


;;;
;;; equivalence classes :
;;;   - no two elements of separate classes are equal.
;;;   - no two elements of the same classes are alpha-variants.
;;;
;;; an equality :
;;;   - no two elements of the equality are alpha-variants.
;;;

;; assumes equalence-classes have no duplicates.
;; if classes intersect, returns copy of class-b with common member removed.
;;    due to transitivity the union of result and class-a will also
;;    have no duplicates.
(defun equivalence-class-intersect-p (class-a class-b)
  (let ((any nil))
    (let ((new-b (mapcan #'(lambda (member-b)
			     (if (member member-b class-a :test #'equal-terms-p)
				 (progn (setf any t) nil)
				 (list member-b)))
			 class-b)))
      (values any new-b))))

;; a list of (lists of terms equal in some universe)
;; returns equivalence classes 
;;   in an equivalence class no two members of alpha-equivalent.
;;   if a and b are from distinct classes
;;      then a is not alpha-equivalent to b.


(defun reduce-equalities-to-equivalence-classes (pre-equalities)
  (when pre-equalities
    (let ((equivalence-classes (list (remove-duplicates (car pre-equalities)
							:test #'equal-terms-p))))
      (dolist (pre-equality (cdr pre-equalities))

	(setf equivalence-classes
		(reduce-equivalence-classes-by-equality
		  equivalence-classes
		  (remove-duplicates pre-equality :test #'equal-terms-p))))

      equivalence-classes)))


;;; combines equivalence classes equated by equality.
;;; if none combined then equality becomes a new equivalence class.
(defun reduce-equivalence-classes-by-equality (equivalence-classes equality)
  ;; first partitions the equivalence classes into those contain a member
  ;; equal to member of the equality and those which do not.
  (mlet* (((yes no)
	   (partition-equivalence-classes-by-equality equivalence-classes
						      equality)))

    ;; make new equivalence class for equality and add it to remaining classes.
    (cons (mapcan #'(lambda (class) class)
		  yes)
	  no)))


(defun partition-equivalence-classes-by-equality (classes class)
  (if class
      (if classes
	  ;; note that members in intersection can not occur in later equivalence classes.
	  ;; otherwise the equivalence classes would violate the first criteria.
	  ;; thus new-class has intesecting members removed.
	  (mlet* (((intersect-p new-class) (equivalence-class-intersect-p (car classes)
									  class))
		  ((yes no) (partition-equivalence-classes-by-equality (cdr classes)
								     new-class)))
	    (if intersect-p
		(values (cons (car classes) yes) no)
		(values yes (cons (car classes) no))))
	  (values (list class) nil))
      (values nil classes)))




(defun arith (proof-node rule)
  (let ((level (level-of-universe-term (get-first-arg-value rule)))
	(result (do-arith (assumptions-of-proof-node proof-node)
		  	  (conclusion-of-proof-node proof-node)
			  nil)))

      (if (eql result 'GOOD)
	  (let ((assumptions (mapcar #'unhide-assumption
				     (assumptions-of-proof-node proof-node))))
	    (list
	     ;; subgoals
	     (mapcar #'(lambda (concl)
			 (make-proof-node :assumptions assumptions
					  :conclusion concl))
		     (arith-subgoal-terms (conclusion-of-proof-node proof-node)
					  level))
	     (ext-arith proof-node)))
	  (ref-error '(arith) result))))


(defun arith-subgoal-terms (term level)
  (let ((int-term (int-term)))
    (labels
      ((visit (term)
	 (cond
	   ((union-term-p term)
	    (let ((l (visit (lefttype-of-union-term term)))
		  (r (visit (righttype-of-union-term term))))
	      (nconc (or l (list (reflexive-equal-term (universe-term level)
						       (lefttype-of-union-term term))))
		     (or r (list (reflexive-equal-term (universe-term level)
						       (righttype-of-union-term term)))))))

	   ((not-term-p term) (visit (term-of-not-term term)))

	   ((and (int-equal-term-p term)
		 (not (reflexive-equal-term-p term)))
	    (list (reflexive-equal-term int-term (leftterm-of-equal-term term))
		  (reflexive-equal-term int-term (rightterm-of-equal-term term))))

	   ((less-than-term-p term)
	    (list (reflexive-equal-term int-term (leftterm-of-less-than-term term))
		  (reflexive-equal-term int-term (rightterm-of-less-than-term term))))
      
	   (t nil))))

      (visit term))))

;; by monotonicity i j op v
(defun monotonicity (proof-node rule) 
   (handle-error 'monot-tag
		 #'(lambda (s) (ref-error '(monotonicity) s))

     (list (do-monot (atom-of-token-term (get-third-arg-value rule))
	     (assumption-type
	      (pick-assumption proof-node
			       (number-of-natural-number-term
				(get-first-arg-value rule))))
	     (assumption-type
	      (pick-assumption proof-node
			       (number-of-natural-number-term
				(get-second-arg-value rule))))))))


(defun do-monot (opkind hyp1 hyp2)
  ;; Returns the new hypothesis term representing an inference using
  ;; one instance of non-trivial monotonicity.
  (case opkind
    (|add|
     (lookup-and-make-literal$
       monot-table-plus (process-hyps-plus$ hyp1 hyp2)))
    (|subtract|
     (lookup-and-make-literal$
       monot-table-minus (process-hyps-minus$ hyp1 hyp2)))
    (|multiply|
     (lookup-and-make-literal$
       monot-table-mult (process-hyps-mult$ hyp1 hyp2)))
    (|divide|
     (lookup-and-make-literal$
       monot-table-div (process-hyps-div$ hyp1 hyp2)))
    (otherwise
     (ref-error '(monotonicity operation) opkind))))

(defun rec-equality (proof-node rule)
  (declare (ignore rule))
  (let* ((eqterm (conclusion-of-proof-node proof-node))
	 (left (leftterm-of-equal-term eqterm))
	 (right (rightterm-of-equal-term eqterm)))
    
    (unless (occurs-positively (binding-of-term-of-rec-term left)
			       (term-of-rec-term left))
      (ref-error '(rec-equality positivity left)
		 (binding-of-term-of-rec-term left)
		 (term-of-rec-term left)))

    (unless (occurs-positively (binding-of-term-of-rec-term right)
			       (term-of-rec-term right))
      (ref-error '(rec-equality positivity right)
		 (binding-of-term-of-rec-term right)
		 (term-of-rec-term right))))

  nil)
