%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
ALGEBRA-TACTICS
****************************************************************************
****************************************************************************
tactics useful for algebra.
]%

% Replaces term t in clause i with t'. Uses conversion c to 
normalize new and old clauses. Should normalize to same.
%
let ReplaceWithEqv c t' i p = 
  let i' = get_pos_hyp_num i p
  in
  if i=0 then 
  ( Assert t' 
    THEN IfLabL
    [`main` % t' |- t %
     ,Rewrite c (-1) 
      THENM Rewrite c 0 
      THENM (Trivial ORELSE AddHiddenLabel `inequiv clauses?`)
    ;`assertion` % |- t' %
     ,AddHiddenLabel `main`
    ]
  ) p
  else
  ( AssertAtHyp i' t' 
    THEN IfLabL
    [`main` % ... #i': t', t ... |- ... %
     ,Thin (i'+1)
    ;`assertion`  % ... #i': t ... |- t' %
     ,Rewrite c i' 
      THENM Rewrite c 0 
      THENM (Trivial ORELSE AddHiddenLabel `inequiv clauses?`)
    ]
  ) p
;;



%[
*****************************************************************************
Functions for specializing lemmas.
*****************************************************************************
]%

% 
Start with fmla 

    F = All x1:A1,...xn:An.P

Take [y1,B1;...;ym,Bm] and [t1;...;tk],
and generate fmla

    F' = All y1:B1,...,ym:Bm (All x(k+1):A(k+1),...,xn,An.P)[t1;...;tk/x1;...;xk]


Works if initial xs are `level expression' quantifiers.
%

let specialize_fmla F yBs ts = 
  let xAs,Froot = dest_iterated_all_for_n (length ts) F
  in let Froot' = full_subst (zip (map fst xAs) ts) Froot
  in
    mk_iterated_all yBs Froot'
;;

let ProveSpecializedLemma old_lemma n ts conv p = 
 (SeqOnM 
    [RepeatMFor n (D 0)
    ;InstLemma old_lemma ts
    ;Rewrite conv (-1)
    ;Try Trivial
    ]
  THENA Auto
 ) p
;;

let ProveSpecializedLemma1 old_lemma n ts conv p = 
 (SeqOnM 
    [RepeatMFor n (D 0)
    ;InstLemma old_lemma ts
    ;Rewrite conv (-1)
    ;Try Trivial
    ]
 ) p
;;



% intersperses text terms for ml list separators and delimiters.
Returns list of terms. %

let add_terms_for_ml_list ts = 
  let n = length ts 
  in let ml_strs = n = 0 => ["[]"] |  ["["] @ replicate ";" (n-1) @ ["]"]
  in 
    interleave (map mk_text_term ml_strs) ts
;;


