%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 1994                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
ALGEBRA-TACTICS
****************************************************************************
****************************************************************************
tactics useful for algebra.
]%


% returns goal of specialized thm, and tactic to prove it. %

let mk_specialized_thm_and_tactic
      old_thm_name 
      yBs 
      ts 
      conv 
      conv_string
  =
  let old_thm_tname = string_to_tok old_thm_name
  in let lemma = main_goal_of_theorem old_thm_tname
  in let new_lemma = 
    apply_conv conv (strip_le_quants (specialize_fmla lemma yBs ts))
  in let n = 
   length (remove_if ($= level_exp_type o snd) yBs)
  in
  let tactic_term = 
    mk_text_seq `!ml_text_cons`
    (flatten
      [[mk_text_term
         ("ProveSpecializedLemma `"
          J old_thm_name
          J "` "
          J int_to_string n
          J " "
         )
       ]
      ;add_terms_for_ml_list (map mk_prl_term ts)
      ;[mk_text_term (" (" J conv_string J ")")]
      ]
    )
  in
% why is normalize_text_seq here? Doesn't seem necessary. %

    new_lemma, (normalize_text_seq `!ml_text_cons` tactic_term)
;;


%
----------------------------------------------------------------------------
USAGE:

add_specialized_theorem 
      old_thm_name : string
      [y1,B1;...;ym,Bm] : (var # term) list
      [t1;...;tk] : term list
      conv : convn
      conv_string : string
      new_thm_name : string
      new_position : string
    = () : unit
;;

Assumes that old_thm_name is of form

  F = All x1:A1,...xn:An.P

and has level expression variables 

   i1,...,ij

1. Adds `bindings' of form i:level_exp() for each level exp var
   to close F and create F':

   F' = All i1:level_exp() ... All ij:level_exp() . F

2. Instantiates k outermost quantifiers in F' with t1 ... tk respectively
   to get term G. t1...tj should be parameter{le:l}() terms for instantiating 
   level expressions of F':

3. Applies conversion conv to G to get G'

4. Adds bindings y1:B1;...;yn:Bn to G' to get specialized lemma.

   H = All y1:B1, ..., yn:Bn . G'

5. Creates new theorem object with name new_thm_name at position new_position.
   Makes H main goal of theorem, and tries running tactic to prove 
   specialized lemma. This tactic should normally completely prove the 
   lemma. It needs conv_string, which should a string of ML text that
   evaluates to the same as conv.



A variant called test_add_specialize_theorem with the same typing doesn't
create the new lemma, but instead just returns the new lemma H. 

----------------------------------------------------------------------------
%

%
let add_specialized_theorem 
      old_thm_name 
      yBs 
      ts 
      conv 
      conv_string
      new_thm_name 
      new_position 
  =
  let new_goal, tactic_term = 
      mk_specialized_thm_and_tactic
        old_thm_name 
        yBs 
        ts 
        conv 
        conv_string
  in
    add_new_thm_and_run 
      new_thm_name 
      new_goal
      tactic_term
      new_position 
;;

let test_add_specialized_theorem  
      old_thm_name 
      yBs 
      ts 
      conv 
      conv_string
      (new_thm_name : string)
      (new_position : string)
  =
   fst
    ( mk_specialized_thm_and_tactic
        old_thm_name 
        yBs 
        ts 
        conv 
        conv_string
    )
;;
%

%[
****************************************************************************
Specialization of lemmas for Rewrites.
****************************************************************************
]%

% 3 lemmas involved:

  1. typing lemma tlemma
  2. general lemma glemma
  3. new specific lemma slemma
%
%
let spec_alg_thm (tnam:tok) (snam:tok, gnam:tok) = 
  if is_lib_member snam then
    failwith `spec_alg_thm: thm exists`
  else
  let t_xAs,t_Bs,t_C = dest_simple_lemma tnam
  in let t_Class,t_algtup = dest_member t_C

  in let g_xAs,(),() = dest_simple_lemma gnam
  in let (g_lv,()).((),g_Class).() = g_xAs
  in let s_le_val = 
       snd (hd (full_match_with_retry
                  get_hard_and_supertype_alts 
                  0 
                  [var_to_tok g_lv] 
                  [] 
                  g_Class 
                  t_Class))

  in let g_inst_tms = [s_le_val;t_algtup]
  in let s_new_bindings = t_xAs
  in 
    add_specialized_theorem 
      (tok_to_string gnam)
      s_new_bindings 
      g_inst_tms
      AbReduceC
      "AbReduceC"
      (tok_to_string snam)
      ("+" J (tok_to_string tnam))
;;
%

% 
Each pi_id_ar_pr <id,a> gives information about a corresponding
operator destructor argument expected by normC. It should be
straightforward, given this information and the typing lemma for the
specialized instance, to build operator destructor functions for the
...
Punt on processing term destructors for now. %


let create_spec_norm_conv 

  % specific to particular algebra %

  (normC : ((term list -> term) list) -> tok list -> convn)
  (pi_id_ar_prs : (tok # int) list)
  (gthms : tok list)   

  % specific to particular instantiation %

  (typing_lemma : tok)
  (sprefix : tok)

  =
  let mk_snam gnam = sprefix ^ gnam
  in let sthms = map mk_snam gthms
  in 
    % don't create the objects in v5.
     mapfilter 
      (spec_alg_thm typing_lemma)
      (zip sthms gthms)
   ; %
   normC [] sthms
;;
