%()
****************************************************************************
****************************************************************************
INC-TACTICS-2.ML
****************************************************************************
****************************************************************************
DecomposeSubtype tactics.

We should integrate these tactics into the functionality database for
rewriting at some stage...

NB: In Nuprl's type theory, we can't summarize the effect of these
tactics in lemmas, since we can't write inclusion lemmas which involve
proving WF of Subtype(A;B) for arbitrary A and B. 

It would be a very good idea to extend type theory slightly, so we could... %


let DecompFunInc1 p =
  let (),F,F' = get_subtype_args p in
  let x,A,Bx = dest_function F in
  let x',A',B'x' = dest_function F' in

  % >> Subtype(x:A->B[x]; x:A'->B'[x]) %

 (Assert (mk_simple_term `suptype` [A;A'])
  THEN
  IfLabL
  [`assertion`,
   % >> Suptype(A;A') %
   AddHiddenLabelAndNumber `subterm` 1
  ;`main`,
   % Suptype(A;A') >> Subtype(x:A->B[x]; x:A'->B'[x]) %
   UnfoldTop `suptype` (-1) THEN
   SubtypeCD THEN
   IfLabL
   [`wf`,
    % Subtype(A':A), f:x:A->B[x] >> A = A in U* %
    KeepingAnnotation (Thin (-1))
   ;`main`,
    % Subtype(A':A), f:x:A->B[x] >> f = f in x:A'->B'[x] %
    FoldTop `member` 0 THEN AddHiddenLabel `link`
   ]
  ]
 ) p
;;

let DecompFunInc2 p =
   % Subtype(A':A), f:x:A->B[x] >> f in x:A'->B'[x] %
  (ExtWith [] [h (-1) p] THEN
   IfLabL
   [`wf`,
    % Subtype(A':A), f:x:A->B[x] >> A' in Ui %
    % Subtype(A':A), f:x:A->B[x] >> f in x:A->B[x] %
    (UnfoldTop `member` 0 THEN NthDecl (-1))
    ORELSE KeepingAnnotation (OnHyps [-2;-1] Thin)
   ;`main`,
   % Subtype(A':A), f:x:A->B[x], z:A' >> f z in B'[z] %
    (\p'.
      let z = mk_var_term (var_of_hyp (-1) p') in
      let B'z,() = dest_member (concl p') in
      let x,A,Bx = dest_function (h (-2) p') in
      let Bz = fo_subst [x,z] Bx in

      ( Assert (mk_simple_term `subtype` [Bz;B'z]) 
        THEN
        IfLabL [`main`,
                % Subtype(A';A), f:x:A->B[x], z:A', Subtype(B[z];B'[z])
                                                          >> f z in B'[z] %
                AddHiddenLabel `link`

               ;`assertion`,
                % Subtype(A';A), f:x:A->B[x], z:A' >> Subtype(B[z];B'[z]) %
                OnHyps [-3;-2] Thin 
                THEN AddHiddenLabelAndNumber `subterm` 2
               ]
      ) p'
    )
   ]
  ) p
;;

let DecompFunInc3 p =

  % Subtype(A';A), f:x:A->B[x], z:A', Subtype(B[z];B'[z]) >> f z in B'[z] %

  let (),f_z = dest_member (concl p) in
  let (),z = dest_apply f_z in
      
  ( DTerm z (-3)
    THEN
    IfLabL
    [`wf`,
    % Subtype(A';A), f:x:A->B[x], z:A', Subtype(B[z];B'[z])
                           >> z = z in A %
     UnfoldTop `subtype` (-4)
     THEN DTerm z (-4)
     THEN Trivial

    ;`main`,
     % Subtype(A';A), f: x:A->B[x], z:A', Subtype(B[z];B'[z])
                      y:B[z], y = f z in B[z] >> f z in B'[z] %
     UnfoldTop `subtype` (-3)
     THEN DTerm f_z (-3)
     % Subtype(A';A), f: x:A->B[x], z:A', 
                      y:B[z], y = f z in B[z] >> f z in B[z] %
     % Subtype(A';A), f: x:A->B[x], z:A', 
                      y:B[z], y = f z in B[z], f z in B'[z] >> f z in B'[z] %
     THEN Trivial
    ]
  ) p
;;

let DecompFunctionInc p =
 (DecompFunInc1
  THEN IfLabL 
  [ `link`,
    DecompFunInc2
    THEN IfLabL 
    [ `link`,
      DecompFunInc3
    ]
  ]
 ) p
;;

let DecompProductInc p =
 (SubtypeCD
  THENM
  % ... f: x:A # Bx >> f = f in x':A' # B'x' %
  ( D (-1)
    % ... a:A, b:Ba >> <a,b> = <a,b> in x':A' # B'x' %
    THEN
    PrimEqCD
    THENLL
    [`wf`,
      % ... a:A, b:Ba x':A' >> B'x' in U{*}%
      [Id]
    ; `subterm`,
      [ %  a:A, b:Ba >> a = a in A' % 
        VarIncToSubtypeRel (-2)
        THEN OnHyps [-1;-1] Thin
        THEN AddHiddenLabelAndNumber `subterm` 1
      ; %  a:A, b:Ba >> b = b in B'a % 
        VarIncToSubtypeRel (-1)
        THEN Thin (-1)
        THEN Try (Thin (-1))
        THEN AddHiddenLabelAndNumber `subterm` 2
      ]
    ]
  )
 ) p
;;

let DecompUnionInc p =
 (SubtypeCD
  THENM
  % ... x: A | B >> x = x in A' | B' %
  ( D (-1)
  % ... a:A >> inl(a) = inl(a) in A' | B' %
  % ... b:B >> inr(b) = inr(b) in A' | B' %
    THENL
    [% ... a:A >> inl(a) = inl(a) in A' | B' %
     PrimEqCD THEN IfLab `subterm` 
       ( VarIncToSubtypeRel (-1)
         THEN Thin (-1)
         THEN AddHiddenLabelAndNumber `subterm` 1
       )   
       Id
    ;% ... b:B >> inr(b) = inr(b) in A' | B' %
     PrimEqCD THEN IfLab `subterm` 
       ( VarIncToSubtypeRel (-1)
         THEN Thin (-1)
         THEN AddHiddenLabelAndNumber `subterm` 2
       )   
       Id
    ]
  )
 ) p
;;


let DecompListInc p = 
  let i,(),() = get_subtype_args p
  in
 (SubtypeCD 
  THENM 
  % ...i:A List ... |- i = i in B List%
  (ListInduction null_var null_var i THENL
    [% ... ... |- [] = [] in B List%
     PrimEqCD THEN AddHiddenLabel `wf`
    ;% ... i:A list ... 
       x:A, xs:A List, xs = xs in B List |- x::xs = x::xs in B List  %
     PrimEqCD THENL 
     [OnHyps [-1;-1] Thin THEN AddHiddenLabel `subterm`
      % ... i:A List ... x:A |- x = x in B %
     ;NthHyp (-1)
     ]
    ]
  )
 ) p
;;

  

let DecomposeSubtype p =
  let i,A,B = get_subtype_args p in
  let opidA = opid_of_term A in
  if opidA = `function` then
    DecompFunctionInc p
  if opidA = `product` then
    DecompProductInc p
  if opidA = `union` then
    DecompUnionInc p
  if opidA = `list` then
    DecompListInc p
  else 
    failwith `DecomposeSubtype`
;;




% Copes with 2 kinds of inclusions:

S subtype of T
1. subset inclusions:  {x:A|P x} subtype of A
2.quotient inclusions: A subtype of A//E

subtype inclusion lemmas should have names:

<opid of S>_inc*

quotient inclusion lemmas should have names: 

<opid of T>_qinc*

Careful to insist that level expressions match up exactly.

name_of_lib_objects_with_prefix searches library in linear fashion.
This is makes failure of LemmaSubtype very slow. 

15th sept 94:

To speed things up, assume always that 1st lemma for
given opid has no suffix. 

Only even try looking up successive subtypes if application of first
fails.
%

%
letref inc_alist = ([]: (tok # (tok list)) list);;
letref qinc_alist = ([]: (tok # (tok list)) list);;

let inc_alist_lookup opid = 
  (snd (assoc opid inc_alist))
  ? (let names = opid_alist_names opid `inc` in
      inc_alist := ((opid, names) . inc_alist);
      names)
;;

let qinc_alist_lookup opid = 
  (snd (assoc opid qinc_alist))
  ? (let names = opid_alist_names opid `qinc` in
      qinc_alist := (opid, names) . qinc_alist;
      names)
;;

let inc_alist_reset () = 
 qinc_alist := nil
 ; inc_alist := nil
;;
%

let qinc_alist_lookup  =
  cache_prefix_lookup "qinc"
    (\(). qinc_cache)
    (\c. qinc_cache := c)
    (\index. id) 
;;

let inc_alist_lookup  =
  cache_prefix_lookup "inc"
    (\(). inc_cache)
    (\c. inc_cache := c)
    (\index. id)
;;
      

let LemmaSubtypeTac p = 
  let BLemma' name p =
  % need p arg to forestall lemma_lookup since if lemma x not avail
    (BLemma' x ORELSE B) fails without trying B
  %
    BackThruGenFormula
      get_type_using_env
      (half_match_with_retry get_hard_and_supertype_alts)
      (half_match_with_retry get_hardened_pr 0)
      (main_goal_of_theorem name)
      (InstGenLemmaByAddr (lemma_lookup name))
      0 p
  in
  let i,A,B = get_subtype_args p 
  in let opidA = opid_of_term A
  in let opidB = opid_of_term B
  in let BLemmaExts names = 
         First (map BLemma' names) 
  in let Aroot = opidA ^ `_inc` 
  in let Aexts = inc_alist_lookup opidA
  in
  if is_statement Aroot or not (null Aexts) then
  ( IncToSubtype THEN (BLemma' Aroot ORELSE BLemmaExts Aexts)) p
  else
  (let Broot = opidB ^ `_qinc` in
   let Bexts = qinc_alist_lookup opidB in
    if is_statement Broot or not (null Bexts) then
       ( IncToSubtype THEN (BLemma' Broot ORELSE BLemmaExts Bexts)) p
    else failwith `LemmaSubtype: no lemma applies`)
;;

LemmaSubtype := LemmaSubtypeTac ;;
