%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

let content_sort_by_kind content =
 let thms,rest = divide_list (\c. member (fst c) ``STM THM``) content in
 let code,rrest = divide_list (\c. `ML` = fst c) rest in
   (rrest @ code @ thms)
;;

let at_location_wrechain_sorted partialp = at_location_wrechain_aux partialp content_sort_by_kind;;


let is_lib_member = exists_object_p;;

let object_accumulate_wo_delim f place name = 
  if not (exists_object_p name)
     then (create_object_accumulator_wo_delim name place (\oacc. f (inr oacc)))
     else f (inl ())

   ; ()
;;

let object_accumulate_wo_delim_at f dir place name = 
 (create_object_accumulator_wo_delim_at name dir place (\oacc. f (inr oacc)))
 ; ()
;;

let maybe_object_accumulate_wo_delim_at f dir place name = 
  if not (exists_object_p name)
     then (object_accumulate_wo_delim_at f dir place name)
     else f (inl ())

   ; ()
;;


let add_def lhs rhs place =
  let id = (opid_of_term lhs) in
   if (exists_object_p id)
      then failwith (`add_def ` ^ id)
      else create_lib_objects place (map odt (add_def_content true lhs rhs))
;;

let add_def_at lhs rhs dir place =
  let id = opid_of_term lhs in
   if (exists_object_p id)
      then (raise_error [] [`add_def`; id; `object-exists-with-same-name`] []
	   ; failwith (`add_def ` ^ id))
      else create_lib_objects_at_wrechain dir place (map odt (add_def_content true lhs rhs))
;;

let add_def_disp model =
   let opid = id_of_term model in
      odt (create_disp_obj_data (mk_disp_object_term_for_term model (tok_to_string opid))
		  (tok_to_string (opid ^ `_df`)))
;;


%
;;;;	
;;;;	add_rec_def as a top level call was not migrated
;;;;	it leaves an unproven thm and thus it appeared
;;;;	not to be a top level function. If this is 
;;;;	mistaken then it would need to be resurrected.
%

let add_rec_def lhs rhs = 
  let ab_lhs.y_tms = dest_iterated_apply lhs in
  let (id,ps),bts = dest_term ab_lhs in

   if (exists_object_p id) 
       then add_rec_def_content (inl ()) lhs rhs
       else
         %raise_error [] ``add_rec_def top level call`` [];%
         (create_object_accumulator_wo_delim id (id ^ `_ml`)
	   (\oacc. 
	       add_rec_def_content (inr oacc) lhs rhs
	     ; let wfname = id ^ `_wf` in
	          (oacc [create_thm_obj_data ivoid_term ivoid_term (tok_to_string wfname)])))
   ; ()
;;


let add_rec_def_at lhs rhs = 
  let ab_lhs.y_tms = dest_iterated_apply lhs in
  let (id,ps),bts = dest_term ab_lhs in
   at_location_wrechain false
     (\oacc.
         let odata = rec_def_content true lhs rhs in
	 let wfname = id ^ `_wf` in
	 let reinit, oaccf = oacc in
	   call_oacc (call_oacc oacc odata)
	     [create_thm_obj_data ivoid_term ivoid_term (tok_to_string wfname)])
    false false id
;;


let recdef typed_def lib_position  =
 let ptyped_def = proc_typed_def typed_def in
 let opid = opid_of_term (hd (dest_iterated_apply (fst ptyped_def))) in

   object_accumulate_wo_delim 
      (\oacc. recdef_content oacc ptyped_def)
      lib_position
      opid
;;

% like add_def2 but supplies wf_proof%
let add_def3_aux build_oacc deftm tac =

  let (lhs,rhs,goal, dtac) = add_def2_prep deftm in
  let id = (opid_of_term lhs) in

   if (exists_object_p id) then
      ()
      %LAL I think ver 4 doesn't fail in this case%
      %raise_error nil ``add_def exists already`` [(itoken_term id)];% 

   else

   build_oacc
      (\oacc. add_def2_content oacc  (lhs,rhs,goal,tac))
      id
;;

let add_def3 deftm tac lib_position =
  add_def3_aux
   (\f id. object_accumulate_wo_delim f lib_position id)
   deftm tac
;;

let add_def3_content_aux deftm tac =
  let (lhs,rhs,goal, dtac) = add_def2_prep deftm in
   add_def2_content_aux (lhs,rhs,goal,tac)
;;

let add_def3_at oacc deftm tac =
  let (lhs,rhs,goal, dtac) = add_def2_prep deftm in
    add_def2_content oacc (lhs,rhs,goal,tac)
;;


let add_def2 deftm lib_position =

  let defstuff = add_def2_prep deftm in
  let id = (opid_of_term (fst defstuff)) in

   if (exists_object_p id) then
      ()
      %LAL I think ver 4 doesn't fail in this case%
      %raise_error nil ``add_def exists already`` [(itoken_term id)];% 

   else

   object_accumulate_wo_delim 
      (\oacc. add_def2_content oacc defstuff)
      lib_position
      id
;;


let def = add_def2;;

let setdef deftm lib_position = 
  let defstuff = add_def2_prep deftm in
  let id = (opid_of_term (fst defstuff)) in

   if (exists_object_p id) then
      raise_error nil ``set_def exists already`` [(itoken_term id)];

   object_accumulate_wo_delim 
      (\oacc. setdef_content oacc deftm defstuff)
      lib_position
      id
;;


let add_inc_objs opid = 
  let deftm = mk_typed_def opid in
  let defstuff = add_def2_prep deftm in
  let id = (opid_of_term (fst defstuff)) in

  let incname = id ^ `_ml_inc` 
  and propname = id ^ `_properties` 
  and lib_position = id ^ `_wf` in

   if (exists_object_p incname) or (exists_object_p propname) then
      raise_error nil ``add_inc inc prop exists already`` [(itoken_term incname); (itoken_term incname)];

    object_accumulate_wo_delim 
      (\oacc. add_inc_content oacc deftm defstuff)
      lib_position
      opid
;;
   

let add_guarded_theorem name ext addr =

  let id =  (name ^ ext) in
   
   if (exists_object_p id) then
      raise_error nil ``add_guarded_thm exists already`` [(itoken_term id)];

    object_accumulate_wo_delim 
      (\oacc. add_guarded_theorem_content oacc name ext addr)
      name
      id     
;;

let create_module_at opid short_id parm_vTs prodvTs Universe =
 at_location_wrechain_sorted false
   (\oacc. create_module_content oacc
	       opid
	       short_id
	       parm_vTs
	       prodvTs
	       Universe
    )
 true true opid
;;

%
let create_module opids short_id parm_vTs prodvTs Universe = 
 let opid = (string_to_tok opids) in 
   %%if (exists_object_p opid) then
      raise_error nil ``create_module exists already`` [(itoken_term opid)];
   %%
    object_accumulate_wo_delim 
      (\oacc. 
	    create_module_content oacc
	       opid
	       (string_to_tok  short_id)
	       parm_vTs
	       prodvTs
	       Universe
	)
	(`create_` ^ opid)
	opid
;;
%
%
let clear_all_caches () = 
    decidable__lemmas_reset()
  ; sq_stable__lemmas_reset()
  ; initialize_rw_lemma_caches ()
  ; inc_alist_reset ()
  ; update_all_caches_from_history ()
;;

let touch_history_touched () =

 if (member_p `STM` (touch_history()) (\kind (k,oid, s) . kind = k))
    then () %%(clear_all_caches ())%%
 ; ()
;;
%
