%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%------------------------------------------------------------------------------+
|                                                                              |
|     File: nuprl5/lib//ml/standard/tacticals-2.ml                             |
|                                                                              |
|     General Purpose Tacticals                                                |
|                                                                              |
|     Author: Christoph Kreitz                                                 |
|     Date: 03/29/94                                                           |
|     Last Update: 04/30/98                                                    |
|                                                                              |
+------------------------------------------------------------------------------%



%------------------------------------------------------------------------------+
|									       |
|  TryOnC:  tactic -> (term->bool) -> tactic	         	               |
|    Apply the given tactic to the conclusion if the condition is satisfied    |
|									       |
|  TryOnH:  (int->tactic) -> int -> (term->bool) -> tactic		       |
|    Apply the given tactic to a the hypothesis if the condition is satisfied  |
|									       |
+------------------------------------------------------------------------------%


let TryOnC tactic condition proof     = if condition (conclusion proof)        
				           then tactic proof                  
				           else failwith `tactic inappropriate`
  				        ;;  
let TryOnH tactic pos condition proof = if condition (type_of_hyp pos proof)  
				           then tactic proof              
				           else failwith `tactic inappropriate`
  				        ;;         



%------------------------------------------------------------------------------+
|  TryOn:      (* list -> tactic) -> tactic				       |
|              Try to apply a given tactic with a *-parameter to values        |
|              given in a selection (often a list of hypotheses)	       |
|									       |
|  TryAllHyps: (int -> tactic) -> (term -> bool) -> tactic		       |
|              Try to apply a given tactic with a label parameter to the       |
|              hypotheses selected by a condition. 			       |
|									       |
+------------------------------------------------------------------------------+
|									       |
|  select_hyps: (term -> bool) -> proof -> int list		               |
|	       select hypotheses in the current proof which satisfy a given    |
|	       condition						       |
|									       |
+------------------------------------------------------------------------------%

let select_hyps condition proof = 
   letrec Select condition start_no hyps
      = if hyps = []
           then []
           else let hyp = hd hyps
                and selected = Select condition (start_no+1) (tl hyps)
                in
                   if condition (type_of_declaration hyp) 
                      then start_no.selected
                      else selected
   in
      Select condition 1 (hypotheses proof)
;;

letrec TryOn selection tac  
   = if selection = []                                                     
        then \pf.failwith `Nothing appropriate`                          
        else tac (hd selection) ORELSE  TryOn (tl selection) tac
;;  


let TryAllHyps tac condition proof =
   TryOn (select_hyps condition proof) tac proof
;;

