%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
*********************************************************************
*********************************************************************
Transformation tactics.
**********************************************************************
**********************************************************************
These tactics may operate on refined proof trees, though it is questionable
whether they should be called `transformation' tactics since they never
actually transform any refined proof tree. One always uses the tactics which
have any effect as refinement tactics.
]
%

let ((Graft p): tactic) p' = 
  if equal_sequents p p' then
    [],\ps.p
  else
    failwith `Graft: new sequent not equal to old`
;;

%
Mark and Copy transformation tactics
%


letref saved_proofs = []: (tok#proof) list ;;

letref saved_proof_index = 0;;

let add_saved_proof name proof =
  saved_proofs := update_alist saved_proofs name proof;
  ()
;;

let get_saved_proof name = 
  apply_alist saved_proofs name
;;

let new_saved_proof_index () =
    saved_proof_index := saved_proof_index + 1;
    `save` ^ (int_to_tok saved_proof_index)
;;

let Mark name p = 
    saved_proof_index := 0;
    add_saved_proof name (copy_proof p);
    Id p
;; 

let Restore name p =
  Graft (copy_proof (get_saved_proof name)) p 
;; 
% 
is_refined used to be redefined here so as to just check
presence of rule. Redefinition has since been removed, since
it was unnecessary. 

The functions that use it should be reviewed for their
behaviour on proofs with bad and incomplete rules.
%



letrec DoAnalogy pattern p =
  let mk_pf_key p' = label_of_proof p',(number_of_proof p' ? -1) in
  let prep_old_child_pf p' = mk_pf_key p',DoAnalogy p' in
  let childT ps = 
    let old_child_alist = map prep_old_child_pf (children pattern) in
    let new_child_keys = map mk_pf_key ps in
      map snd (reorder_alist old_child_alist new_child_keys Id)
  in

  if not is_refined pattern then
    Id p
  else
    Try (refine (refinement pattern) THEN_OnEach childT) p
;;

let DoAnalogyOnChildren pattern p =
  if is_refined p then
  ( Try
    ( refine (refinement p)
      THEN_OnFirstL (map DoAnalogy (children pattern))
    )
  ) p
  else 
    Id p
;;

let Copy name p =
  DoAnalogy (get_saved_proof name) p
;;


let Save = Mark ;;

let SS = Save `anonymous` ;;
let CC = Copy `anonymous` ;;


let CopyCh %ildren% name p = 
  DoAnalogyOnChildren (get_saved_proof name) p
;;


%
*********************************************************************
Analogy reasoning
**********************************************************************
These functions and tactics allow one to construct tactics from proof trees.
The tactics so constructed can take a variety of types of parameters, and
can be safely nested.


ProofTree Marking:
(here # is the percent character...)

#S# start of marked proof.

#E# End of marked proof.

#L:<label># 


Labels are used at intermediate nodes of a proofscript. They are needed
when different instances of a goal in the template will generate subgoals in 
different orders, but with consistent labels.

When running a proof script, labelled proofscript subgoals are matched up 
first with the generated subgoals. Unlabelled proofscript subgoals
are then run on the remaining subgoals.
%


absrectype pscript = (term # pscript list)
 with make_pscript stuff = abs_pscript stuff
  and pscript_children  pscript = (snd (rep_pscript pscript))
  and pscript_tactic    pscript = (fst (rep_pscript pscript))
;;

let mk_pscript term pslist = make_pscript (term, pslist)
;;

%
let psterm_of_prf poid =
  let
%

let header_of_rterm t = 
  snd (dest_sp_term (hd (dest_list_of_terms t)))
  ?
  ""
;;

let extract_pscript_label pscript =
  let rterm = pscript_tactic pscript
  in let rstring = header_of_rterm rterm
  in let rtoks = string_to_toks rstring
  in 
  if is_prefix (string_to_toks "%L:") rtoks then
  (let x = nthtl 3 rtoks
   in let lab_toks = firstn (position `%` x - 1) x
   in 
     implode lab_toks
  )
  else
    `any`
;;


% 
When pscripts for incomplete proofs are built in ML, the null_rule_term
is used for the unrefined proof nodes. However, when the proof editor
creates pscripts, it uses placeholder terms for unrefined nodes.
%


let null_rule_term = void_term ;;
let is_null_rule_term t = is_terms ``cons void placeholder`` t ;;
%lal added cons%

%
RunMarkedPScript1 never fails. RunMarkedPScript does fail if script 
doesn't complete properly.

RunMarkedPScript1 is careful to obey any labelling of subgoals.

%
%letref tlist = [void_term];;%
letref rmpsfailed = (make_proof_node nil void_term,void_term);;

letrec RunMarkedPScript1 pscript p =
  let rterm = pscript_tactic pscript and
      pscripts = pscript_children pscript in
  if is_null_rule_term rterm then
    Id p
  else
  (%tlist := rterm.tlist;%
  let tagged_Tacs = 
    map (\ps.extract_pscript_label ps, RunMarkedPScript1 ps) pscripts
  in let grouped_Tacs = group_alist_entries tagged_Tacs
  in let move lab l = move_alist_entry_to_end l lab ? l
  in let sorted_Tacs = 
       every_fun [move `any`;move `aux`;move `main`] grouped_Tacs
  in
  ( (refine (make_tactic_rule rterm)
      THENLL sorted_Tacs
    )
    p
    ?\x
       (  rmpsfailed := p,rterm;
	  tty_print ("RunMarkedPScript: caught exception: " J (tok_to_string x) );
	  AddLabel (`RunMarkedPScript: caught exception: `^x )
          THEN AddHiddenLabel `RunMarkedPScript exception`
    )
    p
  ))
;;

let RunMarkedPScript pscript p =
  ( RunMarkedPScript1 pscript
    THEN 
      (\p.if is_proof_with_label `RunMarkedPScript exception` p then
            failwith `RunMarkedPScript: script failed`
          else
            Id p
      )
  ) p
;;
  
letrec psterm_to_pscript term =
 let (a, bts) = destruct_term term in
  if bts = [] then mk_pscript (void_term) [] 
  else let ([], tt) = (hd bts) in
  mk_pscript tt (map psterm_to_pscript (map (\x. let ([], ttt) = x in ttt) (tl bts)))
;;
%
letrec psterm_to_pscript term =
 let (a, bts) = destruct_term term in
  if bts = [] then mk_pscript (void_term) [] 
  else let ([], tt) = (hd bts) and ([], pc) = (hd (tl bts)) in
  mk_pscript tt (map_isexpr_to_list (`pscript_cons`,[]) (\x. psterm_to_pscript x) pc)
%

% by analogy defs moved to lib-calls %


%
*********************************************************************
General Purpose ProofScript Execution
**********************************************************************
Tactics useful for fixing broken scripts.
%

let addr_to_string addr = 
  concatenate_strings
     (" top" . map (\i." " J int_to_string i) addr @ [" :"] )
;;

