%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
****************************************************************************
****************************************************************************
TYPE-INF.ML
****************************************************************************
Routines for inferring the type of a term. Digs into soft abstractions.

%



% A strong match of t' to t with typed variables vs in the context of p
| is a substitution, sub, where (subst sub t' = t) and every v,x in sub
| corresponds to a v,T in vs and x:T is a declaration in p.
%
letrec strong_match vs dhp sofar t' t =
  if is_variable_term t' then
    let v' = dest_variable t' in
    let x,b = (apply_alist sofar v'),true ? t,false in
    if b then (if (alpha_equal_terms x t) then sofar else failwith `strong_match:a`) else
    let T',c = apply_alist vs v',true ? t,false in
    if c then
      let aux_trivial =
        if is_variable_term t then
          let v = dest_variable t in
          member_p (v,T') dhp alpha_equal_bterms
        else false
      in
      if aux_trivial then (v',t).sofar else failwith `strong_match:b`
   else if alpha_equal_terms t' t then sofar else failwith `strong_match:b2`
  else 
   let op',args' = dest_term t' in
   let op,args = dest_term t in
   if op' = op then strong_match_list vs dhp sofar args' args
   else failwith `strong_match:c`
and strong_match_list vs dhp sofar bts' bts =
  if null bts' then 
   if null bts then sofar else failwith `strong_match:d`
 else if null bts then failwith `strong_match:e`
 else let sofar' = 
      strong_match_list vs dhp sofar (tl bts') (tl bts) in
      let bvs',x' = hd bts' in
      let bvs,x = hd bts in
      if bvs' = [] & bvs = [] then
         strong_match vs dhp sofar' x' x 
     else failwith `strong_match:f`
;;

let dest_iterated_all = iterate_dest_quantifier dest_all ;;


let asserted_type_of_term t e =
  first_value
    (\d.
      let T,t' = dest_member (snd d) in
      if alpha_equal_terms t' t then T else fail
    ) 
    (rev e)
  ?
    failwith `asserted_type_of_term`
;;
%let asserted_type_of_term t e =
 first_value
  (\d.
   let td = (snd d) in
     if is_member_term td then
        let T,t' = dest_member td in
        if alpha_equal_terms t' t then T else fail
     else if is_all_term td then
        let vs,A = dest_iterated_all td in
        let Tr = (mk_simple_term `true` []) in
        let P,Q = if is_implies_term A then
                     dest_implies A else
                     Tr,A in
        let T,t' = dest_member Q in
        let sub = strong_match vs e [] t' t in
        let P' = subst sub P in
        let aux_trivial =
          (alpha_equal_terms P' Tr) or (member_p P' (map snd e) alpha_equal_terms) in
        if aux_trivial then
          (subst sub T) else fail
    else fail
    ) 
    (rev e)
  ?
    failwith `asserted_type_of_term`
;;
%
% 
Somewhat polymorphic. Always returns term with opid same as first arg. 

dest_lp caters for abstractions that wrap up universe terms
(e.g. prop and subsets of universe)
%

% Work hard to get a canonical type from t by computing and digging
into set types. %
letrec extract_canonical_type t =
  let t' = compute t in
  (let (),A,() = dest_set t' in extract_canonical_type A) 
  ? t' 
;;

let ti_dest_lp_term S = 
     dest_lp_term S 
     ? dest_lp_term (extract_canonical_type S)
;;


letref default_level = mk_var_level_exp `*default*` ;;


% This will soon change to index off declarations in library. %

let super_type t =
  if member (opid_of_term t) 
       ``nat nat_plus int_upper int_lower int_seg int_nzero`` then
    int_term
  else
    repeatf (orelsef (progressf unfold_soft_abs) (fst o snd o dest_set)) t
;;

%
let super_type =
  repeatf (orelsef (progressf unfold_soft_abs) (fst o snd o dest_set)) 
;;
%

% For the universe of a product type, we may have the type of one
  component given as an intersection, so we allow that. %

% need some caching here. %

let get_type_env_to_env e =
  form_env (map (\v,t.v,t,false) e)
;;
let env_to_get_type_env e = 
  map (\v,t,b.v,t) (open_env e)
;;

let fix_internal_get_type1 g =
  \e t. g (env_to_get_type_env e) t
;;

% is this ever used??? Would be useful to soup this up.
e.g. use ab_reduce... e.g. sometimes mix concrete types and
algebraic types e.g. Carrier(int_ring) and Z %

let fix_internal_get_type2 g =
  \e t. reduce_term (g (env_to_get_type_env e) t)
;;

let get_abstraction_type g e t =
  ( let x_A_pairs,Bs,c_in_T = 
      dest_simple_formula
               (main_goal_of_theorem
                  (abstraction_typing_lemma_name (opid_of_term t))) in 
    let T,c = dest_member c_in_T in
    if null (free_vars T) & null (level_vars T) then T
    else
      let sub =
      ( match_in_context_with_ti_and_ms
          (half_match_with_retry get_hard_and_supertype_alts)
          (fix_internal_get_type1 g)
          x_A_pairs 
          (semi_match true 1)
          c 
          t 
          [] 
          (get_type_env_to_env e)
        ? 
        match_in_context_with_ti_and_ms
          (half_match_with_retry get_hard_and_supertype_alts)
          (fix_internal_get_type2 g)
          x_A_pairs 
          (semi_match true 1)
          c 
          t 
          [] 
          (get_type_env_to_env e)
      )
      in
        full_subst sub T
  )
  ?
  g e (unfold_soft_ab t)
;;


let get_token_type g e t = mk_atom_term ;;

let get_any_type g e t = fail ;;

let get_int_type g e t = mk_int_term ;;

let get_axiom_type g e t = fail ;;

let get_nil_type g e t = fail ;;

let get_cons_type g e t = 
  let a,b = dest_cons t in 
  g e b ? mk_list_term (g e a) 
;;

let get_inl_or_inr_type g e t = fail ;;

let get_lambda_type g e t = fail ;;

let get_pair_type g e t =
  let a,b = dest_pair t in
  if (is_var_term a & 
     (let v = dv a in all (\d. not (fst d) = v) e))
  then mk_product_term (dv a) (g e a) (g e b)
  else mk_product_term null_var (g e a) (g e b)
;;

let get_ind_type g e t =  
  let (),(),t0,() = dest_ind t in
  % Guessing a too-small U is very bad. %
  assert (\x. not is_U_term x) (g e t0)
;;

let get_list_ind_type g e t =
    let is_U x =
	let opid = opid_of_term x in
	    opid = `univ` or opid = `prop`
    in
    let dest_U_or_prop x =
	let ((), (le . ())), () = dest_term x in
	    dest_level_exp_parm le
    in
    let merge_U x y =
	% Compute the max of the level expressions %
	let le_x = dest_level_exp (dest_U_or_prop x) in
	let le_y = dest_level_exp (dest_U_or_prop y) in
	    mk_U_term (simplify_level_exp (mk_level_exp (le_x @ le_y)))
    in
    let l, tnil, ([u; v; f], tstep) = dest_list_ind t in
    let Tnil = g e tnil in
	if is_U Tnil then
	    let Tlist = g e l in
            let op, [T] = dest_simple_term Tlist in
		if op = `list` then
		    let Tstep = g (multi_update_alist e [u, T; v, Tlist; f, Tnil]) tstep in
			% Max out the universes %
			if is_U Tstep then
			    merge_U Tnil Tstep
			else
			    Tstep
		else
		    failwith `get_list_ind_type: not a list`
	else
	    Tnil;;

let get_rec_ind_type g e t =     
  let a, [h;z],d = dest_rec_ind t in
  g (multi_update_alist e [z, g e a]) d
;;

let get_decide_type g e t =     
  let arg, ([x],t1), ([y],t2) = dest_decide t in
  let A,B = dest_union (extract_canonical_type (g e arg))  in
  g (multi_update_alist e [x,A]) t1 ? g (multi_update_alist e [y,B]) t2 
;;

let get_spread_type g e t =     
  let arg, ([x;y],t1) = dest_spread t  in
  let z,A,B = dest_product (extract_canonical_type (g e arg))  in
  if is_null_var z 
  then g (multi_update_alist e [x,A;y,B]) t1
  else let fstof_arg = 
           mk_spread_term 
             arg
             (map tok_to_var [`u`;`v`], (mvt (tok_to_var `u`)))  in
       g (multi_update_alist e [ x, A; y, fo_subst [z,fstof_arg] B ]) t1 
;;

letref new_get_apply_type = true;;

let get_apply_type g betabound e t =
  let a,b = dest_apply t  in
  if (new_get_apply_type & is_lambda_term a & betabound > 0)
     then let x,t' = dest_lambda a in
            g (betabound - 1) e (fo_subst [x, b] t')
  else	   
  let z,(),B = dest_function (extract_canonical_type (g betabound e a))  in
  fo_subst [z, b] B 
;;

let get_var_type g e t = apply_alist e (dv t) ;;

%
let get_var_type g e t = unfold_all_soft_abs (apply_alist e (dv t)) ;;
%


let type_of_extract t =
  let thm_oid,level_exps = dest_extract t
  in let thm = statement_lookup thm_oid
  in let le_vars = level_vars thm
  in let sub = level_exp_sub_to_term_sub (zip le_vars level_exps)
  in 
    full_subst sub thm
;;

let get_extract_type g e t = type_of_extract t ;;

let get_atom_eq_type g e t =
  let [();();t1;t2] = subterms_of_term t in 
  (g e t1) ? (g e t2)
;;

let get_int_eq_type g e t =
  let [();();t1;t2] = subterms_of_term t in 
  (g e t1) ? (g e t2)
;;

let get_less_type g e t =
  let [();();t1;t2] = subterms_of_term t in 
  (g e t1) ? (g e t2)
;;

let get_U_type g e t = mk_U_term (mk_inc_level_exp (dest_U t) 1) ;;

let get_list_type g e t = g e (dest_list t) ;;

let get_equal_type g e t = 
  let T = g e (fst (dest_equal t))
  in mk_prop_term (snd (dest_lp_term T))
;;


let get_function_type ulub g e t = 
  let x,A,B = dest_function t  in
  let B_type = if is_null_var x 
               then g e B 
               else g (multi_update_alist e [x,A]) B  in
  ulub B_type (g e A) 
;;

let get_rfunction_type ulub g e t = 
  let f,x,A,B = dest_rfunction t in
  let B_type = g (multi_update_alist e [x,A; f,mk_lambda_term x (mk_var_term x)]) B in
      ulub B_type (g e A) 
;;

let get_isect_type ulub g e t = 
  let x,A,B = dest_isect t  in
  let B_type = if is_null_var x 
               then g e B 
               else g (multi_update_alist e [x,A]) B  in
  ulub B_type (g e A) 
;;

let get_product_type ulub g e t =    
 let x,A,B = dest_product t  in
 let B_type = if is_null_var x
              then g e B 
              else g (multi_update_alist e [x,A]) B  in
 ulub B_type (g e A) 
;;

let get_set_type ulub g e t =    
  let x,A,B = dest_set t  in
  let B_type = if is_null_var x               then g e B 
               else g (multi_update_alist e [x,A]) B  in
  ulub (g e A) B_type 
;;

let get_union_type ulub g e t =    
  let A,B = dest_union t in ulub (g e A) (g e B)
;;

let get_quotient_type ulub g e t =    
  let x,y,A,E = dest_quotient t  in
  ulub (g e A) (g (multi_update_alist e [x,A;y,A]) E)  
;;

let get_rec_type g e t =    
  let T,C = dest_rec t in
  g (multi_update_alist e [T, mk_U_term (mk_const_level_exp 1)]) C
;;


% Tail of get_type_aux --- break because of Lucid bug %
%
let get_type_aux' g e t=
%
%
letref get_type_additions_alist = [] 
  :(tok 
    #
    (((var # term) list -> term -> term)
    -> ((var # term) list -> term -> term) 
    ) 
   ) list
;;

let get_type_from_additions g e t = 
  apply_alist get_type_additions_alist (opid_of_term t) g e t
;;


let add_type_inf_fun id f = 
  get_type_additions_alist :=
    update_alist get_type_additions_alist id f ; ()
;;
%

letref type_inf_assoc =
  new_alist_ref_state `type_inf`

  (nil : (tok # (( (var # term) list -> term -> term)
                   -> ((var # term) list -> term -> term))
	 ) list )
;;

update_ref_state_view
 (\(). type_inf_assoc)
 (ref_state_view_list_entry (itoken_term o fst))
;;
 
let ref_add_type_inf index edges items =
 declare_ref_state_index index `type_inf` index;
 type_inf_assoc 
   := declare_ref_state_data_indirect `type_inf` type_inf_assoc index items edges
;;

let type_inf_add_data index data =
 type_inf_assoc 
   := ref_state_set_data type_inf_assoc [index, data]
;;

let ref_add_type_inf_additions items index edges =
  type_inf_assoc
    := ref_state_modify_state_aux (\data gedata. append gedata data)
         type_inf_assoc items index edges
  ; ()
;;

let type_inf_add oid data =
 add_ref_environment_data oid `type_inf` type_inf_add_data  data
;;

let type_inf_do_updates oid edges oids =
  type_inf_assoc := ref_state_do_updates type_inf_assoc oid oids edges
; ()
;;
let undeclare_type_inf oid =
  (type_inf_assoc := ref_state_remove type_inf_assoc oid; ())
 ? ()
;;

let lookup_type_inf_alist () = 
  ref_state_get type_inf_assoc (current_ref_environment_index `type_inf`)
;;

let lookup_type_inf id = apply_alist (lookup_type_inf_alist ()) id;;

let get_type_from_additions g e t = 
  (lookup_type_inf (opid_of_term t)) g e t
;;



% CHANGE 5/16/95:
  Used to be
  1) try get_type_aux
  2) try looking up asserted type
  3) try additions

  Order changed to:

  1) try looking up asserted type
  2) try additions
  3) try get_type_aux

This seems more sensible: typing additions should be able to
override default behaviour and typing assumptions should
override both.
%

letref betabound_default = 8;;       
       
letrec U_lub_aux betabound T T' =
 let ulub_get_type p t =
       let e = (map var_and_type_of_declaration (hyps p)) in
        get_type_aux ivoid_term betabound e t in

 %FDL HOL port 11/2003 %
 % hmmm, but pf is free so commented out.      
 let T  = if opid_of_term T = `stype` then (ulub_get_type pf mk_int_term ? T)  else T in
 let T' = if opid_of_term T' = `stype` then (ulub_get_type pf mk_int_term ? T') else T' in
 %%FDL HOL port 11/2003  end %

(let op,le = ti_dest_lp_term  (if is_term `isect` T then subtermn 2 T else T)
  and op',le' = ti_dest_lp_term (if is_term `isect` T' then subtermn 2 T' else T')
  in
    if equal_level_expression le base_level then T'
    if equal_level_expression le' base_level then T
    else
      mk_lp_term op (normalize_level_exp (mk_max_level_exp [le;le']))
 ) ?
 failwith `U_lub`

 and get_type_aux lastt betabound e t =
  if (eq_terms lastt t) then failwith `get_type_aux loop`
  else
  let g = get_type_aux t betabound in
  let U_lub = U_lub_aux betabound in
  
  asserted_type_of_term t e
  ? get_type_from_additions g e t
  ?
  if is_abstraction_term t then get_abstraction_type g e t
  if is_token_term t then get_token_type g e t
  if is_any_term t then get_any_type g e t 
  if is_int_exp t then get_int_type g e t 
  if is_axiom_term t then get_axiom_type g e t
  if is_nil_term t then get_nil_type g e t 
  if is_cons_term t then get_cons_type g e t 
  if is_inl_term t or is_inr_term t then 
    get_inl_or_inr_type g e t 
  if is_lambda_term t then get_lambda_type g e t 
  if is_pair_term t then get_pair_type g e t
  if is_ind_term t then get_ind_type g e t 
  if is_list_ind_term t then get_list_ind_type g e t 
  if is_rec_ind_term t then get_rec_ind_type g e t
  if is_decide_term t then get_decide_type g e t
  if is_spread_term t then get_spread_type g e t
  if is_apply_term t then get_apply_type (get_type_aux t) betabound e t
  if is_var_term t then get_var_type g e t 
  if is_extract_term t then get_extract_type g e t 
  if is_atom_eq_term t then get_atom_eq_type g e t 
  if is_int_eq_term t then get_int_eq_type g e t 
  if is_less_term t then get_less_type g e t 
  if is_atom_term t or is_void_term t or is_int_term t 
    then mk_U_term base_level
  if is_less_than_term t then mk_prop_term base_level 
  if is_U_term t then get_U_type g e t
  if is_list_term t then get_list_type g e t
  if is_equal_term t then get_equal_type g e t
  if is_sqequal_term t or is_term_sq_term t then mk_U_term base_level
  if is_function_term t then get_function_type U_lub g e t
  if is_rfunction_term t then get_rfunction_type U_lub g e t
  if is_isect_term t then get_isect_type U_lub g e t
  if is_product_term t then get_product_type U_lub g e t
  if is_set_term t then get_set_type U_lub g e t
  if is_union_term t then get_union_type U_lub g e t
  if is_quotient_term t then get_quotient_type U_lub g e t

  if is_rec_term t then get_rec_type g e t
  
  % some new primitives are introduced in the library and have 
    wf lemmas that give the typing information
    e.g. subtype(0;0) and csubtype(0;0)
  %
  else get_abstraction_type g e t
;;

let get_type_from_hyps hs t =
  let e = (map var_and_type_of_declaration hs) in
  get_type_aux ivoid_term betabound_default e t
  ? failwith `get_type_from_hyps`
;;

let U_lub = U_lub_aux betabound_default;;

let get_type_from_env e t = 
  get_type_aux ivoid_term betabound_default (env_to_get_type_env e) t 
  ? failwith `get_type`
;;

let get_type p t = 
  get_type_from_hyps (hyps p) t 
  ? failwith `get_type`
;;

%
let guess_U t p = 
  dest_U (get_type p t)
  ? big_U - 1
;;
%

let is_recursive_abstraction conds lhs rhs =
 is_term `ycomb` (hd (dest_iterated_apply rhs))
;;
 
% Get type of t, blasting through non-canonical forms and set-types.
  We can't safely blast through recursive abstractions, so we exclude those.
%
let get_using_type p t = 
  letrec aux t =
    let t' = compute_wo_pred (`is-recursive`, is_recursive_abstraction) t in
    (let (),A,() = dest_set t' in aux A) ? t' in
  aux (get_type p t)
;;

% maybe want to use this instead to find
  supertypes: 
  
  fst (last (find_supertypes p t)) ;;

 However, the compute and dest_set still seems to work fine 
%



% try to find another (wrt get_type) another type for t %
let alternate_type t p =
  let type_from_equandicity A =
    let l,T = dest_member A in if t = l then T else fail in
  first_value (type_from_equandicity o type_of_declaration) (hyps p)
;;

let get_type_using_env e t =
  get_type
    (mk_sequent_using_env e void_term)
    t
;;
  
%
****************************************************************************
Use of get type to infer universe levels for rules. 
****************************************************************************
Look for term proof annotation argument first.
%

letref default_level_inc = 17
;;

let get_universe_from_term t =
 let le_vars = level_vars t in
 let le_vars' = null le_vars => [unit_le_id] | le_vars in
   mk_U_term (mk_level_exp (map (\v.v,default_level_inc) le_vars'))
;;

let get_universe_from_hyps e t = 
 get_type_from_hyps e t
 ? get_universe_from_term t
;;


%----------------------------------------------------------------%

letref hol_compatible = false;;

letref hol_compatible_ref_state = or_ref_state `hol_compatible`;;

let hol_compatible_do_updates oid edges oids =
  hol_compatible_ref_state := ref_state_do_updates hol_compatible_ref_state oid oids edges
; ()
;;

let hol_compatible_add_data oid data = 
  hol_compatible_ref_state
    := ref_state_set_data hol_compatible_ref_state [oid,  data]
;;

let hol_compatible_add oid data =
 reset_ref_environment_data oid;
 add_ref_environment_data oid `hol_compatible` hol_compatible_add_data data
;;

update_ref_state_view
 (\(). hol_compatible_ref_state)
 (ref_state_view_bool_entry)
;;     

update_ref_state_merge `hol_compatible`
 (\index edges. 
   hol_compatible_ref_state :=
       or_ref_state_merge `hol_compatible` hol_compatible_ref_state index edges
   ; true)
;;

let undeclare_hol_compatible index =
 (hol_compatible_ref_state := ref_state_remove hol_compatible_ref_state index; ())
 ? ()
;;

update_ref_environment_cache_hook `hol_compatible`
  (\uoid.
     hol_compatible :=
       if (isl uoid) then false
       else ((ref_state_get hol_compatible_ref_state (outr uoid)) ? false)
    ; ())
;;       

%----------------------------------------------------------------%

let get_universe p t =
 %FDL HOL port 11/2003%
 if not hol_compatible then get_term_arg `universe` p else fail
 ? (let gt = get_type p t in
    if hol_compatible & opid_of_term gt = `stype`
       then get_type p mk_int_term
       else gt)
 ? (get_universe_from_term t)

 %FDL HOL port 11/2003 end%
 % ( get_term_arg `universe` p
  ? get_universe_from_hyps (hyps p) t)
 %
;;

let infer_level_exp_arg p t = 
  let U = get_universe p t
  in let le = snd (ti_dest_lp_term U)
  in
    mk_level_exp_arg (simplify_level_exp le)
;;


  
%
****************************************************************************
Match in context functions with get_type incorporated.
****************************************************************************
Make the default matcher assume +ve polarity and do soft matching on all
of pattern.
%

let match_in_context_with x_A_prs = 
  match_in_context_with_ti_and_ms 
    (half_match_with_retry get_hard_and_supertype_alts)
    get_type_using_env 
    x_A_prs 
;;

let match_in_context x_A_prs = 
  match_in_context_with_ti_and_ms
    (half_match_with_retry get_hard_and_supertype_alts)
    get_type_using_env 
    x_A_prs 
    (half_match_with_retry get_hard_and_supertype_alts 1)
;;

