
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      ncons neq clock triple
	      revassoc1 revassq1 assq1 assoc1
	      addprop inq  qeval
	      )))

(defvar %debug nil)
(defvar experimental nil)
(defvar eof '$eof$)
(defvar prflag nil)
(defvar %mlprindepth 3)
(defvar initial%load t)   ; allow modules to initialize themselves


(eval-when (compile load)
  (proclaim '(special %version)))

               ; (3 . 2)    1st October 1982       The portable LCF
               ; 4          1st November 1982      LCF with full PPLAMBDA
               ; (4 . 1)    1st December 1982      Emacs Formel
               ; (4 . 2)    1st March 1983         revised theory package


(setq %version '(4 . 3))        ;



(eval-when (compile)
  (proclaim
   '(special %ctime)))

; record when system was built
(setq %ctime (get-decoded-time))


(defun ncons (x) (cons x nil))
(defmacro neq (x y) `(not (eql ,x ,y)))

; Returns (jobtime . gctime) where jobtime does not include gctime
; Unix -- return current runtime in milliseconds (rounded)
; Depends on line frequency
(defun runtimems ()
  (cons (truncate (get-internal-run-time) 100) 0)) ; get time in microsec and div by 100.

; get absolute time for time-stamps
(defun clock () (get-universal-time)) 

(defun banner ()
  (terpri)
  (princ '|Cambridge ML modified for PRL, version |)
  (princ %version)
  (cond (experimental (princ '|Experimental system!|)))
  (terpri)
  (terpri))

(defun ml-save (tok)
  tok
  (error "Tried to do a dump-lisp.  No such thing on lisp machine."))

; Lisp machine will accept anything (at this stage) for a path
(defun filetokp (kind tok)
  kind tok
   t)

(defmacro uconcat (&rest atoms)
  `(concat ,@atoms))
(defmacro concatlist (&rest atoms)
  `(concat ,@atoms))


; Turn debugging on/off
; sets Lisp debugging switches, interrupt handler, and top-level
(defun setdebug (flag)
 (cond
  (flag
     (setq *print-length* 6)        ; control printing of circular lists
     (setq *print-level* 4))
  (t 
     (setq *print-length* nil)
     (setq *print-level* nil)
     )))  ;setdebug

  
; initialize system in experimental mode
; turn debug options on
(defun experimental-init ()
     (setdebug t))      ; experimental-init


; Function called before returning to Lisp
; Clears user-top-level to prevent automatic re-entry to ML
(defun finalize-tml ()
   (setdebug t))                ; finalize-tml

(defmacro genprefix (&rest args)
  (declare (ignore args))
  nil)

(defmacro tag (name &body body)
  `(catch ',name
     (progn ,@body)))

(defvar %breakout-tag (ncons 'BREAKOUT-TAG))

(defvar *ml-break* nil)

(defmacro breakout (name &body body)
  `(progn
    (when *ml-break* (break))
    (throw ',name (values (progn ,@body) %breakout-tag))))

(defmacro ifn (test then . else)
  `(cond ((not ,test) ,then) (t nil ,@else)))	;ifn



;**************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************

; F-gp.lisp     Original code: gp (lisp 1.6) part of Edinburgh LCF
;               by M. Gordon, R. Milner and C.Wadsworth   (1978)
;               Transported by G. Huet in Maclisp on Multics, Fall 1981
; V2.2 :breakout instead of err in function can
; V3.1 Unix -- added "uniquesym"
;      Changed "can" to avoid non-local "return" from "tag" (caused looping)


(eval-when (compile load)
  (proclaim '(special %%%fn %%%args  %symcount %timestamp word-sep)))


; Manifest constants
(setq word-sep '|%|)            ; word separator for uniquesym


(defun triple (x y z)  (cons x (cons y z)))  ;triple

; A family of "assoc" functions that match the cdr instead of the car
(defun revassoc (x l)
  (prog nil
        (cond ((null l) (return nil)))
   a    (cond ((equal x (cdar l)) (return (car l)))
              ((setq l (cdr l)) (go a)))))   ;revsasoc

(defun revassq (x l)
  (prog nil
        (cond ((null l) (return nil)))
   a    (cond ((eql x (cdar l)) (return (car l)))
              ((setq l (cdr l)) (go a)))))   ;revassq


; "assoc" functions that return only the opposite element of the pair found

(defun revassoc1 (x l) (car (revassoc x l)))  ; revassoc1

(defun revassq1 (x l) (car (revassq x l)))  ;revassq1

(defun assq1 (x l) (cdr (assoc x l)))  ; assq1

(defun assoc1 (x l) (cdr (assoc x l)))  ;assoc1

(defun itlist (fn xl x)
  (prog nil
        (setq xl (reverse xl))
   l    (cond ((null xl) (return x))
              (t (setq x (funcall fn (car xl) x))
                 (setq xl (cdr xl))
                 (go l)))))  ;itlist

(defun addprop (i v p)
  (car (setf (get i p) (cons v (get i p)))))  ;addprop

(defun charseq(ch n)
  (prog (l)
   loop (cond ((eql n 0) (return l)))
        (setq l (cons ch l))
        (setq n (1- n))
        (go loop)))  ;charseq

(defun can (%%%fn %%%args)   ;t iff fn[args] does not fail
       (tag canit
            (tag evaluation (apply %%%fn %%%args) (breakout canit t))
            nil))  ;can


(defun inq (x l)
  (cond
    ((member x l) l)
    (t (cons x l))))  

(defun outq (x l)
  (cond
    ((null l) nil)
    ((eql x (car l)) (outq x (cdr l)))
    (t (cons (car l) (outq x (cdr l))))))

(defun qeval (x) (list 'quote x))  ;qeval



