
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;; RLE TODO inline

#|
(defun allocate-statements (stamp tag)
  (statement-table stamp tag))

(defun allocate-proofs (stamp tag)
  (proof-table stamp tag))
|#




(defclass rule-substance (substance)
  ((model :reader spec-of-rule-substance
	  :writer set-rule-substance-spec
	  :initform nil
	  :initarg spec)
   ))


(defun rule-substance (term spec)
  (make-instance 'rule-substance 'term term  'spec spec))

;; currently export/import loses spec but that's ok since no one is using it.
;;(define-primitive |!rule_substance| () (term dependencies spec))

(defmethod data-import ((substance rule-substance) super)
  (let ((term (call-next-method substance super)))
    (set-rule-substance-spec term substance))

  (values))


(defstruct (rule-definition (:include definition))
  ;;id	; use name field-of def.
  )	

(defun id-of-rule-definition (rd) (definition-name rd))


(defstruct (rule-specification (:include rule-definition))
  spec
  )	

(defun provide-rule-spec (def term)
  (let* ((substance (term-to-data term))
	 (rule-substance (provide-data substance 'rule-substance)))

    (setf (definition-substance def) rule-substance
	  (rule-specification-spec def) (spec-of-rule-substance rule-substance))))

(defun import-rule-spec (term)
  (let ((spec (make-rule-specification)))
    (provide-rule-spec spec term)))


;; spec

(defun spec-of-rule-specification (spec) (rule-specification-spec spec))
;; (spec-of-rule-substance (substance-of-definition spec))


;;;	RLE NAP might be useful to extend inf-tree to include failures.
;;;
;;;



;;;
;;; RLE TODO maybe make a REFLIB- module for this, as EDD dont want it.
;;;	

;;;
;;;	Operators for rule source syntax and rule interpreter syntax.
;;;



;; Operators common to rule source syntax and rule interpreter syntax.

;; operators in interpreter syntax:

#|
(defun irule-specification-mangle-term (spec def)
  (instantiate-term (irule-specification-op)
		    (append (bound-terms-of-term spec)
			    (list (instantiate-bound-term def)))))

(defun definition-of-irule-specification-wdef-term (term)
  (let ((def-bt (fifth (bound-terms-of-term term))))
    (unless def-bt
      (raise-error (error-message '(ref rule specification definition not))))
    (term-of-bound-term def-bt)))

(defun irule-specification-unmangle-term (spec)
  (instantiate-term (irule-specification-op)
		    (butlast (bound-terms-of-term spec))))
|#
  
;; source
(define-primitive |!rule_definition| nil (goal rule let subgoals))
;; interpreter version: 
(define-primitive |!rule_specification| nil (goal rule let subgoals))

(define-primitive |!sequent| nil (assumptions conclusion extract))
(define-primitive |!assumption| ((bool . hidden) (variable . id)) (type))
(define-primitive |!rule| ((token . id)) (args))
(define-primitive |!rule_instance| ((oid . name)) (args))
(define-primitive |!let| nil (lhs rhs))
(define-primitive |!call_lisp| ((token . name)))
(define-primitive |!subst| nil (term subs))
(define-primitive |!term_sub| ((variable . id)) (term))

(define-primitive |!assum_cons| nil (car cdr))
(define-primitive |!rule_arg_cons| nil (car cdr))
(define-primitive |!let_cons| nil (car cdr))
(define-primitive |!goal_cons| nil (car cdr))
(define-primitive |!sub_cons| nil (car cdr))


(defun primitive-rule-to-term (rule)
  (irule-instance-term (oid-of-definition (definition-of-rule rule))
		       (map-list-to-ilist (args-of-primitive-rule rule)
					  (irule-arg-nil-term)
					  #'(lambda (a)
					      (if (term-p a)
						  a
						  (itoken-term 'rule-arg-not-a-term)
						  )))))
		       

;;;
;;;	parameter sub
;;;

(defconstant *iparameter-sub* '|parameter_sub|)

(defun iparameter-sub-term (tok parameter)
  (instantiate-term (instantiate-operator *iparameter-sub*
					  (list (instantiate-parameter-r tok *token-type*)
						parameter))))

(defun iparameter-sub-term-p (term)
  (and (eql (id-of-term term) *iparameter-sub*)
       (null (bound-terms-of-term term))
       (let* ((parameters (parameters-of-term term))
	     (v (car parameters))
	     (val (cadr parameters)))
	 (and v val (null (cddr parameters))
	      (token-parameter-p v)))))
		   
(defun variable-of-iparameter-sub-term (term)
  (car (parameters-of-term term)))

(defun value-of-iparameter-sub-term (term)
  (cadr (parameters-of-term term)))
   

(define-primitive |!assumption_index| ((token . id)))
(define-primitive |!assumption_list| ((token . id)))
(define-primitive |!substitution_list| ((token . id)))
(define-primitive |!goal_list| ((token . id)))
;; moved to lib-ref to avoid conflict with !term for edit explode.
;;(define-primitive |!term| ((variable . id)))
 


;; (define-primitive '|!parameter| ((<type> . <$meta>))

(defconstant *iparameter* '|!parameter|)

(defun iparameter-term-p (term)
  (and (eql (id-of-term term) *iparameter*)
       (null (bound-terms-of-term term))
       (let* ((parameters (parameters-of-term term))
	      (p (car parameters)))
	 (and p (null (cdr parameters))))))


(defun parameter-of-iparameter-term (term)
  (car (parameters-of-term term)))

(defun iparameter-term (p)
  (instantiate-term (instantiate-operator *iparameter* (list p))))
  
;; (define-primitive '|!bound_id| () ((<n> . term)))

(defconstant *ibound-id* '|!bound_id|)

;; *<f-root>-operator*
(defparameter *ibound-id-operator*
  (instantiate-operator *ibound-id* nil))

(defun ibound-id-operator () *ibound-id-operator*)

(defun ibound-id-term-p (term)
  (and (eql (id-of-term term) *ibound-id*)
       (null (parameters-of-term term))
       (let* ((bound-terms (bound-terms-of-term term))
	      (bt (car bound-terms)))
	 (and bt (null (cdr bound-terms))))))

(defun bound-term-of-ibound-id-term (term)
  (car (bound-terms-of-term term)))

(defun bound-term-to-ibound-id-term (bound-term)
  (instantiate-term (ibound-id-operator)
		    (list bound-term)))

(defun bindings-of-term-of-ibound-id-term (term)
  (bindings-of-bound-term (car (bound-terms-of-term term))))

(defun term-of-ibound-id-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))

(defun ibound-id-term (bindings term)
  (instantiate-term (ibound-id-operator)
		    (list (instantiate-bound-term term bindings))))


;; Operators of rule source syntax but not rule interpreter syntax.

(define-primitive |!subgoal_cons| nil (car cdr))

;; seems like this should be !assumption_index
;; but this if rule def and not rule spec.
;; rule spec uses !assumption-index with token parameter.
;; OTOH this is only opid without ! and _.
(define-primitive |assumption-index| ((natural . index)))


;; old-subst
;;(define-primitive |!subst|  nil (0 1 ... 1) (subbee subbends))

(defun iold-subst-term-p (term)
  (and (eql (id-of-term term) *isubst*)
       (null (parameters-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (and (null (bindings-of-bound-term-n (car bound-terms)))
	      (forall-p #'(lambda (bound-term)
			    (let ((bindings (bindings-of-bound-term bound-term)))
			      (and bindings (null (cdr bindings)))))
			(cdr bound-terms))))))

(defun subbee-of-iold-subst-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))

(defun subbends-of-iold-subst-term (term)
  (cdr (bound-terms-of-term term)))




;;;
;;; LIB/REF proof representation:
;;;


(define-primitive |!incomplete| ((natural . index)))

(define-primitive |!annotation_cons| () (icar icdr))
(define-primitive |!annotation| ((token . label)) (term))

(define-primitive |!ml_annotation| () (label args))
(define-primitive |!anno_label| ((token . name)) (value))

(define-primitive |!dependency_stores| () (text abstraction statement proof))

;;(define-primitive |!tactic| ((token . type)) (text))


(define-primitive |!inf_tree| () (goal node children annotations))
(define-primitive |!inf_tree_cons| () (car cdr))

(define-primitive |!inf_sequent| ((bool . hidden)) (type (1 . sequent)))
(define-primitive |!inf_goal| () (sequent annotations))

(define-primitive |!inf_top| ((bool . direct)) (dependencies tree tactic))
(define-primitive |!inf_primitive| () (dependencies extract))
(define-primitive |!inf_abbrev| ((bool . direct)) (dependencies extract tactic))
(define-primitive |!inf_unrefined| ())

(define-primitive |!inf_primitive_actual| () (rule))

(define-primitive |!inf_extract| () (term))

(defun null-iinf-extract-term ()
  (instantiate-term (iinf-extract-op)))

(defun null-iinf-extract-term-p (term)
  (null (bound-terms-of-term term)))

(defun null-iinf-goal-term ()
  (instantiate-term (iinf-goal-op)))

(defun null-iinf-goal-term-p (term)
  (null (bound-terms-of-term term)))


(defun iinf-goal-term-to-goal (term)
  (cons (sequent-of-iinf-goal-term term)
	(map-isexpr-to-list (annotations-of-iinf-goal-term term)
			    (iannotation-cons-op))))

(defun sequent-of-goal (g) (car g))
(defun annotations-of-goal (g) (cdr g))

(defun term-to-assum-term-list (term)
  (map-isexpr-to-list (assumptions-of-isequent-term term)
		      (iassum-cons-op)
		      ))

(defun goal-to-term (goal)
  ;;(when (cdr goal) (break));; LAL
  (iinf-goal-term (car goal)
		  (annotations-to-term (cdr goal))))


(defun inf-extract-to-term (e)
  (if e
      (iinf-extract-term e)
      (instantiate-term (iinf-extract-op) nil)))

(defun term-to-inf-extract (ext-term)
  (unless (null-iinf-extract-term-p ext-term)
    (term-of-iinf-extract-term ext-term)))



(defun annotations-to-term (annotations)
  (map-sexpr-to-isexpr annotations
		       (iannotation-nil-term)))

(defun term-to-annotations (term)
   (map-isexpr-to-list term (iannotation-cons-op)))

(defun xref-ianno-p (ianno)
  (and (iannotation-term-p ianno)
       (eql 'xref (tag-of-iproperty-term ianno))))

(defun xref-of-ianno (ianno) (term-of-iannotation-term ianno))

(defun xrefs-of-iannotations (iannos)
  (map-isexpr iannos (iannotation-cons-op)
	      #'(lambda (ianno)
		  (when (xref-ianno-p ianno)
		    (return-from xrefs-of-iannotations (xref-of-ianno ianno))))))
			   


;; RLE TODO at the moment, zeros out dependencies and extracts.
(defun abbreviate-iinf-tree (term)
  (if (not (iinf-tree-term-p term))
      term
      (iinf-tree-term (goal-of-iinf-tree-term term)
		      (iinf-abbrev-term (direct-of-iinf-top-term (node-of-iinf-tree-term term))
					(instantiate-term (idependency-stores-op))
					(instantiate-term (iinf-extract-op))
					(tactic-of-iinf-top-term (node-of-iinf-tree-term term)))
		      (map-sexpr-to-isexpr (map-isexpr-to-sexpr (children-of-iinf-tree-term term)
							   (iinf-tree-cons-op))
					(iinf-tree-nil-term)
					#'abbreviate-iinf-tree)
		      (annotations-of-iinf-tree-term term))))
;; args as terms
(define-primitive |!argument| ((tok . type)) (value))

	

(define-primitive |!refine| () ())

      

(defparameter *special-level-variable* (make-level-variable "\\v"))

(defparameter *special-level-parameter*
  (instantiate-parameter *special-level-variable*
			 *level-expression-type*))

(defmacro special-level-variable-p (v)
  `(level-variable-equal-p ,v *special-level-variable*))

(defun special-level-parameter-p (parameter)
  (and (level-expression-parameter-p parameter)
       (special-level-variable-p (value-of-parameter parameter))))

(defun level-expressions-of-termof-term (term)
  (cdr (parameters-of-operator (operator-of-term term))))


(defun termof-level-variables (ext)
  (cons *special-level-parameter*
	(mapcan #'(lambda (v)
		    (unless (special-level-variable-p v)
		      (list (level-expression-parameter v))))
		(level-variables-of-term ext))))

(defun is-termof-id (term)
  (eql 'termof (id-of-term term)))

(defun oid-of-termof-term (term)
  (if (is-termof-id term)
      (value-of-parameter-r (car (parameters-of-term term)))
      (raise-error (error-message '(oid-of-termof-term not) term))))

(defun termof-of-term (oid term)
  ;;(break "tot")
  ;;(when (null oid) (break "tot"))
  (instantiate-term
   (instantiate-operator 'termof
			 (cons (oid-parameter oid)
			       (termof-level-variables term)))))

(defun termof-of-term-? (name term)
  ;;(when (null oid) (break "tot"))
  (instantiate-term
   (instantiate-operator name
			 (termof-level-variables term))))



;;LAL qf
(defun name-termof-of-term (name term)
  ;;(when (null oid) (break "tot"))
  (instantiate-term
   (instantiate-operator name
			 (termof-level-variables term))))


(defun diff-toks (a -b)
  (let ((acc nil))
    (dolist (tok a)
      (unless (member tok -b)
	(push tok acc)))
    (nreverse acc)))

(defun extract-le-fixup (goal extract)
  ;;(break "el")
  (let ((unbound (diff-toks (level-variables-of-term extract)
			    (level-variables-of-term goal))))
    (substitute-parameters-in-term extract
				   (mapcar #'(lambda (v)
					       ;; ?? *special-level-parameter*
					       ;; ?? (make-level-constant 0)
					       ;; zero not allowed ??
					       (cons v *special-level-parameter*
						     ;;(level-expression-parameter (make-level-constant 1))
						     ))
					   unbound))))




(define-primitive |!cons_left| nil  (left right))
(define-primitive |!pui_addr_cons| nil  (car cdr))
(define-primitive |!pui_addr| ((natural . natural)) ())
(define-primitive |!proof_editor_cons| nil (car cdr))
(define-primitive |!proof_editor| ((token . view))  (node))

(define-primitive |!proof_node_cons| nil (car cdr))
(define-primitive |!proof_node|
    ((oid . oid) (natural . depth) (token . view) (natural . count))
  (status address goal refinement subgoals annotations))

(define-primitive |!proof_status|  ((token . state))  ())
(define-primitive |!pui_sequent| ((natural . numeral) (bool . repeat-p)  (bool . invisible-p)) (sequent))

;; meta-prl :
(define-primitive |!numbered| () (num term))
(define-primitive |!num_sequent| () (numeral sequent))
(define-primitive |!mp_msequent| () (assums goal))
(define-primitive |!mp_num_msequent| () (num assums goal)) ;; for display
(define-primitive |!nl_prf| () (goal tactic subgoals extras))

(defun itext-slot-term ()
  (instantiate-term
   (instantiate-operator (intern "!text")
			 (list (instantiate-parameter
				(slot-parameter-value "text") *string-type*)))
   nil))


;;;;	
;;;;	!lambda(1)
;;;;	!apply(0;0)
;;;;	
;;;;	Implementation terms may occur in partial extracts as 
;;;;	method of encoding delayed substutions.
;;;;	
;;;;	When extract is complete the they should be computed away.
;;;;	
;;;;	
;;(define-primitive |!apply| () (function arg))
;;(define-primitive |!lambda| () ((1 . body)))



(defconstant *iapply* '|!apply|)
(defconstant *ilambda* '|!lambda|)

(defun iapply-term-p (term)
  (and (let ((op (operator-of-term term)))
	 (and (eql (id-of-operator op) *iapply*)
	      (null (parameters-of-operator op))))
       (let ((bts (bound-terms-of-term term)))
	 (and (forall-p #'(lambda (bt) (null (bindings-of-bound-term bt))) bts)
	      (cdr bts)			; at least two
	      t ))))

(defun ilambda-term-p (term)
  (and (let ((op (operator-of-term term)))
	 (and (eql (id-of-operator op) *ilambda*)
	      (null (parameters-of-operator op))))
       (let ((bts (bound-terms-of-term term)))
	 (and (forall-p #'(lambda (bt)
			    (and (bindings-of-bound-term bt) ; at least one.
				 t)) bts)
	      (null (cdr bts))
	      t ))))
    
(defun args-of-iapply-term (term)
  (mapcar #'term-of-bound-term-f
	  (cdr (bound-terms-of-term term))))

(defun function-of-iapply-term (term)
  (term-of-bound-term
   (car (bound-terms-of-term term))))

(defun body-of-ilambda-term (term)
  (term-of-bound-term
   (car (bound-terms-of-term term))))

(defun bindings-of-body-of-ilambda-term (term)
  (bindings-of-bound-term
   (car (bound-terms-of-term term))))
    

(defun icompute (term)
  (labels ((sub (term)
	     (let ((ilam (function-of-iapply-term term)))
	       (if (not (ilambda-term-p ilam))
		   (raise-error (error-message `(icompute function !lambda not) ilam))
		   (let ((body (body-of-ilambda-term ilam)))
		     (let ((nterm (substitute body
					      (mapcar #'(lambda (b arg) (cons b arg))
						      (bindings-of-body-of-ilambda-term ilam)
						      (args-of-iapply-term term)))))
		       (aux nterm))))))
    
	   (aux (term)
	     (if (iapply-term-p term)
		 (sub term)
		 (maybe-instantiate-term term
					 (operator-of-term term)
					 (mapcar #'(lambda (bt)
						     (maybe-instantiate-bound-term
						      bt
						      (bindings-of-bound-term bt)
						      (aux (term-of-bound-term bt))))
						 (bound-terms-of-term term)))))

	   )


    (if (or (term-walk-p term #'iincomplete-term-p)
	    (not (term-walk-p term #'iapply-term-p)))
	term
	(aux term))))


;; returns nil if extract is nil or if any referenced child is nil.
(defun extract-replace (extract children)
  ;;(setf -a extract -b children) (break "er")
  (labels
      ((visit (term)
	 (if (iincomplete-term-p term)
	     (let ((child (nth (1- (index-of-iincomplete-term term))
			       children)))
	       (or child
		   (progn
		     (setf -term term -extract extract -children children)
		     (break "er")
		     nil)
		   (return-from extract-replace nil)))
	     (maybe-instantiate-term
	      term
	      (operator-of-term term)
	      (mapcar #'(lambda (bt)
			  (maybe-instantiate-bound-term bt
							(bindings-of-bound-term-n bt)
							(visit (term-of-bound-term bt))))
		      (bound-terms-of-term term))))))

    (when extract
      (let ((next (visit extract)))
	(when next
	  (icompute next))))))



(define-primitive |tactic_tree| () (tactic children))
(defvar *tactic-tree-nil-term* (instantiate-term *tactic-tree-operator* nil))

(define-primitive |!refinement_tree| () (refinement children))
(define-primitive |!refinement_tree_cons| () (car cdr))
(define-primitive |!refinement_tree_refinement| () (tactic goal refinement))
;;
;; !void ()
;; A THEN (TRY COMPLETE B), A produces two subgoals a1 and a2.
;; TRY fails on a1 but reuturns a refinemnt on a2. The a1 failure
;; will show here as !goal(0;0).
(defun refinement-tree-to-iinf-tree-term (deps rsrc rtt)
  (setf -deps deps -rsrc rsrc -orig-rtt rtt)
  (let ((frontier nil))
    (labels ((aux (rtt)
	       (format t "rtr 1~%")
	       (setf -rtt rtt) ;;(break "rttit")
	       (let ((c (map-isexpr-to-list (children-of-irefinement-tree-term rtt)
					    (irefinement-tree-cons-op)
					    #'aux)))

		 (let ((rtr (refinement-of-irefinement-tree-term rtt)))
		   (let ((ref (refinement-of-irefinement-tree-refinement-term rtr))
			 (goal (goal-of-irefinement-tree-refinement-term rtr))
			 (tactic (tactic-of-irefinement-tree-refinement-term rtr)))

		     (format t "rtr 2~%")
		     (setf -ref ref -goal goal -tactic tactic)

		     (if (ivoid-term-p ref)
			 (let ((itree (iinf-tree-term goal
						      (iinf-unrefined-term)
						      (iinf-tree-nil-term)
						      (iannotation-nil-term))))
			   (push itree frontier)
			   itree)
			 (let ((subgoals (map-isexpr-to-list (children-of-iinf-tree-term ref)
							     (iinf-tree-cons-op)))
			       (node (node-of-iinf-tree-term ref)))

			   (setf -subgoals subgoals -c c);; (break "rtt2")
			   (iinf-tree-term goal
					   ;; node should be degenerate !inf_top without a tactic.
					   (instantiate-term
					    (operator-of-term node)
					    (append (bound-terms-of-term node)
						    (list (instantiate-bound-term tactic))))
					   (if (and subgoals (null c))
					       ;; The refinement tree term does not contain nodes for
					       ;; unproven subgoals. Thus that needs to be expanded here.
					       ;; either the children of the rtt match the subgoals of the
					       ;; refinement or the children are null and the subgoals are
					       ;; part of the frontier.
					       (let ((nc (mapcar #'(lambda (g)
								     (iinf-tree-term g
										     (iinf-unrefined-term)
										     (iinf-tree-nil-term)
										     (iannotation-nil-term)))
								 subgoals)))
						 (setf frontier (append (reverse nc) frontier))
						 (map-sexpr-to-isexpr nc (iinf-tree-nil-term)))
					       (progn
						 (when (not (= (length subgoals) (length c)))
						   (raise-error (error-message '(refinement-tree-to-iinf-tree tree form bad) rtt)))
						 (map-sexpr-to-isexpr c (iinf-tree-nil-term))))
					   (annotations-of-iinf-tree-term ref)))))))))

      (let ((r (iinf-tree-term (goal-of-irefinement-tree-refinement-term 
				(refinement-of-irefinement-tree-term rtt))
			       (iinf-top-term t
					      deps
					      (aux rtt)
					      rsrc)
			       (map-sexpr-to-isexpr (nreverse frontier)
						    (iinf-tree-nil-term))
			       (iannotation-nil-term)
			       )))
	;;(view-show r)
	r))))









