%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
***************************************************************************
***************************************************************************
COMPUTE-CONVS.ML
***************************************************************************
***************************************************************************
Atomic direct computation conversions

]%


let TagC tagger (e:env) t =
  ( let tagged_t = tagger t in
    let computed_t = do_computations tagged_t in
      computed_t, 
      untyped_equal_reln,
      form_comp_seq_just ((NOP,t,[]).(FWD,tagged_t,[]).[NOP,computed_t,[]])
  ) 
  ? failwith `TagC`
;;

let BetaC e t = 
  TagC tag_beta_redex e t
  ? 
  failwith `BetaC`
;;

let RedexC e t = 
  TagC tag_prim_redex e t
  ? 
  failwith `RedexC`
;;

let SORedexC e t = 
  TagC tag_so_redex e t
  ? 
  failwith `SORedexC`
;;

let ExtractC names e t = 
  TagC (tag_extract names) e t
  ?
  failwith `ExtractC`
;;

let AnyExtractC e t = 
  TagC tag_any_extract e t
  ?
  failwith `ExtractC`
;;

let UnfoldTopAbC e t= 
  TagC tag_any_ab_for_unfold e t
  ? 
  failwith `UnfoldTopAbC`
;;

let UnfoldsTopC names e t = 
  TagC (tag_abs_for_unfold names) e t
  ? 
  failwith `UnfoldsTopC`
;;

let UnfoldTopC name = UnfoldsTopC [name]
;;


let RevTagC tagger (e:env) t =
  ( let tagged_t = tagger t in
    let [untagged_t] = subterms_of_term tagged_t in
      untagged_t, 
      untyped_equal_reln,
      form_comp_seq_just ((NOP,t,[]).(REV,tagged_t,[]).[NOP,untagged_t,[]])
  ) 
  ? failwith `RevTagC`
;;

let FoldsTopC names e t = 
  RevTagC (fold_and_tag_abs names) e t
  ?
  failwith `FoldsTopC`
;;

let FoldTopC name = FoldsTopC [name]
;;

% could leave off e t args and let fold_and_tag happen with partial apply
  but may allow failure to occur earlier than expected particularly for _o version.
 PERF?
%
let FoldWithC ts name e t =
  RevTagC (fold_and_tag_top_ab_with name ts) e t
;;
let FoldWithC_o ts obid e t =
  RevTagC (fold_and_tag_top_ab_aux_o obid ts) e t
;;


let AUnfoldsTopC attrs =
  let utattrs = map (string_to_tok o string_upcase) attrs in
  (\e t. let tattrs = get_ab_attrs_of_term t in
          if not null (intersection utattrs tattrs) then
             UnfoldTopAbC e t 
         else failwith `AUnfoldsTopC`)
;;

let ComputeC_o dir obidts e t =
 TagC (mk_tag_term_aux_o 0 dir obidts) e t
 ? failwith `ComputeC_o`
;;
%isl outr outl btrue bfalse ifthenelse p1 p2%

%[
***************************************************************************
Composite direct computation conversions.
***************************************************************************
]%

% 
Could use Top or Depth compounds here?
%

%[
    
Nuprl terminology is a mess at the moment. Here are a few overloaded words!

Compute  1. any redex contraction and definition expansion.
         2. As tactic, doesn't touch defs.
Eval     1. Bit more than lazy evaluation. also some definition expansion.
         2. the nuprl evaluation relation.
Reduce   1. Contract all redices (in what order...)
Normalize 1. expand all defs and contract all redices
          2. get into normal form. Don't expand defs. Head order normalization
          3. Applicative order norm.
SemiNorm  1. Expand some defs and contract all redices.
Unfold  1. Unfold all visible defs specified.
        2. Repeatedly unfold specified defs till none left.
ExpandDefs Like Unfold...

Definitions Abstractions... to abstract to reify...

These need debugging!

]%


%
UnfoldsC does one stage of unfolding, unfolding only those defs 
named names which are visible at the start.  Fails if no unfolding done.
%

let UnfoldsC names =
  SweepUpC (UnfoldsTopC names)
  ?
  failwith `UnfoldsC`
;;


let UnfoldC name = UnfoldsC [name] ;;

let AUnfoldsC attrs = SweepDnC (AUnfoldsTopC attrs) ;;

let FoldsC names = SweepUpC (FoldsTopC names)
  ?
  failwith `FoldsC`
;;

let FoldC name = FoldsC [name] ;;

let FoldC_o obid = FoldC (name_of_abstraction obid);;

%
Redex contracting strategies...

Lazy (normal order) reduction. Puts term in head normal form. Never fails.
%

letrec LazyReduceC (e:env) t =
      ( TryC (SubIfC (\e. is_principle_arg) LazyReduceC) ANDTHENC
        TryC (RedexC ANDTHENC LazyReduceC)
      ) e t
;;

let LazyEvalC defs =
  letrec LzE (e:env) t =
    ( RepeatC (UnfoldsTopC defs) 
      ANDTHENC SubIfC (\e. is_principle_arg) LzE
      ANDTHENC TryC (RedexC ANDTHENC LzE)
    ) e t
  in
    LzE 
;;

letrec LazyNormC e t = 
 (RepeatC (UnfoldTopAbC ORELSEC AnyExtractC) 
  ANDTHENC TryC (SubIfC (\e. is_principle_arg) LazyNormC)
  ANDTHENC TryC (RedexC ANDTHENC LazyNormC)
 ) e t
;;

%
Eager (applicative order) reduction. Puts term in normal form. Never fails.
%

let EagerReduceC =
      ReDepthC RedexC
;;

let EagerEvalC defs =
      ReDepthC (Repeat1C (UnfoldsTopC defs) ORTHENC RedexC)
;;

%
Reduce contracts all redices, leaving a redex free term. Always succeeds.
Same strategy as used in current Reduce tactic.
%

let PrimReduceC =
  RepeatC (SweepUpC RedexC)
;;
let SOReduceC =
  RepeatC (SweepUpC SORedexC)
;;

%
Expand all named def occurrences till none left, and then reduce all redices.
Always succeeds.
%

let SemiNormC names =
    SweepDnC (RepeatC (UnfoldsTopC names)) ANDTHENC PrimReduceC
;;    
%
Expand every def and reduce all redices. Never fails.
%

let NormalizeC =
      SweepDnC (RepeatC UnfoldTopAbC) ANDTHENC PrimReduceC
;;    

%[
***************************************************************************
Functions for creating macro dc conversions.
***************************************************************************
]%

%[ 
A macro conversion is built from two pattern terms t1 and t2 and
two dc conversions c1 and c2. The conversions when applied to t1 and
t2 must yield the same term. A macro conversion converts any term 
which is an intance of t1 into the corresponding instance of t2.

Special feature. If * given as name, don't do free_var check.
Useful when its used on-the-fly in theorems to fold abstractions involving
new free vars.
]%

letref MacroC_info = void_term,void_term ;;

let MacroC name (c1:convn) t1 (c2:convn) t2 =
  let ids = free_vars t1 in
  let le_vars = level_vars t1 in
  if not name = `*` & not subset (free_vars t2) ids then 
    failwith `MacroC:C too many free vars in rhs.` 
  else
    let t1',r1,just1 = c1 null_env t1 in
    let t2',r2,just2 = c2 null_env t2 in
    if not (alpha_equal_terms t1' t2') then 
      (MacroC_info := t1',t2'
       ; failwith `MacroC: lhs and rhs do not convert to same`
      )
    if is_tactic_just just1 or is_tactic_just just2 then
      failwith `MacroC: a conversion returned a tactic`
    else
      let cs1 = open_comp_seq_just just1  in
      let cs2 = open_comp_seq_just just2  in
      let combined_cs = 
          append_compute_seqs cs1 (reverse_compute_seq cs2) in
      let failure_message = `MacroC closure: ` ^ name 
      in
        \(e:env) t. 
            let sub = full_match 0 le_vars ids t1 t  
                        ? failwith failure_message in
            let t' = full_subst sub t2 in
            let instantiated_cs =
                  map (\op,pat_t,tac. op, full_subst sub pat_t, tac) combined_cs
            in
              t', untyped_equal_reln, form_comp_seq_just instantiated_cs
;;


let SimpleMacroC name t1 t2 abs_to_expand =
  let SN = 
        SemiNormC abs_to_expand 
  in
    MacroC name SN t1 SN t2
;;


let FwdMacroC name c t =
  MacroC name c t IdC (fst (c null_env t))
;;

let DoubleMacroC name c1 t1 c2 t2 = 
  MacroC name c1 t1 c2 t2
  ,
  MacroC (`rev_` ^ name) c2 t2 c1 t1
;;

let TryDoubleMacroC name c1 t1 c2 t2 = 
  let AC = MacroC name c1 t1 c2 t2 in
  let BC = MacroC (`rev_` ^ name) c2 t2 c1 t1 ? FailC 
  in
    AC,BC
;;

%[
***************************************************************************
Functions for non canonical term reduction
***************************************************************************
]%

%
Need a couple of things here:

1. An AbUnroll function. This on the fly constructs macro conversions
for doing obvious unrollings of inductive definitions hidden inside 
abstractions.

2. A mod of this which references the case rules.

Seems stupid to have to put in explicit macro convs for these things.
We can cache stuff internally if we like...

While we are about it, we can think more about abstraction reduction in
the non recursive case.
%


    

% 
handles when we don't have an explicit redex, but we do
have a non-canonical term which we want to evaluate.
Want an option to supply a tactic to run on the conditional subgoal.

let ReduceCaseThenC case Optional_Tac e t =
%

let one = mk_integer_term 1 ;;
let zero = mk_integer_term 0 ;;

let case_reduce_term case t = 
  let opid = opid_of_term t in
  ((if opid = `ind` then
    ( let n,([a;b],down),base,([c;d],up) = dest_ind t in
      if case = `down` then
        subst [a,mk_ind_term 
                  (mk_add_term n one)
                  ([a;b],down)
                  base
                  ([c;d],up)
              ;b,n
              ]
              down
        ,
        (mk_less_than_term n zero)
      if case = `base` then
        base
        ,
        (mk_equal_term int_term n zero)
      if case = `up` then
        subst [c,mk_ind_term 
                  (mk_subtract_term n (mk_integer_term 1))
                  ([a;b],down)
                  base
                  ([c;d],up)
              ;d,n
              ]
              up
        ,
        (mk_less_than_term zero n)
      else fail
    )
    if opid = `less` then
    ( let a,b,c,d = dest_less t in
      if case = `true` then
        c
        ,
        (mk_less_than_term a b)
      if case = `false` then
        d
        ,
        (mk_simple_term `ge` [a;b])
      else fail
    )
    if opid = `int_eq` then
    ( let a,b,c,d = dest_inteq  t in
      if case = `true` then
        c
        ,
        (mk_equal_term int_term a b)
      if case = `false` then
        d
        ,
        (mk_simple_term `nequal` [int_term;a;b])
      else fail
    )
    if opid = `atom_eq` then
    ( let a,b,c,d = dest_atomeq  t in
      if case = `true` then
        c
        ,
        (mk_equal_term atom_term a b)
      if case = `false` then
        d
        ,
        (mk_simple_term `nequal` [atom_term;a;b])
      else fail
    )
    else fail
   )  
   ? failwith `case_reduce_term`
  ) 
;;

let ReduceCaseThenC Tacs case e t =
  let opid = opid_of_term t in
  let t',C = case_reduce_term case t in
  let SubgoalTac = 
  ( if null Tacs then
      AddHiddenLabel `reduce condition`
    else 
      hd Tacs
  ) 
  in
  let do_rewrite = 
  ( if null Tacs then
      true
    else
      ((Complete (hd Tacs) (mk_sequent_using_env e C)
        ; true
       )
       ? false
      )
  )
  in
  if do_rewrite then
    t'
    ,untyped_equal_reln
    ,form_tactic_just
      (PrimReduceFirstEquand case THEN 
       IfLab `main` (AddHiddenLabel `wf`) SubgoalTac
      )
  else 
    failwith `ReduceCaseThenC: Tac failed to complete`
;;

% 9/2002 redefined in prog-case
let ReduceCaseC = ReduceCaseThenC [] ;;
%

let ReduceThenC T e t =
  let opid = opid_of_term t in
  let cases = 
  ( if opid = `ind` then ``up base down``
    if member opid ``int_eq less atom_eq`` then ``true false``
    else
      failwith `ReduceThenC: conv does not apply`
  )
  in
    FirstC (map (ReduceCaseThenC [T]) cases) e t
;;

%[
***************************************************************************
Debugging Conversions
***************************************************************************
]%

% 
The justification here cannot be executed. Might be worth adding 
a special option at top level to use Fiat rule to make it executable.(In 
some debug mode.)
%

let FakeC t' (e:env) t = 
      t',
      untyped_equal_reln,
      form_comp_seq_just ((NOP,t,[]).(FAKE,t,[]).[NOP,t',[]])
;;

%
Uses FakeC to rw instances of t1 to instances of t2 
%

let PatC t1 t2 =
  let ids = free_vars t1 in
  let le_vars = level_vars t1 in
  if not subset (free_vars t2) ids then 
    failwith `PatC:C too many free vars in rhs.` 
  else
        \(e:env) t. 
            let sub = full_match 0 le_vars ids t1 t  
                        ? failwith `PatC: failed match`
            in 
              FakeC (full_subst sub t2) e t
;;

%[
***************************************************************************
Lambda Abstraction conversions.
***************************************************************************
To help with higher order matching, where basic matching fails. 
i.e. when higher order var applied to something else other than
set of bound vars.


LambdaC '\x1...xn.t(ys,x1...xn)'

rewrites terms of form:

  't(ys,t1...tn)'

to 

  '(\x1...xn.t(ys,x1...xn)) t1 ... tn'
]%

let dest_soft_lambda t = 
  dest_lambda (unfold_soft_abs t) ;;


let dest_iterated_soft_lambda = unreduce dest_soft_lambda ;;

let LambdaC lamt = 
  let xs,t = dest_iterated_soft_lambda lamt in
  let t' = mk_iterated_apply (lamt.map mvt xs) in
  let RedC = SweepUpC (AddrC [1]  (TryC (IfC (\e t.is_soft_ab t) UnfoldTopAbC))
                       ANDTHENC BetaC)
  in
    MacroC `LambdaC` IdC t RedC t'
;;

%[
***************************************************************************
Adding Guard Terms
***************************************************************************
]%

let GuardC e t = FoldTopC `guard` e t ;;
