%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
| This is a package for creating states, which are implemented
| as functions with natural number domains.
|
| To use "create_state", you must provide the following argtuments:
|    name: base name of state (as a tok)
|    values: variable names (as tokens), and their types
|
| The create_state call provides the type of the enum,
| abstractions for each of the values,
| and a switch.
]%

%
| Tactic for proving wf of state.
%
let ProgStateWF p =
    let (), state = dest_member (concl p) in
    let sopid, () = dest_simple_term state in
        (Unfold sopid 0
	 THEN MemCD
	 THENL [Auto; SplitEnumSwitch (sopid ^ `_enum`) 0 THEN Auto]) p;;

%
| Tactic for proving branch cases.
%
let ProgStateVarWF p =
    let T, vart = dest_member (concl p) in
    let (), statet, type = dest_function T in
    let vopid, () = dest_simple_term vart in
    let sopid, () = dest_simple_term statet in
    let ApplyEquality p =
        let i, enumt, switcht = dest_function (h 1 p) in
	let (), t = dest_member (concl p) in
	let vart, caset = dest_apply t in
        let memt = mk_member_term (subst [i, caset] switcht) t in
	    (Assert memt
	     THENL [MemCD THENL [Trivial; Auto];
		    RW (AddrC [1] AbRedexC) (-1) THEN Trivial]) p
    in
        (Unfold vopid 0
         THEN MemCD
	 THENL [Unfold sopid 1 THEN ApplyEquality; Auto]) p;;

%
| Make the state abstraction.
%
let create_state_abs oacc sopid opid types univ =
    % It is a function type %
    let sopids = tok_to_string sopid in
    let ab_df = [mk_text_term sopids] in
    let le_vars = collect level_vars types in
    let le_parms = map (mk_level_exp_parm o mk_var_level_exp) le_vars in
    let ab_term = mk_term (sopid, le_parms) [] in
    let v = `i' in
    let vt = mk_var_term v in
    let ab_def =
	mk_function_term v
	  (mk_simple_term (sopid ^ `_enum`) [])
	  (mk_simple_term (sopid ^ `_enum_switch`) (vt.types))
    in
    let ab_wf_thm = mk_member_term univ ab_term in
    let wf_text = "ProgStateWF" in
      (call_oacc oacc
        [ create_disp_content_for_new_def ab_term (sopids J "_df") sopids
	; create_ab_content_for_new_def ab_term ab_def sopids
	; create_thm_obj_data ab_wf_thm (itext_term wf_text) (sopids J "_wf")
	])
;;	

%
| State variables.
%
let create_state_vars oacc sopid opid names types =
    let opids = tok_to_string opid in
    let state = `state' in
    let statet = mk_var_term state in
    let statetype = mk_simple_term sopid [] in
    letrec aux oacc names types =
	if not null names then
	   (let name.namerest = names in
	    let type.typerest = types in
	    let ab_name = opid ^ `_` ^ name in
            let ab_names = tok_to_string ab_name in
	    let ab_df = [mk_text_term ab_names] in
	    let ab_term = mk_simple_term ab_name [] in
	    let ab_def =
		mk_lambda_term state
		  (mk_apply_term statet
		    (mk_simple_term (opid ^ `_` ^ name ^ `_enum`) []))
	    in
	    let ab_wf_thm =
		mk_member_term
		  (mk_function_term null_var statetype type)
		  ab_term
	    in
	    let wf_text = "ProgStateVarWF" in
		aux (call_oacc oacc
	       		[ create_disp_content_for_new_def ab_term (ab_names J "_df") ab_names
			; create_ab_content_for_new_def ab_term ab_def ab_names
			; create_thm_obj_data ab_wf_thm (itext_term wf_text) (ab_names J "_wf")
			])
		     namerest typerest)
	    else oacc
	      
    in
	aux oacc names types;;

%
| Some theorems about states.
%
let create_state_thms oacc sopid opid names types = oacc;;

%
| Make a state.
%
let create_state_aux oacc sopid opid names types univ =

    % Make the theorems %
    create_state_thms

      % Make the state vars %
      (create_state_vars  % Make the state %
			  (create_state_abs oacc sopid opid types univ)
         sopid opid names types)

      sopid opid names types
 ;;



