%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
;;;;	
;;;;	Moving calls to content to end to move dependencies on system 
;;;;	down the chain.
;;;;	
;;;;	TODO delete object which deletes all objects created by create_rec_mod
;;;;	
;;;;	
;;;;	dependency on token name to identify object and place is unreliable.
;;;;	Need an object_id /token pair.
%

let object_accumulate f name = 
  if not (exists_object_delimiters_p name)
     then let place = `create_` ^ name in
	    (create_object_accumulator name place (\oacc. f (inr oacc)))
     else f (inl ())

   ; ()
;;

let ref_env_content name dir cur prevs abs stms adds = 
 
 create_ml_obj_data 
  (let re =
   make_term (`!make_reference_environment`, 
	       [make_object_id_parameter cur; make_object_id_parameter dir])
	     [ ([], map_to_ilist ioid_term ioid_cons_op prevs)
             ; ([], map_to_ilist ioid_term ioid_cons_op abs)
             ; ([], map_to_ilist ioid_term ioid_cons_op stms)
             ; ([], map_to_ilist ioid_term ioid_cons_op adds)
	     ] in
  %view_showw name re;%
  re
  )
  ((tok_to_string name) J "_reference_environment")
;;

% apparently not used 5/02
let at_location_make_ref_env f dirp delimp mnemonic =
 \re cur loc. if (isr loc)
                then let dir,place = (outr loc) in 
                     let oid,obacc = (make_obacc_aux dirp delimp mnemonic (dir,place)) in 
		     let r = (with_ref_environment f (inr obacc) re) in 
	               ( obacc [(ref_env_content mnemonic dir cur [re] [oid] [oid] [])]
		       ; r)
	        else (with_ref_environment f (inl ()) re)
;;
%


%
;;;;	
;;;;	From prog-case :
;;;;	

| Convenient defaults.
|    1. update is not forced,
|    2. place the pattern above a "create_<opid>" library object,
|    3. default initial format.
%
%
let create_pattern opid pattern update_flags =
   object_accumulate_x
        (\oacc.
	  snd (create_pattern_aux
		false
		false
		oacc
		opid
		pattern
		update_flags
		[]))
       opid (`create_` ^ opid)
;;
%
% update flags are meant to be used to force replace of old versions if present
  currently do not support replacement except for wholesale delete and recreation.
  flags then mistakenly? reinterpreted to mean whether to create at all
  so just force flags on here.
%
let create_pattern_at opid pattern update_flags =
  at_location_wrechain_sorted false
    (\oacc. snd (create_pattern_aux oacc false opid pattern
                     [`case_display`; `case_abstraction`] % update_flags%
                     []))
    true true opid
;;
let create_state_pattern_at opid pattern update_flags =
  at_location_wrechain_sorted false
    (\oacc. 
     snd (create_pattern_aux
	    oacc
	    true
	    opid
	    pattern
            [`case_display`; `case_abstraction`] % update_flags%
	    []))
     true true opid
;;

	    
%
| Update a pattern
%
% would require reaccumulator :
let update_pattern opid =
    let opid = string_to_tok opids in
    let copid, cflag, update_flag, state_flag, pattern = get_pattern opid ?
	failwith `update_pattern: no pattern for ` ^ opid
    in
     snd (create_pattern_aux
	    true
	    state_flag
	    (tok_to_string opid J "_finish")
	    opid
	    pattern
	    update_flag
	    []);;
%

%
| Update all patterns.
%
% would require reaccumulator :
let update_all_patterns arg =
    letrec aux patterns =
	if null patterns then
	    ()
	else
	    let opid, copid, cflag, update_flag, state_flag, pattern = hd patterns in
		if not null update_flag then
	          snd (create_pattern_aux
		        true
			state_flag
			(tok_to_string opid J "_finish")
			opid
			pattern 
			update_flag
			[]);
		aux (tl patterns)
    in
	aux pattern_list;;
%


%
;;;;	
;;;;	From prog-union :
;;;;

| Usually unions are created above a "create_..." object.
%

let create_union_at aopid opid arg_pairs parts U_term =
  at_location_wrechain false
     (\oacc . snd (create_union_aux oacc false aopid opid arg_pairs parts U_term))
    true true opid
;;

let create_state_union_at aopid opid arg_pairs parts U_term =
  at_location_wrechain false
    (\oacc . snd (create_union_aux oacc true aopid opid arg_pairs parts U_term))
    true true opid
;;



%
;;;;
;;;;	from prog-module.
;;;;	

| Create the object before create_<opid>
%
let create_rec_module_at topid copid pi_opid arg_pairs data_pairs U_term =
  at_location_wrechain_sorted false
    (\oacc. snd (create_rec_module_aux oacc
                  false topid copid pi_opid arg_pairs data_pairs U_term))
    true true copid
;;

let create_rec_state_module_at topid copid pi_opid arg_pairs data_pairs U_term =
  at_location_wrechain_sorted false
    (\oacc. snd (create_rec_module_aux oacc
                  true topid copid pi_opid arg_pairs data_pairs U_term))
    true true copid
;;

%
;;;;
;;;;	from prog-enum.
;;;;	

| Normal use places it above a create_<name>_enum
%
let create_enum_at eopid opid values =
  at_location_wrechain false
    (\oacc. create_enum_aux oacc false eopid opid values) 
    true true eopid
;;

let create_state_enum_at eopid opid values =
  at_location_wrechain false
    (\oacc. create_enum_aux oacc true eopid opid values)
    true true eopid
;;

%
| Update the enum switch.
%
% would require reaccumulator :
let update_enum eopid =
    let opid, values = get_enum eopid 
	               ? failwith `unknown enumeration`
    in
	create_enum_switch ("create_" J (tok_to_string opid)) eopid opid values true;; 
%

%
| Normal use places it above a create_<name>_enum
%

let create_state sopid opid values univ =

  let names, types = unzip values in
  let names' = map (\n. n ^ `_enum`) names in

  at_location_wrechain false
    (\oacc. 
       create_state_aux (create_enum_aux oacc false (sopid ^ `_enum`) opid names')
         sopid opid names types univ
	)
    true true sopid
;;
