%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
| This package simulates a many-way disjoint union, and
| patterns for each of the ways.
|
| Usage: create_union
|            1. name: base name as a token
|	     2. args: parameters of this type
|            3. values: (tok * term) list
|                  Each tok specifies part of the union hasving type 'Term'
|            4. univ: term
|		   Universe this union should belong to
]%

%
| Create the union from the parts.
%
let mk_iterated_union types =
    let i = length types in
    letrec aux types i =
	if i = 1 then
	    hd types
	else
	    mk_union_term (hd types) (aux (tl types) (i - 1))
    in
	if i = 0 then
	    failwith `mk_iterated_union: empty union`
	else
	    aux types i;;

%
| Make an injection for a part.
%
let mk_iterated_injection j i term =
    letrec aux k =
	if k = j then
	    if j = i then
		term
	    else
		mk_simple_term `inl` [term]
	else
	    mk_simple_term `inr` [aux (k + 1)]
    in
	aux 1;;

%
| Create the main union.
%
let create_union_abs oacc aopid arg_pairs ab_term ab_def U_term =
    let aopids = tok_to_string aopid in
    let ab_wf_thm = mk_iterated_all arg_pairs (mk_member_term U_term ab_term) in
    let wf_text = "Unfold `" J aopids J "` 0 THEN Auto" in
     call_oacc oacc
      [ create_disp_content_for_new_def ab_term (aopids J "_df") aopids;
	create_ab_content_for_new_def ab_term ab_def aopids;
	create_thm_obj_data ab_wf_thm (itext_term wf_text) (aopids J "_wf")
      ]
;;


%
| Create union patterns.
| This creates constructors and destructors for the parts.
|
| If the type of a part is 'Unit', then the
| constructor assumes that the argument is the unique element.
%
let create_union_patterns oacc state_flag aopid opid arg_pairs parts term def =
    let aopids = tok_to_string aopid in
    let i = length parts in
    let bv = all_vars def in
    let v = maybe_new_var `x' bv in
    let vt = mk_var_term v in
    let it = mk_simple_term `it` [] in
    let format =
	[mk_text_term "(";
	 mk_df_slot_format (tok_to_string (var_to_tok v)) "term" "*";
	 mk_text_term ")"]
    in
    letrec aux oacc pattern_abs parts j =
	if not null parts then
	    let name, type = hd parts in
	    let popid = opid ^ `_` ^ (var_to_tok name) in
	    let popids = tok_to_string popid in
	    let null_flag = opid_of_term type = `unit` in
	    let inj = mk_iterated_injection j i (if null_flag then it else vt) in
	    let dform = (mk_text_term popids).(if null_flag then [] else format) in
	    let wf_thm =
		mk_iterated_all arg_pairs
		    (if null_flag then
			 mk_member_term term
			     (mk_simple_term popid [])
		     else
			 mk_all_term v type
			     (mk_member_term term
			         (mk_simple_term popid [vt])))
	    in
	    let wf_text =
		"Unfolds ``" J popids J " " J aopids J "`` 0 THEN UnivCD THEN Auto"
	    in
            let pattern_ab_terms, oacc' = create_pattern_aux oacc state_flag popid inj update_case_flags dform in
	        
              aux
                (call_oacc oacc'
		     [create_thm_obj_data wf_thm (itext_term wf_text) (popids J "_wf")])
                (pattern_ab_terms . pattern_abs)
		(tl parts) (j + 1)
	else
	    (unzip (reverse pattern_abs), oacc)
    in
	aux oacc [] parts 1;;


%
| Create the union.
%

let create_union_aux oacc state_flag aopid opid arg_pairs parts U_term =
    % Preliminaries %
    let aopids = tok_to_string aopid in
    let arg_vars, arg_types = unzip arg_pairs in
    let type_vars, types = unzip parts in
    let ab_def = mk_iterated_union types in
    let le_vars = level_vars ab_def in
    let ab_term = mk_term (aopid, (map (mk_level_exp_parm o mk_var_level_exp) le_vars))
	                  (map (\x. [], mk_var_term x) arg_vars)
    in
      create_union_patterns (create_union_abs oacc aopid arg_pairs ab_term ab_def U_term)
          state_flag aopid opid arg_pairs parts ab_term ab_def
;;
    

