%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
*********************************************************************
*********************************************************************
REC-TYPE-TACTICS.ML
*********************************************************************
*********************************************************************
Tactics to support simple rec types.

Defined here:

RecTypeEqCD       : incorporated into PrimEqCD tactic and hence Auto
RecTypeHD i
RecTypeEqTypeCD

RecInduction i
RecInd i

AbRecTypeHD i      : incorporated into D tactic
AbRecTypeEqTypeCD  : incorporated into EqTypeCD/MemTypeCD tactic
AbRecInd i

Unused rules:


*R rec_memberFormation  
               H,   |- rec(z.t) ext t   
                 by rec_memberFormation level-expression{i:l} 
                 H |- t[rec(z.t)/z] ext t                     
                 H |- rec(z.t) = rec(z.t) in U{i} ext Ax

*R rec_indEquality  
  H,   |- rec_ind(r1;h1,z1.t1) = rec_ind(r2;h2,z2.t2) in S[r1/x] ext Ax  
  by rec_indEquality x S rec(Z.T) level-expression{i:l} u v w
  H |- r1 = r2 in rec(Z.T) ext Ax                            
  H |- rec(Z.T) = rec(Z.T) in U{i} ext Ax                    
  H, u:rec(Z.T) -> U{i}, v:w:{w:rec(Z.T)| (u w)}  -> S[w/x]  
  w:T[{w:rec(Z.T)| (u w)} /Z] |- t1[v,w/h1,z1] = t2[v,w/h2,z2] in S[w/x] ext Ax


Display form objects:

simplerec
recind

]%

%
the primitive rule:

*R recEquality  
  H,   |- rec(z1.t1) = rec(z2.t2) in U{i} ext Ax 
  by recEquality y                
  !let{}(;;                    
  CallLisp(REC-EQUALITY))
  H, y:U{i} |- t1[y/z1] = t2[y/z2] in U{i} ext Ax
%

let RecTypeEqCD p = 
  let z,T = dest_rec (first_equand (concl p))
  in
  Refine `recEquality`
   (mk_new_var_args [[get_optional_var_arg `v1` p;z]] p)
   p
;;

%
*R recUnrollElimination  
               H, x:rec(z.t), J,   |- G ext g[x/y] 
                 by recUnrollElimination assumption-index{$i:n} y u  
  H, x:rec(z.t), J, y:t[rec(z.t)/z], u:x = y in t[rec(z.t)/z] |- G[y/x] ext g
%

let RecTypeHD i p = 
  let i' = get_pos_hyp_num i p
  %in let v,T = dest_hyp i' p%
  in let h = nth_decl i' p
  in let T = type_of_declaration h
  in if not is_term `rec` T then failwith `RecTypeHD: not rec type` else

    Refine
      `recUnrollElimination`
      (mk_int_arg i' 
       . mk_new_var_args 
         [[get_optional_var_arg `v1` p;(var_of_declaration h)];[]] p
      )
      p
;;

%
*R rec_memberEquality  
   H,   |- a1 = a2 in rec(z.t) ext Ax
  by rec_memberEquality level-expression{i:l}
  H |- a1 = a2 in t[rec(z.t)/z] ext Ax       
  H  |- rec(z.t) = rec(z.t) in U{i} ext Ax
%

let RecTypeEqTypeCD p = 
  let T,(),() = dest_equal (concl p)
  in
  ( Refine `rec_memberEquality` [infer_level_exp_arg p T]
    THENL
    [Id;WFPrettyUp]
  ) p
;;

%
Prim rule:

*R recElimination  
  H, x:rec(Z.T), J,   |- G ext rec_ind(x;w,z.g[(\x.Void)/u])
    by recElimination assumption-index{$h:n} level-expression{i:l} u v w z 
  H, x:rec(Z.T), J |- rec(Z.T) = rec(Z.T) in U{i} ext Ax     
  H, x:rec(Z.T), J, u:rec(Z.T) -> U{i}, w:x:{v:rec(Z.T)| (u v)}  -> G 
    z:T[{v:rec(Z.T)| (u v)} /Z] |- G[z/x] ext g

Tactic:

  ...,#i. x:rec(Z.T), ... |- G 

BY RecTypeInduction i 

`wf`  ...,#i. x:rec(Z.T), ... |- rec(Z.T) in U{i}
`main` 

  ...
  #i. x:rec(Z.T)
  ...
  u: rec(Z.T) -> P{i}
     All x:{x:rec(Z.T)| (u x)}.  G 
  z:T[{x:rec(Z.T)| (u x)} /Z] |- G[z/x]

`v1` optional var arg overrides choice of u to be `Q?'
`v2` optional var arg overrides choice of z to be `x?'
%

let RecTypeInduction i p = 
  let i' = get_pos_hyp_num i p
  in let x,RecT = dest_hyp i' p
  in let Z,T = dest_rec RecT
  in let Z'= maybe_new_proof_var Z p 
  in let T' = Z = Z' => T | fo_subst [Z,mvt Z'] T
  in let p' = extend_sequent p [Z,mk_U_term (mk_const_level_exp 1)] 
  in let [u;w;z] = 
      mk_new_var_args
        [[get_optional_var_arg `v1` p;`Q']
        ;[]
        ;[get_optional_var_arg `v2` p;x]
        ]
        p
    
  in let v = mk_var_arg x
  in
  ( Refine `recElimination`
      (mk_int_arg i'
      .infer_level_exp_arg p' T'
      . [u;v;w;z]
      ) 
    THENL 
    [WFPrettyUp;
     FoldTop `all` (-2) THEN FoldAtAddr `prop` [2] (-3)]
  ) p
;;


%
Tactic:

  ...,#i. x:rec(Z.T), ... |- G 

BY RecTypeInd i 

`wf`  ...,#i. x:rec(Z.T), ... |- rec(Z.T) in U{i}
`main` 

  ...
  ...
  u: rec(Z.T) -> U{i}
     All x:{x:rec(Z.T)| (u x)}.  G 
  z:T[{x:rec(Z.T)| (u x)} /Z] |- G[z/x]

`v1` optional var arg overrides choice of u to be `Q?'
`v2` optional var arg overrides choice of z to be `x'

Dependent hyps moved to concl initially, and initial hyp is thinned.

%
let RecTypeInd i p = 
  let i' = get_pos_hyp_num i p
  in let h = nth_decl i' p 
  in let RecT = type_of_declaration h
  in let final_x = get_var_arg `v1` p ? (var_of_declaration h)
  in if not is_term `rec` RecT then failwith `RecTypeInd` else
  
  ( MoveDepHypsToConcl i'
    THEN RecTypeInduction i
    THEN IfLabL
    [`main`,Thin i' THEN RenameVar final_x (-1)
    ;`wf`,Id
    ]
  ) p
;;




let analyze_ab_rec_type T = 
  if is_term `rec` T then `rec` else
  let T' = unfold_ab T
  in
  if is_term `rec` T' then opid_of_term T else
    failwith `analyze_ab_rec_type: not rec type or ab rec type`
;;

let AbRecTypeInd i p = 
  let AbRecT = h i p
  in let recid = analyze_ab_rec_type AbRecT
  in
  if recid = `rec` then
      RecTypeInd i p
  else
  let U = get_universe p AbRecT
  in
  ( UnfoldTopAb i
    THEN At U (RecTypeInd i)
    THENL [KeepingAnnotation 
            (FoldTop recid i THEN FoldAtAddr recid [2] 0)
          ;OnHyps [-1;-2;-3] (Fold recid)
          ]
  ) p
;;

let AbRecTypeHD i p = 
  let recid = analyze_ab_rec_type (h i p)
  in
  if recid = `rec` then
      RecTypeHD i p
  else
  ( UnfoldTopAb i
    THEN RecTypeHD i
    THEN OnHyps [-1;-2] (Fold recid)
  ) p
;;

let AbRecTypeD i p = 
  if i = 0 then Fail p else AbRecTypeHD i p
;;

let AbRecTypeEqTypeCD p = 
  let T,(),() = dest_equal (concl p)
  in let recid = analyze_ab_rec_type T
  in if recid = `rec` then
    RecTypeEqTypeCD p
  else
  let U = get_type p T 
  in
  ( UnfoldAtAddr [1] 0 
    THEN At U RecTypeEqTypeCD
    THENL [Fold recid 0;KeepingAnnotation (FoldAtAddr recid [2] 0)]
  ) p
;;

let AbRecTypeMemTypeCD p =
  EqToMemberEq (\i.AbRecTypeEqTypeCD) 0 p
;;
