/*
 * Decompiled with CFR 0.152.
 */
package Lambda;

import Lambda.Expression;
import Lambda.Term;
import java.util.LinkedList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class Atom
implements Expression {
    private String atom = new String();
    private Term parent;

    public Atom(String newAtom, Term newParent) {
        this.atom = newAtom;
        this.parent = newParent;
    }

    public String toString() {
        return this.atom;
    }

    public Term getParent() {
        return this.parent;
    }

    public void toComposite(Composite composite) {
        Label lblAtom = new Label(composite, 0);
        lblAtom.setText(this.atom);
        lblAtom.setData(this);
        lblAtom.addMouseTrackListener(new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                Atom myAtom = (Atom)((Label)e.widget).getData();
                Label varLabel = (Label)e.widget;
                if (varLabel != null) {
                    varLabel.setToolTipText(myAtom.getToolTip());
                }
            }
        });
        composite.pack();
    }

    public Expression replaceExp(String oldAtom, Expression newExp) {
        if (this.atom.compareTo(oldAtom) == 0) {
            return newExp.getCopy(this.parent);
        }
        return this;
    }

    public LinkedList getVarList() {
        return new LinkedList();
    }

    public LinkedList getTermList() {
        LinkedList<Atom> myList = new LinkedList<Atom>();
        myList.add(this);
        return myList;
    }

    public LinkedList getArgList() {
        return new LinkedList();
    }

    public int countVar() {
        return 0;
    }

    public int countTerm() {
        return 1;
    }

    public int countArg() {
        return 0;
    }

    public String removeVar(int i) {
        return "";
    }

    public Expression removeTerm(int i) {
        return new Term(null);
    }

    public Expression removeArg(int i) {
        return new Term(null);
    }

    public String getVar(int i) {
        return "";
    }

    public Expression getTerm(int i) {
        return new Term(null);
    }

    public Expression getArg(int i) {
        return new Term(null);
    }

    public void setParent(Term newParent) {
        this.parent = newParent;
    }

    public Expression getCopy(Term newParent) {
        return new Atom(this.atom, newParent);
    }

    public int getPosition() {
        int i = 0;
        while (i < this.parent.countTerm() && this.parent.getTerm(i) != this) {
            ++i;
        }
        if (i == this.parent.countTerm()) {
            return -1;
        }
        return i;
    }

    public String getToolTip() {
        String myString = "Atom: " + this.toString() + "\nParent-Term: " + this.getParent().toString() + "\nPosition: " + (this.getPosition() + 1);
        return myString;
    }
}

