/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public final class Cursor {
    public int handle;
    Device device;

    Cursor() {
    }

    public Cursor(Device device, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int shape = 0;
        switch (style) {
            case 0: {
                shape = 68;
                break;
            }
            case 1: {
                shape = 150;
                break;
            }
            case 21: {
                shape = 60;
                break;
            }
            case 2: {
                shape = 30;
                break;
            }
            case 3: {
                shape = 68;
                break;
            }
            case 4: {
                shape = 92;
                break;
            }
            case 5: {
                shape = 52;
                break;
            }
            case 6: {
                shape = 120;
                break;
            }
            case 7: {
                shape = 42;
                break;
            }
            case 8: {
                shape = 120;
                break;
            }
            case 9: {
                shape = 108;
                break;
            }
            case 10: {
                shape = 138;
                break;
            }
            case 11: {
                shape = 16;
                break;
            }
            case 12: {
                shape = 96;
                break;
            }
            case 13: {
                shape = 70;
                break;
            }
            case 14: {
                shape = 136;
                break;
            }
            case 15: {
                shape = 14;
                break;
            }
            case 16: {
                shape = 12;
                break;
            }
            case 17: {
                shape = 134;
                break;
            }
            case 18: {
                shape = 114;
                break;
            }
            case 19: {
                shape = 152;
                break;
            }
            case 20: {
                shape = 0;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = OS.XCreateFontCursor(device.xDisplay, shape);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        byte s;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(5);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (mask.depth != 1) {
            SWT.error(5);
        }
        if (source.depth != 1) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        int i = 0;
        while (i < data.length) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            sourceData[i] = ~sourceData[i];
            ++i;
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        i = 0;
        while (i < data.length) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            maskData[i] = ~maskData[i];
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        int xDisplay = device.xDisplay;
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int sourcePixmap = OS.XCreateBitmapFromData(xDisplay, drawable, sourceData, source.width, source.height);
        int maskPixmap = OS.XCreateBitmapFromData(xDisplay, drawable, maskData, source.width, source.height);
        int screenNum = OS.XDefaultScreen(xDisplay);
        XColor foreground = new XColor();
        foreground.pixel = OS.XBlackPixel(xDisplay, screenNum);
        foreground.blue = 0;
        foreground.green = 0;
        foreground.red = 0;
        XColor background = new XColor();
        background.pixel = OS.XWhitePixel(xDisplay, screenNum);
        background.blue = (short)-1;
        background.green = (short)-1;
        background.red = (short)-1;
        this.handle = OS.XCreatePixmapCursor(xDisplay, maskPixmap, sourcePixmap, foreground, background, hotspotX, hotspotY);
        OS.XFreePixmap(xDisplay, sourcePixmap);
        OS.XFreePixmap(xDisplay, maskPixmap);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        byte s;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        ImageData mask = source.getTransparencyMask();
        if (source.depth > 1) {
            ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
            PaletteData palette = source.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, 0, 0, 0, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, 0, 0, 0, false, false);
            } else {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, null, null, null, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, null, null, null, false, false);
            }
            source = newSource;
        }
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        int i = 0;
        while (i < data.length) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        i = 0;
        while (i < data.length) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        int xDisplay = device.xDisplay;
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int sourcePixmap = OS.XCreateBitmapFromData(xDisplay, drawable, sourceData, source.width, source.height);
        int maskPixmap = OS.XCreateBitmapFromData(xDisplay, drawable, maskData, source.width, source.height);
        int screenNum = OS.XDefaultScreen(xDisplay);
        XColor foreground = new XColor();
        foreground.pixel = OS.XWhitePixel(xDisplay, screenNum);
        foreground.blue = (short)-1;
        foreground.green = (short)-1;
        foreground.red = (short)-1;
        XColor background = new XColor();
        background.pixel = OS.XBlackPixel(xDisplay, screenNum);
        this.handle = OS.XCreatePixmapCursor(xDisplay, sourcePixmap, maskPixmap, foreground, background, hotspotX, hotspotY);
        OS.XFreePixmap(xDisplay, sourcePixmap);
        OS.XFreePixmap(xDisplay, maskPixmap);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.XFreeCursor(this.device.xDisplay, this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Cursor motif_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.device = device;
        cursor.handle = handle;
        return cursor;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

