/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

public class Library {
    static int MAJOR_VERSION = 3;
    static int MINOR_VERSION = 64;
    static int REVISION = 0;

    public static int getVersion() {
        return MAJOR_VERSION * 1000 + MINOR_VERSION;
    }

    public static String getPlatform() {
        return "motif";
    }

    public static int getRevision() {
        return REVISION;
    }

    public static void loadLibrary(String name) {
        String platform = "motif";
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = String.valueOf(version) + "00";
            } else if (MINOR_VERSION < 100) {
                version = String.valueOf(version) + "0";
            }
            version = String.valueOf(version) + MINOR_VERSION;
            if (REVISION > 0) {
                version = String.valueOf(version) + "r" + REVISION;
            }
        }
        try {
            String newName = String.valueOf(name) + "-" + platform + "-" + version;
            System.loadLibrary(newName);
            return;
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                String newName = String.valueOf(name) + "-" + platform;
                System.loadLibrary(newName);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw e1;
            }
        }
    }
}

