/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XClientMessageEvent;
import org.eclipse.swt.internal.motif.XCreateWindowEvent;
import org.eclipse.swt.internal.motif.XDestroyWindowEvent;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XPropertyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XReparentEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    public int embeddedHandle;
    int focusHandle;
    int damagedRegion;
    int clientWindow;
    Control[] tabList;
    static byte[] _XEMBED_INFO = Converter.wcsToMbcs(null, "_XEMBED_INFO", true);
    static byte[] _XEMBED = Converter.wcsToMbcs(null, "_XEMBED", true);

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return new Control[0];
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        int length = this.focusHandle != 0 ? count - 1 : count;
        Control[] children = new Control[length];
        int i = 0;
        int j = 0;
        while (i < count) {
            Widget widget;
            int handle = handles[i];
            if (handle != 0 && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
        }
        if (j == length) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    protected void checkSubclass() {
    }

    void createHandle(int index) {
        this.state |= 0xA;
        boolean scroll = (this.style & 0x300) != 0;
        this.createHandle(index, this.parent.handle, scroll);
    }

    void createHandle(int index, int parentHandle, boolean scrolled) {
        int[] argList;
        if (scrolled) {
            argList = new int[]{OS.XmNancestorSensitive, 1};
            this.scrolledHandle = OS.XmCreateMainWindow(parentHandle, null, argList, argList.length / 2);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0x300) != 0) {
            int[] nArray = new int[10];
            nArray[0] = OS.XmNmarginWidth;
            nArray[1] = 3;
            nArray[2] = OS.XmNmarginHeight;
            nArray[3] = 3;
            nArray[4] = OS.XmNresizePolicy;
            nArray[6] = OS.XmNshadowType;
            nArray[7] = 7;
            nArray[8] = OS.XmNshadowThickness;
            nArray[9] = this.hasBorder() ? this.display.buttonShadowThickness : 0;
            int[] argList1 = nArray;
            this.formHandle = OS.XmCreateForm(this.scrolledHandle, null, argList1, argList1.length / 2);
            if (this.formHandle == 0) {
                this.error(2);
            }
            int[] nArray2 = new int[18];
            nArray2[0] = OS.XmNtopAttachment;
            nArray2[1] = 1;
            nArray2[2] = OS.XmNbottomAttachment;
            nArray2[3] = 1;
            nArray2[4] = OS.XmNleftAttachment;
            nArray2[5] = 1;
            nArray2[6] = OS.XmNrightAttachment;
            nArray2[7] = 1;
            nArray2[8] = OS.XmNresizable;
            nArray2[10] = OS.XmNmarginWidth;
            nArray2[12] = OS.XmNmarginHeight;
            nArray2[14] = OS.XmNresizePolicy;
            nArray2[16] = OS.XmNtraversalOn;
            nArray2[17] = (this.style & 0x80000) != 0 ? 0 : 1;
            int[] argList2 = nArray2;
            this.handle = OS.XmCreateDrawingArea(this.formHandle, null, argList2, argList2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            int[] nArray = new int[12];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNborderWidth;
            nArray[3] = this.hasBorder() ? 1 : 0;
            nArray[4] = OS.XmNmarginWidth;
            nArray[6] = OS.XmNmarginHeight;
            nArray[8] = OS.XmNresizePolicy;
            nArray[10] = OS.XmNtraversalOn;
            nArray[11] = (this.style & 0x80000) != 0 ? 0 : 1;
            argList = nArray;
            if (this.scrolledHandle != 0) {
                parentHandle = this.scrolledHandle;
            }
            this.handle = OS.XmCreateDrawingArea(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0x80000) == 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            argList = nArray;
            this.focusHandle = OS.XmCreateDrawingArea(this.handle, null, argList, argList.length / 2);
            if (this.focusHandle == 0) {
                this.error(2);
            }
        }
    }

    int defaultBackground() {
        return this.display.compositeBackground;
    }

    int defaultForeground() {
        return this.display.compositeForeground;
    }

    void deregister() {
        super.deregister();
        if (this.focusHandle != 0) {
            this.display.removeWidget(this.focusHandle);
        }
    }

    int focusHandle() {
        if (this.focusHandle == 0) {
            return super.focusHandle();
        }
        return this.focusHandle;
    }

    int focusProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        Shell shell = this.getShell();
        if (handle != shell.shellHandle) {
            return super.XFocusChange(w, client_data, call_data, continue_to_dispatch);
        }
        if (xEvent.mode != 0) {
            return 0;
        }
        block0 : switch (xEvent.detail) {
            case 3: 
            case 4: {
                switch (xEvent.type) {
                    case 9: {
                        this.sendClientEvent(0, 1, 0, 0, 0);
                        break block0;
                    }
                    case 10: {
                        this.sendClientEvent(0, 2, 0, 0, 0);
                    }
                }
            }
        }
        return 0;
    }

    boolean fowardKeyEvent(int event) {
        if (this.clientWindow == 0) {
            return false;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, event, 60);
        xEvent.window = this.clientWindow;
        int newEvent = OS.XtMalloc(96);
        OS.memmove(newEvent, xEvent, 60);
        int xDisplay = OS.XtDisplay(this.handle);
        OS.XSendEvent(xDisplay, this.clientWindow, false, 0, newEvent);
        OS.XSync(xDisplay, false);
        OS.XtFree(newEvent);
        this.display.setWarnings(warnings);
        return true;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.formHandle != 0 && !OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        return super.getClientArea();
    }

    int getChildrenCount() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (this.focusHandle != 0) {
            return Math.max(0, argList[1] - 1);
        }
        return argList[1];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.XtInsertEventHandler(this.handle, 0, true, this.display.windowProc, 26, 1);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int focusProc = this.display.focusProc;
            int windowProc = this.display.windowProc;
            OS.XtInsertEventHandler(this.handle, 655360, false, windowProc, 28, 1);
            OS.XtInsertEventHandler(this.handle, 0x400000, false, windowProc, 34, 1);
            OS.XtInsertEventHandler(this.handle, 0, true, windowProc, 26, 1);
            Shell shell = this.getShell();
            OS.XtInsertEventHandler(shell.shellHandle, 0x200000, false, focusProc, this.handle, 1);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        int count = this.getChildrenCount();
        if (count == 0) {
            return;
        }
        this.layout.layout(this, changed);
    }

    void manageChildren() {
        if (this.focusHandle != 0) {
            OS.XtSetMappedWhenManaged(this.focusHandle, false);
            OS.XtManageChild(this.focusHandle);
        }
        super.manageChildren();
        if (this.focusHandle != 0) {
            OS.XtConfigureWidget(this.focusHandle, 0, 0, 1, 1, 0);
            OS.XtSetMappedWhenManaged(this.focusHandle, true);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            shell.createFocusProxy();
            if (!OS.XtIsRealized(this.handle)) {
                shell.realizeWidget();
            }
            this.embeddedHandle = OS.XtWindow(this.handle);
        }
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void moveAbove(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[0];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1 - 1);
            handles[index2 - 1] = handle1;
        } else {
            System.arraycopy(handles, index2, handles, index2 + 1, index1 - index2);
            handles[index2] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void moveBelow(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[count - 1];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1);
            handles[index2] = handle1;
        } else {
            System.arraycopy(handles, index2 + 1, handles, index2 + 2, index1 - index2 - 1);
            handles[index2 + 1] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void propagateChildren(boolean enabled) {
        super.propagateChildren(enabled);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getEnabled()) {
                child.propagateChildren(enabled);
            }
            ++i;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].realizeChildren();
            ++i;
        }
        if (this.focusHandle != 0) {
            OS.XtUnmapWidget(this.focusHandle);
        }
        if ((this.state & 2) != 0) {
            if ((this.style & 0x40000) == 0 && (this.style & 0x100000) != 0) {
                return;
            }
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            int flags = 0;
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            if ((this.style & 0x40000) != 0) {
                flags |= 1;
                attributes.background_pixmap = 0;
            }
            if ((this.style & 0x100000) == 0) {
                flags |= 0x10;
                attributes.bit_gravity = 0;
            }
            if (flags != 0) {
                OS.XChangeWindowAttributes(xDisplay, xWindow, flags, attributes);
            }
        }
    }

    void register() {
        super.register();
        if (this.focusHandle != 0) {
            this.display.addWidget(this.focusHandle, this);
        }
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        super.redrawWidget(x, y, width, height, all);
        if (!all) {
            return;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Point location = child.getClientLocation();
            child.redrawWidget(x - location.x, y - location.y, width, height, all);
            ++i;
        }
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.focusHandle = 0;
    }

    void releaseWidget() {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            int focusProc = this.display.focusProc;
            OS.XtRemoveEventHandler(shell.shellHandle, 0x200000, false, focusProc, this.handle);
            if (this.clientWindow != 0) {
                boolean warnings = this.display.getWarnings();
                this.display.setWarnings(false);
                int xDisplay = OS.XtDisplay(this.handle);
                OS.XUnmapWindow(xDisplay, this.clientWindow);
                OS.XReparentWindow(xDisplay, this.clientWindow, OS.XDefaultRootWindow(xDisplay), 0, 0);
                OS.XSync(xDisplay, false);
                this.display.setWarnings(warnings);
            }
            this.setClientWindow(0);
        }
        this.releaseChildren();
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
        if (this.damagedRegion != 0) {
            OS.XDestroyRegion(this.damagedRegion);
        }
        this.damagedRegion = 0;
    }

    void resizeClientWindow() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.handle);
        OS.XMoveResizeWindow(xDisplay, this.clientWindow, 0, 0, Math.max(1, argList[1]), Math.max(1, argList[3]));
        this.display.setWarnings(warnings);
    }

    void sendClientEvent(int time, int message, int detail, int data1, int data2) {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        XClientMessageEvent xEvent = new XClientMessageEvent();
        xEvent.type = 33;
        xEvent.window = this.clientWindow;
        xEvent.message_type = OS.XInternAtom(xDisplay, _XEMBED, false);
        xEvent.format = 32;
        xEvent.data[0] = time != 0 ? time : OS.XtLastTimestampProcessed(xDisplay);
        xEvent.data[1] = message;
        xEvent.data[2] = detail;
        xEvent.data[3] = data1;
        xEvent.data[4] = data2;
        int event = OS.XtMalloc(96);
        OS.memmove(event, xEvent, 48);
        OS.XSendEvent(xDisplay, this.clientWindow, false, 0, event);
        OS.XSync(xDisplay, false);
        OS.XtFree(event);
        this.display.setWarnings(warnings);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        if ((this.state & 2) != 0 && (this.style & 0x40000) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            attributes.background_pixmap = 0;
            OS.XChangeWindowAttributes(xDisplay, xWindow, 1, attributes);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            if (this.focusHandle != 0) {
                int[] nArray = new int[4];
                nArray[0] = OS.XmNwidth;
                nArray[2] = OS.XmNheight;
                int[] argList = nArray;
                OS.XtGetValues(this.handle, argList, argList.length / 2);
                OS.XtConfigureWidget(this.focusHandle, 0, 0, argList[1], argList[3], 0);
            }
            if (this.layout != null) {
                this.layout.layout(this, false);
            }
            if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
                this.resizeClientWindow();
            }
        }
        return changed;
    }

    void setClientWindow(int window) {
        if (this.focusHandle != 0 && window == OS.XtWindow(this.focusHandle)) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        if (window != 0) {
            if (this.clientWindow == 0) {
                this.clientWindow = window;
                this.sendClientEvent(0, 0, 0, 0, 0);
                OS.XtRegisterDrawable(xDisplay, this.clientWindow, this.handle);
                OS.XSelectInput(xDisplay, this.clientWindow, 0x400000);
                this.updateMapped();
                this.resizeClientWindow();
                Shell shell = this.getShell();
                if (shell == this.display.getActiveShell()) {
                    shell.bringToTop(true);
                    this.sendClientEvent(0, 1, 0, 0, 0);
                    if (this == this.display.getFocusControl()) {
                        this.sendClientEvent(0, 4, 0, 0, 0);
                    }
                }
            }
        } else {
            if (this.clientWindow != 0) {
                OS.XtUnregisterDrawable(xDisplay, this.clientWindow);
            }
            this.clientWindow = 0;
        }
        this.display.setWarnings(warnings);
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        if ((this.state & 2) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            OS.XClearArea(xDisplay, xWindow, 0, 0, 0, 0, true);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                takeFocus = true;
            }
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus(next)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int detail = next ? 1 : 2;
            this.sendClientEvent(0, 4, detail, 0, 0);
        }
        return true;
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, xEvent);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return false;
        }
        return super.translateTraversal(key, xEvent);
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        if ((this.state & 2) != 0) {
            XButtonEvent xEvent = new XButtonEvent();
            OS.memmove(xEvent, call_data, 60);
            if ((this.style & 0x80000) == 0 && this.hooksKeys() && xEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
            if (xEvent.button != 3) {
                OS.memmove(continue_to_dispatch, new int[1], 4);
            }
            return 1;
        }
        return result;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        if ((this.state & 2) == 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        if ((this.style & 0x200000) != 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        XExposeEvent xEvent = new XExposeEvent();
        OS.memmove(xEvent, call_data, 40);
        int exposeCount = xEvent.count;
        if (exposeCount == 0 && OS.XEventsQueued(xEvent.display, 1) != 0) {
            int xEvent1 = OS.XtMalloc(96);
            this.display.lastExpose = 0;
            this.display.exposeCount = 0;
            int checkExposeProc = this.display.checkExposeProc;
            OS.XCheckIfEvent(xEvent.display, xEvent1, checkExposeProc, xEvent.window);
            exposeCount = this.display.exposeCount;
            int lastExpose = this.display.lastExpose;
            if (exposeCount != 0 && lastExpose != 0) {
                XExposeEvent xExposeEvent = this.display.xExposeEvent;
                OS.memmove(xExposeEvent, lastExpose, 40);
                xExposeEvent.count = 0;
                OS.memmove(lastExpose, xExposeEvent, 40);
            }
            OS.XtFree(xEvent1);
        }
        if (exposeCount == 0 && this.damagedRegion == 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        if (this.damagedRegion == 0) {
            this.damagedRegion = OS.XCreateRegion();
        }
        OS.XtAddExposureToRegion(call_data, this.damagedRegion);
        if (exposeCount != 0) {
            return 0;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return 0;
        }
        Event event = new Event();
        GC gc = event.gc = new GC(this);
        Region region = Region.motif_new(this.display, this.damagedRegion);
        gc.setClipping(region);
        XRectangle rect = new XRectangle();
        OS.XClipBox(this.damagedRegion, rect);
        OS.XDestroyRegion(this.damagedRegion);
        this.damagedRegion = 0;
        event.x = rect.x;
        event.y = rect.y;
        event.width = rect.width;
        event.height = rect.height;
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int result = super.xFocusIn(xEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 4, 0, 0, 0);
        }
        return result;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        int result = super.xFocusOut(xEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 5, 0, 0, 0);
        }
        return result;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyPress(w, client_data, call_data, continue_to_dispatch);
        if (result == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(call_data)) {
            return 0;
        }
        return result;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
        if (result == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(call_data)) {
            return 0;
        }
        return result;
    }

    int XNonMaskable(int w, int client_data, int call_data, int continue_to_dispatch) {
        XEvent xEvent;
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            if (xEvent.type == 33) {
                XClientMessageEvent xClientEvent = new XClientMessageEvent();
                OS.memmove(xClientEvent, call_data, 48);
                int xDisplay = OS.XtDisplay(this.handle);
                if (xClientEvent.message_type == OS.XInternAtom(xDisplay, _XEMBED, false)) {
                    int type = xClientEvent.data[1];
                    switch (type) {
                        case 3: {
                            this.setFocus();
                            break;
                        }
                        case 7: {
                            this.traverse(8);
                            break;
                        }
                        case 6: {
                            this.traverse(16);
                        }
                    }
                }
                return 0;
            }
        }
        if ((this.state & 2) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            if (xEvent.type == 13) {
                return this.XExposure(w, client_data, call_data, continue_to_dispatch);
            }
        }
        return 0;
    }

    int XPropertyChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XPropertyChange(w, client_data, call_data, continue_to_dispatch);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int xDisplay;
            int atom;
            XPropertyEvent xPropertyEvent = new XPropertyEvent();
            OS.memmove(xPropertyEvent, call_data, 40);
            if (xPropertyEvent.window == this.clientWindow && (atom = xPropertyEvent.atom) == OS.XInternAtom(xDisplay = xPropertyEvent.display, _XEMBED_INFO, false)) {
                this.updateMapped();
            }
        }
        return result;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            XEvent xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            switch (xEvent.type) {
                case 21: {
                    XReparentEvent xReparentEvent = new XReparentEvent();
                    OS.memmove(xReparentEvent, call_data, 40);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xReparentEvent.window);
                    break;
                }
                case 16: {
                    XCreateWindowEvent xCreateEvent = new XCreateWindowEvent();
                    OS.memmove(xCreateEvent, call_data, 48);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xCreateEvent.window);
                    break;
                }
                case 17: {
                    XDestroyWindowEvent xDestroyEvent = new XDestroyWindowEvent();
                    OS.memmove(xDestroyEvent, call_data, 24);
                    if (xDestroyEvent.window != this.clientWindow) break;
                    this.setClientWindow(0);
                }
            }
        }
        return result;
    }

    void updateMapped() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        int prop = OS.XInternAtom(xDisplay, _XEMBED_INFO, false);
        int[] type = new int[1];
        int[] format = new int[1];
        int[] nitems = new int[1];
        int[] bytes_after = new int[1];
        int[] data = new int[1];
        if (OS.XGetWindowProperty(xDisplay, this.clientWindow, prop, 0, 2, false, prop, type, format, nitems, bytes_after, data) == 0 && type[0] == prop && nitems[0] >= 2) {
            int[] buffer = new int[2];
            OS.memmove(buffer, data[0], buffer.length * 4);
            int flags = buffer[1];
            if ((flags & 1) != 0) {
                OS.XMapWindow(xDisplay, this.clientWindow);
            } else {
                OS.XUnmapWindow(xDisplay, this.clientWindow);
            }
        }
        if (data[0] != 0) {
            OS.XFree(data[0]);
        }
        this.display.setWarnings(warnings);
    }
}

