/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int cursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int border = (this.style & 0x800) != 0 ? 1 : 0;
        int[] nArray = new int[12];
        nArray[0] = OS.XmNborderWidth;
        nArray[1] = border;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNmarginHeight;
        nArray[6] = OS.XmNresizePolicy;
        nArray[8] = OS.XmNancestorSensitive;
        nArray[9] = 1;
        nArray[10] = OS.XmNtraversalOn;
        int[] argList = nArray;
        int parentHandle = this.parent.handle;
        this.handle = OS.XmCreateDrawingArea(parentHandle, null, argList, argList.length / 2);
    }

    void drawBand(int x, int y, int width, int height) {
        int display = OS.XtDisplay(this.parent.handle);
        if (display == 0) {
            return;
        }
        int window = OS.XtWindow(this.parent.handle);
        if (window == 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        int[] argList = nArray;
        OS.XtGetValues(this.parent.handle, argList, argList.length / 2);
        int color = argList[1] ^ argList[3];
        byte[] bits = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int stipplePixmap = OS.XCreateBitmapFromData(display, window, bits, 8, 8);
        int gc = OS.XCreateGC(display, window, 0, null);
        OS.XSetForeground(display, gc, color);
        OS.XSetStipple(display, gc, stipplePixmap);
        OS.XSetSubwindowMode(display, gc, 1);
        OS.XSetFillStyle(display, gc, 2);
        OS.XSetFunction(display, gc, 6);
        OS.XFillRectangle(display, window, gc, x, y, width, height);
        OS.XFreePixmap(display, stipplePixmap);
        OS.XFreeGC(display, gc);
    }

    void propagateWidget(boolean enabled) {
        int xCursor = enabled && ((Control)this).cursor != null ? ((Control)this).cursor.handle : this.cursor;
        this.propagateHandle(enabled, this.handle, xCursor);
    }

    void realizeChildren() {
        super.realizeChildren();
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        this.cursor = (this.style & 0x100) != 0 ? OS.XCreateFontCursor(xDisplay, 116) : OS.XCreateFontCursor(xDisplay, 108);
        if (((Control)this).cursor == null && this.isEnabled()) {
            OS.XDefineCursor(xDisplay, xWindow, this.cursor);
            OS.XFlush(xDisplay);
        }
    }

    void releaseWidget() {
        int display;
        super.releaseWidget();
        if (this.cursor != 0 && (display = OS.XtDisplay(this.handle)) != 0) {
            OS.XFreeCursor(display, this.cursor);
        }
        this.cursor = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        super.setCursor(cursor);
        if (cursor == null && this.cursor != 0) {
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            OS.XDefineCursor(xDisplay, xWindow, this.cursor);
            OS.XFlush(xDisplay);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        if (xEvent.button != 1) {
            return result;
        }
        short[] x_root = new short[1];
        short[] y_root = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
        this.startX = xEvent.x_root - x_root[0];
        this.startY = xEvent.y_root - y_root[0];
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int border = argList[9];
        int width = argList[5] + border * 2;
        int height = argList[7] + border * 2;
        this.lastX = (short)argList[1] - border;
        this.lastY = (short)argList[3] - border;
        Event event = new Event();
        event.detail = 1;
        event.time = xEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return result;
        }
        if (event.doit) {
            this.dragging = true;
            OS.XmUpdateDisplay(this.handle);
            this.lastX = event.x;
            this.lastY = event.y;
            this.drawBand(this.lastX, this.lastY, width, height);
        }
        return result;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonRelease(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        if (xEvent.button != 1) {
            return result;
        }
        if (!this.dragging) {
            return result;
        }
        this.dragging = false;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int border = argList[5];
        int width = argList[1] + border * 2;
        int height = argList[3] + border * 2;
        Event event = new Event();
        event.time = xEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.drawBand(this.lastX, this.lastY, width, height);
        this.sendEvent(13, event);
        return result;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int result = super.xFocusIn(xEvent);
        if (this.handle == 0) {
            return result;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.lastX = argList[1];
        this.lastY = argList[3];
        return result;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        byte[] buffer = new byte[1];
        int[] keysym = new int[1];
        OS.XLookupString(xEvent, buffer, buffer.length, keysym, null);
        switch (keysym[0]) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((xEvent.state & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keysym[0] == 65362 || keysym[0] == 65364) break;
                    xChange = keysym[0] == 65361 ? -stepSize : stepSize;
                } else {
                    if (keysym[0] == 65361 || keysym[0] == 65363) break;
                    yChange = keysym[0] == 65362 ? -stepSize : stepSize;
                }
                int[] nArray = new int[6];
                nArray[0] = OS.XmNwidth;
                nArray[2] = OS.XmNheight;
                nArray[4] = OS.XmNborderWidth;
                int[] argList1 = nArray;
                OS.XtGetValues(this.handle, argList1, argList1.length / 2);
                int border = argList1[5];
                int width = argList1[1] + border * 2;
                int height = argList1[3] + border * 2;
                int[] nArray2 = new int[6];
                nArray2[0] = OS.XmNwidth;
                nArray2[2] = OS.XmNheight;
                nArray2[4] = OS.XmNborderWidth;
                int[] argList2 = nArray2;
                OS.XtGetValues(this.parent.handle, argList2, argList2.length / 2);
                int parentBorder = argList2[5];
                int parentWidth = argList2[1] + parentBorder * 2;
                int parentHeight = argList2[3] + parentBorder * 2;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - parentBorder - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - parentBorder - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                int xDisplay = this.display.xDisplay;
                int xWindow = OS.XtWindow(this.parent.handle);
                int ptrGrabResult = OS.XGrabPointer(xDisplay, xWindow, 1, 0, 1, 1, 0, this.cursor, 0);
                Event event = new Event();
                event.time = xEvent.time;
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (ptrGrabResult == 0) {
                    OS.XUngrabPointer(xDisplay, 0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                int cursorX = newX;
                int cursorY = newY;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, cursorX, cursorY);
            }
        }
        return result;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XPointerMotion(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        XMotionEvent xEvent = new XMotionEvent();
        OS.memmove(xEvent, call_data, 60);
        if (!this.dragging || (xEvent.state & 0x100) == 0) {
            return result;
        }
        short[] x_root = new short[1];
        short[] y_root = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
        int eventX = xEvent.x_root - x_root[0];
        int eventY = xEvent.y_root - y_root[0];
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int border = argList1[9];
        int x = (short)argList1[1] - border;
        int y = (short)argList1[3] - border;
        int width = argList1[5] + border * 2;
        int height = argList1[7] + border * 2;
        int[] nArray2 = new int[6];
        nArray2[0] = OS.XmNwidth;
        nArray2[2] = OS.XmNheight;
        nArray2[4] = OS.XmNborderWidth;
        int[] argList2 = nArray2;
        OS.XtGetValues(this.parent.handle, argList2, argList2.length / 2);
        int parentBorder = argList2[5];
        int parentWidth = argList2[1] + parentBorder * 2;
        int parentHeight = argList2[3] + parentBorder * 2;
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX - parentBorder), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY - parentBorder), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return result;
        }
        this.drawBand(this.lastX, this.lastY, width, height);
        Event event = new Event();
        event.detail = 1;
        event.time = xEvent.time;
        event.x = newX;
        event.y = newY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return result;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            OS.XmUpdateDisplay(this.handle);
            this.drawBand(this.lastX, this.lastY, width, height);
        }
        return result;
    }
}

