/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.SelectableItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends SelectableItem {
    private static final int FIRST_COLUMN_IMAGE_INDENT = 2;
    private static final int FIRST_COLUMN_TEXT_INDENT = 4;
    private static final int TEXT_INDENT_NO_IMAGE = 2;
    private static final int TEXT_INDENT = 6;
    private static final int SELECTION_PADDING = 6;
    private Vector dataLabels = new Vector();
    private String[] trimmedLabels;
    private Vector images = new Vector();
    private Point selectionExtent;
    private int imageIndent = 0;
    private int index;
    Color background = null;
    Color foreground = null;
    Font font = null;
    Color[] cellBackground;
    Color[] cellForeground;
    Font[] cellFont;
    boolean cached;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount());
    }

    public TableItem(Table parent, int style, int index) {
        super(parent, style);
        this.trimmedLabels = new String[parent.internalGetColumnCount()];
        parent.addItem(this, index);
    }

    void calculateSelectionExtent() {
        Table parent = this.getParent();
        TableColumn column = parent.internalGetColumn(0);
        GC gc = new GC(parent);
        gc.setFont(this.getFont());
        String trimmedText = this.getText(gc, column);
        int gridLineWidth = parent.getGridLineWidth();
        if (trimmedText != null) {
            this.selectionExtent = new Point(gc.stringExtent((String)trimmedText).x, parent.getItemHeight());
            this.selectionExtent.x += this.getTextIndent(0) + 6;
            this.selectionExtent.x = Math.min(this.selectionExtent.x, column.getWidth() - this.getImageStopX(column.getIndex()) - gridLineWidth);
            if (parent.getLinesVisible()) {
                this.selectionExtent.y -= gridLineWidth;
            }
        }
        gc.dispose();
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        super.clear();
        this.dataLabels = new Vector();
        this.trimmedLabels = new String[this.getParent().internalGetColumnCount()];
        this.images = new Vector();
        this.selectionExtent = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
        this.cached = false;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Table parent = this.getParent();
        parent.removeItem(this);
        super.dispose();
    }

    void doDispose() {
        this.dataLabels = null;
        this.trimmedLabels = null;
        this.images = null;
        this.selectionExtent = null;
        this.background = null;
        this.foreground = null;
        this.font = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.cellFont = null;
        super.doDispose();
    }

    Point drawImage(GC gc, Point destinationPosition, int index) {
        Table parent = this.getParent();
        Image image = this.getImage(index);
        Point destinationImageExtent = parent.getImageExtent();
        int itemHeight = parent.getItemHeight();
        if (image != null) {
            Rectangle sourceImageBounds = image.getBounds();
            if (index == 0) {
                gc.setBackground(this.getBackground(index));
                gc.fillRectangle(destinationPosition.x, destinationPosition.y, destinationImageExtent.x, itemHeight);
            } else if ((parent.getStyle() & 0x10000) != 0) {
                gc.fillRectangle(destinationPosition.x, destinationPosition.y, destinationImageExtent.x, destinationImageExtent.y);
            }
            int imageOffset = (itemHeight - destinationImageExtent.y) / 2;
            gc.drawImage(image, 0, 0, sourceImageBounds.width, sourceImageBounds.height, destinationPosition.x, destinationPosition.y + imageOffset, destinationImageExtent.x, destinationImageExtent.y);
        }
        if ((index == 0 && parent.hasFirstColumnImage() || index != 0 && image != null) && destinationImageExtent != null) {
            destinationPosition.x += destinationImageExtent.x;
        }
        return destinationPosition;
    }

    void drawText(String label, GC gc, Point position, int index) {
        Table parent = this.getParent();
        if (label != null) {
            boolean drawSelection;
            gc.setFont(this.getFont(index));
            boolean bl = drawSelection = !(index != 0 && (parent.getStyle() & 0x10000) == 0 || (parent.style & 0x8000) != 0 && !parent.isFocusControl());
            if (this.isSelected() && drawSelection) {
                gc.setForeground(this.getSelectionForegroundColor());
            } else {
                gc.setForeground(this.getForeground(index));
            }
            int alignmentOffset = this.getAlignmentOffset(index, this.getBounds((int)index).width, gc);
            int textOffset = (parent.getItemHeight() - parent.getFontHeight()) / 2;
            gc.drawString(label, position.x + alignmentOffset, position.y + textOffset, true);
        }
    }

    int getAlignmentOffset(int columnIndex, int columnWidth, GC gc) {
        Table parent = this.getParent();
        TableColumn column = parent.internalGetColumn(columnIndex);
        Image image = this.getImage(columnIndex);
        int alignmentOffset = 0;
        int alignment = column.getAlignment();
        String label = this.getText(gc, column);
        int imageWidth = 0;
        int textWidth = gc.stringExtent((String)label).x;
        Point imageExtent = parent.getImageExtent();
        if ((columnIndex == 0 && parent.hasFirstColumnImage() || columnIndex != 0 && image != null) && imageExtent != null) {
            textWidth += imageExtent.x;
        }
        if ((alignment & 0x20000) != 0) {
            alignmentOffset = columnWidth - textWidth - imageWidth - 6 - 6;
        }
        if ((alignment & 0x1000000) != 0) {
            alignmentOffset = (columnWidth - textWidth) / 2 - imageWidth - 6;
        }
        if (alignmentOffset < 0) {
            alignmentOffset = 0;
        }
        return alignmentOffset;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background != null) {
            return this.background;
        }
        Table parent = this.getParent();
        return parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds(int index) {
        Rectangle itemBounds;
        int gridLineWidth;
        this.checkWidget();
        Table parent = this.getParent();
        int itemIndex = parent.indexOf(this);
        int itemHeight = parent.getItemHeight();
        int n = gridLineWidth = parent.getLinesVisible() ? parent.getGridLineWidth() : 0;
        if (itemIndex == -1 || index < 0 || index >= parent.internalGetColumnCount()) {
            itemBounds = new Rectangle(0, 0, 0, 0);
        } else {
            TableColumn column = parent.internalGetColumn(index);
            Rectangle columnBounds = column.getBounds();
            int itemYPos = columnBounds.y + itemHeight * itemIndex;
            itemBounds = new Rectangle(columnBounds.x, itemYPos, columnBounds.width - gridLineWidth, itemHeight - gridLineWidth);
            if (index == 0) {
                if (this.isCheckable()) {
                    Rectangle checkboxBounds = this.getCheckboxBounds();
                    itemBounds.x = checkboxBounds.x + checkboxBounds.width + 1;
                    itemBounds.width -= itemBounds.x;
                } else {
                    int imageIndent = this.getImageIndentPixel();
                    itemBounds.x += imageIndent;
                    itemBounds.width -= imageIndent;
                }
            }
        }
        return itemBounds;
    }

    public boolean getChecked() {
        this.checkWidget();
        return super.getChecked();
    }

    int getCheckboxXPosition() {
        return this.getImageIndentPixel();
    }

    Vector getDataLabels() {
        return this.dataLabels;
    }

    int getDotStartX(int columnIndex, int columnWidth) {
        Table parent = this.getParent();
        String label = this.getText(columnIndex);
        int alignment = parent.internalGetColumn(columnIndex).getAlignment();
        int dotStartX = -1;
        if (label != null) {
            int maxWidth;
            GC gc = new GC(parent);
            gc.setFont(this.getFont());
            dotStartX = this.getAlignmentOffset(columnIndex, columnWidth, gc);
            if ((alignment & 0x4000) != 0 && (label = parent.trimItemText(label, maxWidth = this.getMaxTextWidth(columnIndex, columnWidth), gc)).endsWith("...")) {
                int dotsWidth = gc.stringExtent((String)"...").x;
                dotStartX = gc.stringExtent((String)label).x - dotsWidth;
                dotStartX += this.getImageStopX(columnIndex);
                dotStartX += this.getTextIndent(columnIndex);
            }
            gc.dispose();
        }
        return dotStartX;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        Table parent = this.getParent();
        return parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground != null) {
            return this.foreground;
        }
        Table parent = this.getParent();
        return parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        return super.getGrayed();
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int columnIndex) {
        this.checkWidget();
        Image image = null;
        Vector images = this.getImages();
        int itemIndex = this.getParent().indexOf(this);
        if (itemIndex != -1 && columnIndex >= 0 && columnIndex < images.size()) {
            image = (Image)images.elementAt(columnIndex);
        }
        return image;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        Table parent = this.getParent();
        int itemIndex = parent.indexOf(this);
        int imageWidth = 0;
        Point imageExtent = parent.getImageExtent();
        Rectangle imageBounds = this.getBounds(index);
        if (itemIndex == -1) {
            imageBounds = new Rectangle(0, 0, 0, 0);
        } else if (imageExtent != null && (index == 0 || this.getImage(index) != null)) {
            imageWidth = imageExtent.x;
        }
        imageBounds.width = imageWidth;
        return imageBounds;
    }

    public int getImageIndent() {
        this.checkWidget();
        int index = this.getParent().indexOf(this);
        if (index == -1) {
            return 0;
        }
        return this.imageIndent;
    }

    int getImageIndentPixel() {
        int indentPixel = 2;
        Point imageExtent = this.getParent().getImageExtent();
        if (imageExtent != null) {
            indentPixel += imageExtent.x * this.getImageIndent();
        }
        return indentPixel;
    }

    Vector getImages() {
        return this.images;
    }

    int getImageStopX(int columnIndex) {
        int imageStopX = 0;
        Table parent = this.getParent();
        if (columnIndex == 0) {
            if (this.isCheckable()) {
                Rectangle checkboxBounds = this.getCheckboxBounds();
                imageStopX += checkboxBounds.x + checkboxBounds.width + 1;
            } else {
                imageStopX = this.getImageIndentPixel();
            }
        }
        if ((columnIndex == 0 && parent.hasFirstColumnImage() || columnIndex != 0 && this.getImage(columnIndex) != null) && parent.getImageExtent() != null) {
            imageStopX += parent.getImageExtent().x;
        }
        return imageStopX;
    }

    int getIndex() {
        return this.index;
    }

    Point getItemExtent(TableColumn column) {
        Table parent = this.getParent();
        int columnIndex = column.getIndex();
        Point extent = new Point(this.getImageStopX(columnIndex), parent.getItemHeight() - parent.getGridLineWidth());
        GC gc = new GC(parent);
        gc.setFont(this.getFont());
        String trimmedText = this.getText(gc, column);
        if (trimmedText != null && trimmedText.length() > 0) {
            extent.x += gc.stringExtent((String)trimmedText).x + this.getTextIndent(columnIndex);
        }
        if (columnIndex == 0) {
            extent.x += 6;
        }
        gc.dispose();
        return extent;
    }

    int getMaxTextWidth(int columnIndex, int columnWidth) {
        int itemWidth = this.getImageStopX(columnIndex) + this.getTextIndent(columnIndex) * 2;
        return columnWidth - itemWidth;
    }

    public Table getParent() {
        this.checkWidget();
        return (Table)super.getSelectableParent();
    }

    int getPreferredWidth(int index) {
        int size = this.getImageStopX(index);
        String text = this.getText(index);
        if (text != null) {
            size += this.getTextWidth(text) + this.getTextIndent(index) * 2 + 1;
        }
        return size;
    }

    Point getSelectionExtent() {
        Point extent;
        Table parent = this.getParent();
        if ((parent.getStyle() & 0x10000) == 0) {
            if (this.selectionExtent == null) {
                this.calculateSelectionExtent();
            }
            extent = this.selectionExtent;
        } else {
            extent = parent.getFullSelectionExtent(this);
        }
        return extent;
    }

    int getSelectionX() {
        return this.getImageStopX(0) + this.getParent().getHorizontalOffset();
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int columnIndex) {
        this.checkWidget();
        int itemIndex = this.getParent().indexOf(this);
        Vector labels = this.getDataLabels();
        String label = null;
        if (itemIndex == -1) {
            this.error(12);
        }
        if (columnIndex >= 0 && columnIndex < labels.size()) {
            label = (String)labels.elementAt(columnIndex);
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    String getText(GC gc, TableColumn column) {
        int columnIndex = column.getIndex();
        String label = this.getTrimmedText(columnIndex);
        if (label == null) {
            gc.setFont(this.getFont());
            int maxWidth = this.getMaxTextWidth(columnIndex, column.getWidth());
            label = this.getParent().trimItemText(this.getText(columnIndex), maxWidth, gc);
        }
        return label;
    }

    int getTextIndent(int columnIndex) {
        int textIndent = columnIndex == 0 ? (!this.getParent().hasFirstColumnImage() ? 2 : 4) : 6;
        return textIndent;
    }

    String getTrimmedText(int columnIndex) {
        String label = null;
        String[] labels = this.getTrimmedTexts();
        if (columnIndex < labels.length) {
            label = labels[columnIndex];
        }
        return label;
    }

    String[] getTrimmedTexts() {
        return this.trimmedLabels;
    }

    int getTextWidth(String text) {
        int textWidth = 0;
        if (text != null) {
            GC gc = new GC(this.getParent());
            gc.setFont(this.getFont());
            textWidth = gc.stringExtent((String)text).x;
            gc.dispose();
        }
        return textWidth;
    }

    void growVectors(int newSize) {
        Vector images = this.getImages();
        Vector labels = this.getDataLabels();
        if (newSize > images.size()) {
            images.setSize(newSize);
        }
        if (newSize > labels.size()) {
            labels.setSize(newSize);
        }
    }

    void insertColumn(TableColumn column) {
        Vector data = this.getDataLabels();
        Vector images = this.getImages();
        int index = column.getIndex();
        if (index < data.size()) {
            data.insertElementAt(null, index);
        } else {
            data.addElement(null);
        }
        Object[] stringData = new String[data.size()];
        data.copyInto(stringData);
        this.setText((String[])stringData);
        if (index < images.size()) {
            images.insertElementAt(null, index);
        } else {
            images.addElement(null);
        }
        Object[] imageData = new Image[images.size()];
        images.copyInto(imageData);
        this.setImage((Image[])imageData);
        String[] tempTrimmed = new String[this.trimmedLabels.length + 1];
        System.arraycopy(this.trimmedLabels, 0, tempTrimmed, 0, index);
        System.arraycopy(this.trimmedLabels, index, tempTrimmed, index + 1, this.trimmedLabels.length - index);
        this.trimmedLabels = tempTrimmed;
    }

    void internalSetImage(int columnIndex, Image image) {
        Vector images = this.getImages();
        boolean imageWasNull = false;
        Table parent = this.getParent();
        if (columnIndex >= 0 && columnIndex < parent.internalGetColumnCount()) {
            Image oldImage;
            if (columnIndex >= images.size()) {
                this.growVectors(columnIndex + 1);
            }
            if ((oldImage = (Image)images.elementAt(columnIndex)) == null && image != null) {
                imageWasNull = true;
            }
            if (image != null && image.isDisposed()) {
                this.error(5);
            }
            if (image != null && image.type == 1 && image.equals(oldImage)) {
                return;
            }
            images.setElementAt(image, columnIndex);
            this.reset(columnIndex);
            this.notifyImageChanged(columnIndex, imageWasNull);
        }
    }

    void internalSetText(int columnIndex, String string) {
        Vector labels = this.getDataLabels();
        Table parent = this.getParent();
        if (columnIndex >= 0 && columnIndex < parent.internalGetColumnCount()) {
            String oldText;
            if (columnIndex >= labels.size()) {
                this.growVectors(columnIndex + 1);
            }
            if (!string.equals(oldText = (String)labels.elementAt(columnIndex))) {
                labels.setElementAt(string, columnIndex);
                this.reset(columnIndex);
                this.notifyTextChanged(columnIndex, oldText == null);
            }
        }
    }

    boolean isSelectionHit(int xPosition) {
        int itemStopX = this.getImageStopX(0);
        Point selectionExtent = this.getSelectionExtent();
        if (selectionExtent != null) {
            itemStopX += selectionExtent.x;
        }
        return xPosition > this.getCheckboxBounds().x + this.getCheckboxBounds().width && xPosition <= itemStopX;
    }

    void notifyImageChanged(int columnIndex, boolean imageWasNull) {
        Table parent = this.getParent();
        int redrawStartX = 0;
        int redrawWidth = 0;
        int columnCount = parent.internalGetColumnCount();
        if (columnIndex >= 0 && columnIndex < columnCount && parent.getVisibleRedrawY(this) != -1) {
            Rectangle changedColumnBounds = parent.internalGetColumn(columnIndex).getBounds();
            Image currentImage = this.getImage(columnIndex);
            redrawStartX = Math.max(0, this.getImageBounds((int)columnIndex).x);
            redrawWidth = parent.getImageExtent() != null && !imageWasNull && currentImage != null ? this.getImageStopX(columnIndex) : changedColumnBounds.width;
            redrawWidth += changedColumnBounds.x - redrawStartX;
        }
        this.cached = true;
        parent.itemChanged(this, redrawStartX, redrawWidth);
    }

    void notifyTextChanged(int columnIndex, boolean textWasNull) {
        Table parent = this.getParent();
        int redrawStartX = 0;
        int redrawWidth = 0;
        int columnCount = parent.internalGetColumnCount();
        if (columnIndex >= 0 && columnIndex < columnCount && parent.getVisibleRedrawY(this) != -1) {
            String text = (String)this.getDataLabels().elementAt(columnIndex);
            Rectangle columnBounds = parent.internalGetColumn(columnIndex).getBounds();
            redrawStartX = columnBounds.x;
            if (this.getImage(columnIndex) != null) {
                redrawStartX += this.getImageStopX(columnIndex);
            }
            redrawStartX = Math.max(0, redrawStartX);
            if (!textWasNull || text.length() > 0) {
                redrawWidth = columnBounds.x + columnBounds.width - redrawStartX;
            }
        }
        this.cached = true;
        parent.itemChanged(this, redrawStartX, redrawWidth);
    }

    void paint(GC gc, Point paintPosition, TableColumn column) {
        int columnIndex = column.getIndex();
        String label = this.getText(gc, column);
        String oldLabel = this.getTrimmedText(columnIndex);
        Table parent = this.getParent();
        int itemHeight = parent.getItemHeight();
        if (label != null && !label.equals(oldLabel)) {
            this.setTrimmedText(label, columnIndex);
            this.selectionExtent = null;
        }
        Color background = gc.getBackground();
        if (!this.isSelected() || (parent.getStyle() & 0x8000) != 0 && !parent.isFocusControl()) {
            int width = column.getBounds().width;
            int height = itemHeight;
            gc.setBackground(this.getBackground(columnIndex));
            gc.fillRectangle(paintPosition.x, paintPosition.y, width, height);
        } else if (columnIndex == 0) {
            int width = this.getImageIndentPixel();
            int height = itemHeight;
            gc.setBackground(this.getBackground(columnIndex));
            gc.fillRectangle(paintPosition.x, paintPosition.y, width, height);
        } else if ((parent.getStyle() & 0x10000) == 0) {
            int width = column.getBounds().width;
            int height = itemHeight;
            gc.setBackground(this.getBackground(columnIndex));
            gc.fillRectangle(paintPosition.x, paintPosition.y, width, height);
        }
        if (columnIndex == 0) {
            paintPosition.x += this.getImageIndentPixel();
            if (this.isCheckable()) {
                paintPosition = this.drawCheckbox(gc, paintPosition);
            }
        }
        paintPosition = this.drawImage(gc, paintPosition, columnIndex);
        paintPosition.x += this.getTextIndent(columnIndex);
        this.drawText(label, gc, paintPosition, columnIndex);
        gc.setBackground(background);
    }

    void removeColumn(TableColumn column) {
        Vector data = this.getDataLabels();
        Vector images = this.getImages();
        int index = column.getIndex();
        if (index < data.size()) {
            data.removeElementAt(index);
            Object[] stringData = new String[data.size()];
            data.copyInto(stringData);
            this.setText((String[])stringData);
        }
        if (index < images.size()) {
            images.removeElementAt(index);
            Object[] imageData = new Image[images.size()];
            images.copyInto(imageData);
            this.setImage((Image[])imageData);
        }
        if (this.trimmedLabels.length == 1) {
            this.trimmedLabels = new String[0];
        } else {
            String[] tempTrimmed = new String[this.trimmedLabels.length - 1];
            System.arraycopy(this.trimmedLabels, 0, tempTrimmed, 0, index);
            System.arraycopy(this.trimmedLabels, index + 1, tempTrimmed, index, this.trimmedLabels.length - index - 1);
            this.trimmedLabels = tempTrimmed;
        }
    }

    void reset(int index) {
        String[] trimmedLabels = this.getTrimmedTexts();
        if (index >= 0 && index < trimmedLabels.length) {
            trimmedLabels[index] = null;
        }
        if (index == 0) {
            this.selectionExtent = null;
        }
    }

    void redraw() {
        this.cached = true;
        Table parent = this.getParent();
        int y = parent.getRedrawY(this);
        parent.redraw(0, y, parent.getClientArea().width, parent.getItemHeight(), false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == color) {
            return;
        }
        if (this.background != null && this.background.equals(color)) {
            return;
        }
        this.background = color;
        this.redraw();
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new Color[count];
        }
        if (this.cellBackground[index] == color) {
            return;
        }
        if (this.cellBackground[index] != null && this.cellBackground[index].equals(color)) {
            return;
        }
        this.cellBackground[index] = color;
        this.redraw();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.redraw();
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[count];
        }
        if (this.cellFont[index] == font) {
            return;
        }
        if (this.cellFont[index] != null && this.cellFont[index].equals(font)) {
            return;
        }
        this.cellFont[index] = font;
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == color) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(color)) {
            return;
        }
        this.foreground = color;
        this.redraw();
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        Table parent = this.getParent();
        int count = Math.max(1, parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new Color[count];
        }
        if (this.cellForeground[index] == color) {
            return;
        }
        if (this.cellForeground[index] != null && this.cellForeground[index].equals(color)) {
            return;
        }
        this.cellForeground[index] = color;
        this.redraw();
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        if (this.getParent().indexOf(this) == -1) {
            return;
        }
        int i = 0;
        while (i < images.length) {
            this.internalSetImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (this.getParent().indexOf(this) != -1) {
            this.internalSetImage(index, image);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        Table parent = this.getParent();
        int index = parent.indexOf(this);
        if (index != -1 && indent >= 0 && indent != this.imageIndent) {
            this.imageIndent = indent;
            TableColumn column = parent.internalGetColumn(0);
            parent.redraw(0, parent.getRedrawY(this), column.getWidth(), parent.getItemHeight(), false);
            this.cached = true;
        }
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        if (this.getParent().indexOf(this) == -1) {
            return;
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.internalSetText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.getParent().indexOf(this) != -1) {
            this.internalSetText(index, string);
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        this.setText(0, text);
    }

    void setTrimmedText(String label, int columnIndex) {
        String[] labels = this.getTrimmedTexts();
        if (columnIndex < labels.length) {
            labels[columnIndex] = label;
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        super.setChecked(checked);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        super.setGrayed(grayed);
    }

    void setIndex(int newIndex) {
        this.index = newIndex;
    }
}

