/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Text
extends Scrollable {
    char echoCharacter;
    boolean ignoreChange;
    String hiddenText;
    XmTextVerifyCallbackStruct textVerify;
    int drawCount;
    static final boolean IsGB18030;
    public static final int LIMIT;
    public static final String DELIMITER;

    static {
        LIMIT = Integer.MAX_VALUE;
        DELIMITER = "\n";
        IsGB18030 = Converter.defaultCodePage().endsWith("18030");
    }

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int position = OS.XmTextGetLastPosition(this.handle);
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetInsertionPosition(this.handle, position);
        OS.XmTextInsert(this.handle, position, buffer);
        position = OS.XmTextGetLastPosition(this.handle);
        OS.XmTextSetInsertionPosition(this.handle, position);
        this.display.setWarnings(warnings);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        OS.XmTextClearSelection(this.handle, OS.XtLastTimestampProcessed(xDisplay));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1 || hHint == -1) {
            int ptr = OS.XmTextGetString(this.handle);
            if (ptr == 0) {
                return new Point(0, 0);
            }
            int size = OS.strlen(ptr);
            if (size == 0) {
                if (hHint == -1) {
                    height = (this.style & 4) != 0 ? this.getLineHeight() : 64;
                }
                if (wHint == -1) {
                    width = 64;
                }
            } else {
                byte[] buffer = new byte[size + 1];
                OS.memmove(buffer, ptr, size);
                int xmString = (this.style & 4) != 0 ? OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0) : OS.XmStringGenerate(buffer, OS.XmFONTLIST_DEFAULT_TAG, 0, null);
                int fontList = this.font.handle;
                if (hHint == -1) {
                    height = (this.style & 4) != 0 ? this.getLineHeight() : OS.XmStringHeight(fontList, xmString);
                }
                if (wHint == -1) {
                    width = OS.XmStringWidth(fontList, xmString);
                }
                OS.XmStringFree(xmString);
            }
            OS.XtFree(ptr);
        }
        if (this.horizontalBar != null) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNheight;
            int[] argList1 = nArray;
            OS.XtGetValues(this.horizontalBar.handle, argList1, argList1.length / 2);
            height += argList1[1] + 4;
        }
        if (this.verticalBar != null) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNwidth;
            int[] argList1 = nArray;
            OS.XtGetValues(this.verticalBar.handle, argList1, argList1.length / 2);
            width += argList1[1] + 4;
        }
        XRectangle rect = new XRectangle();
        OS.XmWidgetGetDisplayRect(this.handle, rect);
        width += rect.x * 2;
        height += rect.y * 2;
        if ((this.style & 0x802) != 0) {
            ++height;
        }
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        XRectangle rect = new XRectangle();
        OS.XmWidgetGetDisplayRect(this.handle, rect);
        trim.x -= rect.x;
        trim.y -= rect.y;
        trim.width += rect.x;
        trim.height += rect.y;
        if ((this.style & 0x802) != 0) {
            trim.height += 3;
        }
        return trim;
    }

    public void copy() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        OS.XmTextCopy(this.handle, OS.XtLastTimestampProcessed(xDisplay));
    }

    void createHandle(int index) {
        this.state |= 8;
        int[] nArray = new int[16];
        nArray[0] = OS.XmNverifyBell;
        nArray[2] = OS.XmNeditMode;
        nArray[3] = (this.style & 4) != 0 ? 1 : 0;
        nArray[4] = OS.XmNscrollHorizontal;
        nArray[5] = (this.style & 0x100) != 0 ? 1 : 0;
        nArray[6] = OS.XmNscrollVertical;
        nArray[7] = (this.style & 0x200) != 0 ? 1 : 0;
        nArray[8] = OS.XmNwordWrap;
        nArray[9] = !IsGB18030 && (this.style & 0x40) != 0 ? 1 : 0;
        nArray[10] = OS.XmNeditable;
        nArray[11] = (this.style & 8) != 0 ? 0 : 1;
        nArray[12] = OS.XmNcursorPositionVisible;
        nArray[13] = (this.style & 8) != 0 && (this.style & 4) != 0 ? 0 : 1;
        nArray[14] = OS.XmNancestorSensitive;
        nArray[15] = 1;
        int[] argList1 = nArray;
        int parentHandle = this.parent.handle;
        if ((this.style & 4) != 0) {
            this.handle = OS.XmCreateTextField(parentHandle, null, argList1, argList1.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNcursorPositionVisible;
            int[] argList2 = nArray2;
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        } else {
            this.handle = OS.XmCreateScrolledText(parentHandle, new byte[1], argList1, argList1.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.XtParent(this.handle);
        }
        if ((this.style & 0x800) == 0) {
            int[] nArray3 = new int[4];
            nArray3[0] = OS.XmNmarginHeight;
            nArray3[2] = OS.XmNshadowThickness;
            int[] argList3 = nArray3;
            OS.XtSetValues(this.handle, argList3, argList3.length / 2);
        }
    }

    ScrollBar createScrollBar(int type) {
        return this.createStandardBar(type);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.hiddenText = "";
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('*');
        }
    }

    public void cut() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        OS.XmTextCut(this.handle, OS.XtLastTimestampProcessed(xDisplay));
    }

    int defaultBackground() {
        return this.display.textBackground;
    }

    Font defaultFont() {
        return this.display.textFont;
    }

    int defaultForeground() {
        return this.display.textForeground;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return this.getLineNumber(OS.XmTextGetInsertionPosition(this.handle));
    }

    public Point getCaretLocation() {
        this.checkWidget();
        int position = this.textVerify != null ? this.textVerify.currInsert : OS.XmTextGetInsertionPosition(this.handle);
        short[] x = new short[1];
        short[] y = new short[1];
        OS.XmTextPosToXY(this.handle, position, x, y);
        return new Point(x[0], y[0] - this.getFontAscent(this.font.handle));
    }

    public int getCaretPosition() {
        this.checkWidget();
        return OS.XmTextGetInsertionPosition(this.handle);
    }

    public int getCharCount() {
        this.checkWidget();
        return OS.XmTextGetLastPosition(this.handle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNselectionArrayCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 1;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNeditable;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        int lastChar = this.echoCharacter != '\u0000' ? this.hiddenText.length() : OS.XmTextGetLastPosition(this.handle);
        return this.getLineNumber(lastChar) + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.getFontHeight(this.font.handle);
    }

    int getLineNumber(int position) {
        if (position == 0) {
            return 0;
        }
        int count = 0;
        int start = 0;
        int page = 1024;
        char[] buffer = new char[page + 1];
        byte[] buffer1 = null;
        if (OS.IsLinux) {
            buffer1 = new byte[page + 1];
        }
        int end = (position + page - 1) / page * page;
        while (start < end) {
            int i;
            int length = page;
            if (start + page > position) {
                length = position - start;
            }
            if (this.echoCharacter != '\u0000') {
                this.hiddenText.getChars(start, start + length, buffer, 0);
            } else if (OS.IsLinux) {
                OS.XmTextGetSubstring(this.handle, start, length, buffer1.length, buffer1);
                i = 0;
                while (i < length) {
                    buffer[i] = (char)buffer1[i];
                    ++i;
                }
            } else {
                OS.XmTextGetSubstringWcs(this.handle, start, length, buffer.length, buffer);
            }
            i = 0;
            while (i < length) {
                if (buffer[i] == '\n') {
                    ++count;
                }
                ++i;
            }
            start += page;
        }
        return count;
    }

    int getNavigationType() {
        if ((this.style & 4) != 0) {
            return super.getNavigationType();
        }
        int ptr = OS.XtMalloc(4);
        if (ptr == 0) {
            return 0;
        }
        int[] argList = new int[]{OS.XmNnavigationType, ptr};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int[] buffer = new int[1];
        OS.memmove(buffer, ptr, 4);
        OS.XtFree(ptr);
        return buffer[0];
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if (this.textVerify != null) {
            return new Point(this.textVerify.startPos, this.textVerify.endPos);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, start, end);
        if (start[0] == end[0]) {
            start[0] = end[0] = OS.XmTextGetInsertionPosition(this.handle);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.textVerify != null) {
            return this.textVerify.endPos - this.textVerify.startPos;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, start, end);
        return end[0] - start[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.echoCharacter != '\u0000' || this.textVerify != null) {
            Point selection = this.getSelection();
            return this.getText(selection.x, selection.y);
        }
        int ptr = OS.XmTextGetSelection(this.handle);
        if (ptr == 0) {
            return "";
        }
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        OS.XtFree(ptr);
        return new String(Converter.mbcsToWcs(this.getCodePage(), buffer));
    }

    public int getTabs() {
        this.checkWidget();
        return 8;
    }

    public String getText() {
        this.checkWidget();
        if (this.echoCharacter != '\u0000') {
            return this.hiddenText;
        }
        int ptr = OS.XmTextGetString(this.handle);
        if (ptr == 0) {
            return "";
        }
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        OS.XtFree(ptr);
        return new String(Converter.mbcsToWcs(this.getCodePage(), buffer));
    }

    public String getText(int start, int end) {
        int length;
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        boolean hasEcho = this.echoCharacter != '\u0000';
        int n = length = hasEcho ? this.hiddenText.length() : OS.XmTextGetLastPosition(this.handle);
        if (length == 0) {
            return "";
        }
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        if (hasEcho) {
            return this.hiddenText.substring(start, end + 1);
        }
        int numChars = end - start + 1;
        int bufLength = numChars * OS.MB_CUR_MAX() + 1;
        byte[] buffer = new byte[bufLength];
        int code = OS.XmTextGetSubstring(this.handle, start, numChars, bufLength, buffer);
        switch (code) {
            case 0: 
            case 2: {
                this.error(12);
            }
        }
        char[] unicode = Converter.mbcsToWcs(this.getCodePage(), buffer);
        return new String(unicode, 0, numChars);
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.XmTextGetMaxLength(this.handle);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        if (this.scrolledHandle == 0) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNverticalScrollBar;
        int[] argList1 = nArray;
        OS.XtGetValues(this.scrolledHandle, argList1, argList1.length / 2);
        if (argList1[1] == 0) {
            return 0;
        }
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNvalue;
        int[] argList2 = nArray2;
        OS.XtGetValues(argList1[1], argList2, argList2.length / 2);
        return argList2[1];
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getTopIndex() * this.getLineHeight();
    }

    boolean hasIMSupport() {
        return true;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNactivateCallback, windowProc, 9);
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 25);
        OS.XtAddCallback(this.handle, OS.XmNmodifyVerifyCallback, windowProc, 19);
    }

    int inputContext() {
        return 0;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, start, end);
        if (start[0] == end[0]) {
            start[0] = end[0] = OS.XmTextGetInsertionPosition(this.handle);
        }
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextReplace(this.handle, start[0], end[0], buffer);
        int position = start[0] + buffer.length - 1;
        OS.XmTextSetInsertionPosition(this.handle, position);
        this.display.setWarnings(warnings);
    }

    void overrideTranslations() {
        if ((this.style & 4) != 0) {
            OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
        }
    }

    public void paste() {
        this.checkWidget();
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        if ((this.style & 4) != 0) {
            OS.XmTextFieldPaste(this.handle);
        } else {
            OS.XmTextPaste(this.handle);
        }
        this.display.setWarnings(warnings);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.hiddenText = null;
        this.textVerify = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    boolean sendIMKeyEvent(int type, XKeyEvent xEvent) {
        return super.sendIMKeyEvent(type, xEvent, this.handle);
    }

    public void selectAll() {
        int xDisplay;
        this.checkWidget();
        int position = OS.XmTextGetLastPosition(this.handle);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(this.handle, 0, position, OS.XtLastTimestampProcessed(xDisplay));
        OS.XmTextSetInsertionPosition(this.handle, 0);
        this.display.setWarnings(warnings);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        this.display.setWarnings(warnings);
        return changed;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNselectionArrayCount, doubleClick ? 4 : 1};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setEchoChar(char echo) {
        String newText;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.echoCharacter == echo) {
            return;
        }
        if (echo == '\u0000') {
            newText = this.hiddenText;
            this.hiddenText = "";
        } else {
            newText = this.hiddenText = this.getText();
        }
        this.echoCharacter = echo;
        Point selection = this.getSelection();
        boolean oldValue = this.ignoreChange;
        this.ignoreChange = true;
        this.setText(newText);
        this.setSelection(selection);
        this.ignoreChange = oldValue;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        OS.XmTextSetEditable(this.handle, editable);
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNcursorPositionVisible, editable && this.hasFocus() ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (redraw) {
            if (--this.drawCount == 0) {
                OS.XmTextEnableRedisplay(this.handle);
            }
        } else if (this.drawCount++ == 0) {
            OS.XmTextDisableRedisplay(this.handle);
        }
    }

    public void setSelection(int start) {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int position = OS.XmTextGetLastPosition(this.handle);
        int nStart = Math.min(Math.max(start, 0), position);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextClearSelection(this.handle, OS.XtLastTimestampProcessed(xDisplay));
        OS.XmTextSetInsertionPosition(this.handle, nStart);
        this.display.setWarnings(warnings);
    }

    public void setSelection(int start, int end) {
        int xDisplay;
        this.checkWidget();
        int position = OS.XmTextGetLastPosition(this.handle);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        int nStart = Math.min(Math.max(Math.min(start, end), 0), position);
        int nEnd = Math.min(Math.max(Math.max(start, end), 0), position);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(this.handle, nStart, nEnd, OS.XtLastTimestampProcessed(xDisplay));
        OS.XmTextSetInsertionPosition(this.handle, nEnd);
        this.display.setWarnings(warnings);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(this.handle, buffer);
        OS.XmTextSetInsertionPosition(this.handle, 0);
        this.display.setWarnings(warnings);
        if (OS.IsLinux && (this.style & 2) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.XmTextSetMaxLength(this.handle, limit);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.scrolledHandle == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNverticalScrollBar;
        int[] argList1 = nArray;
        OS.XtGetValues(this.scrolledHandle, argList1, argList1.length / 2);
        if (argList1[1] == 0) {
            return;
        }
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNvalue;
        int[] argList2 = nArray2;
        OS.XtGetValues(argList1[1], argList2, argList2.length / 2);
        OS.XmTextScroll(this.handle, index - argList2[1]);
    }

    public void showSelection() {
        this.checkWidget();
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int position = OS.XmTextGetInsertionPosition(this.handle);
        OS.XmTextShowPosition(this.handle, position);
        this.display.setWarnings(warnings);
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        int bits = super.traversalCode(key, xEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && xEvent != null) {
                boolean next;
                boolean bl = next = (xEvent.state & 1) == 0;
                if (next && (xEvent.state & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        super.xFocusIn(xEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            return 0;
        }
        if ((this.style & 2) != 0) {
            return 0;
        }
        int[] argList = new int[]{OS.XmNcursorPositionVisible, 1};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        super.xFocusOut(xEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            return 0;
        }
        if ((this.style & 2) != 0) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNcursorPositionVisible;
        int[] argList = nArray;
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        return 0;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(14);
        return 0;
    }

    int XmNmodifyVerifyCallback(int w, int client_data, int call_data) {
        String text;
        int result = super.XmNmodifyVerifyCallback(w, client_data, call_data);
        if (result != 0) {
            return result;
        }
        if (this.echoCharacter == '\u0000' && !this.hooks(25) && !this.filters(25)) {
            return result;
        }
        XmTextVerifyCallbackStruct textVerify = new XmTextVerifyCallbackStruct();
        OS.memmove(textVerify, call_data, 32);
        XmTextBlockRec textBlock = new XmTextBlockRec();
        OS.memmove(textBlock, textVerify.text, 12);
        byte[] buffer = new byte[textBlock.length];
        OS.memmove(buffer, textBlock.ptr, textBlock.length);
        String codePage = this.getCodePage();
        String newText = text = new String(Converter.mbcsToWcs(codePage, buffer));
        if (!this.ignoreChange) {
            Event event = new Event();
            if (textVerify.event != 0) {
                XKeyEvent xEvent = new XKeyEvent();
                OS.memmove(xEvent, textVerify.event, 60);
                event.time = xEvent.time;
                this.setKeyState(event, xEvent);
            }
            event.start = textVerify.startPos;
            event.end = textVerify.endPos;
            event.doit = textVerify.doit == 1;
            event.text = text;
            this.sendEvent(25, event);
            newText = event.text;
            textVerify.doit = (byte)(event.doit && newText != null ? 1 : 0);
        }
        if (newText != null) {
            if (this.echoCharacter != '\u0000' && textVerify.doit != 0) {
                String prefix = this.hiddenText.substring(0, textVerify.startPos);
                String suffix = this.hiddenText.substring(textVerify.endPos, this.hiddenText.length());
                this.hiddenText = String.valueOf(prefix) + newText + suffix;
                char[] charBuffer = new char[newText.length()];
                int i = 0;
                while (i < charBuffer.length) {
                    charBuffer[i] = this.echoCharacter;
                    ++i;
                }
                newText = new String(charBuffer);
            }
            if (newText != text) {
                byte[] buffer2 = Converter.wcsToMbcs(codePage, newText, true);
                int length = buffer2.length;
                int ptr = OS.XtMalloc(length);
                OS.memmove(ptr, buffer2, length);
                textBlock.ptr = ptr;
                textBlock.length = buffer2.length - 1;
                OS.memmove(textVerify.text, textBlock, 12);
            }
        }
        OS.memmove(call_data, textVerify, 32);
        textVerify = null;
        return result;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if (!this.ignoreChange) {
            this.sendEvent(24);
        }
        return 0;
    }
}

