/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int drawCount;
    int itemCount;
    ToolItem[] items;
    ToolItem lastFocus;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        int[] result = this.layout(width, height, false);
        int border = this.getBorderWidth() * 2;
        Point extent = new Point(result[1], result[2]);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        extent.x += border;
        extent.y += border;
        return extent;
    }

    void createHandle(int index) {
        super.createHandle(index);
        this.state &= 0xFFFFFFFD;
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.createWidget(index);
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void destroyItem(ToolItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus();
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        ToolItem[] items = this.getItems();
        if (index >= 0 && index < items.length) {
            return items[index];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point pt) {
        this.checkWidget();
        if (pt == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(pt)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        return this.layout(rect.width, rect.height, false)[0];
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int[] layoutHorizontal(int nWidth, int nHeight, boolean resize) {
        int xSpacing = 0;
        int ySpacing = (this.style & 0x80000) != 0 ? 4 : 2;
        int marginWidth = 0;
        int marginHeight = 0;
        ToolItem[] children = this.getItems();
        int length = children.length;
        int x = marginWidth;
        int y = marginHeight;
        int maxHeight = 0;
        int maxX = 0;
        int rows = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int i = 0;
        while (i < length) {
            ToolItem child = children[i];
            Rectangle rect = child.getBounds();
            if (wrap && i != 0 && x + rect.width > nWidth) {
                ++rows;
                x = marginWidth;
                y += ySpacing + maxHeight;
                maxHeight = 0;
            }
            maxHeight = Math.max(maxHeight, rect.height);
            if (resize) {
                child.setBounds(x, y, rect.width, rect.height);
            }
            maxX = Math.max(maxX, x += xSpacing + rect.width);
            ++i;
        }
        return new int[]{rows, maxX, y + maxHeight};
    }

    int[] layoutVertical(int nWidth, int nHeight, boolean resize) {
        int xSpacing = (this.style & 0x80000) != 0 ? 4 : 2;
        int ySpacing = 0;
        int marginWidth = 0;
        int marginHeight = 0;
        ToolItem[] children = this.getItems();
        int length = children.length;
        int x = marginWidth;
        int y = marginHeight;
        int maxWidth = 0;
        int maxY = 0;
        int cols = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int i = 0;
        while (i < length) {
            ToolItem child = children[i];
            Rectangle rect = child.getBounds();
            if (wrap && i != 0 && y + rect.height > nHeight) {
                ++cols;
                x += xSpacing + maxWidth;
                y = marginHeight;
                maxWidth = 0;
            }
            maxWidth = Math.max(maxWidth, rect.width);
            if (resize) {
                child.setBounds(x, y, rect.width, rect.height);
            }
            maxY = Math.max(maxY, y += ySpacing + rect.height);
            ++i;
        }
        return new int[]{cols, x + maxWidth, maxY};
    }

    int[] layout(int nWidth, int nHeight, boolean resize) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(nWidth, nHeight, resize);
        }
        return this.layoutHorizontal(nWidth, nHeight, resize);
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.items.length) {
            char mnemonic;
            ToolItem item = this.items[i];
            if (item != null && (mnemonic = this.findMnemonic(item.getText())) != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                this.XmProcessTraversal(item.handle, 0);
                item.click(false, 0);
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.items.length) {
            char mnemonic;
            ToolItem item = this.items[i];
            if (item != null && item.getEnabled() && (mnemonic = this.findMnemonic(item.getText())) != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].propagateWidget(enabled);
            ++i;
        }
    }

    void relayout() {
        if (this.drawCount > 0) {
            return;
        }
        Rectangle rect = this.getClientArea();
        this.layout(rect.width, rect.height, true);
    }

    void relayout(int width, int height) {
        if (this.drawCount > 0) {
            return;
        }
        this.layout(width, height, true);
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].setBackgroundPixel(pixel);
            }
            ++i;
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            Rectangle rect = this.getClientArea();
            this.relayout(rect.width, rect.height);
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        int i = 0;
        while (i < this.items.length) {
            ToolItem item = this.items[i];
            if (item != null) {
                Point size = item.computeSize();
                item.setSize(size.x, size.y, false);
            }
            ++i;
        }
        this.relayout();
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].setForegroundPixel(pixel);
            }
            ++i;
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.relayout();
            }
        } else {
            ++this.drawCount;
        }
    }

    boolean setTabItemFocus(boolean next) {
        int index = 0;
        while (index < this.items.length) {
            ToolItem item = this.items[index];
            if (item != null && (item.style & 2) == 0 && item.getEnabled()) break;
            ++index;
        }
        if (index == this.items.length) {
            return false;
        }
        return super.setTabItemFocus(next);
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        return super.traversalCode(key, xEvent) | 0x80;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int newFocus = OS.XmGetFocusWidget(this.handle);
        if (newFocus != this.focusHandle()) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i].handle == newFocus) {
                    this.lastFocus = this.items[i];
                    break;
                }
                ++i;
            }
        }
        return super.xFocusIn(xEvent);
    }
}

