/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XCrossingEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XWindowChanges;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean set;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 8;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        parent.relayout();
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
        parent.relayout();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.handle;
        if ((this.style & 2) != 0) {
            int orientation = (this.parent.style & 0x100) != 0 ? 1 : 2;
            int[] argList = new int[]{OS.XmNheight, orientation == 1 ? 22 : 8, OS.XmNwidth, orientation == 2 ? 24 : 8, OS.XmNancestorSensitive, 1, OS.XmNpositionIndex, index, OS.XmNorientation, orientation, OS.XmNseparatorType, (this.parent.style & 0x800000) != 0 ? 5 : 6};
            this.handle = OS.XmCreateSeparator(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] nArray = new int[20];
        nArray[0] = OS.XmNwidth;
        nArray[1] = 24;
        nArray[2] = OS.XmNheight;
        nArray[3] = 22;
        nArray[4] = OS.XmNrecomputeSize;
        nArray[6] = OS.XmNhighlightThickness;
        nArray[7] = (this.parent.style & 0x80000) != 0 ? 0 : 1;
        nArray[8] = OS.XmNmarginWidth;
        nArray[9] = 2;
        nArray[10] = OS.XmNmarginHeight;
        nArray[11] = 1;
        nArray[12] = OS.XmNtraversalOn;
        nArray[13] = (this.parent.style & 0x80000) != 0 ? 0 : 1;
        nArray[14] = OS.XmNpositionIndex;
        nArray[15] = index;
        nArray[16] = OS.XmNshadowType;
        nArray[17] = 8;
        nArray[18] = OS.XmNancestorSensitive;
        nArray[19] = 1;
        int[] argList = nArray;
        this.handle = OS.XmCreateDrawnButton(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int pixel = this.parent.getBackgroundPixel();
        this.setBackgroundPixel(pixel);
    }

    void click(boolean dropDown, int state) {
        if ((this.style & 0x10) != 0) {
            this.selectRadio();
        } else if ((this.style & 0x20) != 0) {
            this.setSelection(!this.set);
        }
        Event event = new Event();
        if ((this.style & 4) != 0 && dropDown) {
            event.detail = 4;
            int[] nArray = new int[6];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            nArray[4] = OS.XmNheight;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            event.x = (short)argList[1];
            event.y = (short)argList[3] + (short)argList[5];
        }
        if (state != 0) {
            this.setInputState(event, state);
        }
        this.postEvent(13, event);
    }

    Point computeSize() {
        if ((this.style & 2) != 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int width = argList[1];
            int height = argList[3];
            return new Point(width, height);
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNmarginHeight;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNshadowThickness;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int marginHeight = argList[1];
        int marginWidth = argList[3];
        int shadowThickness = argList[5];
        if ((this.parent.style & 0x800000) != 0) {
            shadowThickness = Math.min(2, this.display.buttonShadowThickness);
        }
        int textWidth = 0;
        int textHeight = 0;
        if (this.text.length() != 0) {
            GC gc = new GC(this.parent);
            int flags = 14;
            Point textExtent = gc.textExtent(this.text, flags);
            textWidth = textExtent.x;
            textHeight = textExtent.y;
            gc.dispose();
        }
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            imageWidth = rect.width;
            imageHeight = rect.height;
        }
        int width = 0;
        int height = 0;
        if ((this.parent.style & 0x20000) != 0) {
            width = imageWidth + textWidth;
            height = Math.max(imageHeight, textHeight);
            if (imageWidth != 0 && textWidth != 0) {
                width += 2;
            }
        } else {
            height = imageHeight + textHeight;
            if (imageHeight != 0 && textHeight != 0) {
                height += 2;
            }
            width = Math.max(imageWidth, textWidth);
        }
        if ((this.style & 4) != 0) {
            width += 12;
        }
        width = width != 0 ? (width += (marginWidth + shadowThickness) * 2 + 2) : 24;
        height = height != 0 ? (height += (marginHeight + shadowThickness) * 2 + 2) : 22;
        return new Point(width, height);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.parent.relayout();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return new Rectangle((short)argList[1], (short)argList[3], argList[5], argList[7]);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.set;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNwidth;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    boolean hasCursor() {
        int xWindow;
        int[] unused = new int[1];
        int[] buffer = new int[1];
        int xDisplay = OS.XtDisplay(this.handle);
        int xParent = OS.XDefaultRootWindow(xDisplay);
        do {
            if (OS.XQueryPointer(xDisplay, xParent, unused, buffer, unused, unused, unused, unused, unused) == 0) {
                return false;
            }
            xWindow = buffer[0];
            if (xWindow == 0) continue;
            xParent = xWindow;
        } while (xWindow != 0);
        return this.handle == OS.XtWindowToWidget(xDisplay, xParent);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        int windowProc = this.display.windowProc;
        OS.XtAddEventHandler(this.handle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(this.handle, 2, false, windowProc, 7);
        OS.XtAddEventHandler(this.handle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(this.handle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(this.handle, 64, false, windowProc, 27);
        OS.XtAddEventHandler(this.handle, 16, false, windowProc, 4);
        OS.XtAddEventHandler(this.handle, 32, false, windowProc, 8);
        OS.XtAddCallback(this.handle, OS.XmNexposeCallback, windowProc, 32);
        OS.XtInsertEventHandler(this.handle, 0x200000, false, windowProc, 5, 1);
    }

    int hoverProc(int id) {
        boolean showTip = this.toolTipText != null;
        this.parent.hoverProc(id, !showTip);
        if (showTip) {
            this.display.showToolTip(this.handle, this.toolTipText);
        }
        return 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void manageChildren() {
        OS.XtManageChild(this.handle);
    }

    void redraw() {
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return;
        }
        int window = OS.XtWindow(this.handle);
        if (window == 0) {
            return;
        }
        OS.XClearArea(display, window, 0, 0, 0, 0, true);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        this.display.releaseToolTipHandle(this.handle);
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void setBackgroundPixel(int pixel) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNhighlightColor;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmChangeColor(this.handle, pixel);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setBounds(int x, int y, int width, int height) {
        if (this.control != null) {
            this.control.setBounds(x, y, width, height);
        }
        int newWidth = Math.max(width, 1);
        int newHeight = Math.max(height, 1);
        OS.XtConfigureWidget(this.handle, x, y, newWidth, newHeight, 0);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        this.control = control;
        if (control != null && !control.isDisposed()) {
            int topHandle1;
            int window1;
            control.setBounds(this.getBounds());
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            if (!OS.XtIsRealized(this.handle)) {
                Shell shell = this.parent.getShell();
                shell.realizeWidget();
            }
            if ((window1 = OS.XtWindow(topHandle1 = control.topHandle())) == 0) {
                return;
            }
            int topHandle2 = this.topHandle();
            int window2 = OS.XtWindow(topHandle2);
            if (window2 == 0) {
                return;
            }
            XWindowChanges struct = new XWindowChanges();
            struct.sibling = window2;
            struct.stack_mode = 0;
            int screen = OS.XDefaultScreen(xDisplay);
            int flags = 96;
            OS.XReconfigureWMWindow(xDisplay, window1, screen, flags, struct);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setForegroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        if (!this.getEnabled()) {
            this.redraw();
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        return this.XmProcessTraversal(this.handle, 0);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        Point size = this.computeSize();
        this.setSize(size.x, size.y, true);
        this.redraw();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if (selected == this.set) {
            return;
        }
        this.set = selected;
        this.setDrawPressed(this.set);
    }

    void setSize(int width, int height, boolean layout) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] != width || argList[3] != height) {
            OS.XtResizeWidget(this.handle, width, height, 0);
            if (layout) {
                this.parent.relayout();
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        Point size = this.computeSize();
        this.setSize(size.x, size.y, true);
        this.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.setSize(width, argList[1], true);
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(this.getBounds());
        }
    }

    void setDrawPressed(boolean value) {
        int shadowType = value ? 7 : 8;
        int[] argList = new int[]{OS.XmNshadowType, shadowType};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    boolean translateAccelerator(char key, int keysym, XKeyEvent xEvent, boolean doit) {
        return this.parent.translateAccelerator(key, keysym, xEvent, doit);
    }

    boolean translateMnemonic(char key, int keysym, XKeyEvent xEvent) {
        return this.parent.translateMnemonic(key, keysym, xEvent);
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        return this.parent.translateTraversal(key, xEvent);
    }

    void propagateWidget(boolean enabled) {
        this.propagateHandle(enabled, this.handle, 0);
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.hideToolTip();
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        if (xEvent.button == 1 && !this.set && (this.style & 0x10) == 0) {
            this.setDrawPressed(!this.set);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        xEvent.window = OS.XtWindow(this.parent.handle);
        xEvent.x += argList[1];
        xEvent.y += argList[3];
        OS.memmove(call_data, xEvent, 60);
        this.parent.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        return 0;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        int[] argList;
        this.display.hideToolTip();
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        if (xEvent.button == 1) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int width = argList[1];
            int height = argList[3];
            if (xEvent.x >= 0 && xEvent.x < width && xEvent.y >= 0 && xEvent.y < height) {
                this.click(xEvent.x > width - 12, xEvent.state);
            }
            this.setDrawPressed(this.set);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        xEvent.window = OS.XtWindow(this.parent.handle);
        xEvent.x += argList[1];
        xEvent.y += argList[3];
        OS.memmove(call_data, xEvent, 60);
        this.parent.XButtonRelease(w, client_data, call_data, continue_to_dispatch);
        return 0;
    }

    int XEnterWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 68);
        if ((xEvent.state & 0x100) != 0) {
            this.setDrawPressed(!this.set);
        } else if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        xEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XFocusChange(w, client_data, call_data, continue_to_dispatch);
        return 0;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = 0;
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        int[] keysym = new int[1];
        OS.XLookupString(xEvent, null, 0, keysym, null);
        keysym[0] = keysym[0] & 0xFFFF;
        switch (keysym[0]) {
            case 32: {
                this.click(false, xEvent.state);
                result = 1;
                break;
            }
            case 65364: {
                this.click(true, xEvent.state);
                result = 1;
            }
        }
        xEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XKeyPress(w, client_data, call_data, continue_to_dispatch);
        if (result == 1) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
        }
        return result;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        xEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
        return 0;
    }

    int XLeaveWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.removeMouseHoverTimeOut();
        this.display.hideToolTip();
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 68);
        if ((xEvent.state & 0x100) != 0) {
            this.setDrawPressed(this.set);
        } else if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
        return 0;
    }

    int XmNexposureCallback(int w, int client_data, int call_data) {
        if ((this.style & 2) != 0) {
            return 0;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return 0;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return 0;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNcolormap;
        nArray[2] = OS.XmNwidth;
        nArray[4] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int width = argList[3];
        int height = argList[5];
        Image currentImage = this.image;
        boolean enabled = this.getEnabled();
        if ((this.parent.style & 0x800000) != 0) {
            boolean hasCursor = this.hasCursor();
            int thickness = 0;
            if (this.set || hasCursor && enabled) {
                thickness = Math.min(2, this.display.buttonShadowThickness);
            }
            argList = new int[]{OS.XmNshadowThickness, thickness};
            OS.XtSetValues(this.handle, argList, argList.length / 2);
            if (enabled && hasCursor && this.hotImage != null) {
                currentImage = this.hotImage;
            }
        }
        GCData data = new GCData();
        data.device = this.display;
        data.display = xDisplay;
        data.drawable = xWindow;
        data.font = this.parent.font;
        data.colormap = argList[1];
        int xGC = OS.XCreateGC(xDisplay, xWindow, 0, null);
        if (xGC == 0) {
            SWT.error(2);
        }
        GC gc = GC.motif_new(xGC, data);
        XmAnyCallbackStruct cb = new XmAnyCallbackStruct();
        OS.memmove(cb, call_data, 8);
        if (cb.event != 0) {
            XExposeEvent xEvent = new XExposeEvent();
            OS.memmove(xEvent, cb.event, 40);
            Rectangle rect = new Rectangle(xEvent.x, xEvent.y, xEvent.width, xEvent.height);
            gc.setClipping(rect);
        }
        if (!enabled) {
            currentImage = this.disabledImage;
            if (currentImage == null && this.image != null) {
                currentImage = new Image((Device)this.display, this.image, 1);
            }
            Color disabledColor = this.display.getSystemColor(18);
            gc.setForeground(disabledColor);
        } else {
            gc.setForeground(this.parent.getForeground());
        }
        gc.setBackground(this.parent.getBackground());
        int textX = 0;
        int textY = 0;
        int textWidth = 0;
        int textHeight = 0;
        if (this.text.length() != 0) {
            int flags = 14;
            Point textExtent = gc.textExtent(this.text, flags);
            textWidth = textExtent.x;
            textHeight = textExtent.y;
        }
        int imageX = 0;
        int imageY = 0;
        int imageWidth = 0;
        int imageHeight = 0;
        if (currentImage != null) {
            Rectangle imageBounds = currentImage.getBounds();
            imageWidth = imageBounds.width;
            imageHeight = imageBounds.height;
        }
        int spacing = 0;
        if (textWidth != 0 && imageWidth != 0) {
            spacing = 2;
        }
        if ((this.parent.style & 0x20000) != 0) {
            imageX = (width - imageWidth - textWidth - spacing) / 2;
            imageY = (height - imageHeight) / 2;
            textX = spacing + imageX + imageWidth;
            textY = (height - textHeight) / 2;
        } else {
            imageX = (width - imageWidth) / 2;
            imageY = (height - imageHeight - textHeight - spacing) / 2;
            textX = (width - textWidth) / 2;
            textY = spacing + imageY + imageHeight;
        }
        if ((this.style & 4) != 0) {
            textX -= 6;
            imageX -= 6;
        }
        if (textWidth > 0) {
            int flags = 14;
            gc.drawText(this.text, textX, textY, flags);
        }
        if (imageWidth > 0) {
            gc.drawImage(currentImage, imageX, imageY);
        }
        if ((this.style & 4) != 0) {
            int startX = width - 12;
            int startY = (height - 2) / 2;
            int[] arrow = new int[]{startX, startY, startX + 3, startY + 3, startX + 6, startY};
            gc.setBackground(this.parent.getForeground());
            gc.fillPolygon(arrow);
            gc.drawPolygon(arrow);
        }
        gc.dispose();
        OS.XFreeGC(xDisplay, xGC);
        if (!enabled && this.disabledImage == null && currentImage != null) {
            currentImage.dispose();
        }
        return 0;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.addMouseHoverTimeOut(this.handle);
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        xEvent.window = OS.XtWindow(this.parent.handle);
        xEvent.x += argList[1];
        xEvent.y += argList[3];
        this.parent.sendMouseEvent(5, xEvent);
        return 0;
    }
}

