/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, gdkGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int gdkGC = drawable.internal_new_GC(data);
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        int gdkGC = OS.gdk_gc_new((int)image.pixmap);
        if (gdkGC == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow((int)gdkGC, (int)1);
        OS.gdk_draw_drawable((int)image.pixmap, (int)gdkGC, (int)this.data.drawable, (int)x, (int)y, (int)0, (int)0, (int)rect.width, (int)rect.height);
        OS.g_object_unref((int)gdkGC);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int drawable = this.data.drawable;
        OS.gdk_gc_set_exposures((int)this.handle, (boolean)true);
        OS.gdk_draw_drawable((int)drawable, (int)this.handle, (int)drawable, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)width, (int)height);
        OS.gdk_gc_set_exposures((int)this.handle, (boolean)false);
        if (this.data.image != null) {
            return;
        }
        boolean disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
        GdkRectangle rect = new GdkRectangle();
        if (disjoint) {
            rect.x = srcX;
            rect.y = srcY;
            rect.width = width;
            rect.height = height;
            OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
        } else {
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                rect.x = newX;
                rect.y = srcY;
                rect.width = Math.abs(deltaX);
                rect.height = height;
                OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                rect.x = srcX;
                rect.y = newY;
                rect.width = width;
                rect.height = Math.abs(deltaY);
                OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
            }
        }
    }

    public void dispose() {
        int layout;
        int context;
        Image image;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.gdk_region_destroy((int)clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((context = this.data.context) != 0) {
            OS.g_object_unref((int)context);
        }
        if ((layout = this.data.layout) != 0) {
            OS.g_object_unref((int)layout);
        }
        Device device = this.data.device;
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.data.clipRgn = 0;
        this.data.drawable = 0;
        this.data.context = 0;
        this.data.layout = 0;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.string = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height, (int)(startAngle * 64), (int)(arcAngle * 64));
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkColor color = new GdkColor();
        OS.gtk_style_get_fg((int)OS.gtk_widget_get_default_style(), (int)0, (GdkColor)color);
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_rectangle((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)(width - 1), (int)(height - 1));
        color.pixel = values.foreground_pixel;
        color.red = values.foreground_red;
        color.green = values.foreground_green;
        color.blue = values.foreground_blue;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gdk_drawable_get_size((int)srcImage.pixmap, (int[])width, (int[])height);
        int imgWidth = width[0];
        int imgHeight = height[0];
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.gdk_draw_drawable((int)this.data.drawable, (int)this.handle, (int)srcImage.pixmap, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)destWidth, (int)destHeight);
        } else {
            int pixbuf = this.scale(srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destWidth, destHeight);
            if (pixbuf != 0) {
                OS.gdk_pixbuf_render_to_drawable((int)pixbuf, (int)this.data.drawable, (int)this.handle, (int)0, (int)0, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (int)1, (int)0, (int)0);
                OS.g_object_unref((int)pixbuf);
            }
        }
    }

    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)true, (int)8, (int)srcWidth, (int)srcHeight);
        if (pixbuf == 0) {
            return;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)srcImage.pixmap, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
        int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
        byte[] line = new byte[stride];
        byte alpha = (byte)srcImage.alpha;
        byte[] alphaData = srcImage.alphaData;
        int y = 0;
        while (y < srcHeight) {
            int alphaIndex = (y + srcY) * imgWidth + srcX;
            OS.memmove((byte[])line, (int)(pixels + y * stride), (int)stride);
            int x = 3;
            while (x < stride) {
                line[x] = alphaData == null ? alpha : alphaData[alphaIndex++];
                x += 4;
            }
            OS.memmove((int)(pixels + y * stride), (byte[])line, (int)stride);
            ++y;
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
            OS.g_object_unref((int)pixbuf);
            if (scaledPixbuf == 0) {
                return;
            }
            pixbuf = scaledPixbuf;
        }
        OS.gdk_pixbuf_render_to_drawable_alpha((int)pixbuf, (int)this.data.drawable, (int)0, (int)0, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (int)0, (int)128, (int)1, (int)0, (int)0);
        OS.g_object_unref((int)pixbuf);
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int newHeight;
        int newWidth;
        int bytesPerLine;
        byte[] maskData;
        int mask;
        int drawable = this.data.drawable;
        int colorPixmap = srcImage.pixmap;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        int maskPixmap = srcImage.mask;
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)true, (int)8, (int)srcWidth, (int)srcHeight);
            if (pixbuf != 0) {
                int colormap = OS.gdk_colormap_get_system();
                OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)colorPixmap, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
                int gdkImagePtr = OS.gdk_drawable_get_image((int)maskPixmap, (int)0, (int)0, (int)imgWidth, (int)imgHeight);
                if (gdkImagePtr != 0) {
                    int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
                    int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < srcHeight) {
                        int offset = pixels + y * stride;
                        OS.memmove((byte[])line, (int)offset, (int)stride);
                        int x = 0;
                        while (x < srcWidth) {
                            if (OS.gdk_image_get_pixel((int)gdkImagePtr, (int)(x + srcX), (int)(y + srcY)) == 0) {
                                line[x * 4 + 3] = 0;
                            }
                            ++x;
                        }
                        OS.memmove((int)offset, (byte[])line, (int)stride);
                        ++y;
                    }
                    OS.g_object_unref((int)gdkImagePtr);
                    int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
                    if (scaledPixbuf != 0) {
                        int[] colorBuffer = new int[1];
                        int[] maskBuffer = new int[1];
                        OS.gdk_pixbuf_render_pixmap_and_mask((int)scaledPixbuf, (int[])colorBuffer, (int[])maskBuffer, (int)128);
                        colorPixmap = colorBuffer[0];
                        maskPixmap = maskBuffer[0];
                        OS.g_object_unref((int)scaledPixbuf);
                    }
                }
                OS.g_object_unref((int)pixbuf);
            }
            srcX = 0;
            srcY = 0;
            srcWidth = destWidth;
            srcHeight = destHeight;
        }
        if (this.data.clipRgn != 0 && (mask = OS.gdk_bitmap_create_from_data((int)0, (byte[])(maskData = new byte[(bytesPerLine = ((newWidth = srcX + srcWidth) + 7) / 8) * (newHeight = srcY + srcHeight)]), (int)newWidth, (int)newHeight)) != 0) {
            int gc = OS.gdk_gc_new((int)mask);
            OS.gdk_region_offset((int)this.data.clipRgn, (int)(-destX + srcX), (int)(-destY + srcY));
            OS.gdk_gc_set_clip_region((int)gc, (int)this.data.clipRgn);
            OS.gdk_region_offset((int)this.data.clipRgn, (int)(destX - srcX), (int)(destY - srcY));
            GdkColor color = new GdkColor();
            color.pixel = 1;
            OS.gdk_gc_set_foreground((int)gc, (GdkColor)color);
            OS.gdk_draw_rectangle((int)mask, (int)gc, (int)1, (int)0, (int)0, (int)newWidth, (int)newHeight);
            OS.gdk_gc_set_function((int)gc, (int)4);
            OS.gdk_draw_drawable((int)mask, (int)gc, (int)maskPixmap, (int)0, (int)0, (int)0, (int)0, (int)newWidth, (int)newHeight);
            OS.g_object_unref((int)gc);
            if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
                OS.g_object_unref((int)maskPixmap);
            }
            maskPixmap = mask;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        OS.gdk_gc_set_clip_mask((int)this.handle, (int)maskPixmap);
        OS.gdk_gc_set_clip_origin((int)this.handle, (int)(destX - srcX), (int)(destY - srcY));
        OS.gdk_draw_drawable((int)drawable, (int)this.handle, (int)colorPixmap, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)srcWidth, (int)srcHeight);
        OS.gdk_gc_set_values((int)this.handle, (GdkGCValues)values, (int)6272);
        if (this.data.clipRgn != 0) {
            OS.gdk_gc_set_clip_region((int)this.handle, (int)this.data.clipRgn);
        }
        if (colorPixmap != 0 && srcImage.pixmap != colorPixmap) {
            OS.g_object_unref((int)colorPixmap);
        }
        if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
            OS.g_object_unref((int)maskPixmap);
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    int scale(int src, int srcX, int srcY, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)false, (int)8, (int)srcWidth, (int)srcHeight);
        if (pixbuf == 0) {
            return 0;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)src, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
        int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
        OS.g_object_unref((int)pixbuf);
        return scaledPixbuf;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.gdk_draw_line((int)this.data.drawable, (int)this.handle, (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height, (int)0, (int)23040);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.gdk_draw_point((int)this.data.drawable, (int)this.handle, (int)x, (int)y);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.gdk_draw_polygon((int)this.data.drawable, (int)this.handle, (int)0, (int[])pointArray, (int)(pointArray.length / 2));
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.gdk_draw_lines((int)this.data.drawable, (int)this.handle, (int[])pointArray, (int)(pointArray.length / 2));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.gdk_draw_rectangle((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)naw, (int)nah, (int)5760, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)ny, (int)(nx + nw - naw2), (int)ny);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nah, (int)0, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + nw), (int)(ny + nah2), (int)(nx + nw), (int)(ny + nh - nah2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)(ny + nh - nah), (int)naw, (int)nah, (int)17280, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)(ny + nh), (int)(nx + nw - naw2), (int)(ny + nh));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)(ny + nh - nah), (int)naw, (int)nah, (int)11520, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)nx, (int)(ny + nah2), (int)nx, (int)(ny + nh - nah2));
            } else {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)naw, (int)nh, (int)5760, (int)11520);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)ny, (int)(nx + nw - naw2), (int)ny);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nh, (int)17280, (int)11520);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)(ny + nh), (int)(nx + nw - naw2), (int)(ny + nh));
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)nw, (int)nah, (int)0, (int)11520);
            OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + nw), (int)(ny + nah2), (int)(nx + nw), (int)(ny + nh - nah2));
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)(ny + nh - nah), (int)nw, (int)nah, (int)11520, (int)11520);
            OS.gdk_draw_line((int)drawable, (int)this.handle, (int)nx, (int)(ny + nah2), (int)nx, (int)(ny + nh - nah2));
        } else {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)nw, (int)nh, (int)0, (int)23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        this.setString(string, flags);
        GdkColor background = null;
        GdkGCValues values = null;
        if ((flags & 1) == 0) {
            values = new GdkGCValues();
            OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
            background = new GdkColor();
            background.pixel = values.background_pixel;
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)background.pixel, (GdkColor)background);
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors((int)this.data.drawable, (int)this.handle, (int)x, (int)y, (int)this.data.layout, null, (GdkColor)background);
        } else {
            int gdkGC;
            int layout = this.data.layout;
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            int width = OS.PANGO_PIXELS((int)w[0]);
            int height = OS.PANGO_PIXELS((int)h[0]);
            int pixmap = OS.gdk_pixmap_new((int)OS.GDK_ROOT_PARENT(), (int)width, (int)height, (int)-1);
            if (pixmap == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new((int)pixmap)) == 0) {
                SWT.error(2);
            }
            GdkColor foreground = new GdkColor();
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
            OS.gdk_draw_rectangle((int)pixmap, (int)gdkGC, (int)1, (int)0, (int)0, (int)width, (int)height);
            if (values == null) {
                values = new GdkGCValues();
                OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
            }
            foreground.pixel = values.foreground_pixel;
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
            OS.gdk_draw_layout_with_colors((int)pixmap, (int)gdkGC, (int)0, (int)0, (int)layout, null, (GdkColor)background);
            OS.g_object_unref((int)gdkGC);
            OS.gdk_draw_drawable((int)this.data.drawable, (int)this.handle, (int)pixmap, (int)0, (int)0, (int)x, (int)y, (int)width, (int)height);
            OS.g_object_unref((int)pixmap);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height, (int)(startAngle * 64), (int)(arcAngle * 64));
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height, (int)0, (int)23040);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_polygon((int)this.data.drawable, (int)this.handle, (int)1, (int[])pointArray, (int)(pointArray.length / 2));
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_rectangle((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)naw, (int)nah, (int)5760, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + naw2), (int)ny, (int)(nw - naw2 * 2), (int)nh);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nah, (int)0, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nah2), (int)naw2, (int)(nh - nah2 * 2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)(ny + nh - nah), (int)naw, (int)nah, (int)17280, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw2), (int)(ny + nah2), (int)naw2, (int)(nh - nah2 * 2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nh - nah), (int)naw, (int)nah, (int)11520, (int)5760);
            } else {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)naw, (int)nh, (int)5760, (int)11520);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + naw2), (int)ny, (int)(nw - naw2 * 2), (int)nh);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nh, (int)17280, (int)11520);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)nw, (int)nah, (int)0, (int)11520);
            OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nah2), (int)nw, (int)(nh - nah2 * 2));
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nh - nah), (int)nw, (int)nah, (int)11520, (int)11520);
        } else {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)nw, (int)nh, (int)0, (int)23040);
        }
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        int mnemonic = -1;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == -1) {
                mnemonic = j;
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        return Color.gtk_new(this.data.device, color);
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        int clipRgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((clipRgn = this.data.clipRgn) == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            OS.gdk_drawable_get_size((int)this.data.drawable, (int[])width, (int[])height);
            return new Rectangle(0, 0, width[0], height[0]);
        }
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_region_get_clipbox((int)clipRgn, (GdkRectangle)rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        int hRegion = region.handle;
        int clipRgn = this.data.clipRgn;
        OS.gdk_region_subtract((int)hRegion, (int)hRegion);
        if (this.data.clipRgn == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            OS.gdk_drawable_get_size((int)this.data.drawable, (int[])width, (int[])height);
            GdkRectangle rect = new GdkRectangle();
            rect.x = 0;
            rect.y = 0;
            rect.width = width[0];
            rect.height = height[0];
            OS.gdk_region_union_with_rect((int)hRegion, (GdkRectangle)rect);
        } else {
            OS.gdk_region_union((int)hRegion, (int)clipRgn);
        }
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.gtk_new(this.data.device, this.data.font);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int context = this.data.context;
        int lang = OS.pango_context_get_language((int)context);
        int metrics = OS.pango_context_get_metrics((int)context, (int)this.data.font, (int)lang);
        FontMetrics fm = new FontMetrics();
        fm.ascent = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_ascent((int)metrics));
        fm.descent = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_descent((int)metrics));
        fm.averageCharWidth = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_approximate_char_width((int)metrics));
        fm.height = fm.ascent + fm.descent;
        OS.pango_font_metrics_unref((int)metrics);
        return fm;
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.foreground_pixel;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        return Color.gtk_new(this.data.device, color);
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        return values.line_width;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        return values.function == 2;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int gdkGC) {
        Image image;
        int font;
        GdkColor background;
        int context = OS.gdk_pango_context_get();
        if (context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language((int)context, (int)OS.gtk_get_default_language());
        OS.gdk_pango_context_set_colormap((int)context, (int)OS.gdk_colormap_get_system());
        data.context = context;
        int layout = OS.pango_layout_new((int)context);
        if (layout == 0) {
            SWT.error(2);
        }
        data.layout = layout;
        GdkColor foreground = data.foreground;
        if (foreground != null) {
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
        }
        if ((background = data.background) != null) {
            OS.gdk_gc_set_background((int)gdkGC, (GdkColor)background);
        }
        if ((font = data.font) != 0) {
            OS.pango_layout_set_font_description((int)layout, (int)font);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = gdkGC;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_background((int)this.handle, (GdkColor)color.handle);
    }

    public void setClipping(int x, int y, int width, int height) {
        int clipRgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((clipRgn = this.data.clipRgn) == 0) {
            this.data.clipRgn = clipRgn = OS.gdk_region_new();
        } else {
            OS.gdk_region_subtract((int)clipRgn, (int)clipRgn);
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.gdk_gc_set_clip_rectangle((int)this.handle, (GdkRectangle)rect);
        OS.gdk_region_union_with_rect((int)clipRgn, (GdkRectangle)rect);
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int clipRgn = this.data.clipRgn;
        if (rect == null) {
            OS.gdk_gc_set_clip_region((int)this.handle, (int)0);
            if (clipRgn != 0) {
                OS.gdk_region_destroy((int)clipRgn);
                clipRgn = 0;
                this.data.clipRgn = 0;
            }
            return;
        }
        this.setClipping(rect.x, rect.y, rect.width, rect.height);
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int clipRgn = this.data.clipRgn;
        if (region == null) {
            OS.gdk_gc_set_clip_region((int)this.handle, (int)0);
            if (clipRgn != 0) {
                OS.gdk_region_destroy((int)clipRgn);
                clipRgn = 0;
                this.data.clipRgn = 0;
            }
        } else {
            if (clipRgn == 0) {
                this.data.clipRgn = clipRgn = OS.gdk_region_new();
            } else {
                OS.gdk_region_subtract((int)clipRgn, (int)clipRgn);
            }
            OS.gdk_region_union((int)clipRgn, (int)region.handle);
            OS.gdk_gc_set_clip_region((int)this.handle, (int)clipRgn);
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int fontHandle = this.data.font = font.handle;
        OS.pango_layout_set_font_description((int)this.data.layout, (int)fontHandle);
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color.handle);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int line_style = 1;
        switch (lineStyle) {
            case 1: {
                line_style = 0;
                break;
            }
            case 2: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{6, 2}, (int)2);
                break;
            }
            case 3: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{3, 1}, (int)2);
                break;
            }
            case 4: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{6, 2, 3, 1}, (int)4);
                break;
            }
            case 5: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{6, 2, 3, 1, 3, 1}, (int)6);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)values.line_width, (int)line_style, (int)2, (int)0);
    }

    public void setLineWidth(int width) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)width, (int)line_style, (int)2, (int)0);
    }

    void setString(String string, int flags) {
        byte[] buffer;
        int mnemonic;
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int length = string.length();
        int layout = this.data.layout;
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        if ((flags & 8) != 0 && (mnemonic = this.fixMnemonic(text)) != -1) {
            char[] text1 = new char[mnemonic - 1];
            System.arraycopy(text, 0, text1, 0, text1.length);
            byte[] buffer1 = Converter.wcsToMbcs(null, text1, false);
            char[] text2 = new char[text.length - mnemonic];
            System.arraycopy(text, mnemonic - 1, text2, 0, text2.length);
            byte[] buffer2 = Converter.wcsToMbcs(null, text2, false);
            buffer = new byte[buffer1.length + buffer2.length];
            System.arraycopy(buffer1, 0, buffer, 0, buffer1.length);
            System.arraycopy(buffer2, 0, buffer, buffer1.length, buffer2.length);
            int attr_list = OS.pango_attr_list_new();
            int attr = OS.pango_attr_underline_new((int)3);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
            attribute.start_index = buffer1.length;
            attribute.end_index = buffer1.length + 1;
            OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
            OS.pango_attr_list_insert((int)attr_list, (int)attr);
            OS.pango_layout_set_attributes((int)layout, (int)attr_list);
            OS.pango_attr_list_unref((int)attr_list);
        } else {
            buffer = Converter.wcsToMbcs(null, text, false);
            OS.pango_layout_set_attributes((int)layout, (int)0);
        }
        OS.pango_layout_set_text((int)layout, (byte[])buffer, (int)buffer.length);
        OS.pango_layout_set_single_paragraph_mode((int)layout, ((flags & 2) == 0 ? 1 : 0) != 0);
        OS.pango_layout_set_tabs((int)layout, (int)((flags & 4) != 0 ? 0 : this.data.device.emptyTab));
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.gdk_gc_set_function((int)this.handle, (int)(xor ? 2 : 0));
        this.data.xorMode = xor;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size((int)this.data.layout, (int[])width, (int[])height);
        this.data.stringWidth = OS.PANGO_PIXELS((int)width[0]);
        this.data.stringHeight = OS.PANGO_PIXELS((int)height[0]);
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

