package Lambda;

import java.util.LinkedList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class Atom implements Expression {
	
	private String atom = new String();
	private Term parent;
	
	public Atom(String newAtom, Term newParent)
	{
		atom = newAtom;
		parent = newParent;
	}
	
	public String toString()
	{
		return atom;
	}
	
	public Term getParent()
	{
		return parent;
	}
	
	public void toComposite(Composite composite)
	{
		Label lblAtom = new Label(composite, SWT.NONE);
		lblAtom.setText(atom);
		lblAtom.setData(this);
		
		lblAtom.addMouseTrackListener(new org.eclipse.swt.events.MouseTrackAdapter() 
				{   			
					public void mouseEnter(org.eclipse.swt.events.MouseEvent e) 
					{    
						Atom myAtom = (Atom) ((Label) e.widget).getData();
						Label varLabel = (Label) e.widget;
						
						if (varLabel != null)
						{
							varLabel.setToolTipText(myAtom.getToolTip());
								
					}
					}
				});
		
		composite.pack();
	}

	public Expression replaceExp(String oldAtom, Expression newExp)
	{
		if (atom.compareTo(oldAtom) == 0)
		{
			//newExp.setParent(parent);
			//NEUE ISTANZ
			return newExp.getCopy(parent);	//Atom wird durch Term ersetzt
		}
		else
		{
			return this;	//Atom ndert sich nicht
		}
	}
	
	public LinkedList getVarList()
	{
		return (new LinkedList());
	}
	
	public LinkedList getTermList()
	{
		LinkedList myList = new LinkedList();
		myList.add(this);
		return myList;
	}
	
	public LinkedList getArgList()
	{
		return (new LinkedList());
	}

	public int countVar()
	{
		return 0;
	}
	
	public int countTerm()
	{
		return 1;
	}
	
	public int countArg()
	{
		return 0;
	}

	public String removeVar(int i)
	{
		return "";
	}
	
	public Expression removeTerm(int i)
	{
		return (new Term(null));
	}
	
	public Expression removeArg(int i)
	{
		return (new Term(null));
	}
	
	public String getVar(int i)
	{
		return "";
	}
	
	public Expression getTerm(int i)
	{
		return (new Term(null));
	}
	
	public Expression getArg(int i)
	{
		return (new Term(null));
	}
	
	public void setParent(Term newParent)
	{
		parent = newParent;
	}
	
	public Expression getCopy(Term newParent)
	{
		return new Atom(atom,newParent);
	}
	
	public int getPosition()
	{
		int i = 0;
		while ((i < parent.countTerm()) && (parent.getTerm(i) != this))
		{
			i++;
		}
		
		if (i == parent.countTerm())
		{
			//Expression wurde nicht gefunden
			return -1;
		}
		else
		{
			//Expression wurde gefunden -> Position wird zurck gegeben
			return i;
		}
	}
	
	public String getToolTip()
	{
		String myString = "Atom: "+this.toString()+
			  		      "\nParent-Term: "+this.getParent().toString()+
						  "\nPosition: "+(this.getPosition()+1);
		
		return myString;
	}
}
