package Lambda;

import org.eclipse.swt.widgets.Composite;

public interface Expression {
	
	//Wandelt eine Expression in einen String um
	public String toString();
	
	//Wandelt eine Expression in eine Menge von klickbaren Labels
	public void toComposite(Composite composite);
	
	//Gibt den Eltern-Term eines Terms zurck
	public Term getParent();
	
	//Setzt den Eltern-Term neu
	public void setParent(Term newParent);	
	
	//Ersetzt jedes freie (!) Vorkommen einer Variable durch eine Expression
	public Expression replaceExp(String oldAtom, Expression newExp);
	
	//Gibt die Anzahl der Variablen des aktuellen Terms zurck
	public int countVar();
	
	//Gibt die Anzahl der Terme des aktuellen Terms zurck
	public int countTerm();
	
	//Gibt die Anzahl der Argumente des aktuellen Terms zurck
	public int countArg();
	
	//Lscht die i-te Variable
	public String removeVar(int i);
	
	//Lscht den i-ten Term
	public Expression removeTerm(int i);
	
	//Lscht das i-te Argument
	public Expression removeArg(int i);
	
	//Gibt die i-te Variable zurck
	public String getVar(int i);
	
	//Gibt den i-ten Term zurck
	public Expression getTerm(int i);
	
	//Gibt das i-te Argument zurck
	public Expression getArg(int i);
	
	//Erzeugt eine komplette Speicherkopie des Terms
	public Expression getCopy(Term newParent);
	
	//Gibt die Position der aktuellen Expression in seinem Elternterm zurck
	public int getPosition();
	
	//Gibt einen String zurck, der angezeigt wird wenn man mit der Maus ber das Objekt fhrt
	public String getToolTip();
}
