
package Lambda;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class Library {
	
	private LinkedList lib = new LinkedList();

	public Library() 
	{	//Constructor
		lib.clear();
	}
	
	public void loadFromFile(String filename)
	{
	    File inputFile;  
	    FileReader fr; 
	    BufferedReader br; 
	    String line;
	    Pattern p = Pattern.compile( "[|]" );
	    String newFunction[];
	    String newName = new String();
	    
	    try { 
	    	inputFile = new File(filename); 
	        fr = new FileReader(inputFile); 
	        br = new BufferedReader(fr); 
	        line = br.readLine(); 
	        
	        while ( line != null ) { 
	          
	        	newFunction = p.split(line);
	        	
	        	//TODO fehlerbehandlung

	        	addFunction(new Function(newFunction[0],Integer.parseInt(newFunction[1]),newFunction[2],newFunction[3]));
	        	line = br.readLine(); 
	        }
	        
	        br.close(); 
	      } 
	      catch (ArrayIndexOutOfBoundsException aioobe) { 
	        System.out.println("Aufruf mit"); 
	        System.out.println(" java j2h name"); 
	        System.out.println("erzeugt aus einer Datei name.java"); 
	        System.out.println("eine Datei name.html"); 
	      } 
	      catch (FileNotFoundException fnfe) { 
	        System.out.println("Habe gefangen: "+fnfe); 
	      } 
	      catch (IOException ioe) { 
	        System.out.println("Habe gefangen: "+ioe); 
	      } 
	    
	}
	
	public void saveToFile(String filename)
	{
		File outputFile; 
		FileWriter fw; 
		BufferedWriter bw; 
		String newline = System.getProperty("line.separator"); 
		
		try { 
		      outputFile = new File(filename); 
		      fw = new FileWriter(outputFile); 
		      bw = new BufferedWriter(fw); 

		      for (int i=0; i < countFunction(); i++)
		      {
		      		bw.write(getFunction(i).getName()+"|"+
		      				 getFunction(i).countArgs()+"|"+
		      				 getFunction(i).getLambdaExp()+"|"+
		      				 getFunction(i).getDescription()+"|"+
							 newline) ;
		      }

		      bw.close(); 
		    } 
		    catch (ArrayIndexOutOfBoundsException aioobe) { 
		      System.out.println("Array Error!"); 
		    } 
		    catch (FileNotFoundException fnfe) { 
		      System.out.println("Catch Error: "+fnfe); 
		    } 
		    catch (IOException ioe) { 
		      System.out.println("Catch Error: "+ioe); 
		    } 
	}
	
	public void addFunction(Function newFunction)
	{
		lib.add(newFunction);
	}
	
	public void removeFunction(int i)
	{
		lib.remove(i);
	}
	
	public Function getFunction(int i)
	{
		return (Function) lib.get(i);
	}
	
	public int countFunction()
	{
		return lib.size();
	}

}
