package Lambda;

public class Parser {
	
	private static int LastError = 0;
	
	//liefert den zuletzt erzeugten Fehlercode
	public static int getLastError()
	{
		return LastError;
	}
	
	/* Der bergebene String wird analysiert und an den ebenfalls bergebenen Term angehngt
	 * Rckgabewert ist der Gesamte Term (inkl. bergebene)
	 * Rckgabewert null bei Fehler -> Fehlernummer in LastError  
	 */
	private static Term NewTerm(String sTerm,Term parentTerm) 
	{
		Term result, innerTerm;
		result = new Term(parentTerm);
		char cTerm[];
		int state=1,i,l=0,posTermStart=0,posTermEnd=0;
		String var="";
		
		cTerm = sTerm.toCharArray(); 
		
		for (i = 0 ; i < cTerm.length ; i++ )
		{
			
			switch(state)
			{
				case 1:
					if (cTerm[i] == '\\')
					{
						state = 2;
					}
					else
					{
						if (cTerm[i] == '(')
						{
							l = CheckParenthesis(cTerm,i);
							if (l == -1)
							{
								LastError = 3;
								return null;
							}
							else
							{
								posTermStart =i+1;
								i += l+1;
								posTermEnd = i;
								state = 1;
								innerTerm = NewTerm(sTerm.substring(posTermStart,posTermEnd),result); //Lars Edit
								if ( innerTerm != null)
								{
									result.addTerm(innerTerm);
									state = 3;
								}
								else
								{
									return null;
								}
							}									
						}
						else
						{
								if (cTerm[i] == '#')
								{
									LastError = 8;
									return null;	
								}
								else
								{
									if (cTerm[i] != ' ')
									{
										var += cTerm[i];
										if (i + 1 == cTerm.length)
										{
											result.addTerm(new Atom(var, result));
											var = "";
										}
										else
										{
											state = 4;
										}
									}
								}
						}
					}
					break;
				case 2:
					if (cTerm[i] != '.' && cTerm[i] != ' ' && cTerm[i] != '\\' && cTerm[i] != '(' && cTerm[i] != ')')
					{
						var += cTerm[i];
					}
					else
					{
						if (cTerm[i] == ' ' || cTerm[i] == '.')
						{
							result.addVar(var);
							var = "";
							state = 1;
						}
						else
						{
							LastError = 6;
							return null;
						}
					}
					break;
				case 3:
					if (cTerm[i] == ' ')
					{
						state = 1;
					}
					else
					{
						LastError = 7;
						return null;
		
					}
					break;
				case 4:
					if (cTerm[i] != ' ' && cTerm[i] != '\\'  && cTerm[i] != '.' && cTerm[i] != '(' && cTerm[i] != ')')
					{
						var += cTerm[i];
						if (i + 1 == cTerm.length)
						{
							result.addTerm(new Atom(var, result));
							var = "";
						}
					}
					else
					{
						if (cTerm[i] == ' ')
						{
							result.addTerm(new Atom(var, result)); 
							var = "";
							state = 1;
						}
						else
						{
							LastError = 7;
							return null;
						}
					}
					break;
			}			
		}
		
		return result;
	}

	/*Der bergebene String wird analysiert und als Argumentenliste an den 
	 * ebenfalls bergebenen Term angehnt
	 * Rckgabewert ist bei erfolgreicher Ausfhrung 0, sonst -1
	 */
	private static int AddArg(Term oTerm,String sArgs)
	{
		Term pTerm;
		char cArgs[] = sArgs.toCharArray(); 
		int state=1,i,l=0,posTermStart=0,posTermEnd=0;
		String var = "";
			
		for(i = 0; i < cArgs.length; i++)
		{
			switch (state)
			{
				case 1:
					if (cArgs[i] != ' ' && cArgs[i] != '(' && cArgs[i] != ')' && cArgs[i] != '.' && cArgs[i] != '\\' && cArgs[i] != '#')
					{
						var += cArgs[i];
						if (i + 1 == cArgs.length)
						{
							oTerm.addArg(new Atom(var,oTerm));  
							var = "";
						}
						else
						{
							state = 2;
						}
					}
					else
					{
						if (cArgs[i] == '(')
						{
							l = CheckParenthesis(cArgs,i);
							if (l == -1)
							{
								LastError = 9;
								return -1;
							}
							else
							{
								posTermStart =i+1;
								i += l+1;
								posTermEnd = i;
								state = 1;
								pTerm = NewTerm(sArgs.substring(posTermStart,posTermEnd),oTerm);
								if ( pTerm != null)
								{
									oTerm.addArg(pTerm);
								}
								else
								{
									return -1;
								}
							}
						}
						else
						{
							if (cArgs[i] == '#')
							{
								LastError = 8;
								return -1;
							}
							else
							{
								if (cArgs[i] != ' ')
								{
									LastError = 10;
									return -1;
								}
							}	
						}
					}
					break;
				case 2:
					if (cArgs[i] != ' ' && cArgs[i] != '(' && cArgs[i] != ')' && cArgs[i] != '.' && cArgs[i] != '\\' && cArgs[i] != '#')
					{
						var += cArgs[i];
						if (i + 1 == cArgs.length)
						{
							oTerm.addArg(new Atom(var,oTerm));  
							var = "";
						}
					}
					else
					{
						if (cArgs[i] == ' ')
						{
							oTerm.addArg(new Atom(var,oTerm)); 
							var = "";
							state = 1;
						}
						else
						{
							if (cArgs[i] == '#')
							{
								LastError = 8;
								return -1;
							}
							else
							{
								LastError = 10;
								return -1;
							}
						}
					}
					break;
			}
		}
		return 0;
	}
	/*Erwartet Chararray sowie einen Integerwert, der die aktuelle Position im Array angibt
	 *liefert deie Anzahl der Zeichen bis zur nchsten ungebundenen Klammer 
	 *(zugehrige schlieende Klammer zur ffnenden Klammer an der aktuellen Position)  
	 */
	private static int CheckParenthesis(char toCheck[], int aktPos)
	{
		int i,state = 0, cntParenthesis = 0;
		
		
		for(i = aktPos; i < toCheck.length ; i++)
		{
			switch(state)
			{
				case 0:
					if (toCheck[i] == '(')
					{
						state = 1;
						cntParenthesis++;
					}
					else
					{
						return -1;
					}
					break;
				case 1:
					if (toCheck[i] == '(')
					{
						cntParenthesis++;
					}
					else if (toCheck[i] == ')')
					{
						cntParenthesis--;
						if (cntParenthesis == 0)
						{
							return i - aktPos - 1;
						}
					}
					break;
			}
		}
		
		return -1;
	}
	/*Erwartet einen String (sollte Zahl sein)
	 *und wandelt diese in die entsprechende Chrch Numeral um 
	 *Liefert als Rckgabewert diesen als String
	 */
	private static String getChurchNum(String val)
	{
		String ChurchNum = "";
		
		int n = Integer.parseInt(String.valueOf(val));
		
		ChurchNum += "(\\f.\\x.";
		if (n == 0)
		{
			ChurchNum += "x)";
		}
		else
		{
			for(int j=0; j < n-1; j++ )
			{
				ChurchNum += "f (";
			}
		
			ChurchNum+= "f x";
			
			for(int j=0; j < n  ; j++ )
			{
				ChurchNum += ")";
			}
		}
		
		
		return ChurchNum;
	}
	
	/*Erwartet ein CharArray sowie eine Funktionsbibliothek
	 *Das Chararray wird auf Bibliotheksverweise sowie Zahlen untersucht
	 *Zahlen werden durch Church Numerals ersetzt
	 *Bibliotheksverweise werden durch die entsprechenden Funktionen ersetzt
	 *Rckgabewert ist ein String 
	 */
	private static String PreParse(char term[], Library myLib)
	{
		int state = 0, pos=0;
		String newTerm = ""; 
		char next;
		String var= "";
		LastError = -2;
		
		for(int i=0; i < term.length; i++)
		{
			switch(state)
			{
				case 0:
					if (Character.isDigit(term[i]))
					{
						var += term[i];
						if (i + 1 == term.length)
						{
							newTerm += getChurchNum(var);
						}
						else
						{
							state = 2;
						}
					}
					else
					{
						if(term[i] == '$')
						{
							state = 1;
						}
						else
						{
							newTerm += term[i];
							if (term[i] != ' ')
							{
								state = 3;
							}
						}
					}
					break;
				case 1:
					if(term[i] != ' ' && term[i] != '.' && term[i] != ')' && term[i] != '(' && term[i] != '\\')
					{
						var += term[i];
					}
					else
					{
						Function func = null;
						for(int j=0; j < myLib.countFunction() && state == 1; j ++)
						{
							func = myLib.getFunction(j);
							if (func.getName().compareTo(var) ==0)
							{
								newTerm += func.getLambdaExp() + term[i];
								var = "";
								state = 0;
							}
						}
						if (state == 1)
						{
							LastError = -1;
							return null;
						}
						var = "";
					}
					break;
				case 2:
					if (Character.isDigit(term[i]))
					{
						var += term[i];
						if (i + 1 == term.length)
						{
							newTerm += getChurchNum(var);
							var = "";
						}
					}
					else
					{
						if (term[i] == ' ' || term[i] == '(' || term[i]== ')')
						{
							newTerm += getChurchNum(var);
							var = "";
							state = 0;
							newTerm += term[i];
							
						}
						else
						{
							newTerm += var;
							var = "";
							if (term[i] == '$')
							{
								state = 1;
							}
							else
							{
								newTerm += term[i];
								state = 0;
							}
						}
					}
					break;
				case 3:
					if(term[i] == ' ' || term[i] == '.' || term[i] == '(' || term[i] == ')')
					{
						newTerm += term[i];
						state = 0;
					}
					else
					{
						if (term[i] != '$')
						{
							newTerm += term[i];
						}
						else
						{
							state =1;
						}
					}
					break;
				
			}
		}
		
		return newTerm;
	}
	/*Erwartet den zu parsenden String sowie eine Funktionsbibliothek
	 *Der String wird in die Term Datenstruktur gebracht und liefert 
	 *nach erfolgreichem Parsen diesen Term zurck
	 *Sollte ein Fehler auftreten wird null zurckgegeben
	 *Entsprechende Fehlercode kann mit gerLastError ausgelesen werden 
	 */
	public Term strToTerm(String term,Library myLib)
	{
		Term result, pTerm, pArg;
		result= new Term(null);
		int l, state = 0, cntParenthesis=0, posTermEnd = 0, posArgStart = 0, posArgEnd = 0;
		char toParse[];
		boolean func = true;
		
		toParse = term.toCharArray();
		
		while (func == true)
		{
			term = PreParse(toParse,myLib);
			if (term == null || term == "")
			{ 
				return null;
			}
			func = false;
			toParse = term.toCharArray();
			for (int i = 0; i < toParse.length ; i++ )
			{
				if (toParse[i] == '$')
				{
					func = true;
					break;
				}
			}
		}
		
		LastError = 0;
		
		for(int i = 0; i < toParse.length; i++ )
		{
			switch(state)
			{
				case 0:
					if (toParse[i] != '(')
					{
						LastError = 1;
						return null;
					}
					else
					{
						l = CheckParenthesis(toParse,i);
						if (l == -1)
						{
							LastError = 2;
							return null;
						}
						else
						{
							i += l+1;
							posTermEnd = i;
							state = 1;
						}			
					}
					break;
				case 1:
					if (toParse[i] != ' ')
					{
						posArgStart = i;
						i = toParse.length;
						posArgEnd = i;
						state = 2;
					}
					break;
				case 2:
					if (toParse[i] != ' ')
					{
						LastError = 4;
						return null;
					}
					break;
			}
					
		}
		
		if (state == 1 || state == 2)
		{
			if ((posTermEnd -1) > 0)
			{
				pTerm = NewTerm(term.substring(1, posTermEnd ),null);
				if (pTerm != null)
				{
					result = pTerm;
				}
				else 
				{
					return null;
				}
			}
			else
			{
				LastError = 11;
				return null;
			}
			if (posArgStart != 0 && posArgStart < posArgEnd)
			{
				if(AddArg(result,term.substring(posArgStart,posArgEnd)) != 0)
				{
					return null;
				}
			}
			return result;
		}
		else
		{
			return null;
		}
	}

}

