package Lambda;

import java.util.LinkedList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import Source.MainForm;

public class Term implements Expression {
	
	private LinkedList variables = new LinkedList();
	private LinkedList lambdaTerms = new LinkedList();
	private LinkedList lambdaArgs = new LinkedList();
	private String atom = new String();
	private Term parent;
	private final String lambdaSign = "\u03BB";

	public Term(Term newparent) 
	{	//Constructor
		variables.clear();
		lambdaTerms.clear();
		lambdaArgs.clear();
		parent = newparent;
	}
	
	public Term getParent()
	{
		return parent;
	}
	
	public String toString()
	{		
		String varString = "";
		String termString = "";
		String argString = "";
		String space;
		String result;
		
		int i;
		
		for (i=0; i < countVar(); i++)
		{
			varString = varString + lambdaSign + getVar(i) + ".";
		}
		
		for (i=0; i < countTerm(); i++)
		{
			if (i==0) {space = "";} else {space = " ";};
			termString = termString + space + getTerm(i).toString();
		}
		
		for (i=0; i < countArg(); i++)
		{
			argString = argString + " " + getArg(i).toString();
		}
		
		if ((countArg() == 0) && (this.getParent() == null))
		{
			//Keine Argumente oder Haupt-Term
			result = varString + termString;
		}
		else
		{
			result = "(" + varString + termString + ")" + argString;
		}
		
		return result;	
	}
	
	public void toComposite(Composite composite)
	{
		String varString = "";
		String termString = "";
		String argString = "";
		String space;
		Label leftBorder = null;
		Label rightBorder = null;
		int i;
		
		
		
		if (!((countArg() == 0) && (this.getParent() == null)))
		{
			leftBorder = new Label(composite, SWT.NONE);
			leftBorder.setText("(");
			leftBorder.setData(this);
			leftBorder.addMouseTrackListener(new org.eclipse.swt.events.MouseTrackAdapter() 
					{   			
						public void mouseEnter(org.eclipse.swt.events.MouseEvent e) 
						{    
							Term myTerm = (Term) ((Label) e.widget).getData();
							Label Border = (Label) e.widget;
							
							if (Border != null)
							{
								Border.setToolTipText(myTerm.getToolTip());
							}
						}
					});
		}
		
		for (i=0; i < variables.size(); i++)
		{
			varString = varString + lambdaSign + variables.get(i) + ".";
		}
		
		Label lblVar = new Label(composite, SWT.NONE);
		lblVar.setText(varString);
		
		if (!((countArg() == 0) && (this.getParent() == null)))
		{
		lblVar.setData(this);
		lblVar.setData("leftBorder",leftBorder);
		
		lblVar.addMouseListener(new org.eclipse.swt.events.MouseAdapter() 
		{ 
			public void mouseDown(org.eclipse.swt.events.MouseEvent e) 
			{    
				Term myTerm = (Term) ((Label) e.widget).getData();
				Conversion conv = new Conversion();
				//Beta-Conversion an angeklickter Stelle
				Conversion.beta(myTerm);
				MainForm.buildInteractiveTerm();
			}
		});
			
		lblVar.addMouseTrackListener(new org.eclipse.swt.events.MouseTrackAdapter() 
		{   			
			public void mouseExit(org.eclipse.swt.events.MouseEvent e) 
			{    	
				Label varLabel = (Label) e.widget;
				Label leftBorder = ((Label) varLabel.getData("leftBorder"));
				Label rightBorder = ((Label) varLabel.getData("rightBorder"));
				
				if ((leftBorder != null) && (varLabel != null) && (rightBorder != null))
				{
					varLabel.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 000, 0, 0));	
					leftBorder.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 000, 0, 0));
					rightBorder.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 000, 0, 0));
					leftBorder.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 8, org.eclipse.swt.SWT.NORMAL));
					rightBorder.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 8, org.eclipse.swt.SWT.NORMAL));
				}	
			} 
			public void mouseEnter(org.eclipse.swt.events.MouseEvent e) 
			{    
				Term myTerm = (Term) ((Label) e.widget).getData();
				Label varLabel = (Label) e.widget;
				Label leftBorder = ((Label) varLabel.getData("leftBorder"));
				Label rightBorder = ((Label) varLabel.getData("rightBorder"));
				
				if ((leftBorder != null) && (varLabel != null) && (rightBorder != null))
				{	
					varLabel.setToolTipText(myTerm.getToolTip());
					varLabel.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 255, 0, 0));	
					leftBorder.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 255, 0, 0));
					rightBorder.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 255, 0, 0));
					leftBorder.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 10, org.eclipse.swt.SWT.BOLD));
					rightBorder.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 10, org.eclipse.swt.SWT.BOLD));
				}
			}
		});
		}
		
		for (i=0; i < lambdaTerms.size(); i++)
		{
			((Expression) lambdaTerms.get(i)).toComposite(composite);
		}
		
		if (!((countArg() == 0) && (this.getParent() == null)))
		{
			rightBorder = new Label(composite, SWT.NONE);
			rightBorder.setText(")");	
			rightBorder.setData(this);
			rightBorder.addMouseTrackListener(new org.eclipse.swt.events.MouseTrackAdapter() 
					{   			
						public void mouseEnter(org.eclipse.swt.events.MouseEvent e) 
						{    
							Term myTerm = (Term) ((Label) e.widget).getData();
							Label Border = (Label) e.widget;
							
							if (Border != null)
							{
								Border.setToolTipText(myTerm.getToolTip());
							}
						}
					});
		}
		lblVar.setData("rightBorder",rightBorder);
		
		
		for (i=0; i < lambdaArgs.size(); i++)
		{
			((Expression) lambdaArgs.get(i)).toComposite(composite);
		}
		
		composite.pack();
	}
	
	
	public Expression replaceExp(String oldAtom, Expression newExp)
	{
		int i;
		boolean localVar = false;
		boolean term2arg = false;
		boolean change = false;
		
		//Checkt ob die zu ersetzende Variable im aktuellen Lambda Term vorkommt
		for (i=0; i < countVar(); i++)
		{
			if (getVar(i).compareTo(oldAtom) == 0)
			{
				localVar = true;
			}
		}
		
		//Wenn ja, dann darf sie nicht (!) ersetzt werden (doppelter Variablenname)
		if (!localVar)
		{
			// normale Ersetzung
			for (i=0; i < countTerm(); i++)
			{
				lambdaTerms.set(i, getTerm(i).replaceExp(oldAtom,newExp));	
				//TODO notwendig? elternterm neu setzen?
				//getTerm(i).setParent(this);
			}
			
		
		}
		return this;
	}
	
	//Fgt dem Lambda Term eine neue Variable hinzu
	public void addVar(String variable)
	{
		//TODO check obs var ggf schon da ist --> umbennen!
		variables.add(variable);
	}
	
	//Fgt dem Lambda Term einen neuen Term hinzu
	public void addTerm(Expression exp)
	{
		exp.setParent(this);
		lambdaTerms.add(exp);
	}
	
	//Fgt dem Lambda Term ein neues Argument hinzu
	public void addArg(Expression exp)
	{
		//ElternTerm neu setzen (hier nicht wirklich notwendig, aber sauberer :-)
		exp.setParent(this);
		lambdaArgs.add(exp);
	}
		
	public int countVar() //Gibt die Anzahl der Variablen zurck
	{
		return variables.size();
	}
	
	public int countTerm() //Gibt die Anzahl der Lambda-Terme zurck
	{
		return lambdaTerms.size();
	}
	
	public int countArg() //Gibt die Anzahl der Argument-Terme zurck
	{
		return lambdaArgs.size();
	}
	
	public String removeVar(int i)
	{
		//lscht i'te Variable
		//TODO Errorbehandlung
		return (String) variables.remove(i);
	}
	
	public Expression removeTerm(int i)
	{
		//TODO Errorbehandlung
		return (Expression) lambdaTerms.remove(i);
	}
	
	public Expression removeArg(int i)
	{
		//TODO Errorbehandlung
		return (Expression) lambdaArgs.remove(i);
	}
	
	public String getVar(int i) //Gibt die i-te Variable zurck	
	{
		return (String) variables.get(i);
	}
	
	public Expression getTerm(int i) //Gibt den i-ten Lambda Term zurck
	{
		return (Expression) lambdaTerms.get(i);
	}

	public Expression getArg(int i) //	Gibt den i-te Argument Term zurck
	{
		return (Expression) lambdaArgs.get(i);
	}
	
	public void setParent(Term newParent)
	{
		parent = newParent;
	}
	
	public Expression getCopy(Term newParent)
	{
		//Legt eine Kopie des aktuellen Terms an
		//TODO ... verbessern mit "clone" ?!
		Term myCopy = new Term(newParent);
		
		int i;
		
		for (i=0; i < countVar(); i++)
		{
			myCopy.addVar(getVar(i));
		}
		
		for (i=0; i < countTerm(); i++)
		{
			myCopy.addTerm(getTerm(i).getCopy(myCopy));
		}
		
		for (i=0; i < countArg(); i++)
		{
			myCopy.addArg(getArg(i).getCopy(myCopy));
		}
		
		return myCopy;
	}
	
	public int getPosition()
	{
		int i = 0;
		while ((i < parent.countTerm()) && (parent.getTerm(i) != this))
		{
			i++;
		}
		
		if (i == parent.countTerm())
		{
			//Expression wurde nicht gefunden
			return -1;
		}
		else
		{
			//Expression wurde gefunden -> Position wird zurck gegeben
			return i;
		}
	}
	
	public String getToolTip()
	{
		String myString = "Term: "+this.toString()+
		   				  "\nCount Variables: "+this.countVar()+
						  "\nCount Terms: "+this.countTerm()+
						  "\nCount Arguments: "+this.countArg();
		
		if (this.getParent() != null)
		{
			//Term hat einen Eltern-Term
			myString = myString + "\nParent-Term: "+this.getParent().toString()+
								  "\nPosition: "+(this.getPosition()+1);
		}
		
		return myString;
	}	
	
}
