
% Domain: logistics

% 
% 
% EFFECTS: ADD  >>>>>
adds( unloadtruck( Pkg,Truck,Loc ),at( Pkg,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
adds( flyairplane( Airplane,Locfrom,Locto ),at( Airplane,Locto ) ) :- typedobject( airplane( Airplane ) ), typedobject( airport( Locfrom ) ), typedobject( airport( Locto ) ).
adds( loadairplane( Pkg,Airplane,Loc ),in( Pkg,Airplane ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
adds( drivetruck( Truck,Locfrom,Locto,City ),at( Truck,Locto ) ) :- holds( incity( Locfrom,City ) ), holds( incity( Locto,City ) ), typedobject( truck( Truck ) ).
adds( loadtruck( Pkg,Truck,Loc ),in( Pkg,Truck ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
adds( unloadairplane( Pkg,Airplane,Loc ),at( Pkg,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
% <<<<<  EFFECTS: ADD
% 

% 
% 
% EFFECTS: DEL  >>>>>
deletes( unloadtruck( Pkg,Truck,Loc ),in( Pkg,Truck ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
deletes( flyairplane( Airplane,Locfrom,Locto ),at( Airplane,Locfrom ) ) :- typedobject( airplane( Airplane ) ), typedobject( airport( Locfrom ) ), typedobject( airport( Locto ) ).
deletes( loadairplane( Pkg,Airplane,Loc ),at( Pkg,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
deletes( drivetruck( Truck,Locfrom,Locto,City ),at( Truck,Locfrom ) ) :- holds( incity( Locfrom,City ) ), holds( incity( Locto,City ) ), typedobject( truck( Truck ) ).
deletes( loadtruck( Pkg,Truck,Loc ),at( Pkg,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
deletes( unloadairplane( Pkg,Airplane,Loc ),in( Pkg,Airplane ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
% <<<<<  EFFECTS: DEL
% 

% 
% 
% TYPES  >>>>>
object( X ) :- typedobject( physobj( X ) ).
object( X ) :- typedobject( city( X ) ).
typedobject( place( X ) ) :- typedobject( airport( X ) ).
typedobject( vehicle( X ) ) :- typedobject( truck( X ) ).
typedobject( place( X ) ) :- typedobject( location( X ) ).
typedobject( physobj( X ) ) :- typedobject( vehicle( X ) ).
object( X ) :- typedobject( place( X ) ).
typedobject( vehicle( X ) ) :- typedobject( airplane( X ) ).
typedobject( physobj( X ) ) :- typedobject( package( X ) ).
% <<<<<  TYPES
% 

% 
% 
% REIFIED ENCODING OF DOMAIN ACTIONS  >>>>>
action( unloadtruck( Pkg,Truck,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
action( flyairplane( Airplane,Locfrom,Locto ) ) :- typedobject( airplane( Airplane ) ), typedobject( airport( Locfrom ) ), typedobject( airport( Locto ) ).
action( loadairplane( Pkg,Airplane,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
action( drivetruck( Truck,Locfrom,Locto,City ) ) :- holds( incity( Locfrom,City ) ), holds( incity( Locto,City ) ), typedobject( truck( Truck ) ).
action( loadtruck( Pkg,Truck,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
action( unloadairplane( Pkg,Airplane,Loc ) ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
% <<<<<  REIFIED ENCODING OF DOMAIN ACTIONS
% 

% 
% 
% REIFIED ENCODING OF PRECONDITIONS  >>>>>
demands( unloadtruck( Pkg,Truck,Loc ),at( Truck,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
demands( unloadtruck( Pkg,Truck,Loc ),in( Pkg,Truck ),true ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
demands( flyairplane( Airplane,Locfrom,Locto ),at( Airplane,Locfrom ),true ) :- typedobject( airplane( Airplane ) ), typedobject( airport( Locfrom ) ), typedobject( airport( Locto ) ).
demands( loadairplane( Pkg,Airplane,Loc ),at( Pkg,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
demands( loadairplane( Pkg,Airplane,Loc ),at( Airplane,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
demands( drivetruck( Truck,Locfrom,Locto,City ),at( Truck,Locfrom ),true ) :- holds( incity( Locfrom,City ) ), holds( incity( Locto,City ) ), typedobject( truck( Truck ) ).
demands( loadtruck( Pkg,Truck,Loc ),at( Truck,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
demands( loadtruck( Pkg,Truck,Loc ),at( Pkg,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( truck( Truck ) ), typedobject( place( Loc ) ).
demands( unloadairplane( Pkg,Airplane,Loc ),in( Pkg,Airplane ),true ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
demands( unloadairplane( Pkg,Airplane,Loc ),at( Airplane,Loc ),true ) :- typedobject( package( Pkg ) ), typedobject( airplane( Airplane ) ), typedobject( place( Loc ) ).
% <<<<<  REIFIED ENCODING OF PRECONDITIONS
% 

