
% Domain: Rover

% 
% 
% EFFECTS: ADD  >>>>>
adds( drop( X,Y ),empty( Y ) ) :- holds( store_of( Y,X ) ).
adds( sample_rock( X,S,P ),full( S ) ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
adds( sample_rock( X,S,P ),have_rock_analysis( X,P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
adds( navigate( X,Y,Z ),at( X,Z ) ) :- holds( can_traverse( X,Y,Z ) ), holds( visible( Y,Z ) ).
adds( communicate_rock_data( R,L,P,X,Y ),channel_free( L ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
adds( communicate_rock_data( R,L,P,X,Y ),communicated_rock_data( P ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
adds( communicate_rock_data( R,L,P,X,Y ),available( R ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
adds( sample_soil( X,S,P ),full( S ) ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
adds( sample_soil( X,S,P ),have_soil_analysis( X,P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
adds( take_image( R,P,O,I,M ),have_image( R,O,M ) ) :- holds( on_board( I,R ) ), holds( supports( I,M ) ), holds( visible_from( O,P ) ), holds( equipped_for_imaging( R ) ).
adds( calibrate( R,I,T,W ),calibrated( I,R ) ) :- holds( calibration_target( I,T ) ), holds( visible_from( T,W ) ), holds( on_board( I,R ) ), holds( equipped_for_imaging( R ) ).
adds( communicate_image_data( R,L,O,M,X,Y ),channel_free( L ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
adds( communicate_image_data( R,L,O,M,X,Y ),communicated_image_data( O,M ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
adds( communicate_image_data( R,L,O,M,X,Y ),available( R ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
adds( communicate_soil_data( R,L,P,X,Y ),channel_free( L ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
adds( communicate_soil_data( R,L,P,X,Y ),communicated_soil_data( P ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
adds( communicate_soil_data( R,L,P,X,Y ),available( R ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
% <<<<<  EFFECTS: ADD
% 

% 
% 
% EFFECTS: DEL  >>>>>
deletes( drop( X,Y ),full( Y ) ) :- holds( store_of( Y,X ) ).
deletes( sample_rock( X,S,P ),empty( S ) ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
deletes( sample_rock( X,S,P ),at_rock_sample( P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
deletes( navigate( X,Y,Z ),at( X,Y ) ) :- holds( can_traverse( X,Y,Z ) ), holds( visible( Y,Z ) ).
deletes( sample_soil( X,S,P ),empty( S ) ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
deletes( sample_soil( X,S,P ),at_soil_sample( P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
deletes( take_image( R,P,O,I,M ),calibrated( I,R ) ) :- holds( on_board( I,R ) ), holds( supports( I,M ) ), holds( visible_from( O,P ) ), holds( equipped_for_imaging( R ) ).
% <<<<<  EFFECTS: DEL
% 

% 
% 
% TYPES  >>>>>
object( X ) :- typedobject( rover( X ) ).
object( X ) :- typedobject( lander( X ) ).
object( X ) :- typedobject( camera( X ) ).
object( X ) :- typedobject( waypoint( X ) ).
object( X ) :- typedobject( objective( X ) ).
object( X ) :- typedobject( store( X ) ).
object( X ) :- typedobject( mode( X ) ).
% <<<<<  TYPES
% 

% 
% 
% REIFIED ENCODING OF DOMAIN ACTIONS  >>>>>
action( drop( X,Y ) ) :- holds( store_of( Y,X ) ).
action( sample_rock( X,S,P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
action( navigate( X,Y,Z ) ) :- holds( can_traverse( X,Y,Z ) ), holds( visible( Y,Z ) ).
action( communicate_rock_data( R,L,P,X,Y ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
action( sample_soil( X,S,P ) ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
action( take_image( R,P,O,I,M ) ) :- holds( on_board( I,R ) ), holds( supports( I,M ) ), holds( visible_from( O,P ) ), holds( equipped_for_imaging( R ) ).
action( calibrate( R,I,T,W ) ) :- holds( calibration_target( I,T ) ), holds( visible_from( T,W ) ), holds( on_board( I,R ) ), holds( equipped_for_imaging( R ) ).
action( communicate_image_data( R,L,O,M,X,Y ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
action( communicate_soil_data( R,L,P,X,Y ) ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
% <<<<<  REIFIED ENCODING OF DOMAIN ACTIONS
% 

% 
% 
% REIFIED ENCODING OF PRECONDITIONS  >>>>>
demands( drop( X,Y ),full( Y ),true ) :- holds( store_of( Y,X ) ).
demands( sample_rock( X,S,P ),at( X,P ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
demands( sample_rock( X,S,P ),at_rock_sample( P ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
demands( sample_rock( X,S,P ),empty( S ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_rock_analysis( X ) ), typedobject( waypoint( P ) ).
demands( navigate( X,Y,Z ),available( X ),true ) :- holds( can_traverse( X,Y,Z ) ), holds( visible( Y,Z ) ).
demands( navigate( X,Y,Z ),at( X,Y ),true ) :- holds( can_traverse( X,Y,Z ) ), holds( visible( Y,Z ) ).
demands( communicate_rock_data( R,L,P,X,Y ),at( R,X ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_rock_data( R,L,P,X,Y ),have_rock_analysis( R,P ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_rock_data( R,L,P,X,Y ),available( R ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_rock_data( R,L,P,X,Y ),channel_free( L ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( sample_soil( X,S,P ),at( X,P ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
demands( sample_soil( X,S,P ),at_soil_sample( P ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
demands( sample_soil( X,S,P ),empty( S ),true ) :- holds( store_of( S,X ) ), holds( equipped_for_soil_analysis( X ) ), typedobject( waypoint( P ) ).
demands( take_image( R,P,O,I,M ),calibrated( I,R ),true ) :- holds( on_board( I,R ) ), holds( supports( I,M ) ), holds( visible_from( O,P ) ), holds( equipped_for_imaging( R ) ).
demands( take_image( R,P,O,I,M ),at( R,P ),true ) :- holds( on_board( I,R ) ), holds( supports( I,M ) ), holds( visible_from( O,P ) ), holds( equipped_for_imaging( R ) ).
demands( calibrate( R,I,T,W ),at( R,W ),true ) :- holds( calibration_target( I,T ) ), holds( visible_from( T,W ) ), holds( on_board( I,R ) ), holds( equipped_for_imaging( R ) ).
demands( communicate_image_data( R,L,O,M,X,Y ),at( R,X ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
demands( communicate_image_data( R,L,O,M,X,Y ),have_image( R,O,M ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
demands( communicate_image_data( R,L,O,M,X,Y ),available( R ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
demands( communicate_image_data( R,L,O,M,X,Y ),channel_free( L ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( objective( O ) ), typedobject( mode( M ) ).
demands( communicate_soil_data( R,L,P,X,Y ),at( R,X ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_soil_data( R,L,P,X,Y ),have_soil_analysis( R,P ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_soil_data( R,L,P,X,Y ),available( R ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
demands( communicate_soil_data( R,L,P,X,Y ),channel_free( L ),true ) :- holds( at_lander( L,Y ) ), holds( visible( X,Y ) ), typedobject( rover( R ) ), typedobject( waypoint( P ) ).
% <<<<<  REIFIED ENCODING OF PRECONDITIONS
% 

