
% Domain: zeno-travel

% 
% 
% EFFECTS: ADD  >>>>>
adds( debark( P,A,C ),at( P,C ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
adds( zoom( A,C1,C2,L1,L2,L3 ),at( A,C2 ) ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
adds( zoom( A,C1,C2,L1,L2,L3 ),fuellevel( A,L3 ) ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
adds( board( P,A,C ),in( P,A ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
adds( refuel( A,C,L,L1 ),fuellevel( A,L1 ) ) :- holds( next( L,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
adds( fly( A,C1,C2,L1,L2 ),at( A,C2 ) ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
adds( fly( A,C1,C2,L1,L2 ),fuellevel( A,L2 ) ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
% <<<<<  EFFECTS: ADD
% 

% 
% 
% EFFECTS: DEL  >>>>>
deletes( debark( P,A,C ),in( P,A ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
deletes( zoom( A,C1,C2,L1,L2,L3 ),at( A,C1 ) ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
deletes( zoom( A,C1,C2,L1,L2,L3 ),fuellevel( A,L1 ) ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
deletes( board( P,A,C ),at( P,C ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
deletes( refuel( A,C,L,L1 ),fuellevel( A,L ) ) :- holds( next( L,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
deletes( fly( A,C1,C2,L1,L2 ),at( A,C1 ) ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
deletes( fly( A,C1,C2,L1,L2 ),fuellevel( A,L1 ) ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
% <<<<<  EFFECTS: DEL
% 

% 
% 
% TYPES  >>>>>
object( X ) :- typedobject( person( X ) ).
object( X ) :- typedobject( aircraft( X ) ).
object( X ) :- typedobject( flevel( X ) ).
object( X ) :- typedobject( city( X ) ).
% <<<<<  TYPES
% 

% 
% 
% REIFIED ENCODING OF DOMAIN ACTIONS  >>>>>
action( debark( P,A,C ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
action( zoom( A,C1,C2,L1,L2,L3 ) ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
action( board( P,A,C ) ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
action( refuel( A,C,L,L1 ) ) :- holds( next( L,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
action( fly( A,C1,C2,L1,L2 ) ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
% <<<<<  REIFIED ENCODING OF DOMAIN ACTIONS
% 

% 
% 
% REIFIED ENCODING OF PRECONDITIONS  >>>>>
demands( debark( P,A,C ),in( P,A ),true ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( debark( P,A,C ),at( A,C ),true ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( zoom( A,C1,C2,L1,L2,L3 ),at( A,C1 ),true ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
demands( zoom( A,C1,C2,L1,L2,L3 ),fuellevel( A,L1 ),true ) :- holds( next( L2,L1 ) ), holds( next( L3,L2 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
demands( board( P,A,C ),at( P,C ),true ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( board( P,A,C ),at( A,C ),true ) :- typedobject( person( P ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( refuel( A,C,L,L1 ),fuellevel( A,L ),true ) :- holds( next( L,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( refuel( A,C,L,L1 ),at( A,C ),true ) :- holds( next( L,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C ) ).
demands( fly( A,C1,C2,L1,L2 ),at( A,C1 ),true ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
demands( fly( A,C1,C2,L1,L2 ),fuellevel( A,L1 ),true ) :- holds( next( L2,L1 ) ), typedobject( aircraft( A ) ), typedobject( city( C1 ) ), typedobject( city( C2 ) ).
% <<<<<  REIFIED ENCODING OF PRECONDITIONS
% 

