#!/usr/bin/python

import argparse

class TOH:
    def __init__(self, disks):
        self.__disks = disks
        self.__loc = None
        self.__start = None
        self.__length = None
        self.__step = None

    def __print(self, pred):
        pegs = ["a", "b", "c"]
        for i in range(0, self.__disks):
            print("{pred}({disk},{peg}).".format(pred=pred, disk=self.__disks-i, peg=pegs[self.__loc[i]]))

    def __move(self, n, a, b, c):
        if n > 0 and self.__step < self.__start + self.__length:
            self.__move(n-1, a, c, b)
            if self.__step == self.__start:
                self.__print("init_on")
            self.__loc[n-1] = c
            self.__step += 1
            if self.__step == self.__start + self.__length:
                self.__print("goal_on")
            self.__move(n-1, b, a, c)

    def generate(self, start, length):
        assert(start >= 0 and length >= 1 and length + start < pow(2, self.__disks))
        print ("peg(a;b;c).")
        print ("disk(1..{n}).".format(n=self.__disks))
        self.__loc = [0 for x in range(0, self.__disks)]
        self.__start = start
        self.__length = length
        self.__step = 0
        self.__move(self.__disks, 0, 1, 2)


parser = argparse.ArgumentParser(description='Generate Towers of Hanoi instances.', epilog="""
To generate an instance with 8 disks, starting from configuration 42, needing
100 steps to solve, call "toh.py 8 42 100".
Furthermore, start+length must be smaller than 2^disks.""")
parser.add_argument("disks", help="number of disks", type=int)
parser.add_argument("start", help="initial configuration", type=int)
parser.add_argument("length", help="step to goal", type=int)

args = parser.parse_args()

if args.disks < 1:
    parser.error("positive number of disks expected");

if args.start < 0:
    parser.error("starting configuration must be non-negative");

if args.length < 1:
    parser.error("plan length must be a positive integer");

if args.length + args.start >= pow(2, args.disks):
    parser.error("invalid arguments");

t = TOH(args.disks)
t.generate(args.start, args.length)
