
% Domain: Depot
#base.
% 
% 
% EFFECTS: ADD  >>>>>
adds( load( X,Y,Z,P ),in( Y,Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
adds( load( X,Y,Z,P ),available( X ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
adds( lift( X,Y,Z,P ),lifting( X,Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
adds( lift( X,Y,Z,P ),clear( Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
adds( drive( X,Y,Z ),at( X,Z ) ) :- typedobject( truck( X ) ), typedobject( place( Y ) ), typedobject( place( Z ) ).
adds( unload( X,Y,Z,P ),lifting( X,Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
adds( drop( X,Y,Z,P ),available( X ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
adds( drop( X,Y,Z,P ),at( Y,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
adds( drop( X,Y,Z,P ),clear( Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
adds( drop( X,Y,Z,P ),on( Y,Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
% <<<<<  EFFECTS: ADD
% 

% 
% 
% EFFECTS: DEL  >>>>>
deletes( load( X,Y,Z,P ),lifting( X,Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
deletes( lift( X,Y,Z,P ),at( Y,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
deletes( lift( X,Y,Z,P ),clear( Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
deletes( lift( X,Y,Z,P ),available( X ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
deletes( lift( X,Y,Z,P ),on( Y,Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
deletes( drive( X,Y,Z ),at( X,Y ) ) :- typedobject( truck( X ) ), typedobject( place( Y ) ), typedobject( place( Z ) ).
deletes( unload( X,Y,Z,P ),in( Y,Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
deletes( unload( X,Y,Z,P ),available( X ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
deletes( drop( X,Y,Z,P ),lifting( X,Y ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
deletes( drop( X,Y,Z,P ),clear( Z ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
% <<<<<  EFFECTS: DEL
% 

% 
% 
% TYPES  >>>>>
typedobject( surface( X ) ) :- typedobject( pallet( X ) ).
typedobject( locatable( X ) ) :- typedobject( hoist( X ) ).
object( X ) :- typedobject( place( X ) ).
typedobject( surface( X ) ) :- typedobject( crate( X ) ).
typedobject( place( X ) ) :- typedobject( distributor( X ) ).
typedobject( locatable( X ) ) :- typedobject( truck( X ) ).
typedobject( place( X ) ) :- typedobject( depot( X ) ).
object( X ) :- typedobject( locatable( X ) ).
typedobject( locatable( X ) ) :- typedobject( surface( X ) ).
% <<<<<  TYPES
% 

% 
% 
% REIFIED ENCODING OF DOMAIN ACTIONS  >>>>>
action( load( X,Y,Z,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
action( lift( X,Y,Z,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
action( drive( X,Y,Z ) ) :- typedobject( truck( X ) ), typedobject( place( Y ) ), typedobject( place( Z ) ).
action( unload( X,Y,Z,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
action( drop( X,Y,Z,P ) ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
% <<<<<  REIFIED ENCODING OF DOMAIN ACTIONS
% 

% 
% 
% REIFIED ENCODING OF PRECONDITIONS  >>>>>
demands( load( X,Y,Z,P ),at( X,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( load( X,Y,Z,P ),at( Z,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( load( X,Y,Z,P ),lifting( X,Y ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( lift( X,Y,Z,P ),at( X,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( lift( X,Y,Z,P ),available( X ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( lift( X,Y,Z,P ),at( Y,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( lift( X,Y,Z,P ),on( Y,Z ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( lift( X,Y,Z,P ),clear( Y ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( drive( X,Y,Z ),at( X,Y ),true ) :- typedobject( truck( X ) ), typedobject( place( Y ) ), typedobject( place( Z ) ).
demands( unload( X,Y,Z,P ),at( X,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( unload( X,Y,Z,P ),at( Z,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( unload( X,Y,Z,P ),available( X ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( unload( X,Y,Z,P ),in( Y,Z ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( truck( Z ) ), typedobject( place( P ) ).
demands( drop( X,Y,Z,P ),at( X,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( drop( X,Y,Z,P ),at( Z,P ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( drop( X,Y,Z,P ),clear( Z ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
demands( drop( X,Y,Z,P ),lifting( X,Y ),true ) :- typedobject( hoist( X ) ), typedobject( crate( Y ) ), typedobject( surface( Z ) ), typedobject( place( P ) ).
% <<<<<  REIFIED ENCODING OF PRECONDITIONS
% 

